/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.CommonUnit;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Real;
import visad.RealTuple;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.java3d.DirectManipulationRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.ImmersaDeskDisplayRendererJ3D;

public class TestIDesk {
    private static int tracker_shmkey;
    private static int controller_shmkey;

    public static void main(String[] stringArray) throws IOException, VisADException, RemoteException {
        if (stringArray.length != 2) {
            System.err.println("must have 2 integer arguments");
            System.exit(1);
        }
        try {
            tracker_shmkey = Integer.parseInt(stringArray[0]);
            controller_shmkey = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("args must be integers " + stringArray[0] + " " + stringArray[1]);
            System.exit(1);
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfigTemplate3D graphicsConfigTemplate3D = new GraphicsConfigTemplate3D();
        graphicsConfigTemplate3D.setStereo(1);
        GraphicsConfiguration graphicsConfiguration = graphicsConfigTemplate3D.getBestConfiguration(graphicsDevice.getConfigurations());
        if (graphicsConfiguration == null) {
            System.err.println("Unable to find a Stereo visual");
            System.exit(1);
        }
        ImmersaDeskDisplayRendererJ3D immersaDeskDisplayRendererJ3D = new ImmersaDeskDisplayRendererJ3D(tracker_shmkey, controller_shmkey);
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("display1", (DisplayRendererJ3D)immersaDeskDisplayRendererJ3D, graphicsConfiguration);
        RealType realType = new RealType("ir_radiance", null, null);
        RealType realType2 = new RealType("count", CommonUnit.second, null);
        FunctionType functionType = new FunctionType(realType, realType2);
        RealType realType3 = new RealType("vis_radiance", null, null);
        int n = 64;
        FlatField flatField = FlatField.makeField(functionType, n, false);
        Real real = new Real(realType, 2.0);
        Real[] realArray = new Real[]{new Real(realType2, 1.0), new Real(realType, 2.0), new Real(realType3, 1.0)};
        RealTuple realTuple = new RealTuple(realArray);
        displayImplJ3D.addMap(new ScalarMap(realType3, Display.ZAxis));
        displayImplJ3D.addMap(new ScalarMap(realType, Display.XAxis));
        displayImplJ3D.addMap(new ScalarMap(realType2, Display.YAxis));
        displayImplJ3D.addMap(new ScalarMap(realType2, Display.Green));
        GraphicsModeControl graphicsModeControl = displayImplJ3D.getGraphicsModeControl();
        graphicsModeControl.setPointSize(5.0f);
        graphicsModeControl.setPointMode(false);
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("ref_direct");
        dataReferenceImpl.setData(real);
        DataReference[] dataReferenceArray = new DataReference[]{dataReferenceImpl};
        displayImplJ3D.addReferences((DataRenderer)new DirectManipulationRendererJ3D(), dataReferenceArray, null);
        DataReferenceImpl dataReferenceImpl2 = new DataReferenceImpl("ref_direct_tuple");
        dataReferenceImpl2.setData(realTuple);
        DataReference[] dataReferenceArray2 = new DataReference[]{dataReferenceImpl2};
        displayImplJ3D.addReferences((DataRenderer)new DirectManipulationRendererJ3D(), dataReferenceArray2, null);
        DataReferenceImpl dataReferenceImpl3 = new DataReferenceImpl("ref_histogram1");
        dataReferenceImpl3.setData(flatField);
        DataReference[] dataReferenceArray3 = new DataReference[]{dataReferenceImpl3};
        displayImplJ3D.addReferences((DataRenderer)new DirectManipulationRendererJ3D(), dataReferenceArray3, null);
        JFrame jFrame = new JFrame("VisAD ImmersaDesk Test");
        jFrame.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        jPanel.setAlignmentX(0.0f);
        jFrame.getContentPane().add(jPanel);
        jPanel.add(displayImplJ3D.getComponent());
        int n2 = 1280;
        int n3 = 1024;
        ((Component)jFrame).setSize(n2, n3);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)jFrame).setLocation(dimension.width / 2 - n2 / 2, dimension.height / 2 - n3 / 2);
        ((Component)jFrame).setVisible(true);
    }
}

