/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowListener;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import visad.ConstantMap;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.LocalDisplay;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;
import visad.util.ContourWidget;
import visad.util.GMCWidget;
import visad.util.LabeledColorWidget;
import visad.util.ProjWidget;
import visad.util.RangeWidget;
import visad.util.SelectRangeWidget;

public class Test66
extends TestSkeleton {
    DisplayImpl[] setupServerDisplays() throws RemoteException, VisADException {
        DisplayImpl[] displayImplArray = new DisplayImpl[]{new DisplayImplJ3D("D0"), new DisplayImplJ3D("D1")};
        return displayImplArray;
    }

    private void setupDisplayZero(LocalDisplay localDisplay, RealType realType, RealType realType2) throws RemoteException, VisADException {
        localDisplay.addMap(new ScalarMap(RealType.Longitude, Display.XAxis));
        localDisplay.addMap(new ScalarMap(RealType.Latitude, Display.YAxis));
        ScalarMap scalarMap = new ScalarMap(realType, Display.ZAxis);
        localDisplay.addMap(scalarMap);
        scalarMap.setUnderscoreToBlank(true);
        localDisplay.addMap(new ConstantMap(0.5, Display.Red));
        localDisplay.addMap(new ScalarMap(realType, Display.Green));
        localDisplay.addMap(new ConstantMap(0.5, Display.Blue));
        ScalarMap scalarMap2 = new ScalarMap(realType2, Display.SelectRange);
        localDisplay.addMap(scalarMap2);
        scalarMap2.setUnderscoreToBlank(true);
        ScalarMap scalarMap3 = new ScalarMap(realType2, Display.RGBA);
        localDisplay.addMap(scalarMap3);
        scalarMap3.setUnderscoreToBlank(true);
        localDisplay.getGraphicsModeControl().setScaleEnable(true);
    }

    private void setupDisplayOne(LocalDisplay localDisplay, RealType realType, RealType realType2) throws RemoteException, VisADException {
        localDisplay.addMap(new ScalarMap(RealType.Longitude, Display.XAxis));
        localDisplay.addMap(new ScalarMap(RealType.Latitude, Display.YAxis));
        localDisplay.addMap(new ConstantMap(0.5, Display.Red));
        localDisplay.addMap(new ScalarMap(realType2, Display.Green));
        localDisplay.addMap(new ConstantMap(0.5, Display.Blue));
        ScalarMap scalarMap = new ScalarMap(realType, Display.IsoContour);
        localDisplay.addMap(scalarMap);
        scalarMap.setUnderscoreToBlank(true);
        ScalarMap scalarMap2 = new ScalarMap(realType2, Display.RGB);
        localDisplay.addMap(scalarMap2);
        scalarMap2.setUnderscoreToBlank(true);
        localDisplay.getGraphicsModeControl().setScaleEnable(true);
    }

    private void addData(LocalDisplay[] localDisplayArray, RealType realType, RealType realType2) throws RemoteException, VisADException {
        RealType[] realTypeArray = new RealType[]{RealType.Latitude, RealType.Longitude};
        RealTupleType realTupleType = new RealTupleType(realTypeArray);
        RealType[] realTypeArray2 = new RealType[]{realType, realType2};
        RealTupleType realTupleType2 = new RealTupleType(realTypeArray2);
        FunctionType functionType = new FunctionType(realTupleType, realTupleType2);
        FlatField flatField = FlatField.makeField(functionType, 64, false);
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("data");
        dataReferenceImpl.setData(flatField);
        int n = 0;
        while (n < localDisplayArray.length) {
            localDisplayArray[n].addReference(dataReferenceImpl);
            ++n;
        }
    }

    void setupServerData(LocalDisplay[] localDisplayArray) throws RemoteException, VisADException {
        RealType realType = new RealType("vis_radiance", null, null);
        RealType realType2 = new RealType("ir_radiance", null, null);
        this.setupDisplayZero(localDisplayArray[0], realType, realType2);
        this.setupDisplayOne(localDisplayArray[1], realType, realType2);
        this.addData(localDisplayArray, realType, realType2);
    }

    private void addWidget(Container container, Component component) {
        container.add(new JLabel(component.getClass().getName()));
        container.add(component);
    }

    private Component displayZeroUI(LocalDisplay localDisplay) throws RemoteException, VisADException {
        Vector vector = localDisplay.getMapVector();
        int n = vector.size();
        ScalarMap scalarMap = (ScalarMap)vector.elementAt(n - 1);
        ScalarMap scalarMap2 = (ScalarMap)vector.elementAt(n - 2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.addWidget((Container)jPanel, (Component)new LabeledColorWidget(scalarMap));
        this.addWidget((Container)jPanel, (Component)new SelectRangeWidget(scalarMap2));
        this.addWidget((Container)jPanel, (Component)new GMCWidget(localDisplay.getGraphicsModeControl()));
        this.addWidget((Container)jPanel, (Component)new ProjWidget(localDisplay.getProjectionControl()));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(jPanel);
        jPanel2.add(localDisplay.getComponent());
        return jPanel2;
    }

    private Component displayOneUI(LocalDisplay localDisplay) throws RemoteException, VisADException {
        Vector vector = localDisplay.getMapVector();
        int n = vector.size();
        ScalarMap scalarMap = (ScalarMap)vector.elementAt(n - 1);
        ScalarMap scalarMap2 = (ScalarMap)vector.elementAt(n - 2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.addWidget((Container)jPanel, (Component)new RangeWidget(scalarMap));
        this.addWidget((Container)jPanel, (Component)new LabeledColorWidget(scalarMap));
        this.addWidget((Container)jPanel, (Component)new ContourWidget(scalarMap2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(jPanel);
        jPanel2.add(localDisplay.getComponent());
        return jPanel2;
    }

    private Container buildContent(LocalDisplay[] localDisplayArray) throws RemoteException, VisADException {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.displayZeroUI(localDisplayArray[0]));
        jPanel.add(this.displayOneUI(localDisplayArray[1]));
        return jPanel;
    }

    String getFrameTitle() {
        return "Test all widgets";
    }

    void setupUI(LocalDisplay[] localDisplayArray) throws RemoteException, VisADException {
        JFrame jFrame = new JFrame(this.getFrameTitle() + this.getClientServerTitle());
        jFrame.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        jFrame.setContentPane(this.buildContent(localDisplayArray));
        jFrame.pack();
        ((Component)jFrame).setVisible(true);
    }

    public String toString() {
        return ": Test all widgets";
    }

    public static void main(String[] stringArray) throws RemoteException, VisADException {
        new Test66(stringArray);
    }

    public Test66() {
    }

    public Test66(String[] stringArray) throws RemoteException, VisADException {
        super(stringArray);
    }
}

