/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.rmi.RemoteException;
import visad.CommonUnit;
import visad.ConstantMap;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FieldImpl;
import visad.FunctionType;
import visad.LocalDisplay;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Unit;
import visad.VisADException;
import visad.data.netcdf.Plain;
import visad.java3d.DisplayImplJ3D;

public class Test10
extends TestSkeleton {
    private String fileName;

    public void initializeArgs() {
        this.fileName = null;
    }

    public int checkKeyword(String string, int n, String[] stringArray) {
        if (this.fileName == null) {
            this.fileName = stringArray[n];
        } else {
            System.err.println(string + ": Ignoring extra filename \"" + stringArray[n] + "\"");
        }
        return 1;
    }

    public String keywordUsage() {
        return super.keywordUsage() + " file";
    }

    public boolean finalizeArgs(String string) {
        if (this.fileName == null) {
            System.err.println(string + ": No filename specified!");
            return false;
        }
        return true;
    }

    private DataReferenceImpl loadFile() throws RemoteException, VisADException {
        FieldImpl fieldImpl;
        try {
            fieldImpl = (FieldImpl)new Plain().open(this.fileName);
        }
        catch (IOException iOException) {
            System.err.println("Couldn't open \"" + this.fileName + "\": " + iOException.getMessage());
            System.exit(1);
            return null;
        }
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("netcdf");
        dataReferenceImpl.setData(fieldImpl);
        return dataReferenceImpl;
    }

    DataReference[] getClientDataReferences() throws RemoteException, VisADException {
        DataReferenceImpl dataReferenceImpl = this.loadFile();
        if (dataReferenceImpl == null) {
            return null;
        }
        return new DataReference[]{dataReferenceImpl};
    }

    DisplayImpl[] setupServerDisplays() throws RemoteException, VisADException {
        DisplayImpl[] displayImplArray = new DisplayImpl[]{new DisplayImplJ3D("display", 3)};
        return displayImplArray;
    }

    void setupServerData(LocalDisplay[] localDisplayArray) throws RemoteException, VisADException {
        Unit unit = CommonUnit.degree.scale(2.5);
        RealType realType = new RealType("lon", unit, null);
        DataReferenceImpl dataReferenceImpl = this.loadFile();
        if (dataReferenceImpl == null) {
            System.err.println("must specify netCDF file name");
            System.exit(1);
            return;
        }
        FieldImpl fieldImpl = (FieldImpl)dataReferenceImpl.getData();
        FunctionType functionType = (FunctionType)fieldImpl.getType();
        RealTupleType realTupleType = functionType.getDomain();
        MathType mathType = functionType.getRange();
        int n = realTupleType.getDimension();
        localDisplayArray[0].addMap(new ScalarMap((RealType)realTupleType.getComponent(0), Display.XAxis));
        if (n > 1) {
            localDisplayArray[0].addMap(new ScalarMap((RealType)realTupleType.getComponent(1), Display.YAxis));
        }
        if (n > 2) {
            localDisplayArray[0].addMap(new ScalarMap((RealType)realTupleType.getComponent(2), Display.ZAxis));
        }
        if (mathType instanceof RealType) {
            localDisplayArray[0].addMap(new ScalarMap((RealType)mathType, Display.Green));
            if (n <= 2) {
                localDisplayArray[0].addMap(new ScalarMap((RealType)mathType, Display.ZAxis));
            }
        } else if (mathType instanceof RealTupleType) {
            int n2 = ((RealTupleType)mathType).getDimension();
            RealType realType2 = (RealType)((RealTupleType)mathType).getComponent(0);
            localDisplayArray[0].addMap(new ScalarMap(realType2, Display.Green));
            if (n <= 2) {
                if (n2 > 1) {
                    realType2 = (RealType)((RealTupleType)mathType).getComponent(1);
                }
                localDisplayArray[0].addMap(new ScalarMap(realType2, Display.ZAxis));
            }
        }
        localDisplayArray[0].addMap(new ConstantMap(0.5, Display.Red));
        localDisplayArray[0].addMap(new ConstantMap(0.0, Display.Blue));
        localDisplayArray[0].addReference(dataReferenceImpl, null);
        System.out.println("now saving data as 'save.nc' and re-reading");
        Plain plain = new Plain();
        try {
            plain.save("save.nc", fieldImpl, true);
            fieldImpl = (FieldImpl)plain.open("save.nc");
        }
        catch (IOException iOException) {
            System.err.println("Couldn't open \"save.nc\": " + iOException.getMessage());
            System.exit(1);
            return;
        }
    }

    public String toString() {
        return " file_name: netCDF adapter";
    }

    public static void main(String[] stringArray) throws RemoteException, VisADException {
        new Test10(stringArray);
    }

    public Test10() {
    }

    public Test10(String[] stringArray) throws RemoteException, VisADException {
        super(stringArray);
    }
}

