/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import visad.CommonUnit;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.LocalDisplay;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;
import visad.util.ContourWidget;
import visad.util.LabeledColorWidget;

public class Test01
extends UISkeleton {
    static int size3d = 6;
    ScalarMap map1color = null;
    ScalarMap map1contour = null;

    public void initializeArgs() {
        size3d = 6;
    }

    public int checkKeyword(String string, int n, String[] stringArray) {
        try {
            size3d = Integer.parseInt(stringArray[0]);
            if (size3d < 1) {
                size3d = 6;
            }
        }
        catch (NumberFormatException numberFormatException) {
            size3d = 6;
        }
        return 1;
    }

    DisplayImpl[] setupServerDisplays() throws RemoteException, VisADException {
        DisplayImpl[] displayImplArray = new DisplayImpl[]{new DisplayImplJ3D("display", 3)};
        return displayImplArray;
    }

    void setupServerData(LocalDisplay[] localDisplayArray) throws RemoteException, VisADException {
        RealType[] realTypeArray = new RealType[]{RealType.Latitude, RealType.Longitude, RealType.Radius};
        RealTupleType realTupleType = new RealTupleType(realTypeArray);
        RealType realType = new RealType("vis_radiance", CommonUnit.degree, null);
        RealType realType2 = new RealType("ir_radiance", CommonUnit.degree, null);
        RealType[] realTypeArray2 = new RealType[]{realType, realType2};
        RealTupleType realTupleType2 = new RealTupleType(realTypeArray2);
        FunctionType functionType = new FunctionType(realTupleType, realTupleType2);
        FlatField flatField = FlatField.makeField(functionType, size3d, false);
        ScalarMap scalarMap = new ScalarMap(RealType.Latitude, Display.YAxis);
        localDisplayArray[0].addMap(scalarMap);
        scalarMap.setOverrideUnit(CommonUnit.radian);
        localDisplayArray[0].addMap(new ScalarMap(RealType.Longitude, Display.XAxis));
        localDisplayArray[0].addMap(new ScalarMap(RealType.Radius, Display.ZAxis));
        this.map1color = new ScalarMap(realType2, Display.RGB);
        localDisplayArray[0].addMap(this.map1color);
        this.map1color.setOverrideUnit(CommonUnit.radian);
        this.map1contour = new ScalarMap(realType, Display.IsoContour);
        localDisplayArray[0].addMap(this.map1contour);
        this.map1contour.setOverrideUnit(CommonUnit.radian);
        GraphicsModeControl graphicsModeControl = localDisplayArray[0].getGraphicsModeControl();
        graphicsModeControl.setScaleEnable(true);
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("ref_grid3d");
        dataReferenceImpl.setData(flatField);
        localDisplayArray[0].addReference(dataReferenceImpl, null);
    }

    String getFrameTitle() {
        return "VisAD iso-level controls";
    }

    Component getSpecialComponent(LocalDisplay[] localDisplayArray) throws RemoteException, VisADException {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        jPanel.setAlignmentX(0.0f);
        jPanel.add(new ContourWidget(this.map1contour));
        jPanel.add(new LabeledColorWidget(this.map1color));
        return jPanel;
    }

    public String toString() {
        return ": colored iso-surfaces from regular grids and ContourWidget";
    }

    public static void main(String[] stringArray) throws RemoteException, VisADException {
        new Test01(stringArray);
    }

    public Test01() {
    }

    public Test01(String[] stringArray) throws RemoteException, VisADException {
        super(stringArray);
    }
}

