/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import visad.ConstantMap;
import visad.Data;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FunctionImpl;
import visad.FunctionType;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Tuple;
import visad.VisADException;
import visad.data.DefaultFamily;
import visad.java3d.DisplayImplJ3D;

public class Spasm {
    public static int WIDTH = 600;
    public static int HEIGHT = 600;
    private Data data;

    public String toString() {
        try {
            return this.data.getType().toString();
        }
        catch (Exception exception) {
            return exception.getClass().toString() + ": " + exception.getMessage();
        }
    }

    private void linkData(DisplayImpl displayImpl) throws VisADException, RemoteException {
        RealType realType;
        RealType realType2;
        FunctionType functionType = (FunctionType)this.data.getType();
        RealTupleType realTupleType = functionType.getDomain();
        int n = realTupleType.getDimension();
        displayImpl.addMap(new ScalarMap((RealType)realTupleType.getComponent(0), Display.XAxis));
        if (n > 1) {
            displayImpl.addMap(new ScalarMap((RealType)realTupleType.getComponent(1), Display.YAxis));
            if (n > 2) {
                displayImpl.addMap(new ScalarMap((RealType)realTupleType.getComponent(2), Display.ZAxis));
            }
        }
        displayImpl.addMap(new ConstantMap(0.5, Display.Red));
        displayImpl.addMap(new ConstantMap(0.0, Display.Blue));
        MathType mathType = functionType.getRange();
        if (mathType instanceof RealType) {
            realType = realType2 = (RealType)mathType;
        } else if (mathType instanceof RealTupleType) {
            realType = (RealType)((RealTupleType)mathType).getComponent(0);
            realType2 = ((RealTupleType)mathType).getDimension() > 1 ? (RealType)((RealTupleType)mathType).getComponent(1) : realType;
        } else {
            realType2 = null;
            realType = null;
        }
        if (realType != null) {
            displayImpl.addMap(new ScalarMap(realType, Display.Green));
        }
        if (n <= 2 && realType2 != null) {
            displayImpl.addMap(new ScalarMap(realType2, Display.ZAxis));
        }
        System.out.println(this.data.getType());
        System.out.println(displayImpl);
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("SpazData");
        dataReferenceImpl.setData(this.data);
        displayImpl.addReference(dataReferenceImpl, null);
    }

    public void showApp() throws VisADException, RemoteException {
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("display", 3);
        this.linkData((DisplayImpl)displayImplJ3D);
    }

    private JFrame mainFrame(String string) {
        JFrame jFrame = new JFrame(string);
        jFrame.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        ((Component)jFrame).setCursor(Cursor.getPredefinedCursor(0));
        return jFrame;
    }

    private JPanel textPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        jPanel.setAlignmentX(0.0f);
        jPanel.add(new JLabel("Silly file viewer"));
        jPanel.add(new JLabel("using VisAD  -  see:"));
        jPanel.add(new JLabel("  "));
        jPanel.add(new JLabel("  http://www.ssec.wisc.edu/~billh/visad.html"));
        jPanel.add(new JLabel("  "));
        jPanel.add(new JLabel("for more information about VisAD."));
        jPanel.add(new JLabel("  "));
        return jPanel;
    }

    private void showSwing(String string) throws VisADException, RemoteException {
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("display");
        this.linkData((DisplayImpl)displayImplJ3D);
        JFrame jFrame = this.mainFrame(string);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentY(0.0f);
        jPanel.setAlignmentX(0.0f);
        jFrame.getContentPane().add(jPanel);
        jPanel.add(this.textPanel());
        JPanel jPanel2 = (JPanel)displayImplJ3D.getComponent();
        CompoundBorder compoundBorder = new CompoundBorder(new EtchedBorder(), new EmptyBorder(10, 10, 10, 10));
        jPanel2.setBorder(compoundBorder);
        jPanel.add(jPanel2);
        jFrame.pack();
        ((Component)jFrame).setVisible(true);
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException, IOException {
        if (stringArray.length != 1) {
            System.err.println("Usage: Spasm file");
            System.exit(1);
            return;
        }
        Spasm spasm = new Spasm(stringArray[0]);
        try {
            System.out.println("Spasm: " + spasm);
        }
        catch (Exception exception) {
            System.err.println(stringArray[0] + " print threw " + exception.getMessage());
            exception.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        spasm.showSwing("Spasm");
    }

    public Spasm(String string) throws VisADException, RemoteException, IOException {
        Data data;
        DefaultFamily defaultFamily = new DefaultFamily("Default");
        try {
            data = defaultFamily.open(string);
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
            System.exit(1);
            return;
        }
        if (data instanceof Tuple) {
            boolean bl = false;
            Tuple tuple = (Tuple)data;
            try {
                Data data2;
                int n = 0;
                do {
                    data2 = tuple.getComponent(n);
                    if (bl) {
                        System.err.println("Discarding VisAD Data object #" + n + ": " + data2.getType());
                    } else if (data2 instanceof FunctionImpl) {
                        data = data2;
                        bl = true;
                    }
                    ++n;
                } while (data2 != null);
            }
            catch (VisADException visADException) {
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (bl) {
                System.err.println("");
            }
        }
        this.data = data;
    }
}

