/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.Data;
import visad.DataImpl;
import visad.DataReferenceImpl;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.DefaultFamily;
import visad.data.SocketDataServer;
import visad.data.SocketDataSource;
import visad.java3d.DisplayImplJ3D;
import visad.util.Util;

public class SocketDataTest
extends JFrame
implements ActionListener {
    private static final String usage = "Usage: java SocketDataTest [-s port] [-c ip.address:port]";
    private boolean server;
    private DataReferenceImpl ref;
    private DisplayImpl disp;
    private JFileChooser dialog;

    private void constructGUI(String string, boolean bl) {
        this.dialog = Util.getVisADFileChooser();
        JPanel jPanel = new JPanel();
        this.setContentPane(jPanel);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.disp.getComponent());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JButton jButton = new JButton("Load data");
        JButton jButton2 = new JButton("Reset to default");
        jButton.addActionListener((ActionListener)this);
        jButton.setActionCommand("load");
        jButton.setEnabled(bl);
        jButton2.addActionListener((ActionListener)this);
        jButton2.setActionCommand("reset");
        jButton2.setEnabled(bl);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel.add(jPanel2);
        this.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        this.setTitle("SocketDataTest " + (this.server ? "server" : "client") + ": " + string);
        this.pack();
        this.setVisible(true);
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException, IOException {
        if (stringArray.length < 2) {
            System.err.println("Not enough arguments.");
            System.err.println(usage);
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        boolean bl = false;
        if (string.equalsIgnoreCase("-s")) {
            bl = true;
        } else if (!string.equalsIgnoreCase("-c")) {
            System.err.println("Please specify either -s or -c");
            System.err.println(usage);
            System.exit(2);
        }
        SocketDataTest socketDataTest = new SocketDataTest(bl, string2);
    }

    private void loadData(String string) throws VisADException, RemoteException {
        DataImpl dataImpl = null;
        if (string == null) {
            int n = 64;
            RealType realType = RealType.getRealType("ir_radiance");
            RealType realType2 = RealType.getRealType("vis_radiance");
            RealType[] realTypeArray = new RealType[]{RealType.Latitude, RealType.Longitude};
            RealType[] realTypeArray2 = new RealType[]{realType2, realType};
            RealTupleType realTupleType = new RealTupleType(realTypeArray);
            RealTupleType realTupleType2 = new RealTupleType(realTypeArray2);
            FunctionType functionType = new FunctionType(realTupleType, realTupleType2);
            dataImpl = FlatField.makeField(functionType, n, false);
        } else {
            DefaultFamily defaultFamily = new DefaultFamily("loader");
            try {
                dataImpl = defaultFamily.open(string);
            }
            catch (BadFormException badFormException) {
                throw new VisADException(badFormException.getMessage());
            }
        }
        if (dataImpl != null) {
            this.setMaps((Data)dataImpl);
            this.ref.setData(dataImpl);
        }
    }

    private void setMaps(Data data) throws VisADException, RemoteException {
        ScalarMap[] scalarMapArray = data.getType().guessMaps(true);
        this.disp.removeReference(this.ref);
        this.disp.clearMaps();
        int n = 0;
        while (n < scalarMapArray.length) {
            this.disp.addMap(scalarMapArray[n]);
            ++n;
        }
        this.disp.addReference(this.ref);
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        try {
            if (string.equals("load")) {
                int n = this.dialog.showOpenDialog((Component)this);
                if (n == 0) {
                    this.loadData(this.dialog.getSelectedFile().getAbsolutePath());
                }
            } else if (string.equals("reset")) {
                this.loadData(null);
            }
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    static /* synthetic */ DataReferenceImpl access$0(SocketDataTest socketDataTest) {
        return socketDataTest.ref;
    }

    static /* synthetic */ void access$1(SocketDataTest socketDataTest, Data data) throws VisADException, RemoteException {
        socketDataTest.setMaps(data);
    }

    public SocketDataTest(boolean bl, String string) throws VisADException, RemoteException, IOException {
        this.server = bl;
        this.disp = new DisplayImplJ3D("disp");
        if (this.server) {
            int n = -1;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n < 0 || n > 9999) {
                System.err.println("Invalid port: " + string);
                System.exit(3);
            }
            this.ref = new DataReferenceImpl("ref");
            this.disp.addReference(this.ref);
            SocketDataServer socketDataServer = new SocketDataServer(n, this.ref);
            this.loadData(null);
            this.constructGUI(string, true);
        } else {
            SocketDataSource socketDataSource = new SocketDataSource("SocketDataTest");
            socketDataSource.open(string);
            this.ref = socketDataSource.getReference();
            this.disp.addReference(this.ref);
            1 var4_7 = new /* Unavailable Anonymous Inner Class!! */;
            var4_7.addReference(this.ref);
            this.constructGUI(string, false);
        }
    }
}

