/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import visad.ConstantMap;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.FlatField;
import visad.FunctionType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.UnionSet;
import visad.VisADException;
import visad.bom.ImageRendererJ3D;
import visad.data.mcidas.AreaAdapter;
import visad.data.mcidas.BaseMapAdapter;
import visad.java3d.DisplayImplJ3D;
import visad.util.ColorMapWidget;
import visad.util.LabeledColorWidget;

public class SimpleMcIDAS {
    public static void main(String[] stringArray) throws VisADException, RemoteException, IOException {
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("display");
        AreaAdapter areaAdapter = new AreaAdapter(stringArray[0]);
        FlatField flatField = areaAdapter.getData();
        FunctionType functionType = (FunctionType)flatField.getType();
        RealType realType = (RealType)((RealTupleType)functionType.getRange()).getComponent(0);
        displayImplJ3D.addMap(new ScalarMap(RealType.Latitude, Display.Latitude));
        displayImplJ3D.addMap(new ScalarMap(RealType.Longitude, Display.Longitude));
        ScalarMap scalarMap = new ScalarMap(realType, Display.RGB);
        displayImplJ3D.addMap(scalarMap);
        BaseMapAdapter baseMapAdapter = new BaseMapAdapter(stringArray[1]);
        UnionSet unionSet = baseMapAdapter.getData();
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("MapLines");
        dataReferenceImpl.setData(unionSet);
        ConstantMap[] constantMapArray = new ConstantMap[]{new ConstantMap(1.002, Display.Radius), new ConstantMap(0.0, Display.Blue)};
        displayImplJ3D.addReference(dataReferenceImpl, constantMapArray);
        DataReferenceImpl dataReferenceImpl2 = new DataReferenceImpl("ImageRef");
        dataReferenceImpl2.setData(flatField);
        displayImplJ3D.addReferences((DataRenderer)new ImageRendererJ3D(), dataReferenceImpl2);
        JFrame jFrame = new JFrame("Satellite Display");
        jFrame.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(displayImplJ3D.getComponent());
        LabeledColorWidget labeledColorWidget = new LabeledColorWidget(new ColorMapWidget(scalarMap, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setMaximumSize(new Dimension(500, 150));
        jPanel2.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5)));
        jPanel2.add(labeledColorWidget);
        jPanel.add(jPanel2);
        jFrame.getContentPane().add(jPanel);
        ((Component)jFrame).setSize(500, 700);
        ((Component)jFrame).setVisible(true);
    }
}

