/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.WindowListener;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.AxisScale;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded1DSet;
import visad.MathType;
import visad.ProjectionControl;
import visad.RealType;
import visad.SI;
import visad.ScalarMap;
import visad.Tuple;
import visad.Unit;
import visad.VisADException;
import visad.data.units.Parser;
import visad.java2d.DisplayImplJ2D;
import visad.java3d.DisplayImplJ3D;
import visad.util.PrintActionListener;

public class ScaleTest
extends JFrame {
    DisplayImpl display;
    ScalarMap tMap;
    ScalarMap tdMap;
    ScalarMap timeMap;
    RealType temp;
    RealType dewpoint;

    public static void main(String[] stringArray) throws Exception {
        ScaleTest scaleTest = new ScaleTest(stringArray.length > 0);
        scaleTest.show();
    }

    public ScaleTest(boolean bl) throws VisADException, RemoteException {
        double[] dArray;
        this.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        this.display = bl ? new DisplayImplJ3D("Display") : new DisplayImplJ2D("Display");
        GraphicsModeControl graphicsModeControl = this.display.getGraphicsModeControl();
        graphicsModeControl.setScaleEnable(true);
        ProjectionControl projectionControl = this.display.getProjectionControl();
        if (bl) {
            double[] dArray2 = new double[3];
            dArray2[0] = 0.8;
            dArray2[1] = 1.0;
            dArray = dArray2;
            dArray2[2] = 1.0;
        } else {
            double[] dArray3 = new double[2];
            dArray3[0] = 0.8;
            dArray = dArray3;
            dArray3[1] = 1.0;
        }
        projectionControl.setAspectCartesian(dArray);
        Unit unit = null;
        try {
            unit = Parser.parse("degC");
            this.temp = RealType.getRealType("Temperature", SI.kelvin);
            this.dewpoint = RealType.getRealType("DewPoint", unit);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.tMap = new ScalarMap(this.temp, Display.YAxis);
        this.tMap.setOverrideUnit(unit);
        this.tdMap = new ScalarMap(this.dewpoint, bl ? Display.ZAxis : Display.YAxis);
        this.timeMap = new ScalarMap(RealType.Time, Display.XAxis);
        Hashtable<Double, String> hashtable = new Hashtable<Double, String>();
        hashtable.put(new Double(0.0), "First");
        hashtable.put(new Double(10.0), "Last");
        this.timeMap.getAxisScale().setLabelTable(hashtable);
        Hashtable<Double, String> hashtable2 = new Hashtable<Double, String>();
        hashtable2.put(new Double(-20.0), "Low");
        hashtable2.put(new Double(5.0), "High");
        this.tdMap.getAxisScale().setLabelTable(hashtable2);
        this.tdMap.getAxisScale().setSide(1);
        this.tdMap.getAxisScale().setMinorTickSpacing(2.5);
        AxisScale axisScale = this.tMap.getAxisScale();
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
        decimalFormat.applyPattern("0.0E0");
        axisScale.setNumberFormat(decimalFormat);
        axisScale.createStandardLabels(50.0, 10.0, 50.0, 40.0);
        axisScale.setTitle(axisScale.getTitle() + " (" + unit + ")");
        this.display.addMap(this.tMap);
        this.display.addMap(this.tdMap);
        this.display.addMap(this.timeMap);
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("data");
        float[][] fArray = new float[][]{{0.0f, 2.0f, 4.0f, 6.0f, 8.0f, 10.0f}};
        Gridded1DSet gridded1DSet = new Gridded1DSet((MathType)RealType.Time, fArray, 6);
        float[][] fArray2 = new float[][]{{294.15f, 326.15f, 310.15f, 278.15f, 278.15f, 293.15f}};
        float[][] fArray3 = new float[][]{{1.0f, 3.0f, 7.0f, -15.0f, -22.0f, 4.0f}};
        FunctionType functionType = new FunctionType(RealType.Time, this.temp);
        FlatField flatField = new FlatField(functionType, gridded1DSet);
        flatField.setSamples(fArray2);
        FunctionType functionType2 = new FunctionType(RealType.Time, this.dewpoint);
        FlatField flatField2 = new FlatField(functionType2, gridded1DSet);
        flatField2.setSamples(fArray3);
        dataReferenceImpl.setData(new Tuple(new FlatField[]{flatField, flatField2}));
        this.display.addReference(dataReferenceImpl);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add((Component)new ScaleControlPanel(this, this.tMap));
        jPanel.add((Component)new ScaleControlPanel(this, this.tdMap));
        jPanel.add((Component)new ScaleControlPanel(this, this.timeMap));
        JButton jButton = new JButton("Print Me");
        jButton.addActionListener(new PrintActionListener(this.display));
        jPanel.add(jButton);
        Container container = this.getContentPane();
        container.setLayout(new GridLayout(1, 2));
        container.add(jPanel);
        container.add(this.display.getComponent());
        this.pack();
    }
}

