/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.ConstantMap;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayEvent;
import visad.DisplayListener;
import visad.FlatField;
import visad.FunctionType;
import visad.LocalDisplay;
import visad.ProjectionControl;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.UnionSet;
import visad.VisADException;
import visad.bom.ImageRendererJ3D;
import visad.data.mcidas.AreaAdapter;
import visad.data.mcidas.BaseMapAdapter;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.ImmersaDeskDisplayRendererJ3D;

public class IDeskMcIDAS
implements DisplayListener {
    public static void main(String[] stringArray) throws VisADException, RemoteException, IOException {
        IDeskMcIDAS iDeskMcIDAS = new IDeskMcIDAS(stringArray);
    }

    public void displayChanged(DisplayEvent displayEvent) throws RemoteException, VisADException {
        if (displayEvent.getId() == 3) {
            this.rotate((LocalDisplay)displayEvent.getDisplay());
        }
    }

    public void rotate(LocalDisplay localDisplay) throws RemoteException, VisADException {
        ProjectionControl projectionControl = localDisplay.getProjectionControl();
        double[] dArray = projectionControl.getMatrix();
        double[] dArray2 = localDisplay.make_matrix(0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0);
        projectionControl.setMatrix(localDisplay.multiply_matrix(dArray2, dArray));
    }

    public void rotate_x(LocalDisplay localDisplay) throws RemoteException, VisADException {
        ProjectionControl projectionControl = localDisplay.getProjectionControl();
        double[] dArray = projectionControl.getMatrix();
        double[] dArray2 = localDisplay.make_matrix(90.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
        projectionControl.setMatrix(localDisplay.multiply_matrix(dArray2, dArray));
    }

    public IDeskMcIDAS(String[] stringArray) throws VisADException, RemoteException, IOException {
        int n = 4148;
        int n2 = 4147;
        if (stringArray.length >= 3) {
            n = Integer.parseInt(stringArray[3]);
        }
        if (stringArray.length >= 4) {
            n2 = Integer.parseInt(stringArray[4]);
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfigTemplate3D graphicsConfigTemplate3D = new GraphicsConfigTemplate3D();
        graphicsConfigTemplate3D.setStereo(1);
        GraphicsConfiguration graphicsConfiguration = graphicsConfigTemplate3D.getBestConfiguration(graphicsDevice.getConfigurations());
        if (graphicsConfiguration == null) {
            System.err.println("Unable to find a Stereo visual");
            System.exit(1);
        }
        ImmersaDeskDisplayRendererJ3D immersaDeskDisplayRendererJ3D = new ImmersaDeskDisplayRendererJ3D(n, n2);
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("display1", (DisplayRendererJ3D)immersaDeskDisplayRendererJ3D, graphicsConfiguration);
        AreaAdapter areaAdapter = new AreaAdapter(stringArray[0]);
        FlatField flatField = areaAdapter.getData();
        FunctionType functionType = (FunctionType)flatField.getType();
        RealType realType = (RealType)((RealTupleType)functionType.getRange()).getComponent(0);
        displayImplJ3D.addMap(new ScalarMap(RealType.Latitude, Display.Latitude));
        displayImplJ3D.addMap(new ScalarMap(RealType.Longitude, Display.Longitude));
        ScalarMap scalarMap = new ScalarMap(realType, Display.RGB);
        displayImplJ3D.addMap(scalarMap);
        BaseMapAdapter baseMapAdapter = new BaseMapAdapter(stringArray[1]);
        UnionSet unionSet = baseMapAdapter.getData();
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("MapLines");
        dataReferenceImpl.setData(unionSet);
        ConstantMap[] constantMapArray = new ConstantMap[]{new ConstantMap(1.002, Display.Radius), new ConstantMap(0.0, Display.Blue)};
        displayImplJ3D.addReference(dataReferenceImpl, constantMapArray);
        DataReferenceImpl dataReferenceImpl2 = new DataReferenceImpl("ImageRef");
        dataReferenceImpl2.setData(flatField);
        displayImplJ3D.addReferences((DataRenderer)new ImageRendererJ3D(), dataReferenceImpl2);
        displayImplJ3D.addDisplayListener((DisplayListener)this);
        this.rotate_x((LocalDisplay)displayImplJ3D);
        JFrame jFrame = new JFrame("Satellite Display");
        jFrame.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(displayImplJ3D.getComponent());
        jFrame.getContentPane().add(jPanel);
        int n3 = 1280;
        int n4 = 1024;
        ((Component)jFrame).setSize(n3, n4);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)jFrame).setLocation(dimension.width / 2 - n3 / 2, dimension.height / 2 - n4 / 2);
        ((Component)jFrame).setVisible(true);
    }
}

