/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthorizationInfo;
import HTTPClient.Cookie;
import HTTPClient.HttpHeaderElement;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.URI;
import java.lang.reflect.Array;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.Vector;

public class Util {
    private static final BitSet Separators = new BitSet(128);
    private static final BitSet TokenChar = new BitSet(128);
    private static final BitSet UnsafeChar = new BitSet(128);
    private static DateFormat http_format;
    private static DateFormat parse_1123;
    private static DateFormat parse_850;
    private static DateFormat parse_asctime;
    private static final Object http_format_lock;
    private static final Object http_parse_lock;
    static final char[] hex_map;

    static final Object[] resizeArray(Object[] objectArray, int n) {
        Class<?> clazz = objectArray.getClass().getComponentType();
        Object[] objectArray2 = (Object[])Array.newInstance(clazz, n);
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length < n ? objectArray.length : n);
        return objectArray2;
    }

    static final NVPair[] resizeArray(NVPair[] nVPairArray, int n) {
        NVPair[] nVPairArray2 = new NVPair[n];
        System.arraycopy(nVPairArray, 0, nVPairArray2, 0, nVPairArray.length < n ? nVPairArray.length : n);
        return nVPairArray2;
    }

    static final AuthorizationInfo[] resizeArray(AuthorizationInfo[] authorizationInfoArray, int n) {
        AuthorizationInfo[] authorizationInfoArray2 = new AuthorizationInfo[n];
        System.arraycopy(authorizationInfoArray, 0, authorizationInfoArray2, 0, authorizationInfoArray.length < n ? authorizationInfoArray.length : n);
        return authorizationInfoArray2;
    }

    static final Cookie[] resizeArray(Cookie[] cookieArray, int n) {
        Cookie[] cookieArray2 = new Cookie[n];
        System.arraycopy(cookieArray, 0, cookieArray2, 0, cookieArray.length < n ? cookieArray.length : n);
        return cookieArray2;
    }

    static final String[] resizeArray(String[] stringArray, int n) {
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length < n ? stringArray.length : n);
        return stringArray2;
    }

    static final boolean[] resizeArray(boolean[] blArray, int n) {
        boolean[] blArray2 = new boolean[n];
        System.arraycopy(blArray, 0, blArray2, 0, blArray.length < n ? blArray.length : n);
        return blArray2;
    }

    static final byte[] resizeArray(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length < n ? byArray.length : n);
        return byArray2;
    }

    static final char[] resizeArray(char[] cArray, int n) {
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length < n ? cArray.length : n);
        return cArray2;
    }

    static final int[] resizeArray(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length < n ? nArray.length : n);
        return nArray2;
    }

    static String[] splitProperty(String string) {
        if (string == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringTokenizer.nextToken().trim();
            ++n;
        }
        return stringArray;
    }

    static final Hashtable getList(Hashtable hashtable, Object object) {
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            Hashtable hashtable3 = (Hashtable)hashtable.get(object);
            if (hashtable3 == null) {
                hashtable3 = new Hashtable();
                hashtable.put(object, hashtable3);
            }
            Hashtable hashtable4 = hashtable3;
            Object var3_5 = null;
            return hashtable4;
        }
    }

    static final int[] compile_search(byte[] byArray) {
        int[] nArray = new int[]{0, 1, 0, 1, 0, 1};
        int n = 0;
        while (n < byArray.length) {
            int n2 = n + 1;
            while (n2 < byArray.length) {
                if (byArray[n] == byArray[n2]) break;
                ++n2;
            }
            if (n2 < byArray.length) {
                if (n2 - n > nArray[1]) {
                    nArray[4] = nArray[2];
                    nArray[5] = nArray[3];
                    nArray[2] = nArray[0];
                    nArray[3] = nArray[1];
                    nArray[0] = n;
                    nArray[1] = n2 - n;
                } else if (n2 - n > nArray[3]) {
                    nArray[4] = nArray[2];
                    nArray[5] = nArray[3];
                    nArray[2] = n;
                    nArray[3] = n2 - n;
                } else if (n2 - n > nArray[3]) {
                    nArray[4] = n;
                    nArray[5] = n2 - n;
                }
            }
            ++n;
        }
        nArray[1] = nArray[1] + nArray[0];
        nArray[3] = nArray[3] + nArray[2];
        nArray[5] = nArray[5] + nArray[4];
        return nArray;
    }

    static final int findStr(byte[] byArray, int[] nArray, byte[] byArray2, int n, int n2) {
        int n3 = nArray[0];
        int n4 = nArray[1];
        int n5 = n4 - n3;
        int n6 = nArray[2];
        int n7 = nArray[3];
        int n8 = n7 - n6;
        int n9 = nArray[4];
        int n10 = nArray[5];
        int n11 = n10 - n9;
        while (n + byArray.length <= n2) {
            if (byArray[n4] == byArray2[n + n4]) {
                if (byArray[n3] == byArray2[n + n3]) {
                    boolean bl = true;
                    int n12 = 0;
                    while (n12 < byArray.length) {
                        if (byArray[n12] != byArray2[n + n12]) {
                            bl = false;
                            break;
                        }
                        ++n12;
                    }
                    if (bl) break;
                }
                n += n5;
                continue;
            }
            if (byArray[n7] == byArray2[n + n7]) {
                n += n8;
                continue;
            }
            if (byArray[n10] == byArray2[n + n10]) {
                n += n11;
                continue;
            }
            ++n;
        }
        if (n + byArray.length > n2) {
            return -1;
        }
        return n;
    }

    public static final String dequoteString(String string) {
        if (string.indexOf(92) == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            if (cArray[n] == '\\' && n + 1 < cArray.length) {
                System.arraycopy(cArray, n + 1, cArray, n, cArray.length - n - 1);
                ++n2;
            }
            ++n;
        }
        return new String(cArray, 0, cArray.length - n2);
    }

    public static final String quoteString(String string, String string2) {
        char[] cArray = string2.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (string.indexOf(cArray[n]) != -1) break;
            ++n;
        }
        if (n == cArray.length) {
            return string;
        }
        int n2 = string.length();
        char[] cArray2 = new char[n2 * 2];
        string.getChars(0, n2, cArray2, 0);
        int n3 = 0;
        while (n3 < n2) {
            if (string2.indexOf(cArray2[n3], 0) != -1) {
                if (n2 == cArray2.length) {
                    cArray2 = Util.resizeArray(cArray2, n2 + string.length());
                }
                System.arraycopy(cArray2, n3, cArray2, n3 + 1, n2 - n3);
                ++n2;
                cArray2[n3++] = 92;
            }
            ++n3;
        }
        return new String(cArray2, 0, n2);
    }

    public static final Vector parseHeader(String string) throws ParseException {
        return Util.parseHeader(string, true);
    }

    public static final Vector parseHeader(String string, boolean bl) throws ParseException {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        Vector<HttpHeaderElement> vector = new Vector<HttpHeaderElement>();
        boolean bl2 = true;
        int n = -1;
        int n2 = 0;
        int n3 = cArray.length;
        int[] nArray = new int[1];
        while (true) {
            String string2;
            if (!bl2) {
                n = Util.skipSpace(cArray, n2);
                if (n == n3) break;
                if (cArray[n] != ',') {
                    throw new ParseException("Bad header format: '" + string + "'\nExpected \",\" at position " + n);
                }
            }
            bl2 = false;
            if ((n = Util.skipSpace(cArray, n + 1)) == n3) break;
            if (cArray[n] == ',') {
                n2 = n;
                continue;
            }
            if (cArray[n] == '=' || cArray[n] == ';' || cArray[n] == '\"') {
                throw new ParseException("Bad header format: '" + string + "'\nEmpty element name at position " + n);
            }
            n2 = n + 1;
            while (n2 < n3 && !Character.isWhitespace(cArray[n2]) && cArray[n2] != '=' && cArray[n2] != ',' && cArray[n2] != ';') {
                ++n2;
            }
            String string3 = new String(cArray, n, n2 - n);
            n = Util.skipSpace(cArray, n2);
            if (n < n3 && cArray[n] == '=') {
                nArray[0] = n + 1;
                string2 = Util.parseValue(cArray, nArray, string, bl);
                n2 = nArray[0];
            } else {
                string2 = null;
                n2 = n;
            }
            NVPair[] nVPairArray = new NVPair[]{};
            while ((n = Util.skipSpace(cArray, n2)) != n3 && cArray[n] == ';') {
                String string4;
                if ((n = Util.skipSpace(cArray, n + 1)) == n3 || cArray[n] == ',') {
                    n2 = n;
                    break;
                }
                if (cArray[n] == ';') {
                    n2 = n;
                    continue;
                }
                if (cArray[n] == '=' || cArray[n] == '\"') {
                    throw new ParseException("Bad header format: '" + string + "'\nEmpty parameter name at position " + n);
                }
                n2 = n + 1;
                while (n2 < n3 && !Character.isWhitespace(cArray[n2]) && cArray[n2] != '=' && cArray[n2] != ',' && cArray[n2] != ';') {
                    ++n2;
                }
                String string5 = new String(cArray, n, n2 - n);
                n = Util.skipSpace(cArray, n2);
                if (n < n3 && cArray[n] == '=') {
                    nArray[0] = n + 1;
                    string4 = Util.parseValue(cArray, nArray, string, bl);
                    n2 = nArray[0];
                } else {
                    string4 = null;
                    n2 = n;
                }
                nVPairArray = Util.resizeArray(nVPairArray, nVPairArray.length + 1);
                nVPairArray[nVPairArray.length - 1] = new NVPair(string5, string4);
            }
            vector.addElement(new HttpHeaderElement(string3, string2, nVPairArray));
        }
        return vector;
    }

    private static String parseValue(char[] cArray, int[] nArray, String string, boolean bl) throws ParseException {
        String string2;
        int n;
        int n2 = n = nArray[0];
        int n3 = cArray.length;
        if ((n = Util.skipSpace(cArray, n)) < n3 && cArray[n] == '\"') {
            n2 = ++n;
            char[] cArray2 = null;
            int n4 = 0;
            int n5 = n;
            while (n2 < n3 && cArray[n2] != '\"') {
                if (cArray[n2] == '\\') {
                    if (bl) {
                        if (cArray2 == null) {
                            cArray2 = new char[cArray.length];
                        }
                        System.arraycopy(cArray, n5, cArray2, n4, n2 - n5);
                        n4 += n2 - n5;
                        n5 = ++n2;
                    } else {
                        ++n2;
                    }
                }
                ++n2;
            }
            if (n2 == n3) {
                throw new ParseException("Bad header format: '" + string + "'\nClosing <\"> for quoted-string" + " starting at position " + (n - 1) + " not found");
            }
            if (cArray2 != null) {
                System.arraycopy(cArray, n5, cArray2, n4, n2 - n5);
                string2 = new String(cArray2, 0, n4 += n2 - n5);
            } else {
                string2 = new String(cArray, n, n2 - n);
            }
        } else {
            n2 = n;
            while (n2 < n3 && !Character.isWhitespace(cArray[n2]) && cArray[n2] != ',' && cArray[n2] != ';') {
                ++n2;
            }
            string2 = new String(cArray, n, n2 - n);
        }
        nArray[0] = ++n2;
        return string2;
    }

    public static final boolean hasToken(String string, String string2) throws ParseException {
        if (string == null) {
            return false;
        }
        return Util.parseHeader(string).contains(new HttpHeaderElement(string2));
    }

    public static final HttpHeaderElement getElement(Vector vector, String string) {
        int n = vector.indexOf(new HttpHeaderElement(string));
        if (n == -1) {
            return null;
        }
        return (HttpHeaderElement)vector.elementAt(n);
    }

    public static final String getParameter(String string, String string2) throws ParseException {
        NVPair[] nVPairArray = ((HttpHeaderElement)Util.parseHeader(string2).firstElement()).getParams();
        int n = 0;
        while (n < nVPairArray.length) {
            if (nVPairArray[n].getName().equalsIgnoreCase(string)) {
                return nVPairArray[n].getValue();
            }
            ++n;
        }
        return null;
    }

    public static final String assembleHeader(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer(200);
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ((HttpHeaderElement)vector.elementAt(n2)).appendTo(stringBuffer);
            stringBuffer.append(", ");
            ++n2;
        }
        stringBuffer.setLength(stringBuffer.length() - 2);
        return stringBuffer.toString();
    }

    static final int skipSpace(char[] cArray, int n) {
        int n2 = cArray.length;
        while (n < n2 && Character.isWhitespace(cArray[n])) {
            ++n;
        }
        return n;
    }

    static final int findSpace(char[] cArray, int n) {
        int n2 = cArray.length;
        while (n < n2 && !Character.isWhitespace(cArray[n])) {
            ++n;
        }
        return n;
    }

    static final int skipToken(char[] cArray, int n) {
        int n2 = cArray.length;
        while (n < n2 && TokenChar.get(cArray[n])) {
            ++n;
        }
        return n;
    }

    static final boolean needsQuoting(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n && TokenChar.get(string.charAt(n2))) {
            ++n2;
        }
        return n2 < n;
    }

    public static final boolean sameHttpURL(URL uRL, URL uRL2) {
        if (!uRL.getProtocol().equalsIgnoreCase(uRL2.getProtocol())) {
            return false;
        }
        if (!uRL.getHost().equalsIgnoreCase(uRL2.getHost())) {
            return false;
        }
        int n = uRL.getPort();
        int n2 = uRL2.getPort();
        if (n == -1) {
            n = URI.defaultPort(uRL.getProtocol());
        }
        if (n2 == -1) {
            n2 = URI.defaultPort(uRL.getProtocol());
        }
        if (n != n2) {
            return false;
        }
        try {
            return URI.unescape(uRL.getFile(), null).equals(URI.unescape(uRL2.getFile(), null));
        }
        catch (ParseException parseException) {
            return uRL.getFile().equals(uRL2.getFile());
        }
    }

    public static final int defaultPort(String string) {
        return URI.defaultPort(string);
    }

    static final Date parseHttpDate(String string) {
        Object object = http_parse_lock;
        synchronized (object) {
            if (parse_1123 == null) {
                Util.setupParsers();
            }
        }
        try {
            return parse_1123.parse(string);
        }
        catch (java.text.ParseException parseException) {
            try {
                return parse_850.parse(string);
            }
            catch (java.text.ParseException parseException2) {
                try {
                    return parse_asctime.parse(string);
                }
                catch (java.text.ParseException parseException3) {
                    throw new IllegalArgumentException(parseException3.toString());
                }
            }
        }
    }

    private static final void setupParsers() {
        parse_1123 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        parse_850 = new SimpleDateFormat("EEEE, dd-MMM-yy HH:mm:ss 'GMT'", Locale.US);
        parse_asctime = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.US);
        parse_1123.setTimeZone(new SimpleTimeZone(0, "GMT"));
        parse_850.setTimeZone(new SimpleTimeZone(0, "GMT"));
        parse_asctime.setTimeZone(new SimpleTimeZone(0, "GMT"));
        parse_1123.setLenient(true);
        parse_850.setLenient(true);
        parse_asctime.setLenient(true);
    }

    public static final String httpDate(Date date) {
        Object object = http_format_lock;
        synchronized (object) {
            if (http_format == null) {
                Util.setupFormatter();
            }
        }
        return http_format.format(date);
    }

    private static final void setupFormatter() {
        http_format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        http_format.setTimeZone(new SimpleTimeZone(0, "GMT"));
    }

    static final String escapeUnsafeChars(String string) {
        int n = string.length();
        char[] cArray = new char[3 * n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (c >= '\u0080' || UnsafeChar.get(c)) {
                cArray[n2++] = 37;
                cArray[n2++] = hex_map[(c & 0xF0) >>> 4];
                cArray[n2++] = hex_map[c & 0xF];
            } else {
                cArray[n2++] = c;
            }
            ++n3;
        }
        if (n2 > n) {
            return new String(cArray, 0, n2);
        }
        return string;
    }

    public static final String getPath(String string) {
        int n = string.length();
        int n2 = string.indexOf(35);
        if (n2 != -1) {
            n = n2;
        }
        if ((n2 = string.indexOf(63)) != -1 && n2 < n) {
            n = n2;
        }
        if ((n2 = string.indexOf(59)) != -1 && n2 < n) {
            n = n2;
        }
        return string.substring(0, n);
    }

    public static final String getParams(String string) {
        int n = string.indexOf(59);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(35);
        if (n2 != -1 && n2 < n) {
            return null;
        }
        int n3 = string.indexOf(63);
        if (n3 != -1 && n3 < n) {
            return null;
        }
        if (n3 == -1 && n2 == -1) {
            return string.substring(n + 1);
        }
        if (n2 == -1 || n3 != -1 && n3 < n2) {
            return string.substring(n + 1, n3);
        }
        return string.substring(n + 1, n2);
    }

    public static final String getQuery(String string) {
        int n = string.indexOf(63);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(35);
        if (n2 != -1 && n2 < n) {
            return null;
        }
        if (n2 == -1) {
            return string.substring(n + 1);
        }
        return string.substring(n + 1, n2);
    }

    public static final String getFragment(String string) {
        int n = string.indexOf(35);
        if (n == -1) {
            return null;
        }
        return string.substring(n + 1);
    }

    public static final boolean wildcardMatch(String string, String string2) {
        return Util.wildcardMatch(string, string2, 0, 0, string.length(), string2.length());
    }

    /*
     * Unable to fully structure code
     */
    private static final boolean wildcardMatch(String var0, String var1_1, int var2_2, int var3_3, int var4_4, int var5_5) {
        var6_6 = var0.indexOf(42, var2_2);
        if (var6_6 < 0) {
            return var4_4 - var2_2 == var5_5 - var3_3 && var0.regionMatches(var2_2, var1_1, var3_3, var4_4 - var2_2) != false;
        }
        if (!var0.regionMatches(var2_2, var1_1, var3_3, var6_6 - var2_2)) {
            return false;
        }
        if (var6_6 != var4_4 - 1) ** GOTO lbl9
        return true;
lbl-1000:
        // 1 sources

        {
            ++var3_3;
lbl9:
            // 2 sources

            ** while (!Util.wildcardMatch((String)var0, (String)var1_1, (int)(var6_6 + 1), (int)var3_3, (int)var4_4, (int)var5_5) && var3_3 < var5_5)
        }
lbl10:
        // 1 sources

        return var3_3 < var5_5;
    }

    private Util() {
    }

    static {
        http_format_lock = new Object();
        http_parse_lock = new Object();
        Separators.set(40);
        Separators.set(41);
        Separators.set(60);
        Separators.set(62);
        Separators.set(64);
        Separators.set(44);
        Separators.set(59);
        Separators.set(58);
        Separators.set(92);
        Separators.set(34);
        Separators.set(47);
        Separators.set(91);
        Separators.set(93);
        Separators.set(63);
        Separators.set(61);
        Separators.set(123);
        Separators.set(125);
        Separators.set(32);
        Separators.set(9);
        int n = 32;
        while (n < 127) {
            TokenChar.set(n);
            ++n;
        }
        TokenChar.xor(Separators);
        n = 0;
        while (n < 32) {
            UnsafeChar.set(n);
            ++n;
        }
        UnsafeChar.set(32);
        UnsafeChar.set(60);
        UnsafeChar.set(62);
        UnsafeChar.set(34);
        UnsafeChar.set(123);
        UnsafeChar.set(125);
        UnsafeChar.set(124);
        UnsafeChar.set(92);
        UnsafeChar.set(94);
        UnsafeChar.set(126);
        UnsafeChar.set(91);
        UnsafeChar.set(93);
        UnsafeChar.set(96);
        UnsafeChar.set(127);
        hex_map = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

