/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.ChunkedInputStream;
import HTTPClient.HTTPClientModule;
import HTTPClient.HttpHeaderElement;
import HTTPClient.Log;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.UncompressInputStream;
import HTTPClient.Util;
import java.io.IOException;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

class TransferEncodingModule
implements HTTPClientModule {
    public int requestHandler(Request request, Response[] responseArray) throws ModuleException {
        Vector<HttpHeaderElement> vector;
        NVPair[] nVPairArray = request.getHeaders();
        int n = 0;
        while (n < nVPairArray.length) {
            if (nVPairArray[n].getName().equalsIgnoreCase("TE")) break;
            ++n;
        }
        if (n == nVPairArray.length) {
            nVPairArray = Util.resizeArray(nVPairArray, n + 1);
            request.setHeaders(nVPairArray);
            vector = new Vector<HttpHeaderElement>();
        } else {
            try {
                vector = Util.parseHeader(nVPairArray[n].getValue());
            }
            catch (ParseException parseException) {
                throw new ModuleException(parseException.toString());
            }
        }
        HttpHeaderElement httpHeaderElement = Util.getElement(vector, "*");
        if (httpHeaderElement != null) {
            NVPair[] nVPairArray2 = httpHeaderElement.getParams();
            n = 0;
            while (n < nVPairArray2.length) {
                if (nVPairArray2[n].getName().equalsIgnoreCase("q")) break;
                ++n;
            }
            if (n == nVPairArray2.length) {
                return 0;
            }
            if (nVPairArray2[n].getValue() == null || nVPairArray2[n].getValue().length() == 0) {
                throw new ModuleException("Invalid q value for \"*\" in TE header: ");
            }
            try {
                if ((double)Float.valueOf(nVPairArray2[n].getValue()).floatValue() > 0.0) {
                    return 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ModuleException("Invalid q value for \"*\" in TE header: " + numberFormatException.getMessage());
            }
        }
        if (!vector.contains(new HttpHeaderElement("deflate"))) {
            vector.addElement(new HttpHeaderElement("deflate"));
        }
        if (!vector.contains(new HttpHeaderElement("gzip"))) {
            vector.addElement(new HttpHeaderElement("gzip"));
        }
        if (!vector.contains(new HttpHeaderElement("compress"))) {
            vector.addElement(new HttpHeaderElement("compress"));
        }
        nVPairArray[n] = new NVPair("TE", Util.assembleHeader(vector));
        return 0;
    }

    public void responsePhase1Handler(Response response, RoRequest roRequest) {
    }

    public int responsePhase2Handler(Response response, Request request) {
        return 10;
    }

    /*
     * Unable to fully structure code
     */
    public void responsePhase3Handler(Response var1_1, RoRequest var2_2) throws IOException, ModuleException {
        var3_3 = var1_1.getHeader("Transfer-Encoding");
        if (var3_3 == null || var2_2.getMethod().equals("HEAD")) {
            return;
        }
        try {
            var4_4 = Util.parseHeader(var3_3);
            if (true) ** GOTO lbl32
        }
        catch (ParseException var5_5) {
            throw new ModuleException(var5_5.toString());
        }
        do {
            if ((var5_6 = ((HttpHeaderElement)var4_4.lastElement()).getName()).equalsIgnoreCase("gzip")) {
                Log.write(32, "TEM:   pushing gzip-input-stream");
                var1_1.inp_stream = new GZIPInputStream(var1_1.inp_stream);
            } else if (var5_6.equalsIgnoreCase("deflate")) {
                Log.write(32, "TEM:   pushing inflater-input-stream");
                var1_1.inp_stream = new InflaterInputStream(var1_1.inp_stream);
            } else if (var5_6.equalsIgnoreCase("compress")) {
                Log.write(32, "TEM:   pushing uncompress-input-stream");
                var1_1.inp_stream = new UncompressInputStream(var1_1.inp_stream);
            } else if (var5_6.equalsIgnoreCase("chunked")) {
                Log.write(32, "TEM:   pushing chunked-input-stream");
                var1_1.inp_stream = new ChunkedInputStream(var1_1.inp_stream);
            } else if (var5_6.equalsIgnoreCase("identity")) {
                Log.write(32, "TEM:   ignoring 'identity' token");
            } else {
                Log.write(32, "TEM:   Unknown transfer encoding '" + var5_6 + "'");
                break;
            }
            var4_4.removeElementAt(var4_4.size() - 1);
lbl32:
            // 2 sources

        } while (var4_4.size() > 0);
        if (var4_4.size() > 0) {
            var1_1.setHeader("Transfer-Encoding", Util.assembleHeader(var4_4));
        } else {
            var1_1.deleteHeader("Transfer-Encoding");
        }
    }

    public void trailerHandler(Response response, RoRequest roRequest) {
    }

    TransferEncodingModule() {
    }
}

