/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.BufferedInputStream;
import HTTPClient.Codecs;
import HTTPClient.GlobalConstants;
import HTTPClient.HTTPConnection;
import HTTPClient.LinkedList;
import HTTPClient.Log;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.RespInputStream;
import HTTPClient.Response;
import HTTPClient.ResponseHandler;
import HTTPClient.RetryException;
import HTTPClient.SocketTimeout;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;

class StreamDemultiplexor
implements GlobalConstants {
    private static SocketTimeout TimerThread = null;
    private static Object cleanup;
    private int Protocol;
    private HTTPConnection Connection;
    private BufferedInputStream Stream;
    private Socket Sock = null;
    private ResponseHandler MarkedForClose;
    private SocketTimeout.TimeoutEntry Timer = null;
    private LinkedList RespHandlerList;
    private long chunk_len;
    private int cur_timeout = 0;

    private void init(Socket socket) throws IOException {
        Log.write(4, "Demux: Initializing Stream Demultiplexor (" + this.hashCode() + ")");
        this.Sock = socket;
        this.Stream = new BufferedInputStream(socket.getInputStream());
        this.MarkedForClose = null;
        this.chunk_len = -1L;
        this.Timer = TimerThread.setTimeout(this);
        this.Timer.hyber();
    }

    void register(Response response, Request request) throws RetryException {
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            if (this.Sock == null) {
                throw new RetryException();
            }
            this.RespHandlerList.addToEnd(new ResponseHandler(response, request, this));
        }
    }

    RespInputStream getStream(Response response) {
        ResponseHandler responseHandler;
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            responseHandler = (ResponseHandler)this.RespHandlerList.enumerate();
            while (responseHandler != null) {
                if (responseHandler.resp == response) break;
                responseHandler = (ResponseHandler)this.RespHandlerList.next();
            }
        }
        if (responseHandler != null) {
            return responseHandler.stream;
        }
        return null;
    }

    void restartTimer() {
        if (this.Timer != null) {
            this.Timer.reset();
        }
    }

    /*
     * Unable to fully structure code
     */
    int read(byte[] var1_1, int var2_2, int var3_3, ResponseHandler var4_4, int var5_5) throws IOException {
        if (var4_4.exception != null) {
            var4_4.exception.fillInStackTrace();
            throw var4_4.exception;
        }
        if (!var4_4.eof) ** GOTO lbl16
        return -1;
lbl-1000:
        // 1 sources

        {
            try {
                var6_6.stream.readAll(var5_5);
                continue;
            }
            catch (IOException var7_7) {
                if (var7_7 instanceof InterruptedIOException) {
                    throw var7_7;
                }
                var4_4.exception.fillInStackTrace();
                throw var4_4.exception;
            }
lbl16:
            // 2 sources

            ** while ((var6_6 = (ResponseHandler)this.RespHandlerList.getFirst()) != null && var6_6 != var4_4)
        }
lbl17:
        // 1 sources

        var7_8 = this;
        synchronized (var7_8) {
            if (var4_4.exception != null) {
                var4_4.exception.fillInStackTrace();
                throw var4_4.exception;
            }
            if (var4_4.resp.cd_type != 1) {
                Log.write(4, "Demux: Reading for stream " + var4_4.stream.hashCode());
            }
            if (this.Timer != null) {
                this.Timer.hyber();
            }
            try {
                var10_9 = -1;
                if (var5_5 != this.cur_timeout) {
                    Log.write(4, "Demux: Setting timeout to " + var5_5 + " ms");
                    this.Sock.setSoTimeout(var5_5);
                    this.cur_timeout = var5_5;
                }
                switch (var4_4.resp.cd_type) {
                    case 1: {
                        var10_9 = this.Stream.read(var1_1, var2_2, var3_3);
                        if (var10_9 != -1) break;
                        throw new EOFException("Premature EOF encountered");
                    }
                    case 2: {
                        var10_9 = -1;
                        this.close(var4_4);
                        break;
                    }
                    case 3: {
                        var10_9 = this.Stream.read(var1_1, var2_2, var3_3);
                        if (var10_9 != -1) break;
                        this.close(var4_4);
                        break;
                    }
                    case 4: {
                        var11_13 = var4_4.resp.ContentLength;
                        if (var3_3 > var11_13 - var4_4.stream.count) {
                            var3_3 = var11_13 - var4_4.stream.count;
                        }
                        if ((var10_9 = this.Stream.read(var1_1, var2_2, var3_3)) == -1) {
                            throw new EOFException("Premature EOF encountered");
                        }
                        if (var4_4.stream.count + var10_9 != var11_13) break;
                        this.close(var4_4);
                        break;
                    }
                    case 5: {
                        if (this.chunk_len == -1L) {
                            this.chunk_len = Codecs.getChunkLength(this.Stream);
                        }
                        if (this.chunk_len > 0L) {
                            if ((long)var3_3 > this.chunk_len) {
                                var3_3 = (int)this.chunk_len;
                            }
                            if ((var10_9 = this.Stream.read(var1_1, var2_2, var3_3)) == -1) {
                                throw new EOFException("Premature EOF encountered");
                            }
                            this.chunk_len -= (long)var10_9;
                            if (this.chunk_len != 0L) break;
                            this.Stream.read();
                            this.Stream.read();
                            this.chunk_len = -1L;
                            break;
                        }
                        var4_4.resp.readTrailers(this.Stream);
                        var10_9 = -1;
                        this.close(var4_4);
                        this.chunk_len = -1L;
                        break;
                    }
                    case 6: {
                        var12_14 = var4_4.getEndBoundary(this.Stream);
                        var13_15 = var4_4.getEndCompiled(this.Stream);
                        var10_9 = this.Stream.read(var1_1, var2_2, var3_3);
                        if (var10_9 == -1) {
                            throw new EOFException("Premature EOF encountered");
                        }
                        var14_16 = this.Stream.pastEnd(var12_14, var13_15);
                        if (var14_16 == -1) break;
                        var10_9 -= var14_16;
                        this.close(var4_4);
                        break;
                    }
                    default: {
                        throw new Error("Internal Error in StreamDemultiplexor: Invalid cd_type " + var4_4.resp.cd_type);
                    }
                }
                this.restartTimer();
                var9_17 = var10_9;
                var8_18 = null;
                return var9_17;
            }
            catch (InterruptedIOException var10_10) {
                this.restartTimer();
                throw var10_10;
            }
            catch (IOException var10_11) {
                Log.write(4, "Demux: ", var10_11);
                this.close(var10_11, true);
                throw var4_4.exception;
            }
            catch (ParseException var10_12) {
                Log.write(4, "Demux: ", var10_12);
                this.close(new IOException(var10_12.toString()), true);
                throw var4_4.exception;
            }
        }
    }

    synchronized long skip(long l, ResponseHandler responseHandler) throws IOException {
        if (responseHandler.exception != null) {
            responseHandler.exception.fillInStackTrace();
            throw responseHandler.exception;
        }
        if (responseHandler.eof) {
            return 0L;
        }
        byte[] byArray = new byte[(int)l];
        int n = this.read(byArray, 0, (int)l, responseHandler, 0);
        if (n == -1) {
            return 0L;
        }
        return n;
    }

    synchronized int available(ResponseHandler responseHandler) throws IOException {
        if (responseHandler != null && responseHandler.exception != null) {
            responseHandler.exception.fillInStackTrace();
            throw responseHandler.exception;
        }
        if (responseHandler != null && responseHandler.eof) {
            return 0;
        }
        int n = this.Stream.available();
        if (responseHandler == null) {
            return n;
        }
        switch (responseHandler.resp.cd_type) {
            case 2: {
                return 0;
            }
            case 1: {
                return n > 0 ? 1 : 0;
            }
            case 3: {
                return n;
            }
            case 4: {
                int n2 = responseHandler.resp.ContentLength;
                return n < (n2 -= responseHandler.stream.count) ? n : n2;
            }
            case 5: {
                return n;
            }
            case 6: {
                return n;
            }
        }
        throw new Error("Internal Error in StreamDemultiplexor: Invalid cd_type " + responseHandler.resp.cd_type);
    }

    synchronized void close(IOException iOException, boolean bl) {
        if (this.Sock == null) {
            return;
        }
        Log.write(4, "Demux: Closing all streams and socket (" + this.hashCode() + ")");
        try {
            this.Stream.close();
        }
        catch (IOException iOException2) {
            // empty catch block
        }
        try {
            this.Sock.close();
        }
        catch (IOException iOException3) {
            // empty catch block
        }
        this.Sock = null;
        if (this.Timer != null) {
            this.Timer.kill();
            this.Timer = null;
        }
        this.Connection.DemuxList.remove(this);
        if (iOException != null) {
            LinkedList linkedList = this.RespHandlerList;
            synchronized (linkedList) {
                this.retry_requests(iOException, bl);
            }
        }
    }

    private void retry_requests(IOException iOException, boolean bl) {
        RetryException retryException = null;
        RetryException retryException2 = null;
        ResponseHandler responseHandler = (ResponseHandler)this.RespHandlerList.enumerate();
        while (responseHandler != null) {
            if (responseHandler.resp.got_headers) {
                responseHandler.exception = iOException;
            } else {
                RetryException retryException3 = new RetryException(iOException.getMessage());
                if (retryException == null) {
                    retryException = retryException3;
                }
                retryException3.request = responseHandler.request;
                retryException3.response = responseHandler.resp;
                retryException3.exception = iOException;
                retryException3.conn_reset = bl;
                retryException3.first = retryException;
                retryException3.addToListAfter(retryException2);
                retryException2 = retryException3;
                responseHandler.exception = retryException3;
            }
            this.RespHandlerList.remove(responseHandler);
            responseHandler = (ResponseHandler)this.RespHandlerList.next();
        }
    }

    private void close(ResponseHandler responseHandler) {
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            if (responseHandler != (ResponseHandler)this.RespHandlerList.getFirst()) {
                Object var3_3 = null;
                return;
            }
            Log.write(4, "Demux: Closing stream " + responseHandler.stream.hashCode());
            responseHandler.eof = true;
            this.RespHandlerList.remove(responseHandler);
        }
        if (responseHandler == this.MarkedForClose) {
            this.close(new IOException("Premature end of Keep-Alive"), false);
        } else {
            this.closeSocketIfAllStreamsClosed();
        }
    }

    synchronized void closeSocketIfAllStreamsClosed() {
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            ResponseHandler responseHandler = (ResponseHandler)this.RespHandlerList.enumerate();
            while (responseHandler != null && responseHandler.stream.closed) {
                if (responseHandler == this.MarkedForClose) {
                    ResponseHandler responseHandler2;
                    do {
                        responseHandler2 = (ResponseHandler)this.RespHandlerList.getFirst();
                        this.RespHandlerList.remove(responseHandler2);
                    } while (responseHandler2 != responseHandler);
                    this.close(new IOException("Premature end of Keep-Alive"), false);
                    Object var2_4 = null;
                    return;
                }
                responseHandler = (ResponseHandler)this.RespHandlerList.next();
            }
        }
    }

    synchronized Socket getSocket() {
        if (this.MarkedForClose != null) {
            return null;
        }
        if (this.Timer != null) {
            this.Timer.hyber();
        }
        return this.Sock;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void markForClose(Response response) {
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            if (this.RespHandlerList.getFirst() == null) {
                this.close(new IOException("Premature end of Keep-Alive"), false);
                return;
            }
            if (this.Timer != null) {
                this.Timer.kill();
                this.Timer = null;
            }
            ResponseHandler responseHandler = null;
            ResponseHandler responseHandler2 = (ResponseHandler)this.RespHandlerList.enumerate();
            while (true) {
                if (responseHandler2 == null) {
                    if (responseHandler == null) return;
                    this.MarkedForClose = responseHandler;
                    this.closeSocketIfAllStreamsClosed();
                    Log.write(4, "Demux: stream " + responseHandler.stream.hashCode() + " marked for close");
                    return;
                }
                if (responseHandler2.resp == response) {
                    this.MarkedForClose = responseHandler2;
                    Log.write(4, "Demux: stream " + response.inp_stream.hashCode() + " marked for close");
                    this.closeSocketIfAllStreamsClosed();
                    return;
                }
                if (this.MarkedForClose == responseHandler2) {
                    return;
                }
                responseHandler = responseHandler2;
                responseHandler2 = (ResponseHandler)this.RespHandlerList.next();
            }
        }
    }

    void abort() {
        Log.write(4, "Demux: Aborting socket (" + this.hashCode() + ")");
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            ResponseHandler responseHandler = (ResponseHandler)this.RespHandlerList.enumerate();
            while (responseHandler != null) {
                if (responseHandler.resp.http_resp != null) {
                    responseHandler.resp.http_resp.markAborted();
                }
                if (responseHandler.exception == null) {
                    responseHandler.exception = new IOException("Request aborted by user");
                }
                responseHandler = (ResponseHandler)this.RespHandlerList.next();
            }
            if (this.Sock != null) {
                try {
                    try {
                        this.Sock.setSoLinger(false, 0);
                    }
                    catch (SocketException socketException) {
                        // empty catch block
                    }
                    try {
                        this.Stream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        this.Sock.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.Sock = null;
                    if (this.Timer != null) {
                        this.Timer.kill();
                        this.Timer = null;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.Connection.DemuxList.remove(this);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close(null, false);
        super.finalize();
    }

    public String toString() {
        String string;
        switch (this.Protocol) {
            case 0: {
                string = "HTTP";
                break;
            }
            case 1: {
                string = "HTTPS";
                break;
            }
            case 2: {
                string = "SHTTP";
                break;
            }
            case 3: {
                string = "HTTP_NG";
                break;
            }
            default: {
                throw new Error("HTTPClient Internal Error: invalid protocol " + this.Protocol);
            }
        }
        return this.getClass().getName() + "[Protocol=" + string + "]";
    }

    static /* synthetic */ SocketTimeout access$0() {
        return TimerThread;
    }

    StreamDemultiplexor(int n, Socket socket, HTTPConnection hTTPConnection) throws IOException {
        this.Protocol = n;
        this.Connection = hTTPConnection;
        this.RespHandlerList = new LinkedList();
        this.init(socket);
    }

    static {
        TimerThread = new SocketTimeout(60);
        TimerThread.start();
        cleanup = new Object(){
            private final SocketTimeout timer;

            protected void finalize() {
                this.timer.kill();
            }
            {
                this.timer = StreamDemultiplexor.access$0();
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        };
    }
}

