/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.GlobalConstants;
import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPConnection;
import HTTPClient.IdempotentSequence;
import HTTPClient.Log;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RetryException;
import HTTPClient.RoRequest;
import HTTPClient.Util;
import java.io.IOException;

class RetryModule
implements HTTPClientModule,
GlobalConstants {
    public int requestHandler(Request request, Response[] responseArray) {
        return 0;
    }

    public void responsePhase1Handler(Response response, RoRequest roRequest) throws IOException, ModuleException {
        block23: {
            try {
                response.getStatusCode();
                break block23;
            }
            catch (RetryException retryException) {
                Log.write(32, "RtryM: Caught RetryException");
                boolean bl = false;
                try {
                    RetryException retryException2 = retryException.first;
                    synchronized (retryException2) {
                        bl = true;
                        IdempotentSequence idempotentSequence = new IdempotentSequence();
                        RetryException retryException3 = retryException.first;
                        while (retryException3 != null) {
                            idempotentSequence.add(retryException3.request);
                            retryException3 = retryException3.next;
                        }
                        retryException3 = retryException.first;
                        while (retryException3 != null) {
                            Log.write(32, "RtryM: handling exception ", retryException3);
                            Request request = retryException3.request;
                            HTTPConnection hTTPConnection = request.getConnection();
                            if (!idempotentSequence.isIdempotent(request) || hTTPConnection.ServProtVersKnown && hTTPConnection.ServerProtocolVersion >= 65537 && request.num_retries > 0 || (!hTTPConnection.ServProtVersKnown || hTTPConnection.ServerProtocolVersion <= 65536) && request.num_retries > 4 || retryException3.response.got_headers) {
                                retryException3.first = null;
                            } else if (request.getStream() != null) {
                                if (HTTPConnection.deferStreamed) {
                                    request.getStream().reset();
                                    retryException3.response.setRetryRequest(true);
                                }
                                retryException3.first = null;
                            } else {
                                if (request.getData() != null && retryException3.conn_reset) {
                                    if (hTTPConnection.ServProtVersKnown && hTTPConnection.ServerProtocolVersion >= 65537) {
                                        this.addToken(request, "Expect", "100-continue");
                                    } else {
                                        request.delay_entity = 5000L << request.num_retries;
                                    }
                                }
                                if (retryException3.next != null && retryException3.next.request.getData() != null && (!hTTPConnection.ServProtVersKnown || hTTPConnection.ServerProtocolVersion < 65537) && retryException3.conn_reset) {
                                    this.addToken(request, "Connection", "close");
                                }
                                if (hTTPConnection.ServProtVersKnown && hTTPConnection.ServerProtocolVersion >= 65537 && retryException3.conn_reset) {
                                    request.dont_pipeline = true;
                                }
                                request.dont_pipeline = true;
                                Log.write(32, "RtryM: Retrying request '" + request.getMethod() + " " + request.getRequestURI() + "'");
                                if (retryException3.conn_reset) {
                                    ++request.num_retries;
                                }
                                retryException3.response.http_resp.set(request, hTTPConnection.sendRequest(request, retryException3.response.timeout));
                                retryException3.exception = null;
                                retryException3.first = null;
                            }
                            retryException3 = retryException3.next;
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {
                    if (bl) {
                        throw nullPointerException;
                    }
                }
                catch (ParseException parseException) {
                    throw new IOException(parseException.getMessage());
                }
            }
            if (retryException.exception != null) {
                throw retryException.exception;
            }
            retryException.restart = true;
            throw retryException;
        }
    }

    public int responsePhase2Handler(Response response, Request request) {
        request.delay_entity = 0L;
        request.dont_pipeline = false;
        request.num_retries = 0;
        return 10;
    }

    public void responsePhase3Handler(Response response, RoRequest roRequest) {
    }

    public void trailerHandler(Response response, RoRequest roRequest) {
    }

    private void addToken(Request request, String string, String string2) throws ParseException {
        NVPair[] nVPairArray = request.getHeaders();
        int n = 0;
        while (n < nVPairArray.length) {
            if (nVPairArray[n].getName().equalsIgnoreCase(string)) break;
            ++n;
        }
        if (n == nVPairArray.length) {
            nVPairArray = Util.resizeArray(nVPairArray, n + 1);
            nVPairArray[n] = new NVPair(string, string2);
            request.setHeaders(nVPairArray);
        } else if (!Util.hasToken(nVPairArray[n].getValue(), string2)) {
            nVPairArray[n] = new NVPair(string, nVPairArray[n].getValue() + ", " + string2);
        }
    }

    RetryModule() {
    }
}

