/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.TimeZone;

public class Log {
    public static final int CONN = 1;
    public static final int RESP = 2;
    public static final int DEMUX = 4;
    public static final int AUTH = 8;
    public static final int COOKI = 16;
    public static final int MODS = 32;
    public static final int SOCKS = 64;
    public static final int URLC = 128;
    public static final int ALL = -1;
    private static final String NL = System.getProperty("line.separator");
    private static final long TZ_OFF;
    private static int facMask;
    private static Writer logWriter;
    private static boolean closeWriter;
    private static /* synthetic */ Class class$LHTTPClient$Log;

    public static void write(int n, String string) {
        if ((facMask & n) == 0) {
            return;
        }
        try {
            Log.writePrefix();
            logWriter.write(string);
            logWriter.write(NL);
            logWriter.flush();
        }
        catch (IOException iOException) {
            System.err.println("Failed to write to log: " + iOException);
            System.err.println("Failed log Entry was: " + string);
        }
    }

    public static void write(int n, String string, Throwable throwable) {
        if ((facMask & n) == 0) {
            return;
        }
        Class clazz = class$LHTTPClient$Log != null ? class$LHTTPClient$Log : (class$LHTTPClient$Log = Log.class$("HTTPClient.Log"));
        synchronized (clazz) {
            if (!(logWriter instanceof PrintWriter)) {
                logWriter = new PrintWriter(logWriter);
            }
        }
        try {
            Log.writePrefix();
            if (string != null) {
                logWriter.write(string);
            }
            throwable.printStackTrace((PrintWriter)logWriter);
            logWriter.flush();
        }
        catch (IOException iOException) {
            System.err.println("Failed to write to log: " + iOException);
            System.err.print("Failed log Entry was: " + string);
            throwable.printStackTrace(System.err);
        }
    }

    public static void write(int n, String string, ByteArrayOutputStream byteArrayOutputStream) {
        if ((facMask & n) == 0) {
            return;
        }
        try {
            Log.writePrefix();
            if (string != null) {
                logWriter.write(string);
            }
            logWriter.write(NL);
            logWriter.write(new String(byteArrayOutputStream.toByteArray(), "ISO_8859-1"));
            logWriter.flush();
        }
        catch (IOException iOException) {
            System.err.println("Failed to write to log: " + iOException);
            System.err.println("Failed log Entry was: " + string);
            System.err.println(new String(byteArrayOutputStream.toByteArray()));
        }
    }

    private static final void writePrefix() throws IOException {
        logWriter.write("{" + Thread.currentThread().getName() + "} ");
        int n = (int)((System.currentTimeMillis() + TZ_OFF) % 86400000L);
        int n2 = n / 1000;
        int n3 = n2 / 60;
        int n4 = n3 / 60;
        logWriter.write("[" + Log.fill2(n4) + ":" + Log.fill2(n3 - n4 * 60) + ":" + Log.fill2(n2 - n3 * 60) + "." + Log.fill3(n - n2 * 1000) + "] ");
    }

    private static final String fill2(int n) {
        return (n < 10 ? "0" : "") + n;
    }

    private static final String fill3(int n) {
        return (n < 10 ? "00" : (n < 100 ? "0" : "")) + n;
    }

    public static boolean isEnabled(int n) {
        return (facMask & n) != 0;
    }

    public static void setLogging(int n, boolean bl) {
        facMask = bl ? (facMask |= n) : (facMask &= ~n);
    }

    public static void setLogWriter(Writer writer, boolean bl) {
        if (writer == null) {
            return;
        }
        if (closeWriter) {
            try {
                logWriter.close();
            }
            catch (IOException iOException) {
                System.err.println("Error closing log stream: " + iOException);
            }
        }
        logWriter = writer;
        closeWriter = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private Log() {
    }

    static {
        facMask = 0;
        logWriter = new OutputStreamWriter(System.err);
        closeWriter = false;
        Calendar calendar = Calendar.getInstance();
        TZ_OFF = TimeZone.getDefault().getOffset(calendar.get(0), calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), calendar.get(14));
        try {
            String string = System.getProperty("HTTPClient.log.file");
            if (string != null) {
                try {
                    Log.setLogWriter(new FileWriter(string), true);
                }
                catch (IOException iOException) {
                    System.err.println("failed to open file log stream `" + string + "': " + iOException);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            facMask = Integer.getInteger("HTTPClient.log.mask", 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

