/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Request;
import HTTPClient.Util;
import java.util.Enumeration;
import java.util.Hashtable;

class IdempotentSequence {
    private static final int UNKNOWN = 0;
    private static final int HEAD = 1;
    private static final int GET = 2;
    private static final int POST = 3;
    private static final int PUT = 4;
    private static final int DELETE = 5;
    private static final int OPTIONS = 6;
    private static final int TRACE = 7;
    private static final int PROPFIND = 8;
    private static final int PROPPATCH = 9;
    private static final int MKCOL = 10;
    private static final int COPY = 11;
    private static final int MOVE = 12;
    private static final int LOCK = 13;
    private static final int UNLOCK = 14;
    private static final Object INDET = new Object();
    private int[] m_history;
    private String[] r_history;
    private int m_len = 0;
    private int r_len = 0;
    private boolean analysis_done = false;
    private Hashtable threads = new Hashtable();

    public void add(Request request) {
        if (this.m_len >= this.m_history.length) {
            this.m_history = Util.resizeArray(this.m_history, this.m_history.length + 10);
        }
        this.m_history[this.m_len++] = IdempotentSequence.methodNum(request.getMethod());
        if (this.r_len >= this.r_history.length) {
            this.r_history = Util.resizeArray(this.r_history, this.r_history.length + 10);
        }
        this.r_history[this.r_len++] = request.getRequestURI();
    }

    public boolean isIdempotent(Request request) {
        if (!this.analysis_done) {
            this.do_analysis();
        }
        return (Boolean)this.threads.get(request.getRequestURI());
    }

    private void do_analysis() {
        Object object;
        int n = 0;
        while (n < this.r_len) {
            object = this.threads.get(this.r_history[n]);
            if (this.m_history[n] == 0) {
                this.threads.put(this.r_history[n], Boolean.FALSE);
            } else if (object == null) {
                if (IdempotentSequence.methodHasSideEffects(this.m_history[n])) {
                    if (IdempotentSequence.methodIsComplete(this.m_history[n])) {
                        this.threads.put(this.r_history[n], Boolean.TRUE);
                    } else {
                        this.threads.put(this.r_history[n], Boolean.FALSE);
                    }
                } else {
                    this.threads.put(this.r_history[n], INDET);
                }
            } else if (object == INDET && IdempotentSequence.methodHasSideEffects(this.m_history[n])) {
                this.threads.put(this.r_history[n], Boolean.FALSE);
            }
            ++n;
        }
        Enumeration enumeration = this.threads.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (this.threads.get(object) != INDET) continue;
            this.threads.put(object, Boolean.TRUE);
        }
    }

    public static boolean methodIsIdempotent(String string) {
        return IdempotentSequence.methodIsIdempotent(IdempotentSequence.methodNum(string));
    }

    private static boolean methodIsIdempotent(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public static boolean methodIsComplete(String string) {
        return IdempotentSequence.methodIsComplete(IdempotentSequence.methodNum(string));
    }

    private static boolean methodIsComplete(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public static boolean methodHasSideEffects(String string) {
        return IdempotentSequence.methodHasSideEffects(IdempotentSequence.methodNum(string));
    }

    private static boolean methodHasSideEffects(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                return false;
            }
        }
        return true;
    }

    private static int methodNum(String string) {
        if (string.equals("GET")) {
            return 2;
        }
        if (string.equals("POST")) {
            return 3;
        }
        if (string.equals("HEAD")) {
            return 1;
        }
        if (string.equals("PUT")) {
            return 4;
        }
        if (string.equals("DELETE")) {
            return 5;
        }
        if (string.equals("OPTIONS")) {
            return 6;
        }
        if (string.equals("TRACE")) {
            return 7;
        }
        if (string.equals("PROPFIND")) {
            return 8;
        }
        if (string.equals("PROPPATCH")) {
            return 9;
        }
        if (string.equals("MKCOL")) {
            return 10;
        }
        if (string.equals("COPY")) {
            return 11;
        }
        if (string.equals("MOVE")) {
            return 12;
        }
        if (string.equals("LOCK")) {
            return 13;
        }
        if (string.equals("UNLOCK")) {
            return 14;
        }
        return 0;
    }

    public static void main(String[] stringArray) {
        IdempotentSequence idempotentSequence = new IdempotentSequence();
        idempotentSequence.add(new Request(null, "GET", "/b1", null, null, null, false));
        idempotentSequence.add(new Request(null, "PUT", "/b2", null, null, null, false));
        idempotentSequence.add(new Request(null, "GET", "/b1", null, null, null, false));
        idempotentSequence.add(new Request(null, "PUT", "/b3", null, null, null, false));
        idempotentSequence.add(new Request(null, "GET", "/b2", null, null, null, false));
        idempotentSequence.add(new Request(null, "POST", "/b8", null, null, null, false));
        idempotentSequence.add(new Request(null, "PUT", "/b3", null, null, null, false));
        idempotentSequence.add(new Request(null, "GET", "/b1", null, null, null, false));
        idempotentSequence.add(new Request(null, "TRACE", "/b4", null, null, null, false));
        idempotentSequence.add(new Request(null, "GET", "/b9", null, null, null, false));
        idempotentSequence.add(new Request(null, "LINK", "/b4", null, null, null, false));
        idempotentSequence.add(new Request(null, "GET", "/b4", null, null, null, false));
        idempotentSequence.add(new Request(null, "PUT", "/b5", null, null, null, false));
        idempotentSequence.add(new Request(null, "HEAD", "/b5", null, null, null, false));
        idempotentSequence.add(new Request(null, "PUT", "/b5", null, null, null, false));
        idempotentSequence.add(new Request(null, "POST", "/b9", null, null, null, false));
        idempotentSequence.add(new Request(null, "GET", "/b6", null, null, null, false));
        idempotentSequence.add(new Request(null, "DELETE", "/b6", null, null, null, false));
        idempotentSequence.add(new Request(null, "HEAD", "/b6", null, null, null, false));
        idempotentSequence.add(new Request(null, "OPTIONS", "/b7", null, null, null, false));
        idempotentSequence.add(new Request(null, "TRACE", "/b7", null, null, null, false));
        idempotentSequence.add(new Request(null, "GET", "/b7", null, null, null, false));
        idempotentSequence.add(new Request(null, "PUT", "/b7", null, null, null, false));
        if (!idempotentSequence.isIdempotent(new Request(null, null, "/b1", null, null, null, false))) {
            System.err.println("Sequence b1 failed");
        }
        if (!idempotentSequence.isIdempotent(new Request(null, null, "/b2", null, null, null, false))) {
            System.err.println("Sequence b2 failed");
        }
        if (!idempotentSequence.isIdempotent(new Request(null, null, "/b3", null, null, null, false))) {
            System.err.println("Sequence b3 failed");
        }
        if (idempotentSequence.isIdempotent(new Request(null, null, "/b4", null, null, null, false))) {
            System.err.println("Sequence b4 failed");
        }
        if (!idempotentSequence.isIdempotent(new Request(null, null, "/b5", null, null, null, false))) {
            System.err.println("Sequence b5 failed");
        }
        if (idempotentSequence.isIdempotent(new Request(null, null, "/b6", null, null, null, false))) {
            System.err.println("Sequence b6 failed");
        }
        if (idempotentSequence.isIdempotent(new Request(null, null, "/b7", null, null, null, false))) {
            System.err.println("Sequence b7 failed");
        }
        if (idempotentSequence.isIdempotent(new Request(null, null, "/b8", null, null, null, false))) {
            System.err.println("Sequence b8 failed");
        }
        if (idempotentSequence.isIdempotent(new Request(null, null, "/b9", null, null, null, false))) {
            System.err.println("Sequence b9 failed");
        }
        System.out.println("Tests finished");
    }

    public IdempotentSequence() {
        this.m_history = new int[10];
        this.r_history = new String[10];
    }
}

