/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Codecs;
import HTTPClient.Log;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class HttpOutputStream
extends OutputStream {
    private static final NVPair[] empty = new NVPair[0];
    private int length;
    private int rcvd = 0;
    private Request req = null;
    private Response resp = null;
    private OutputStream os = null;
    private ByteArrayOutputStream bos = null;
    private NVPair[] trailers = empty;
    private int con_to = 0;
    private boolean ignore = false;

    void goAhead(Request request, OutputStream outputStream, int n) {
        this.req = request;
        this.os = outputStream;
        this.con_to = n;
        if (outputStream == null) {
            this.bos = new ByteArrayOutputStream();
        }
        Log.write(1, "OutS:  Stream ready for writing");
        if (this.bos != null) {
            Log.write(1, "OutS:  Buffering all data before sending request");
        }
    }

    void ignoreData(Request request) {
        this.req = request;
        this.ignore = true;
    }

    synchronized Response getResponse() {
        while (this.resp == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.resp;
    }

    public int getLength() {
        return this.length;
    }

    public NVPair[] getTrailers() {
        return this.trailers;
    }

    public void setTrailers(NVPair[] nVPairArray) {
        this.trailers = nVPairArray != null ? nVPairArray : empty;
    }

    public void reset() {
        this.rcvd = 0;
        this.req = null;
        this.resp = null;
        this.os = null;
        this.bos = null;
        this.con_to = 0;
        this.ignore = false;
    }

    public void write(int n) throws IOException, IllegalAccessError {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException, IllegalAccessError {
        if (this.req == null) {
            throw new IllegalAccessError("Stream not associated with a request");
        }
        if (this.ignore) {
            return;
        }
        if (this.length != -1 && this.rcvd + n2 > this.length) {
            IOException iOException = new IOException("Tried to write too many bytes (" + (this.rcvd + n2) + " > " + this.length + ")");
            this.req.getConnection().closeDemux(iOException, false);
            this.req.getConnection().outputFinished();
            throw iOException;
        }
        try {
            if (this.bos != null) {
                this.bos.write(byArray, n, n2);
            } else if (this.length != -1) {
                this.os.write(byArray, n, n2);
            } else {
                this.os.write(Codecs.chunkedEncode(byArray, n, n2, null, false));
            }
        }
        catch (IOException iOException) {
            this.req.getConnection().closeDemux(iOException, true);
            this.req.getConnection().outputFinished();
            throw iOException;
        }
        this.rcvd += n2;
    }

    public synchronized void close() throws IOException, IllegalAccessError {
        if (this.req == null) {
            throw new IllegalAccessError("Stream not associated with a request");
        }
        if (this.ignore) {
            return;
        }
        if (this.bos != null) {
            this.req.setData(this.bos.toByteArray());
            this.req.setStream(null);
            if (this.trailers.length > 0) {
                NVPair[] nVPairArray = this.req.getHeaders();
                int n = nVPairArray.length;
                int n2 = 0;
                while (n2 < n) {
                    if (nVPairArray[n2].getName().equalsIgnoreCase("Trailer")) {
                        System.arraycopy(nVPairArray, n2 + 1, nVPairArray, n2, n - n2 - 1);
                        --n;
                    }
                    ++n2;
                }
                nVPairArray = Util.resizeArray(nVPairArray, n + this.trailers.length);
                System.arraycopy(this.trailers, 0, nVPairArray, n, this.trailers.length);
                this.req.setHeaders(nVPairArray);
            }
            Log.write(1, "OutS:  Sending request");
            try {
                this.resp = this.req.getConnection().sendRequest(this.req, this.con_to);
            }
            catch (ModuleException moduleException) {
                throw new IOException(moduleException.toString());
            }
            this.notify();
        } else {
            if (this.rcvd < this.length) {
                IOException iOException = new IOException("Premature close: only " + this.rcvd + " bytes written instead of the " + "expected " + this.length);
                this.req.getConnection().closeDemux(iOException, false);
                this.req.getConnection().outputFinished();
                throw iOException;
            }
            try {
                try {
                    if (this.length == -1) {
                        if (Log.isEnabled(1) && this.trailers.length > 0) {
                            Log.write(1, "OutS:  Sending trailers:");
                            int n = 0;
                            while (n < this.trailers.length) {
                                Log.write(1, "       " + this.trailers[n].getName() + ": " + this.trailers[n].getValue());
                                ++n;
                            }
                        }
                        this.os.write(Codecs.chunkedEncode(null, 0, 0, this.trailers, true));
                    }
                    this.os.flush();
                    Log.write(1, "OutS:  All data sent");
                }
                catch (IOException iOException) {
                    this.req.getConnection().closeDemux(iOException, true);
                    throw iOException;
                }
                Object var2_6 = null;
                this.req.getConnection().outputFinished();
            }
            catch (Throwable throwable) {
                Object var2_7 = null;
                this.req.getConnection().outputFinished();
                throw throwable;
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + "[length=" + this.length + "]";
    }

    public HttpOutputStream() {
        this.length = -1;
    }

    public HttpOutputStream(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Length must be greater equal 0");
        }
        this.length = n;
    }
}

