/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Cookie;
import HTTPClient.HTTPConnection;
import HTTPClient.HttpHeaderElement;
import HTTPClient.Log;
import HTTPClient.ParseException;
import HTTPClient.RoRequest;
import HTTPClient.URI;
import HTTPClient.Util;
import java.io.UnsupportedEncodingException;
import java.net.ProtocolException;
import java.util.Date;
import java.util.StringTokenizer;

public class Cookie2
extends Cookie {
    private static final long serialVersionUID = 2208203902820875917L;
    protected int version;
    protected boolean discard;
    protected String comment;
    protected URI comment_url;
    protected int[] port_list;
    protected String port_list_str;
    protected boolean path_set;
    protected boolean port_set;
    protected boolean domain_set;

    /*
     * Unable to fully structure code
     */
    protected static Cookie[] parse(String var0, RoRequest var1_1) throws ProtocolException {
        try {
            var2_2 = Util.parseHeader(var0);
        }
        catch (ParseException var3_3) {
            throw new ProtocolException(var3_3.getMessage());
        }
        var3_4 = new Cookie[var2_2.size()];
        var4_5 = 0;
        var5_6 = 0;
        while (var5_6 < var3_4.length) {
            block50: {
                block54: {
                    block53: {
                        block52: {
                            block51: {
                                var6_7 = (HttpHeaderElement)var2_2.elementAt(var5_6);
                                if (var6_7.getValue() == null) {
                                    throw new ProtocolException("Bad Set-Cookie2 header: " + var0 + "\nMissing value " + "for cookie '" + var6_7.getName() + "'");
                                }
                                var7_8 = new Cookie2(var1_1);
                                var7_8.name = var6_7.getName();
                                var7_8.value = var6_7.getValue();
                                var8_9 = var6_7.getParams();
                                var9_10 = false;
                                var10_11 = false;
                                var11_12 = 0;
                                while (var11_12 < var8_9.length) {
                                    var12_14 = var8_9[var11_12].getName().toLowerCase();
                                    if ((var12_14.equals("version") || var12_14.equals("max-age") || var12_14.equals("domain") || var12_14.equals("path") || var12_14.equals("comment") || var12_14.equals("commenturl")) && var8_9[var11_12].getValue() == null) {
                                        throw new ProtocolException("Bad Set-Cookie2 header: " + var0 + "\nMissing value " + "for " + var8_9[var11_12].getName() + " attribute in cookie '" + var6_7.getName() + "'");
                                    }
                                    if (var12_14.equals("version")) {
                                        if (var7_8.version == -1) {
                                            try {
                                                var7_8.version = Integer.parseInt(var8_9[var11_12].getValue());
                                            }
                                            catch (NumberFormatException var13_17) {
                                                throw new ProtocolException("Bad Set-Cookie2 header: " + var0 + "\nVersion '" + var8_9[var11_12].getValue() + "' not a number");
                                            }
                                        }
                                    } else if (var12_14.equals("path")) {
                                        if (!var7_8.path_set) {
                                            var7_8.path = var8_9[var11_12].getValue();
                                            var7_8.path_set = true;
                                        }
                                    } else if (var12_14.equals("domain")) {
                                        if (!var7_8.domain_set) {
                                            var13_18 = var8_9[var11_12].getValue().toLowerCase();
                                            var7_8.domain = var13_18.charAt(0) != '.' && var13_18.equals(var7_8.domain) == false ? "." + var13_18 : var13_18;
                                            var7_8.domain_set = true;
                                        }
                                    } else if (var12_14.equals("max-age")) {
                                        if (var7_8.expires == null) {
                                            try {
                                                var13_19 = Integer.parseInt(var8_9[var11_12].getValue());
                                            }
                                            catch (NumberFormatException var14_24) {
                                                throw new ProtocolException("Bad Set-Cookie2 header: " + var0 + "\nMax-Age '" + var8_9[var11_12].getValue() + "' not a number");
                                            }
                                            var7_8.expires = new Date(System.currentTimeMillis() + (long)var13_19 * 1000L);
                                        }
                                    } else if (var12_14.equals("port")) {
                                        if (!var7_8.port_set) {
                                            if (var8_9[var11_12].getValue() == null) {
                                                var7_8.port_list = new int[1];
                                                var7_8.port_list[0] = var1_1.getConnection().getPort();
                                                var7_8.port_set = true;
                                            } else {
                                                var7_8.port_list_str = var8_9[var11_12].getValue();
                                                var13_20 = new StringTokenizer(var8_9[var11_12].getValue(), ",");
                                                var7_8.port_list = new int[var13_20.countTokens()];
                                                var14_23 = 0;
                                                while (var14_23 < var7_8.port_list.length) {
                                                    var15_25 = var13_20.nextToken().trim();
                                                    try {
                                                        var7_8.port_list[var14_23] = Integer.parseInt(var15_25);
                                                    }
                                                    catch (NumberFormatException var16_26) {
                                                        throw new ProtocolException("Bad Set-Cookie2 header: " + var0 + "\nPort '" + var15_25 + "' not a number");
                                                    }
                                                    ++var14_23;
                                                }
                                                var7_8.port_set = true;
                                            }
                                        }
                                    } else if (var12_14.equals("discard")) {
                                        if (!var9_10) {
                                            var7_8.discard = true;
                                            var9_10 = true;
                                        }
                                    } else if (var12_14.equals("secure")) {
                                        if (!var10_11) {
                                            var7_8.secure = true;
                                            var10_11 = true;
                                        }
                                    } else if (var12_14.equals("comment")) {
                                        if (var7_8.comment == null) {
                                            try {
                                                var7_8.comment = new String(var8_9[var11_12].getValue().getBytes("8859_1"), "UTF8");
                                            }
                                            catch (UnsupportedEncodingException var13_21) {
                                                throw new Error(var13_21.toString());
                                            }
                                        }
                                    } else if (var12_14.equals("commenturl") && var7_8.comment_url == null) {
                                        try {
                                            var7_8.comment_url = new URI(var8_9[var11_12].getValue());
                                        }
                                        catch (ParseException var13_22) {
                                            throw new ProtocolException("Bad Set-Cookie2 header: " + var0 + "\nCommentURL '" + var8_9[var11_12].getValue() + "' not a valid URL");
                                        }
                                    }
                                    ++var11_12;
                                }
                                if (var7_8.version == -1) break block50;
                                if (var7_8.expires == null) {
                                    var7_8.discard = true;
                                }
                                if (Util.getPath(var1_1.getRequestURI()).startsWith(var7_8.path)) break block51;
                                Log.write(16, "Cook2: Bad Set-Cookie2 header: " + var0 + "\n       path `" + var7_8.path + "' is not a prefix of the " + "request uri `" + var1_1.getRequestURI() + "'");
                                break block50;
                            }
                            var11_13 = var1_1.getConnection().getHost();
                            if (var11_13.indexOf(46) == -1) {
                                var11_13 = var11_13 + ".local";
                            }
                            if (var7_8.domain.equals(".local") || var7_8.domain.indexOf(46, 1) != -1) break block52;
                            Log.write(16, "Cook2: Bad Set-Cookie2 header: " + var0 + "\n       domain `" + var7_8.domain + "' is not `.local' and " + "doesn't contain two `.'s");
                            break block50;
                        }
                        if (var11_13.endsWith(var7_8.domain)) break block53;
                        Log.write(16, "Cook2: Bad Set-Cookie2 header: " + var0 + "\n       domain `" + var7_8.domain + "' does not match current" + "host `" + var11_13 + "'");
                        break block50;
                    }
                    if (var11_13.substring(0, var11_13.length() - var7_8.domain.length()).indexOf(46) == -1) break block54;
                    Log.write(16, "Cook2: Bad Set-Cookie2 header: " + var0 + "\n       domain `" + var7_8.domain + "' is more than one `.'" + "away from host `" + var11_13 + "'");
                    break block50;
                }
                if (!var7_8.port_set) ** GOTO lbl-1000
                var12_15 = 0;
                var12_15 = 0;
                while (var12_15 < var7_8.port_list.length) {
                    if (var7_8.port_list[var12_15] == var1_1.getConnection().getPort()) break;
                    ++var12_15;
                }
                if (var12_15 == var7_8.port_list.length) {
                    Log.write(16, "Cook2: Bad Set-Cookie2 header: " + var0 + "\n       port list " + "does include current port " + var1_1.getConnection().getPort());
                } else lbl-1000:
                // 2 sources

                {
                    var3_4[var4_5++] = var7_8;
                }
            }
            ++var5_6;
        }
        if (var4_5 < var3_4.length) {
            var3_4 = Util.resizeArray(var3_4, var4_5);
        }
        return var3_4;
    }

    public int getVersion() {
        return this.version;
    }

    public String getComment() {
        return this.comment;
    }

    public URI getCommentURL() {
        return this.comment_url;
    }

    public int[] getPorts() {
        return this.port_list;
    }

    public boolean discard() {
        return this.discard;
    }

    protected boolean sendWith(RoRequest roRequest) {
        String string;
        boolean bl;
        HTTPConnection hTTPConnection = roRequest.getConnection();
        boolean bl2 = bl = !this.port_set;
        if (this.port_set) {
            int n = 0;
            while (n < this.port_list.length) {
                if (this.port_list[n] == hTTPConnection.getPort()) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        if ((string = hTTPConnection.getHost()).indexOf(46) == -1) {
            string = string + ".local";
        }
        return (this.domain.charAt(0) == '.' && string.endsWith(this.domain) || this.domain.charAt(0) != '.' && string.equals(this.domain)) && bl && Util.getPath(roRequest.getRequestURI()).startsWith(this.path) && (!this.secure || hTTPConnection.getProtocol().equals("https") || hTTPConnection.getProtocol().equals("shttp"));
    }

    protected String toExternalForm() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.version == 1) {
            stringBuffer.append(this.name);
            stringBuffer.append("=");
            stringBuffer.append(this.value);
            if (this.path_set) {
                stringBuffer.append("; ");
                stringBuffer.append("$Path=");
                stringBuffer.append(this.path);
            }
            if (this.domain_set) {
                stringBuffer.append("; ");
                stringBuffer.append("$Domain=");
                stringBuffer.append(this.domain);
            }
            if (this.port_set) {
                stringBuffer.append("; ");
                stringBuffer.append("$Port");
                if (this.port_list_str != null) {
                    stringBuffer.append("=\"");
                    stringBuffer.append(this.port_list_str);
                    stringBuffer.append('\"');
                }
            }
        } else {
            throw new Error("Internal Error: unknown version " + this.version);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.name.length() + this.value.length() + 50);
        stringBuffer.append(this.name).append('=').append(this.value);
        if (this.version == 1) {
            stringBuffer.append("; Version=").append(this.version);
            stringBuffer.append("; Path=").append(this.path);
            stringBuffer.append("; Domain=").append(this.domain);
            if (this.port_set) {
                stringBuffer.append("; Port=\"").append(this.port_list[0]);
                int n = 1;
                while (n < this.port_list.length) {
                    stringBuffer.append(',').append(this.port_list[n]);
                    ++n;
                }
                stringBuffer.append('\"');
            }
            if (this.expires != null) {
                stringBuffer.append("; Max-Age=").append((this.expires.getTime() - System.currentTimeMillis()) / 1000L);
            }
            if (this.discard) {
                stringBuffer.append("; Discard");
            }
            if (this.secure) {
                stringBuffer.append("; Secure");
            }
            if (this.comment != null) {
                stringBuffer.append("; Comment=\"").append(this.comment).append('\"');
            }
            if (this.comment_url != null) {
                stringBuffer.append("; CommentURL=\"").append(this.comment_url).append('\"');
            }
        } else {
            throw new Error("Internal Error: unknown version " + this.version);
        }
        return stringBuffer.toString();
    }

    public Cookie2(String string, String string2, String string3, int[] nArray, String string4, Date date, boolean bl, boolean bl2, String string5, URI uRI) {
        super(string, string2, string3, string4, date, bl2);
        this.discard = bl;
        this.port_list = nArray;
        this.comment = string5;
        this.comment_url = uRI;
        this.path_set = true;
        this.domain_set = true;
        if (nArray != null && nArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nArray[0]);
            int n = 1;
            while (n < nArray.length) {
                stringBuffer.append(',');
                stringBuffer.append(nArray[n]);
                ++n;
            }
            this.port_list_str = stringBuffer.toString();
            this.port_set = true;
        }
        this.version = 1;
    }

    protected Cookie2(RoRequest roRequest) {
        super(roRequest);
        this.path = Util.getPath(roRequest.getRequestURI());
        int n = this.path.lastIndexOf(47);
        if (n != -1) {
            this.path = this.path.substring(0, n + 1);
        }
        if (this.domain.indexOf(46) == -1) {
            this.domain = this.domain + ".local";
        }
        this.version = -1;
        this.discard = false;
        this.comment = null;
        this.comment_url = null;
        this.port_list = null;
        this.port_list_str = null;
        this.path_set = false;
        this.port_set = false;
        this.domain_set = false;
    }
}

