/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HTTPConnection;
import HTTPClient.Log;
import HTTPClient.RoRequest;
import HTTPClient.Util;
import java.io.Serializable;
import java.net.ProtocolException;
import java.util.Date;

public class Cookie
implements Serializable {
    private static final long serialVersionUID = 8599975325569296615L;
    protected String name;
    protected String value;
    protected Date expires;
    protected String domain;
    protected String path;
    protected boolean secure;

    protected static Cookie[] parse(String string, RoRequest roRequest) throws ProtocolException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        char[] cArray = string.toCharArray();
        int n4 = cArray.length;
        Cookie[] cookieArray = new Cookie[]{};
        while ((n = Util.skipSpace(cArray, n)) < n4) {
            int n5;
            if (cArray[n] == ',') {
                ++n;
                continue;
            }
            Cookie cookie = new Cookie(roRequest);
            n3 = n;
            n2 = string.indexOf(61, n);
            if (n2 == -1) {
                throw new ProtocolException("Bad Set-Cookie header: " + string + "\nNo '=' found " + "for token starting at " + "position " + n);
            }
            cookie.name = string.substring(n, n2).trim();
            n = Util.skipSpace(cArray, n2 + 1);
            int n6 = string.indexOf(44, n);
            int n7 = string.indexOf(59, n);
            n2 = n6 == -1 && n7 == -1 ? n4 : (n6 == -1 ? n7 : (n7 == -1 ? n6 : (n6 > n7 ? n7 : ((n5 = string.indexOf(61, n6)) > 0 && n5 < n7 ? string.lastIndexOf(44, n5) : n7))));
            cookie.value = string.substring(n, n2).trim();
            n = n2;
            n5 = 1;
            while (n < n4 && cArray[n] != ',') {
                if (cArray[n] == ';') {
                    n = Util.skipSpace(cArray, n + 1);
                    continue;
                }
                if (n + 6 <= n4 && string.regionMatches(true, n, "secure", 0, 6)) {
                    cookie.secure = true;
                    n += 6;
                    if ((n = Util.skipSpace(cArray, n)) < n4 && cArray[n] == ';') {
                        n = Util.skipSpace(cArray, n + 1);
                        continue;
                    }
                    if (n >= n4 || cArray[n] == ',') continue;
                    throw new ProtocolException("Bad Set-Cookie header: " + string + "\nExpected " + "';' or ',' at position " + n);
                }
                n2 = string.indexOf(61, n);
                if (n2 == -1) {
                    throw new ProtocolException("Bad Set-Cookie header: " + string + "\nNo '=' found " + "for token starting at " + "position " + n);
                }
                String string2 = string.substring(n, n2).trim();
                n = Util.skipSpace(cArray, n2 + 1);
                if (string2.equalsIgnoreCase("expires")) {
                    if (string.charAt(n) == '\"') {
                        n = Util.skipSpace(cArray, n + 1);
                    }
                    int n8 = n;
                    while (n8 < n4 && (cArray[n8] >= 'a' && cArray[n8] <= 'z' || cArray[n8] >= 'A' && cArray[n8] <= 'Z')) {
                        ++n8;
                    }
                    if ((n8 = Util.skipSpace(cArray, n8)) < n4 && cArray[n8] == ',' && n8 > n) {
                        n = n8 + 1;
                    }
                }
                n6 = string.indexOf(44, n);
                n7 = string.indexOf(59, n);
                n2 = n6 == -1 && n7 == -1 ? n4 : (n6 == -1 ? n7 : (n7 == -1 ? n6 : Math.min(n6, n7)));
                String string3 = string.substring(n, n2).trim();
                n5 &= Cookie.setAttribute(cookie, string2, string3, string);
                n = n2;
                if (n >= n4 || cArray[n] != ';') continue;
                n = Util.skipSpace(cArray, n + 1);
            }
            if (n5 != 0) {
                cookieArray = Util.resizeArray(cookieArray, cookieArray.length + 1);
                cookieArray[cookieArray.length - 1] = cookie;
                continue;
            }
            Log.write(16, "Cooki: Ignoring cookie: " + cookie);
        }
        return cookieArray;
    }

    private static boolean setAttribute(Cookie cookie, String string, String string2, String string3) throws ProtocolException {
        block14: {
            block16: {
                int n;
                int n2;
                block15: {
                    int n3;
                    block13: {
                        if (!string.equalsIgnoreCase("expires")) break block13;
                        if (string2.charAt(string2.length() - 1) == '\"') {
                            string2 = string2.substring(0, string2.length() - 1).trim();
                        }
                        try {
                            cookie.expires = new Date(string2);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            Log.write(16, "Cooki: Bad Set-Cookie header: " + string3 + "\n       Invalid date `" + string2 + "'");
                        }
                        break block14;
                    }
                    if (!string.equals("max-age")) break block15;
                    if (cookie.expires != null) {
                        return true;
                    }
                    if (string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"') {
                        string2 = string2.substring(1, string2.length() - 1).trim();
                    }
                    try {
                        n3 = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ProtocolException("Bad Set-Cookie header: " + string3 + "\nMax-Age '" + string2 + "' not a number");
                    }
                    cookie.expires = new Date(System.currentTimeMillis() + (long)n3 * 1000L);
                    break block14;
                }
                if (!string.equalsIgnoreCase("domain")) break block16;
                if (string2.length() == 0) {
                    Log.write(16, "Cooki: Bad Set-Cookie header: " + string3 + "\n       domain is empty - ignoring domain");
                    return true;
                }
                if ((string2 = string2.toLowerCase()).length() != 0 && string2.charAt(0) != '.' && !string2.equals(cookie.domain)) {
                    string2 = "." + string2;
                }
                if (!cookie.domain.endsWith(string2)) {
                    Log.write(16, "Cooki: Bad Set-Cookie header: " + string3 + "\n       Current domain " + cookie.domain + " does not match given parsed " + string2);
                    return false;
                }
                if (!string2.equals(".local") && string2.indexOf(46, 1) == -1) {
                    Log.write(16, "Cooki: Bad Set-Cookie header: " + string3 + "\n       Domain attribute " + string2 + "isn't .local and doesn't have at " + "least 2 dots");
                    return false;
                }
                String string4 = null;
                if (string2.length() > 3) {
                    string4 = string2.substring(string2.length() - 4);
                }
                if (!(string4 != null && (string4.equalsIgnoreCase(".com") || string4.equalsIgnoreCase(".edu") || string4.equalsIgnoreCase(".net") || string4.equalsIgnoreCase(".org") || string4.equalsIgnoreCase(".gov") || string4.equalsIgnoreCase(".mil") || string4.equalsIgnoreCase(".int")) || (n2 = cookie.domain.length()) <= (n = string2.length()) || cookie.domain.substring(0, n2 - n).indexOf(46) == -1)) {
                    Log.write(16, "Cooki: Bad Set-Cookie header: " + string3 + "\n       Domain attribute " + string2 + "is more than one level below " + "current domain " + cookie.domain);
                    return false;
                }
                cookie.domain = string2;
                break block14;
            }
            if (!string.equalsIgnoreCase("path")) break block14;
            cookie.path = string2;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Date expires() {
        return this.expires;
    }

    public boolean discard() {
        return this.expires == null;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean hasExpired() {
        return this.expires != null && this.expires.getTime() <= System.currentTimeMillis();
    }

    protected boolean sendWith(RoRequest roRequest) {
        HTTPConnection hTTPConnection = roRequest.getConnection();
        String string = hTTPConnection.getHost();
        if (string.indexOf(46) == -1) {
            string = string + ".local";
        }
        return (this.domain.charAt(0) == '.' && string.endsWith(this.domain) || this.domain.charAt(0) != '.' && string.equals(this.domain)) && Util.getPath(roRequest.getRequestURI()).startsWith(this.path) && (!this.secure || hTTPConnection.getProtocol().equals("https") || hTTPConnection.getProtocol().equals("shttp"));
    }

    public int hashCode() {
        return this.name.hashCode() + this.path.hashCode() + this.domain.hashCode();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Cookie) {
            Cookie cookie = (Cookie)object;
            return this.name.equals(cookie.name) && this.path.equals(cookie.path) && this.domain.equals(cookie.domain);
        }
        return false;
    }

    protected String toExternalForm() {
        return this.name + "=" + this.value;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.name.length() + this.value.length() + 30);
        stringBuffer.append(this.name).append('=').append(this.value);
        if (this.expires != null) {
            stringBuffer.append("; expires=").append(this.expires);
        }
        if (this.path != null) {
            stringBuffer.append("; path=").append(this.path);
        }
        if (this.domain != null) {
            stringBuffer.append("; domain=").append(this.domain);
        }
        if (this.secure) {
            stringBuffer.append("; secure");
        }
        return stringBuffer.toString();
    }

    public Cookie(String string, String string2, String string3, String string4, Date date, boolean bl) {
        if (string == null) {
            throw new NullPointerException("missing name");
        }
        if (string2 == null) {
            throw new NullPointerException("missing value");
        }
        if (string3 == null) {
            throw new NullPointerException("missing domain");
        }
        if (string4 == null) {
            throw new NullPointerException("missing path");
        }
        this.name = string;
        this.value = string2;
        this.domain = string3.toLowerCase();
        this.path = string4;
        this.expires = date;
        this.secure = bl;
        if (this.domain.indexOf(46) == -1) {
            this.domain = this.domain + ".local";
        }
    }

    protected Cookie(RoRequest roRequest) {
        this.name = null;
        this.value = null;
        this.expires = null;
        this.domain = roRequest.getConnection().getHost();
        if (this.domain.indexOf(46) == -1) {
            this.domain = this.domain + ".local";
        }
        this.path = Util.getPath(roRequest.getRequestURI());
        int n = this.path.lastIndexOf(47);
        if (n >= 0) {
            this.path = this.path.substring(0, n);
        }
        this.secure = false;
    }
}

