/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.FilenameMangler;
import HTTPClient.HttpHeaderElement;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.Util;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.BitSet;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class Codecs {
    private static BitSet BoundChar = new BitSet(256);
    private static BitSet EBCDICUnsafeChar;
    private static byte[] Base64EncMap;
    private static byte[] Base64DecMap;
    private static char[] UUEncMap;
    private static byte[] UUDecMap;
    private static final String ContDisp = "\r\nContent-Disposition: form-data; name=\"";
    private static final String FileName = "\"; filename=\"";
    private static final String ContType = "\r\nContent-Type: ";
    private static final String Boundary = "\r\n----------ieoau._._+2_8_GoodLuck8.3-dskdfJwSJKl234324jfLdsjfdAuaoei-----";
    private static NVPair[] dummy;

    public static final String base64Encode(String string) {
        if (string == null) {
            return null;
        }
        try {
            return new String(Codecs.base64Encode(string.getBytes("8859_1")), "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error(unsupportedEncodingException.toString());
        }
    }

    public static final byte[] base64Encode(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[(byArray.length + 2) / 3 * 4];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length - 2) {
            byArray2[n2++] = Base64EncMap[byArray[n] >>> 2 & 0x3F];
            byArray2[n2++] = Base64EncMap[byArray[n + 1] >>> 4 & 0xF | byArray[n] << 4 & 0x3F];
            byArray2[n2++] = Base64EncMap[byArray[n + 2] >>> 6 & 3 | byArray[n + 1] << 2 & 0x3F];
            byArray2[n2++] = Base64EncMap[byArray[n + 2] & 0x3F];
            n += 3;
        }
        if (n < byArray.length) {
            byArray2[n2++] = Base64EncMap[byArray[n] >>> 2 & 0x3F];
            if (n < byArray.length - 1) {
                byArray2[n2++] = Base64EncMap[byArray[n + 1] >>> 4 & 0xF | byArray[n] << 4 & 0x3F];
                byArray2[n2++] = Base64EncMap[byArray[n + 1] << 2 & 0x3F];
            } else {
                byArray2[n2++] = Base64EncMap[byArray[n] << 4 & 0x3F];
            }
        }
        while (n2 < byArray2.length) {
            byArray2[n2] = 61;
            ++n2;
        }
        return byArray2;
    }

    public static final String base64Decode(String string) {
        if (string == null) {
            return null;
        }
        try {
            return new String(Codecs.base64Decode(string.getBytes("8859_1")), "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error(unsupportedEncodingException.toString());
        }
    }

    public static final byte[] base64Decode(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        while (byArray[n - 1] == 61) {
            --n;
        }
        byte[] byArray2 = new byte[n - byArray.length / 4];
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray[n2] = Base64DecMap[byArray[n2]];
            ++n2;
        }
        n2 = 0;
        int n3 = 0;
        while (n3 < byArray2.length - 2) {
            byArray2[n3] = (byte)(byArray[n2] << 2 & 0xFF | byArray[n2 + 1] >>> 4 & 3);
            byArray2[n3 + 1] = (byte)(byArray[n2 + 1] << 4 & 0xFF | byArray[n2 + 2] >>> 2 & 0xF);
            byArray2[n3 + 2] = (byte)(byArray[n2 + 2] << 6 & 0xFF | byArray[n2 + 3] & 0x3F);
            n2 += 4;
            n3 += 3;
        }
        if (n3 < byArray2.length) {
            byArray2[n3] = (byte)(byArray[n2] << 2 & 0xFF | byArray[n2 + 1] >>> 4 & 3);
        }
        if (++n3 < byArray2.length) {
            byArray2[n3] = (byte)(byArray[n2 + 1] << 4 & 0xFF | byArray[n2 + 2] >>> 2 & 0xF);
        }
        return byArray2;
    }

    public static final char[] uuencode(byte[] byArray) {
        int n;
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return new char[0];
        }
        int n2 = 45;
        char[] cArray = System.getProperty("line.separator", "\n").toCharArray();
        char[] cArray2 = new char[(byArray.length + 2) / 3 * 4 + (byArray.length + n2 - 1) / n2 * (cArray.length + 1)];
        int n3 = 0;
        int n4 = 0;
        while (n3 + n2 < byArray.length) {
            cArray2[n4++] = UUEncMap[n2];
            n = n3 + n2;
            while (n3 < n) {
                cArray2[n4++] = UUEncMap[byArray[n3] >>> 2 & 0x3F];
                cArray2[n4++] = UUEncMap[byArray[n3 + 1] >>> 4 & 0xF | byArray[n3] << 4 & 0x3F];
                cArray2[n4++] = UUEncMap[byArray[n3 + 2] >>> 6 & 3 | byArray[n3 + 1] << 2 & 0x3F];
                cArray2[n4++] = UUEncMap[byArray[n3 + 2] & 0x3F];
                n3 += 3;
            }
            n = 0;
            while (n < cArray.length) {
                cArray2[n4++] = cArray[n];
                ++n;
            }
        }
        cArray2[n4++] = UUEncMap[byArray.length - n3];
        while (n3 + 2 < byArray.length) {
            cArray2[n4++] = UUEncMap[byArray[n3] >>> 2 & 0x3F];
            cArray2[n4++] = UUEncMap[byArray[n3 + 1] >>> 4 & 0xF | byArray[n3] << 4 & 0x3F];
            cArray2[n4++] = UUEncMap[byArray[n3 + 2] >>> 6 & 3 | byArray[n3 + 1] << 2 & 0x3F];
            cArray2[n4++] = UUEncMap[byArray[n3 + 2] & 0x3F];
            n3 += 3;
        }
        if (n3 < byArray.length - 1) {
            cArray2[n4++] = UUEncMap[byArray[n3] >>> 2 & 0x3F];
            cArray2[n4++] = UUEncMap[byArray[n3 + 1] >>> 4 & 0xF | byArray[n3] << 4 & 0x3F];
            cArray2[n4++] = UUEncMap[byArray[n3 + 1] << 2 & 0x3F];
            cArray2[n4++] = UUEncMap[0];
        } else if (n3 < byArray.length) {
            cArray2[n4++] = UUEncMap[byArray[n3] >>> 2 & 0x3F];
            cArray2[n4++] = UUEncMap[byArray[n3] << 4 & 0x3F];
            cArray2[n4++] = UUEncMap[0];
            cArray2[n4++] = UUEncMap[0];
        }
        n = 0;
        while (n < cArray.length) {
            cArray2[n4++] = cArray[n];
            ++n;
        }
        if (n4 != cArray2.length) {
            throw new Error("Calculated " + cArray2.length + " chars but wrote " + n4 + " chars!");
        }
        return cArray2;
    }

    private static final byte[] uudecode(BufferedReader bufferedReader) throws ParseException, IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null && !string.startsWith("begin ")) {
        }
        if (string == null) {
            throw new ParseException("'begin' line not found");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        try {
            int n = Integer.parseInt(stringTokenizer.nextToken(), 8);
        }
        catch (Exception exception) {
            throw new ParseException("Invalid mode on line: " + string);
        }
        try {
            String string2 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new ParseException("No file name found on line: " + string);
        }
        byte[] byArray = new byte[1000];
        int n = 0;
        while ((string = bufferedReader.readLine()) != null && !string.equals("end")) {
            byte[] byArray2 = Codecs.uudecode(string.toCharArray());
            if (n + byArray2.length > byArray.length) {
                byArray = Util.resizeArray(byArray, n + 1000);
            }
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            n += byArray2.length;
        }
        if (string == null) {
            throw new ParseException("'end' line not found");
        }
        return Util.resizeArray(byArray, n);
    }

    public static final byte[] uudecode(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        byte[] byArray = new byte[cArray.length / 4 * 3];
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            byte by;
            byte by2;
            byte by3 = UUDecMap[cArray[n++]];
            int n3 = n2 + by3;
            while (n2 < n3 - 2) {
                by2 = UUDecMap[cArray[n]];
                by = UUDecMap[cArray[n + 1]];
                byte by4 = UUDecMap[cArray[n + 2]];
                byte by5 = UUDecMap[cArray[n + 3]];
                byArray[n2++] = (byte)(by2 << 2 & 0xFF | by >>> 4 & 3);
                byArray[n2++] = (byte)(by << 4 & 0xFF | by4 >>> 2 & 0xF);
                byArray[n2++] = (byte)(by4 << 6 & 0xFF | by5 & 0x3F);
                n += 4;
            }
            if (n2 < n3) {
                by2 = UUDecMap[cArray[n]];
                by = UUDecMap[cArray[n + 1]];
                byArray[n2++] = (byte)(by2 << 2 & 0xFF | by >>> 4 & 3);
            }
            if (n2 < n3) {
                by2 = UUDecMap[cArray[n + 1]];
                by = UUDecMap[cArray[n + 2]];
                byArray[n2++] = (byte)(by2 << 4 & 0xFF | by >>> 2 & 0xF);
            }
            while (n < cArray.length && cArray[n] != '\n' && cArray[n] != '\r') {
                ++n;
            }
            while (n < cArray.length && (cArray[n] == '\n' || cArray[n] == '\r')) {
                ++n;
            }
        }
        return Util.resizeArray(byArray, n2);
    }

    public static final String quotedPrintableEncode(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] cArray2 = System.getProperty("line.separator", "\n").toCharArray();
        char[] cArray3 = new char[(int)((double)string.length() * 1.5)];
        char[] cArray4 = string.toCharArray();
        int n = 0;
        int n2 = 1;
        boolean bl = false;
        int n3 = string.length();
        int n4 = 0;
        while (n4 < n3) {
            char c = cArray4[n4];
            if (c == cArray2[0] && Codecs.match(cArray4, n4, cArray2)) {
                if (cArray3[n2 - 1] == ' ') {
                    cArray3[n2 - 1] = 61;
                    cArray3[n2++] = 50;
                    cArray3[n2++] = 48;
                } else if (cArray3[n2 - 1] == '\t') {
                    cArray3[n2 - 1] = 61;
                    cArray3[n2++] = 48;
                    cArray3[n2++] = 57;
                }
                cArray3[n2++] = 13;
                cArray3[n2++] = 10;
                n4 += cArray2.length - 1;
                n = n2;
            } else if (c > '~' || c < ' ' && c != '\t' || c == '=' || EBCDICUnsafeChar.get(c)) {
                cArray3[n2++] = 61;
                cArray3[n2++] = cArray[(c & 0xF0) >>> 4];
                cArray3[n2++] = cArray[c & 0xF];
            } else {
                cArray3[n2++] = c;
            }
            if (n2 > n + 70) {
                cArray3[n2++] = 61;
                cArray3[n2++] = 13;
                cArray3[n2++] = 10;
                n = n2;
            }
            if (n2 > cArray3.length - 5) {
                cArray3 = Util.resizeArray(cArray3, cArray3.length + 500);
            }
            ++n4;
        }
        return String.valueOf(cArray3, 1, n2 - 1);
    }

    private static final boolean match(char[] cArray, int n, char[] cArray2) {
        if (cArray.length < n + cArray2.length) {
            return false;
        }
        int n2 = 1;
        while (n2 < cArray2.length) {
            if (cArray[n + n2] != cArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static final String quotedPrintableDecode(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        char[] cArray = new char[(int)((double)string.length() * 1.1)];
        char[] cArray2 = string.toCharArray();
        char[] cArray3 = System.getProperty("line.separator", "\n").toCharArray();
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            char c;
            if ((c = cArray2[n4++]) == '=') {
                if (n4 >= n3 - 1) {
                    throw new ParseException("Premature end of input detected");
                }
                if (cArray2[n4] == '\n' || cArray2[n4] == '\r') {
                    if (cArray2[++n4 - 1] == '\r' && cArray2[n4] == '\n') {
                        ++n4;
                    }
                } else {
                    int n6;
                    int n7 = Character.digit(cArray2[n4], 16);
                    if ((n7 | (n6 = Character.digit(cArray2[n4 + 1], 16))) < 0) {
                        throw new ParseException(new String(cArray2, n4 - 1, 3) + " is an invalid code");
                    }
                    n5 = (char)(n7 << 4 | n6);
                    n4 += 2;
                    cArray[n2++] = n5;
                }
                n = n2;
            } else if (c == '\n' || c == '\r') {
                if (c == '\r' && n4 < n3 && cArray2[n4] == '\n') {
                    ++n4;
                }
                n5 = 0;
                while (n5 < cArray3.length) {
                    cArray[n++] = cArray3[n5];
                    ++n5;
                }
                n2 = n;
            } else {
                cArray[n2++] = c;
                if (c != ' ' && c != '\t') {
                    n = n2;
                }
            }
            if (n2 <= cArray.length - cArray3.length - 2) continue;
            cArray = Util.resizeArray(cArray, cArray.length + 500);
        }
        return new String(cArray, 0, n2);
    }

    public static final String URLEncode(String string) {
        if (string == null) {
            return null;
        }
        return URLEncoder.encode(string);
    }

    public static final String URLDecode(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        char[] cArray = new char[string.length()];
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == '+') {
                cArray[n++] = 32;
            } else if (c == '%') {
                try {
                    cArray[n++] = (char)Integer.parseInt(string.substring(n2 + 1, n2 + 3), 16);
                    n2 += 2;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException(string.substring(n2, n2 + 3) + " is an invalid code");
                }
            } else {
                cArray[n++] = c;
            }
            ++n2;
        }
        return String.valueOf(cArray, 0, n);
    }

    public static final NVPair[] mpFormDataDecode(byte[] byArray, String string, String string2) throws IOException, ParseException {
        return Codecs.mpFormDataDecode(byArray, string, string2, null);
    }

    public static final NVPair[] mpFormDataDecode(byte[] byArray, String string, String string2, FilenameMangler filenameMangler) throws IOException, ParseException {
        String string3 = Util.getParameter("boundary", string);
        if (string3 == null) {
            throw new ParseException("'boundary' parameter not found in Content-type: " + string);
        }
        byte[] byArray2 = ("--" + string3 + "\r\n").getBytes("8859_1");
        byte[] byArray3 = ("\r\n--" + string3 + "\r\n").getBytes("8859_1");
        byte[] byArray4 = ("\r\n--" + string3 + "--").getBytes("8859_1");
        int[] nArray = Util.compile_search(byArray2);
        int[] nArray2 = Util.compile_search(byArray3);
        int[] nArray3 = Util.compile_search(byArray4);
        int n = Util.findStr(byArray2, nArray, byArray, 0, byArray.length);
        if (n == -1) {
            throw new ParseException("Starting boundary not found: " + new String(byArray2, "8859_1"));
        }
        n += byArray2.length;
        NVPair[] nVPairArray = new NVPair[10];
        boolean bl = false;
        int n2 = 0;
        while (!bl) {
            String string4;
            int n3;
            int n4 = Util.findStr(byArray3, nArray2, byArray, n, byArray.length);
            if (n4 == -1) {
                n4 = Util.findStr(byArray4, nArray3, byArray, n, byArray.length);
                if (n4 == -1) {
                    throw new ParseException("Ending boundary not found: " + new String(byArray4, "8859_1"));
                }
                bl = true;
            }
            String string5 = null;
            String string6 = null;
            String string7 = null;
            while ((n3 = Codecs.findEOL(byArray, n) + 2) - 2 > n) {
                byte by;
                String string8 = new String(byArray, n, n3 - 2 - n, "8859_1");
                n = n3;
                while (n3 < byArray.length - 1 && ((by = byArray[n3]) == 32 || by == 9)) {
                    n3 = Codecs.findEOL(byArray, n) + 2;
                    string8 = string8 + new String(byArray, n, n3 - 2 - n, "8859_1");
                    n = n3;
                }
                if (!string8.regionMatches(true, 0, "Content-Disposition", 0, 19)) continue;
                Vector vector = Util.parseHeader(string8.substring(string8.indexOf(58) + 1));
                HttpHeaderElement httpHeaderElement = Util.getElement(vector, "form-data");
                if (httpHeaderElement == null) {
                    throw new ParseException("Expected 'Content-Disposition: form-data' in line: " + string8);
                }
                NVPair[] nVPairArray2 = httpHeaderElement.getParams();
                string6 = null;
                string5 = null;
                int n5 = 0;
                while (n5 < nVPairArray2.length) {
                    if (nVPairArray2[n5].getName().equalsIgnoreCase("name")) {
                        string5 = nVPairArray2[n5].getValue();
                    }
                    if (nVPairArray2[n5].getName().equalsIgnoreCase("filename")) {
                        string6 = nVPairArray2[n5].getValue();
                    }
                    ++n5;
                }
                if (string5 == null) {
                    throw new ParseException("'name' parameter not found in header: " + string8);
                }
                string7 = string8;
            }
            if ((n += 2) > n4) {
                throw new ParseException("End of header not found at offset " + n4);
            }
            if (string7 == null) {
                throw new ParseException("Missing 'Content-Disposition' header at offset " + n);
            }
            if (string6 != null) {
                if (filenameMangler != null) {
                    string6 = filenameMangler.mangleFilename(string6, string5);
                }
                if (string6 != null && string6.length() > 0) {
                    File file = new File(string2, string6);
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(byArray, n, n4 - n);
                    fileOutputStream.close();
                }
                string4 = string6;
            } else {
                string4 = new String(byArray, n, n4 - n, "8859_1");
            }
            if (n2 >= nVPairArray.length) {
                nVPairArray = Util.resizeArray(nVPairArray, n2 + 10);
            }
            nVPairArray[n2] = new NVPair(string5, string4);
            n = n4 + byArray3.length;
            ++n2;
        }
        return Util.resizeArray(nVPairArray, n2);
    }

    private static final int findEOL(byte[] byArray, int n) {
        while (n < byArray.length - 1 && (byArray[n++] != 13 || byArray[n] != 10)) {
        }
        return n - 1;
    }

    public static final byte[] mpFormDataEncode(NVPair[] nVPairArray, NVPair[] nVPairArray2, NVPair[] nVPairArray3) throws IOException {
        return Codecs.mpFormDataEncode(nVPairArray, nVPairArray2, nVPairArray3, null);
    }

    /*
     * Unable to fully structure code
     */
    public static final byte[] mpFormDataEncode(NVPair[] var0, NVPair[] var1_1, NVPair[] var2_2, FilenameMangler var3_3) throws IOException {
        var4_4 = "\r\n----------ieoau._._+2_8_GoodLuck8.3-dskdfJwSJKl234324jfLdsjfdAuaoei-----".getBytes("8859_1");
        var5_5 = "\r\nContent-Disposition: form-data; name=\"".getBytes("8859_1");
        var6_6 = "\r\nContent-Type: ".getBytes("8859_1");
        var7_7 = "\"; filename=\"".getBytes("8859_1");
        var8_8 = 0;
        var9_9 = var4_4.length + var5_5.length + 1 + 2 + 2;
        if (var0 == null) {
            var0 = Codecs.dummy;
        }
        if (var1_1 == null) {
            var1_1 = Codecs.dummy;
        }
        var10_10 = 0;
        while (var10_10 < var0.length) {
            if (var0[var10_10] != null) {
                var8_8 += var9_9 + var0[var10_10].getName().length() + var0[var10_10].getValue().length();
            }
            ++var10_10;
        }
        var10_10 = 0;
        while (var10_10 < var1_1.length) {
            if (var1_1[var10_10] != null) {
                var11_12 = new File(var1_1[var10_10].getValue());
                var12_14 = var11_12.getName();
                if (var3_3 != null) {
                    var12_14 = var3_3.mangleFilename(var12_14, var1_1[var10_10].getName());
                }
                if (var12_14 != null) {
                    var8_8 += var9_9 + var1_1[var10_10].getName().length() + var7_7.length;
                    var8_8 = (int)((long)var8_8 + ((long)var12_14.length() + var11_12.length()));
                    var13_16 = CT.getContentType(var11_12.getName());
                    if (var13_16 != null) {
                        var8_8 += var6_6.length + var13_16.length();
                    }
                }
            }
            ++var10_10;
        }
        if (var8_8 == 0) {
            var2_2[0] = new NVPair("Content-Type", "application/octet-stream");
            return new byte[0];
        }
        var8_8 -= 2;
        var10_11 = new byte[var8_8 += var4_4.length + 2 + 2];
        var11_13 = 0;
        var12_15 = 0x30303030;
        block2: while (var12_15 != 0x7A7A7A7A) {
            var11_13 = 0;
            while (!Codecs.BoundChar.get(var12_15 & 255)) {
                ++var12_15;
            }
            while (!Codecs.BoundChar.get(var12_15 >> 8 & 255)) {
                var12_15 += 256;
            }
            while (!Codecs.BoundChar.get(var12_15 >> 16 & 255)) {
                var12_15 += 65536;
            }
            while (!Codecs.BoundChar.get(var12_15 >> 24 & 255)) {
                var12_15 += 0x1000000;
            }
            var4_4[40] = (byte)(var12_15 & 255);
            var4_4[42] = (byte)(var12_15 >> 8 & 255);
            var4_4[44] = (byte)(var12_15 >> 16 & 255);
            var4_4[46] = (byte)(var12_15 >> 24 & 255);
            var13_17 = 2;
            var14_18 = Util.compile_search(var4_4);
            var15_19 = 0;
            while (var15_19 < var0.length) {
                block27: {
                    if (var0[var15_19] == null) break block27;
                    System.arraycopy(var4_4, var13_17, var10_11, var11_13, var4_4.length - var13_17);
                    var13_17 = 0;
                    var16_20 = var11_13 += var4_4.length - var13_17;
                    System.arraycopy(var5_5, 0, var10_11, var11_13, var5_5.length);
                    var17_22 = var0[var15_19].getName().length();
                    System.arraycopy(var0[var15_19].getName().getBytes("8859_1"), 0, var10_11, var11_13 += var5_5.length, var17_22);
                    var11_13 += var17_22;
                    var10_11[var11_13++] = 34;
                    var10_11[var11_13++] = 13;
                    var10_11[var11_13++] = 10;
                    var10_11[var11_13++] = 13;
                    var10_11[var11_13++] = 10;
                    var18_24 = var0[var15_19].getValue().length();
                    System.arraycopy(var0[var15_19].getValue().getBytes("8859_1"), 0, var10_11, var11_13, var18_24);
                    if ((var11_13 += var18_24) - var16_20 >= var4_4.length && Util.findStr(var4_4, var14_18, var10_11, var16_20, var11_13) != -1) ** GOTO lbl121
                }
                ++var15_19;
            }
            var15_19 = 0;
            while (var15_19 < var1_1.length) {
                block29: {
                    block28: {
                        if (var1_1[var15_19] == null) break block28;
                        var16_21 = new File(var1_1[var15_19].getValue());
                        var17_23 = var16_21.getName();
                        if (var3_3 != null) {
                            var17_23 = var3_3.mangleFilename(var17_23, var1_1[var15_19].getName());
                        }
                        if (var17_23 == null) break block28;
                        System.arraycopy(var4_4, var13_17, var10_11, var11_13, var4_4.length - var13_17);
                        var13_17 = 0;
                        var18_24 = var11_13 += var4_4.length - var13_17;
                        System.arraycopy(var5_5, 0, var10_11, var11_13, var5_5.length);
                        var19_25 = var1_1[var15_19].getName().length();
                        System.arraycopy(var1_1[var15_19].getName().getBytes("8859_1"), 0, var10_11, var11_13 += var5_5.length, var19_25);
                        System.arraycopy(var7_7, 0, var10_11, var11_13 += var19_25, var7_7.length);
                        var19_25 = var17_23.length();
                        System.arraycopy(var17_23.getBytes("8859_1"), 0, var10_11, var11_13 += var7_7.length, var19_25);
                        var11_13 += var19_25;
                        var10_11[var11_13++] = 34;
                        var20_26 = CT.getContentType(var16_21.getName());
                        if (var20_26 != null) {
                            System.arraycopy(var6_6, 0, var10_11, var11_13, var6_6.length);
                            System.arraycopy(var20_26.getBytes("8859_1"), 0, var10_11, var11_13 += var6_6.length, var20_26.length());
                            var11_13 += var20_26.length();
                        }
                        var10_11[var11_13++] = 13;
                        var10_11[var11_13++] = 10;
                        var10_11[var11_13++] = 13;
                        var10_11[var11_13++] = 10;
                        var19_25 = (int)var16_21.length();
                        var21_27 = new FileInputStream(var16_21);
                        while (var19_25 > 0) {
                            var22_28 = var21_27.read(var10_11, var11_13, var19_25);
                            var19_25 -= var22_28;
                            var11_13 += var22_28;
                        }
                        var21_27.close();
                        if (var11_13 - var18_24 >= var4_4.length && Util.findStr(var4_4, var14_18, var10_11, var18_24, var11_13) != -1) break block29;
                    }
                    ++var15_19;
                    continue;
                }
                ++var12_15;
                continue block2;
            }
            break block2;
        }
        System.arraycopy(var4_4, 0, var10_11, var11_13, var4_4.length);
        var11_13 += var4_4.length;
        var10_11[var11_13++] = 45;
        var10_11[var11_13++] = 45;
        var10_11[var11_13++] = 13;
        var10_11[var11_13++] = 10;
        if (var11_13 != var8_8) {
            throw new Error("Calculated " + var8_8 + " bytes but wrote " + var11_13 + " bytes!");
        }
        var2_2[0] = new NVPair("Content-Type", "multipart/form-data; boundary=" + new String(var4_4, 4, var4_4.length - 4, "8859_1"));
        return var10_11;
    }

    public static final String nv2query(NVPair[] nVPairArray) {
        if (nVPairArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nVPairArray.length) {
            if (nVPairArray[n] != null) {
                stringBuffer.append(Codecs.URLEncode(nVPairArray[n].getName()) + "=" + Codecs.URLEncode(nVPairArray[n].getValue()) + "&");
            }
            ++n;
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public static final NVPair[] query2nv(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        int n = -1;
        int n2 = 1;
        while ((n = string.indexOf(38, n + 1)) != -1) {
            ++n2;
        }
        NVPair[] nVPairArray = new NVPair[n2];
        n = 0;
        n2 = 0;
        while (n2 < nVPairArray.length) {
            int n3 = string.indexOf(61, n);
            int n4 = string.indexOf(38, n);
            if (n4 == -1) {
                n4 = string.length();
            }
            if (n3 == -1 || n3 >= n4) {
                throw new ParseException("'=' missing in " + string.substring(n, n4));
            }
            nVPairArray[n2] = new NVPair(Codecs.URLDecode(string.substring(n, n3)), Codecs.URLDecode(string.substring(n3 + 1, n4)));
            n = n4 + 1;
            ++n2;
        }
        return nVPairArray;
    }

    public static final byte[] chunkedEncode(byte[] byArray, NVPair[] nVPairArray, boolean bl) {
        return Codecs.chunkedEncode(byArray, 0, byArray == null ? 0 : byArray.length, nVPairArray, bl);
    }

    public static final byte[] chunkedEncode(byte[] byArray, int n, int n2, NVPair[] nVPairArray, boolean bl) {
        int n3;
        if (byArray == null) {
            byArray = new byte[]{};
            n2 = 0;
        }
        if (bl && nVPairArray == null) {
            nVPairArray = new NVPair[]{};
        }
        String string = Integer.toString(n2, 16);
        int n4 = 0;
        if (n2 > 0) {
            n4 += string.length() + 2 + n2 + 2;
        }
        if (bl) {
            n4 += 3;
            int n5 = 0;
            while (n5 < nVPairArray.length) {
                n4 += nVPairArray[n5].getName().length() + 2 + nVPairArray[n5].getValue().length() + 2;
                ++n5;
            }
            n4 += 2;
        }
        byte[] byArray2 = new byte[n4];
        int n6 = 0;
        if (n2 > 0) {
            n3 = string.length();
            try {
                System.arraycopy(string.getBytes("8859_1"), 0, byArray2, n6, n3);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new Error(unsupportedEncodingException.toString());
            }
            n6 += n3;
            byArray2[n6++] = 13;
            byArray2[n6++] = 10;
            System.arraycopy(byArray, n, byArray2, n6, n2);
            n6 += n2;
            byArray2[n6++] = 13;
            byArray2[n6++] = 10;
        }
        if (bl) {
            byArray2[n6++] = 48;
            byArray2[n6++] = 13;
            byArray2[n6++] = 10;
            n3 = 0;
            while (n3 < nVPairArray.length) {
                int n7 = nVPairArray[n3].getName().length();
                try {
                    System.arraycopy(nVPairArray[n3].getName().getBytes("8859_1"), 0, byArray2, n6, n7);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new Error(unsupportedEncodingException.toString());
                }
                n6 += n7;
                byArray2[n6++] = 58;
                byArray2[n6++] = 32;
                int n8 = nVPairArray[n3].getValue().length();
                try {
                    System.arraycopy(nVPairArray[n3].getValue().getBytes("8859_1"), 0, byArray2, n6, n8);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new Error(unsupportedEncodingException.toString());
                }
                n6 += n8;
                byArray2[n6++] = 13;
                byArray2[n6++] = 10;
                ++n3;
            }
            byArray2[n6++] = 13;
            byArray2[n6++] = 10;
        }
        if (n6 != byArray2.length) {
            throw new Error("Calculated " + byArray2.length + " bytes but wrote " + n6 + " bytes!");
        }
        return byArray2;
    }

    public static final Object chunkedDecode(InputStream inputStream) throws ParseException, IOException {
        String string;
        long l = Codecs.getChunkLength(inputStream);
        if (l > Integer.MAX_VALUE) {
            throw new ParseException("Can't deal with chunk lengths greater Integer.MAX_VALUE: " + l + " > " + "2147483647");
        }
        if (l > 0L) {
            byte[] byArray = new byte[(int)l];
            int n = 0;
            int n2 = 0;
            while (n2 != -1 && n < byArray.length) {
                n2 = inputStream.read(byArray, n, byArray.length - n);
                n += n2;
            }
            if (n2 == -1) {
                throw new ParseException("Premature EOF while reading chunk;Expected: " + byArray.length + " Bytes, " + "Received: " + (n + 1) + " Bytes");
            }
            inputStream.read();
            inputStream.read();
            return byArray;
        }
        NVPair[] nVPairArray = new NVPair[]{};
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "8859_1"));
        while ((string = bufferedReader.readLine()) != null && string.length() > 0) {
            int n = string.indexOf(58);
            if (n == -1) {
                throw new ParseException("Error in Footer format: no ':' found in '" + string + "'");
            }
            nVPairArray = Util.resizeArray(nVPairArray, nVPairArray.length + 1);
            nVPairArray[nVPairArray.length - 1] = new NVPair(string.substring(0, n).trim(), string.substring(n + 1).trim());
        }
        return nVPairArray;
    }

    static final long getChunkLength(InputStream inputStream) throws ParseException, IOException {
        int n;
        byte[] byArray = new byte[16];
        int n2 = 0;
        while ((n = inputStream.read()) > 0 && (n == 32 || n == 9)) {
        }
        if (n < 0) {
            throw new EOFException("Premature EOF while reading chunk length");
        }
        byArray[n2++] = (byte)n;
        while ((n = inputStream.read()) > 0 && n != 13 && n != 10 && n != 32 && n != 9 && n != 59 && n2 < byArray.length) {
            byArray[n2++] = (byte)n;
        }
        while ((n == 32 || n == 9) && (n = inputStream.read()) > 0) {
        }
        if (n == 59) {
            while ((n = inputStream.read()) > 0 && n != 13 && n != 10) {
            }
        }
        if (n < 0) {
            throw new EOFException("Premature EOF while reading chunk length");
        }
        if (n != 10 && (n != 13 || inputStream.read() != 10)) {
            throw new ParseException("Didn't find valid chunk length: " + new String(byArray, 0, n2, "8859_1"));
        }
        try {
            return Long.parseLong(new String(byArray, 0, n2, "8859_1").trim(), 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Didn't find valid chunk length: " + new String(byArray, 0, n2, "8859_1"));
        }
    }

    private Codecs() {
    }

    static {
        int n = 48;
        while (n <= 57) {
            BoundChar.set(n);
            ++n;
        }
        n = 65;
        while (n <= 90) {
            BoundChar.set(n);
            ++n;
        }
        n = 97;
        while (n <= 122) {
            BoundChar.set(n);
            ++n;
        }
        BoundChar.set(43);
        BoundChar.set(95);
        BoundChar.set(45);
        BoundChar.set(46);
        EBCDICUnsafeChar = new BitSet(256);
        EBCDICUnsafeChar.set(33);
        EBCDICUnsafeChar.set(34);
        EBCDICUnsafeChar.set(35);
        EBCDICUnsafeChar.set(36);
        EBCDICUnsafeChar.set(64);
        EBCDICUnsafeChar.set(91);
        EBCDICUnsafeChar.set(92);
        EBCDICUnsafeChar.set(93);
        EBCDICUnsafeChar.set(94);
        EBCDICUnsafeChar.set(96);
        EBCDICUnsafeChar.set(123);
        EBCDICUnsafeChar.set(124);
        EBCDICUnsafeChar.set(125);
        EBCDICUnsafeChar.set(126);
        byte[] byArray = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        Base64EncMap = byArray;
        Base64DecMap = new byte[128];
        int n2 = 0;
        while (n2 < Base64EncMap.length) {
            Codecs.Base64DecMap[Codecs.Base64EncMap[n2]] = (byte)n2;
            ++n2;
        }
        UUEncMap = new char[64];
        n2 = 0;
        while (n2 < UUEncMap.length) {
            Codecs.UUEncMap[n2] = (char)(n2 + 32);
            ++n2;
        }
        UUDecMap = new byte[128];
        n2 = 0;
        while (n2 < UUEncMap.length) {
            Codecs.UUDecMap[Codecs.UUEncMap[n2]] = (byte)n2;
            ++n2;
        }
        dummy = new NVPair[0];
    }

    private static class CT
    extends URLConnection {
        protected static final String getContentType(String string) {
            return URLConnection.guessContentTypeFromName(string);
        }

        public void connect() {
        }

        private CT() {
            super(null);
        }
    }
}

