/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.rmi.RemoteException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.ConstantMap;
import visad.Data;
import visad.DataImpl;
import visad.DataReferenceImpl;
import visad.DateTime;
import visad.Display;
import visad.DisplayImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.Linear1DSet;
import visad.LocalDisplay;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.RemoteDisplayImpl;
import visad.RemoteServer;
import visad.RemoteServerImpl;
import visad.ScalarMap;
import visad.Tuple;
import visad.VisADException;
import visad.java2d.DisplayImplJ2D;
import visad.java3d.DisplayImplJ3D;
import visad.util.AnimationWidget;
import visad.util.ClientServer;
import visad.util.ContourWidget;
import visad.util.GMCWidget;
import visad.util.LabeledColorWidget;
import visad.util.ProjWidget;
import visad.util.RangeWidget;
import visad.util.SelectRangeWidget;

/*
 * Exception performing whole class analysis ignored.
 */
public class DisplaySwitch
extends Thread {
    private static final int maximumWaitTime = 60;
    private DisplayImpl display = null;
    private DataReferenceImpl[] dpyRefs = null;
    private Data alphaData0 = null;
    private Data betaData0 = null;
    private Data betaData1 = null;
    private ConstantMap[] betaConstMaps = null;
    private JPanel dpyPanel = null;
    private JButton switchDim = null;
    private JButton switchData = null;
    private boolean startServer = false;
    private String hostName = null;
    private boolean dpy3D = false;
    private boolean dpyBeta = false;

    public boolean processArgs(String[] stringArray) {
        boolean bl = false;
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(36);
        if (n2 > n) {
            n = n2;
        }
        String string2 = string.substring(n == -1 ? 0 : n + 1);
        int n3 = 0;
        while (stringArray != null && n3 < stringArray.length) {
            if (stringArray[n3].length() > 0 && stringArray[n3].charAt(0) == '-') {
                char c = stringArray[n3].charAt(1);
                switch (c) {
                    case 'c': {
                        String string3;
                        String string4 = stringArray[n3].length() > 2 ? stringArray[n3].substring(2) : (string3 = n3 + 1 < stringArray.length ? stringArray[++n3] : null);
                        if (string3 == null) {
                            System.err.println(string2 + ": Missing hostname for \"-c\"");
                            bl = true;
                            break;
                        }
                        if (this.startServer) {
                            System.err.println(string2 + ": Cannot specify both '-c' and '-s'!");
                            bl = true;
                            break;
                        }
                        this.hostName = string3;
                        break;
                    }
                    case 's': {
                        if (this.hostName != null) {
                            System.err.println(string2 + ": Cannot specify both '-c' and '-s'!");
                            bl = true;
                            break;
                        }
                        this.startServer = true;
                        break;
                    }
                    default: {
                        System.err.println(string2 + ": Unknown option \"-" + c + "\"");
                        bl = true;
                        break;
                    }
                }
            } else {
                System.err.println(string2 + ": Unknown keyword \"" + stringArray[n3] + "\"");
                bl = true;
            }
            ++n3;
        }
        if (bl) {
            System.err.println("Usage: " + this.getClass().getName() + " [-c(lient) hostname] [-s(erver)]");
        }
        return !bl;
    }

    boolean isServer() {
        return this.startServer && this.hostName == null;
    }

    boolean isClient() {
        return !this.startServer && this.hostName != null;
    }

    boolean isStandalone() {
        return !this.startServer && this.hostName == null;
    }

    String getClientServerTitle() {
        if (this.isServer()) {
            return " server";
        }
        if (this.isClient()) {
            return " client";
        }
        if (this.isStandalone()) {
            return " standalone";
        }
        return " unknown";
    }

    LocalDisplay setupClientData() throws RemoteException, VisADException {
        RemoteServer remoteServer;
        try {
            remoteServer = ClientServer.connectToServer(this.hostName, this.getClass().getName(), true);
        }
        catch (VisADException visADException) {
            System.err.println(visADException.getMessage());
            System.exit(1);
            remoteServer = null;
        }
        LocalDisplay[] localDisplayArray = ClientServer.getClientDisplays(remoteServer);
        if (localDisplayArray == null) {
            throw new VisADException("No remote displays found!");
        }
        if (localDisplayArray.length != 1) {
            throw new VisADException("Multiple remote displays found!");
        }
        return localDisplayArray[0];
    }

    public void startThreads() throws RemoteException, VisADException {
        LocalDisplay localDisplay;
        if (this.isClient()) {
            localDisplay = this.setupClientData();
        } else {
            DisplayImpl displayImpl = this.setupServerDisplay();
            if (!this.startServer) {
                Object var3_3 = null;
            } else {
                RemoteServerImpl remoteServerImpl = ClientServer.startServer(this.getClass().getName());
                if (displayImpl != null) {
                    remoteServerImpl.addDisplay(new RemoteDisplayImpl(displayImpl));
                }
            }
            localDisplay = displayImpl;
            this.setupServerData(localDisplay);
        }
        this.setupUI(localDisplay);
    }

    DisplayImpl setupServerDisplay() throws RemoteException, VisADException {
        this.display = new DisplayImplJ2D("display");
        return this.display;
    }

    private static ScalarMap findMap(LocalDisplay localDisplay, RealType realType) {
        ScalarMap scalarMap;
        Iterator iterator;
        if (realType == null) {
            return null;
        }
        try {
            iterator = ((AbstractList)localDisplay.getMapVector()).iterator();
        }
        catch (Exception exception) {
            iterator = null;
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                scalarMap = (ScalarMap)iterator.next();
                if (!realType.equals(scalarMap.getDisplayScalar())) continue;
                return scalarMap;
            }
        }
        try {
            iterator = ((AbstractList)localDisplay.getConstantMapVector()).iterator();
        }
        catch (Exception exception) {
            iterator = null;
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                scalarMap = (ConstantMap)iterator.next();
                if (!realType.equals(scalarMap.getDisplayScalar())) continue;
                return scalarMap;
            }
        }
        return null;
    }

    private void buildMaps(LocalDisplay localDisplay) throws RemoteException, VisADException {
        RealType realType = RealType.getRealType("dom0");
        RealType realType2 = RealType.getRealType("dom1");
        localDisplay.addMap(new ScalarMap(RealType.Latitude, Display.XAxis));
        localDisplay.addMap(new ScalarMap(RealType.Longitude, Display.YAxis));
        localDisplay.addMap(new ScalarMap(realType2, Display.Green));
        localDisplay.addMap(new ConstantMap(0.5, Display.Blue));
        localDisplay.addMap(new ConstantMap(0.5, Display.Red));
        localDisplay.addMap(new ScalarMap(realType, Display.IsoContour));
        localDisplay.addMap(new ScalarMap(realType2, Display.SelectRange));
        localDisplay.addMap(new ScalarMap(realType2, Display.RGBA));
        localDisplay.addMap(new ScalarMap(RealType.Time, Display.Animation));
    }

    private DataImpl buildAlphaRefZero() throws RemoteException, VisADException {
        RealType realType = RealType.getRealType("dom0");
        RealType realType2 = RealType.getRealType("dom1");
        RealType[] realTypeArray = new RealType[]{RealType.Latitude, RealType.Longitude};
        RealTupleType realTupleType = new RealTupleType(realTypeArray);
        RealType[] realTypeArray2 = new RealType[]{realType, realType2};
        RealTupleType realTupleType2 = new RealTupleType(realTypeArray2);
        FunctionType functionType = new FunctionType(realTupleType, realTupleType2);
        RealType[] realTypeArray3 = new RealType[]{realType2, realType};
        RealTupleType realTupleType3 = new RealTupleType(realTypeArray3);
        FunctionType functionType2 = new FunctionType(realTupleType, realTupleType3);
        RealType[] realTypeArray4 = new RealType[]{RealType.Time};
        RealTupleType realTupleType4 = new RealTupleType(realTypeArray4);
        FunctionType functionType3 = new FunctionType(realTupleType4, functionType);
        FunctionType functionType4 = new FunctionType(realTupleType4, functionType2);
        int n = 64;
        int n2 = 4;
        double d = new DateTime(1999, 122, 57060.0).getValue();
        Linear1DSet linear1DSet = new Linear1DSet((MathType)realTupleType4, d, d + 3000.0, n2);
        double[][] dArray = new double[][]{{d, d + 600.0, d + 1200.0, d + 1800.0, d + 2400.0, d + 3000.0}};
        Gridded1DDoubleSet gridded1DDoubleSet = new Gridded1DDoubleSet((MathType)realTupleType4, dArray, dArray[0].length);
        FieldImpl fieldImpl = new FieldImpl(functionType3, linear1DSet);
        FieldImpl fieldImpl2 = new FieldImpl(functionType4, gridded1DDoubleSet);
        FlatField flatField = FlatField.makeField(functionType, n, false);
        FlatField flatField2 = FlatField.makeField(functionType2, n, false);
        Real[] realArray = new Real[]{new Real(realType, (double)((float)n / 4.0f)), new Real(realType2, (double)((float)n / 8.0f))};
        RealTuple realTuple = new RealTuple(realArray);
        int n3 = 0;
        while (n3 < n2) {
            fieldImpl.setSample(n3, (Data)flatField);
            flatField = (FlatField)flatField.add(realTuple);
            ++n3;
        }
        n3 = 0;
        while (n3 < dArray[0].length) {
            fieldImpl2.setSample(n3, (Data)flatField2);
            flatField2 = (FlatField)flatField2.add(realTuple);
            ++n3;
        }
        Data[] dataArray = new FieldImpl[]{fieldImpl, fieldImpl2};
        return new Tuple(dataArray);
    }

    void setupAlphaRefs(LocalDisplay localDisplay) throws RemoteException, VisADException {
        if (this.alphaData0 == null) {
            this.alphaData0 = this.buildAlphaRefZero();
        }
        this.dpyRefs = new DataReferenceImpl[1];
        this.dpyRefs[0] = new DataReferenceImpl("dpyRef0");
        this.dpyRefs[0].setData(this.alphaData0);
        localDisplay.addReference(this.dpyRefs[0], null);
    }

    private DataImpl buildBetaRefZero() throws RemoteException, VisADException {
        RealType realType = RealType.getRealType("dom0");
        RealType realType2 = RealType.getRealType("dom1");
        int n = 16;
        RealTupleType realTupleType = new RealTupleType(RealType.Longitude, RealType.Latitude);
        RealTupleType realTupleType2 = new RealTupleType(realType, realType2);
        FunctionType functionType = new FunctionType(realTupleType, realTupleType2);
        FlatField flatField = FlatField.makeField(functionType, n, false);
        double[][] dArray = new double[2][n * n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                dArray[0][n3 + n * n2] = (n2 + 1) * (n3 + 1);
                dArray[1][n3 + n * n2] = (double)n2 * 1.2 * ((double)n3 / 1.2);
                ++n3;
            }
            ++n2;
        }
        return flatField;
    }

    private DataImpl buildBetaRefOne() throws RemoteException, VisADException {
        RealType realType = RealType.getRealType("dom0");
        RealType realType2 = RealType.getRealType("dom1");
        int n = 16;
        RealTupleType realTupleType = new RealTupleType(RealType.Latitude, RealType.Longitude);
        RealTupleType realTupleType2 = new RealTupleType(realType, realType2);
        FunctionType functionType = new FunctionType(realTupleType, realTupleType2);
        FlatField flatField = FlatField.makeField(functionType, n, false);
        double[][] dArray = new double[2][n * n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                dArray[0][n3 + n * n2] = (n2 + 1) * (n3 + 1);
                dArray[1][n3 + n * n2] = (double)n2 * 1.2 * ((double)n3 / 1.2);
                ++n3;
            }
            ++n2;
        }
        flatField.setSamples(dArray, false);
        return flatField;
    }

    void setupBetaRefs(LocalDisplay localDisplay) throws RemoteException, VisADException {
        if (this.betaData0 == null) {
            this.betaData0 = this.buildBetaRefZero();
        }
        if (this.betaData1 == null) {
            this.betaData1 = this.buildBetaRefOne();
        }
        if (this.betaConstMaps == null) {
            this.betaConstMaps = new ConstantMap[3];
            this.betaConstMaps[0] = new ConstantMap(1.0, Display.Blue);
            this.betaConstMaps[1] = new ConstantMap(1.0, Display.Red);
            this.betaConstMaps[2] = new ConstantMap(0.0, Display.Green);
        }
        this.dpyRefs = new DataReferenceImpl[2];
        this.dpyRefs[0] = new DataReferenceImpl("dpyRef0");
        this.dpyRefs[0].setData(this.betaData0);
        localDisplay.addReference(this.dpyRefs[0], null);
        this.dpyRefs[1] = new DataReferenceImpl("dpyRef1");
        this.dpyRefs[1].setData(this.betaData1);
        localDisplay.addReference(this.dpyRefs[1], this.betaConstMaps);
    }

    void setupServerData(LocalDisplay localDisplay) throws RemoteException, VisADException {
        this.buildMaps(localDisplay);
        this.setupAlphaRefs(localDisplay);
    }

    void switchDisplay(boolean bl) {
        ScalarMap scalarMap;
        int n;
        DisplayImpl displayImpl;
        int n2;
        if (this.display == null) {
            System.err.println("No display found!");
            return;
        }
        String string = this.display.getName();
        try {
            n2 = this.display.getAPI();
        }
        catch (VisADException visADException) {
            n2 = 0;
        }
        try {
            displayImpl = this.dpy3D ? new DisplayImplJ3D(string, n2) : new DisplayImplJ2D(string, n2);
        }
        catch (Exception exception) {
            System.err.println("Couldn't create new display!");
            return;
        }
        Vector vector = this.display.getMapVector();
        Vector vector2 = this.display.getConstantMapVector();
        try {
            this.dpyPanel.remove(this.display.getComponent());
            this.display.removeAllReferences();
            this.display.clearMaps();
            this.display = null;
        }
        catch (Exception exception) {
            System.err.println("Ignoring " + exception.getClass().getName() + ": " + exception.getMessage());
        }
        if (vector != null) {
            int n3 = vector.size();
            n = 0;
            while (n < n3) {
                scalarMap = (ScalarMap)vector.elementAt(n);
                try {
                    displayImpl.addMap(scalarMap);
                }
                catch (Exception exception) {
                    System.err.println("Couldn't re-add ScalarMap " + scalarMap + ": " + exception.getClass().getName() + ": " + exception.getMessage());
                    exception.printStackTrace();
                }
                ++n;
            }
        }
        if (vector2 != null) {
            int n4 = vector2.size();
            n = 0;
            while (n < n4) {
                scalarMap = (ConstantMap)vector2.elementAt(n);
                try {
                    displayImpl.addMap(scalarMap);
                }
                catch (Exception exception) {
                    System.err.println("Couldn't re-add ConstantMap " + scalarMap + ": " + exception.getClass().getName() + ": " + exception.getMessage());
                    exception.printStackTrace();
                }
                ++n;
            }
        }
        if (this.dpyRefs == null || bl) {
            if (this.dpyBeta) {
                try {
                    this.setupBetaRefs((LocalDisplay)displayImpl);
                }
                catch (Exception exception) {
                    System.err.println("Couldn't re-init beta refs: " + exception.getClass().getName() + ": " + exception.getMessage());
                    exception.printStackTrace();
                }
            } else {
                try {
                    this.setupAlphaRefs((LocalDisplay)displayImpl);
                }
                catch (Exception exception) {
                    System.err.println("Couldn't re-init alpha refs: " + exception.getClass().getName() + ": " + exception.getMessage());
                    exception.printStackTrace();
                }
            }
        } else {
            int n5 = 0;
            while (n5 < this.dpyRefs.length) {
                try {
                    displayImpl.addReference(this.dpyRefs[n5], null);
                }
                catch (Exception exception) {
                    System.err.println("Couldn't re-add " + this.dpyRefs[n5] + ": " + exception.getClass().getName() + ": " + exception.getMessage());
                    exception.printStackTrace();
                }
                ++n5;
            }
        }
        this.display = displayImpl;
        this.dpyPanel.add(this.display.getComponent());
    }

    private Component buildSwitchButtons() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.switchDim = new JButton("Change to 3D");
        this.switchDim.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        jPanel.add(this.switchDim);
        this.switchData = new JButton("Change Data");
        this.switchData.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        jPanel.add(this.switchData);
        return jPanel;
    }

    Component getSpecialComponent(LocalDisplay localDisplay) throws RemoteException, VisADException {
        Vector vector = localDisplay.getMapVector();
        ScalarMap scalarMap = DisplaySwitch.findMap((LocalDisplay)localDisplay, (RealType)Display.RGBA);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.dpyPanel = new JPanel();
        this.dpyPanel.add(localDisplay.getComponent());
        jPanel.add(this.dpyPanel);
        jPanel.add(new AnimationWidget(DisplaySwitch.findMap((LocalDisplay)localDisplay, (RealType)Display.Animation), 500));
        jPanel.add(new ContourWidget(DisplaySwitch.findMap((LocalDisplay)localDisplay, (RealType)Display.IsoContour)));
        jPanel.add(new GMCWidget(localDisplay.getGraphicsModeControl()));
        jPanel.add(new LabeledColorWidget(scalarMap));
        jPanel.add(new ProjWidget(localDisplay.getProjectionControl()));
        jPanel.add(new RangeWidget(scalarMap));
        jPanel.add(new SelectRangeWidget(DisplaySwitch.findMap((LocalDisplay)localDisplay, (RealType)Display.SelectRange)));
        if (this.isServer() || this.isStandalone()) {
            jPanel.add(this.buildSwitchButtons());
        }
        return jPanel;
    }

    void setupUI(LocalDisplay localDisplay) throws RemoteException, VisADException {
        Container container;
        Container container2;
        Component component = this.getSpecialComponent(localDisplay);
        if (component instanceof Container) {
            container2 = (Container)component;
        } else {
            container = new JPanel();
            container.setLayout(new BorderLayout());
            container.add("Center", component);
            container2 = container;
        }
        container = new JFrame(this.getFrameTitle() + this.getClientServerTitle());
        ((Window)container).addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        ((JFrame)container).setContentPane(container2);
        ((Window)container).pack();
        container.setVisible(true);
    }

    String getFrameTitle() {
        return "2d/3d display switch";
    }

    public String toString() {
        return ": Changing between 2d and 3d display";
    }

    public static void main(String[] stringArray) throws RemoteException, VisADException {
        new DisplaySwitch(stringArray);
    }

    static /* synthetic */ boolean access$0(DisplaySwitch displaySwitch) {
        return displaySwitch.dpy3D;
    }

    static /* synthetic */ void access$1(DisplaySwitch displaySwitch, boolean bl) {
        displaySwitch.dpy3D = bl;
    }

    static /* synthetic */ JButton access$2(DisplaySwitch displaySwitch) {
        return displaySwitch.switchDim;
    }

    static /* synthetic */ boolean access$3(DisplaySwitch displaySwitch) {
        return displaySwitch.dpyBeta;
    }

    static /* synthetic */ void access$4(DisplaySwitch displaySwitch, boolean bl) {
        displaySwitch.dpyBeta = bl;
    }

    public DisplaySwitch(String[] stringArray) throws RemoteException, VisADException {
        if (!this.processArgs(stringArray)) {
            System.err.println("Exiting...");
            System.exit(1);
        }
        this.startThreads();
    }
}

