/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.net.MalformedURLException;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.DataImpl;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DisplayImpl;
import visad.ReferenceActionLink;
import visad.RemoteDisplay;
import visad.RemoteDisplayImpl;
import visad.RemoteServer;
import visad.RemoteServerImpl;
import visad.ScalarMap;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.DefaultFamily;
import visad.java3d.DisplayImplJ3D;
import visad.ss.MappingDialog;

public class CollabMapTest
extends JFrame
implements ActionListener {
    private static final String usage = "Usage: java CollabMapTest [-s filename] [-c address]";
    private boolean server;
    private DataReference ref;
    private DisplayImpl disp;

    private void constructGUI(String string, boolean bl) {
        JPanel jPanel = new JPanel();
        this.setContentPane(jPanel);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.disp.getComponent());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JButton jButton = new JButton("Detect maps");
        JButton jButton2 = new JButton("Edit maps");
        JButton jButton3 = new JButton("Clear maps");
        jButton.addActionListener((ActionListener)this);
        jButton.setActionCommand("detect");
        jButton.setEnabled(bl);
        jButton2.addActionListener((ActionListener)this);
        jButton2.setActionCommand("edit");
        jButton2.setEnabled(bl);
        jButton3.addActionListener((ActionListener)this);
        jButton3.setActionCommand("clear");
        jButton3.setEnabled(bl);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        jPanel.add(jPanel2);
        this.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        this.setTitle("CollabMapTest " + (this.server ? "server" : "client") + ": " + string);
        this.pack();
        this.setVisible(true);
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException {
        if (stringArray.length < 2) {
            System.err.println("Not enough arguments.");
            System.err.println(usage);
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        boolean bl = false;
        if (string.equalsIgnoreCase("-s")) {
            bl = true;
        } else if (!string.equalsIgnoreCase("-c")) {
            System.err.println("Please specify either -s or -c");
            System.err.println(usage);
            System.exit(2);
        }
        CollabMapTest collabMapTest = new CollabMapTest(bl, string2);
    }

    private void setMaps(ScalarMap[] scalarMapArray) throws VisADException, RemoteException {
        this.disp.removeReference(this.ref);
        this.disp.clearMaps();
        int n = 0;
        while (n < scalarMapArray.length) {
            this.disp.addMap(scalarMapArray[n]);
            ++n;
        }
        this.disp.addReference(this.ref);
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("detect")) {
            try {
                this.setMaps(this.ref.getData().getType().guessMaps(true));
            }
            catch (VisADException visADException) {
                visADException.printStackTrace();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        } else if (string.equals("edit")) {
            try {
                Vector vector = this.disp.getMapVector();
                int n = vector.size();
                ScalarMap[] scalarMapArray = n > 0 ? new ScalarMap[n] : null;
                int n2 = 0;
                while (n2 < n) {
                    scalarMapArray[n2] = (ScalarMap)vector.elementAt(n2);
                    ++n2;
                }
                MappingDialog mappingDialog = new MappingDialog((Frame)this, this.ref.getData(), scalarMapArray, true, true);
                mappingDialog.display();
                if (!mappingDialog.okPressed()) {
                    return;
                }
                this.setMaps(mappingDialog.getMaps());
            }
            catch (VisADException visADException) {
                visADException.printStackTrace();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        } else if (string.equals("clear")) {
            try {
                this.disp.removeReference(this.ref);
                this.disp.clearMaps();
                this.disp.addReference(this.ref);
            }
            catch (VisADException visADException) {
                visADException.printStackTrace();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }
    }

    public CollabMapTest(boolean bl, String string) throws VisADException, RemoteException {
        this.server = bl;
        if (this.server) {
            DefaultFamily defaultFamily = new DefaultFamily("loader");
            DataImpl dataImpl = null;
            try {
                dataImpl = defaultFamily.open(string);
            }
            catch (BadFormException badFormException) {
                System.err.println("The specified data file could not be loaded. The file is missing, corrupt, or of the wrong type.");
                badFormException.printStackTrace();
                throw new VisADException(badFormException.getMessage());
            }
            this.ref = new DataReferenceImpl("ref");
            this.ref.setData(dataImpl);
            this.disp = new DisplayImplJ3D("disp");
            this.disp.addReference(this.ref);
            RemoteServerImpl remoteServerImpl = new RemoteServerImpl();
            try {
                Naming.rebind("///CollabMapTest", remoteServerImpl);
            }
            catch (ConnectException connectException) {
                System.err.println("Please run rmiregistry first.");
                throw new VisADException(connectException.getMessage());
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                throw new VisADException(malformedURLException.getMessage());
            }
            RemoteDisplayImpl remoteDisplayImpl = new RemoteDisplayImpl(this.disp);
            remoteServerImpl.addDisplay(remoteDisplayImpl);
            this.constructGUI(string, true);
        } else {
            RemoteServer remoteServer;
            try {
                remoteServer = (RemoteServer)Naming.lookup("//" + string + "/CollabMapTest");
            }
            catch (NotBoundException notBoundException) {
                System.err.println("The specified address is not running a CollabMapTest server!");
                throw new VisADException(notBoundException.getMessage());
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("The specified address is not valid!");
                throw new VisADException(malformedURLException.getMessage());
            }
            RemoteDisplay remoteDisplay = remoteServer.getDisplay(0);
            this.disp = new DisplayImplJ3D(remoteDisplay);
            Vector vector = this.disp.getLinks();
            ReferenceActionLink referenceActionLink = (ReferenceActionLink)vector.elementAt(0);
            DataReference dataReference = (DataReference)referenceActionLink.getThingReference();
            this.constructGUI(string, false);
        }
    }
}

