/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.agent;

import sun.tools.agent.CachedClass;
import sun.tools.agent.CachedMethod;

class Event
implements Cloneable {
    int kind;
    Thread thread;
    Class clazz;
    long methodID;
    int bci;
    Throwable exception;
    Class catch_clazz;
    long catch_methodID;
    int catch_bci;
    static final int SINGLE_STEP = 1;
    static final int BREAKPOINT = 2;
    static final int FRAME_POP = 3;
    static final int EXCEPTION = 4;
    static final int USER_DEFINED = 5;
    static final int THREAD_START = 6;
    static final int THREAD_END = 7;
    static final int VM_DEATH = 99;
    private CachedMethod cachedMethod;
    private CachedMethod cachedCatchMethod;
    private long cachedMethodID = 0L;
    private long cachedCatchMethodID = 0L;
    boolean waiting_for_event;

    Event() {
    }

    synchronized CachedMethod getMethod() {
        if (this.clazz == null) {
            return null;
        }
        if (this.cachedMethodID != this.methodID) {
            CachedClass cachedClass = CachedClass.getCachedClass(this.clazz);
            this.cachedMethod = cachedClass.getMethod(this.methodID);
            this.cachedMethodID = this.methodID;
        }
        return this.cachedMethod;
    }

    int getBCI() {
        return this.bci;
    }

    Throwable getException() {
        return this.exception;
    }

    synchronized CachedMethod getCatchMethod() {
        if (this.catch_clazz == null) {
            return null;
        }
        if (this.cachedCatchMethodID != this.catch_methodID) {
            CachedClass cachedClass = CachedClass.getCachedClass(this.catch_clazz);
            this.cachedCatchMethod = cachedClass.getMethod(this.catch_methodID);
            this.cachedCatchMethodID = this.catch_methodID;
        }
        return this.cachedCatchMethod;
    }

    synchronized void clearCache() {
        this.cachedMethod = null;
        this.cachedCatchMethod = null;
        this.cachedMethodID = 0L;
        this.cachedCatchMethodID = 0L;
    }

    int getCatchBCI() {
        return this.catch_bci;
    }

    protected synchronized Object clone() {
        Event event;
        try {
            event = (Event)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        event.kind = this.kind;
        event.thread = this.thread;
        event.clazz = this.clazz;
        event.methodID = this.methodID;
        event.bci = this.bci;
        event.exception = this.exception;
        event.catch_clazz = this.catch_clazz;
        event.catch_methodID = this.catch_methodID;
        event.catch_bci = this.catch_bci;
        event.waiting_for_event = this.waiting_for_event;
        return event;
    }

    synchronized boolean nextEvent() {
        do {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.waiting_for_event);
        return true;
    }

    synchronized void reset() {
        this.bci = -1;
    }

    public String toString() {
        if (this.kind == 1) {
            return "event:SINGLE_STEP(" + this.thread + ", " + this.getMethod() + " @ " + this.bci + ")";
        }
        if (this.kind == 2) {
            return "event:BREAKPOINT(" + this.thread + ", " + this.getMethod() + " @ " + this.bci + ")";
        }
        if (this.kind == 3) {
            return "event:FRAME_POP(" + this.thread + ")";
        }
        if (this.kind == 4) {
            return "event:EXCEPTION(" + this.thread + ", " + this.getMethod() + " @ " + this.bci + " - exc: " + this.exception + ")";
        }
        if (this.kind == 5) {
            return "event:USER_DEFINED";
        }
        if (this.kind == 6) {
            return "event:THREAD_START(" + this.thread + ")";
        }
        if (this.kind == 7) {
            return "event:THREAD_END(" + this.thread + ")";
        }
        if (this.kind == 99) {
            return "event:VM_DEATH";
        }
        return "event: invalid kind = " + this.kind;
    }
}

