/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audio;

import com.sun.j3d.audio.AudioClipData;
import com.sun.j3d.audio.AudioContainerInputStream;
import com.sun.j3d.audio.AudioFormat;
import com.sun.j3d.audio.Format;
import com.sun.j3d.audio.HaeAudioStreamClip;
import com.sun.j3d.audio.J3DHaeStream;
import com.sun.j3d.audio.JavaSoundParams;
import java.io.InputStream;
import java.net.URL;

public class J3DHaeClip
extends J3DHaeStream {
    public static int loadSample(InputStream inputStream, int n) {
        try {
            AudioClipData audioClipData = new AudioClipData(inputStream, true);
            HaeAudioStreamClip haeAudioStreamClip = new HaeAudioStreamClip(audioClipData, inputStream.toString());
            AudioContainerInputStream audioContainerInputStream = audioClipData.getAudioContainer();
            J3DHaeStream.soundContainers.setElementAt(audioContainerInputStream, n);
            J3DHaeStream.soundSamples.setSize(n + 1);
            J3DHaeStream.soundSamples.setElementAt(haeAudioStreamClip, n);
        }
        catch (Exception exception) {
            J3DHaeStream.soundUrls.removeElementAt(n);
            J3DHaeStream.soundParams.removeElementAt(n);
            J3DHaeStream.soundStreams.removeElementAt(n);
            J3DHaeStream.soundContainers.removeElementAt(n);
            J3DHaeStream.soundSamples.removeElementAt(n);
            return -1;
        }
        return 0;
    }

    public static int loadSample(URL uRL, int n) {
        try {
            AudioClipData audioClipData = new AudioClipData(uRL, true);
            HaeAudioStreamClip haeAudioStreamClip = new HaeAudioStreamClip(audioClipData, uRL.toString());
            AudioContainerInputStream audioContainerInputStream = audioClipData.getAudioContainer();
            J3DHaeStream.soundContainers.setElementAt(audioContainerInputStream, n);
            J3DHaeStream.soundSamples.setSize(n + 1);
            J3DHaeStream.soundSamples.setElementAt(haeAudioStreamClip, n);
        }
        catch (Exception exception) {
            J3DHaeStream.soundUrls.removeElementAt(n);
            J3DHaeStream.soundStreams.removeElementAt(n);
            J3DHaeStream.soundParams.removeElementAt(n);
            J3DHaeStream.soundContainers.removeElementAt(n);
            J3DHaeStream.soundSamples.removeElementAt(n);
            return -1;
        }
        return 0;
    }

    public static long getSampleDuration(int n) {
        if (J3DHaeStream.soundSamples.size() <= n) {
            return -1L;
        }
        AudioContainerInputStream audioContainerInputStream = (AudioContainerInputStream)J3DHaeStream.soundContainers.elementAt(n);
        if (audioContainerInputStream == null) {
            return -1L;
        }
        double d = audioContainerInputStream.getTotalBytes();
        Format[] formatArray = audioContainerInputStream.getFormat();
        AudioFormat audioFormat = (AudioFormat)formatArray[0];
        int n2 = audioFormat.getSampleRate();
        double d2 = audioFormat.getSampleSize();
        double d3 = audioFormat.getChannels();
        String string = audioFormat.getEncoding();
        long l = (long)(d / (d2 * d3 * (double)n2) * 1000.0);
        return l;
    }

    static int calcFrameOffset(JavaSoundParams javaSoundParams, AudioContainerInputStream audioContainerInputStream, long l, float f) {
        int n = 0;
        int n2 = 0;
        if (javaSoundParams.startTime > 0L) {
            n = (int)((float)(l - javaSoundParams.startTime) * f + 0.5f);
            n2 = audioContainerInputStream.getTotalFrames();
            n = n2 > 0 && n > 0 ? (n %= n2) : 0;
        }
        return n;
    }

    static int calcRemainingLoops(int n, JavaSoundParams javaSoundParams, AudioContainerInputStream audioContainerInputStream, long l, float f) {
        if (n > 0) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (javaSoundParams.startTime > 0L) {
                n2 = (int)((float)(l - javaSoundParams.startTime) * f + 0.5f);
                n5 = audioContainerInputStream.getTotalFrames();
                n4 = n5 > 0 && n2 > 0 ? n2 / n5 : 0;
            }
            if ((n3 = n - n4) > 0) {
                return n3;
            }
            return 0;
        }
        return 0;
    }

    public static int startSamples(int n, int n2, int n3, float f, float f2, int n4, int n5) {
        boolean bl;
        double d = 0.0039;
        HaeAudioStreamClip haeAudioStreamClip = null;
        HaeAudioStreamClip haeAudioStreamClip2 = null;
        double d2 = f;
        double d3 = f2;
        if (n < 0 || n2 < 0) {
            return -1;
        }
        if (J3DHaeStream.soundSamples.size() <= n) {
            return -1;
        }
        if (J3DHaeStream.soundSamples.size() <= n2) {
            return -1;
        }
        haeAudioStreamClip = (HaeAudioStreamClip)J3DHaeStream.soundSamples.elementAt(n);
        if (haeAudioStreamClip == null) {
            return -1;
        }
        haeAudioStreamClip2 = (HaeAudioStreamClip)J3DHaeStream.soundSamples.elementAt(n2);
        if (haeAudioStreamClip2 == null) {
            return -1;
        }
        AudioContainerInputStream audioContainerInputStream = (AudioContainerInputStream)J3DHaeStream.soundContainers.elementAt(n);
        if (audioContainerInputStream == null) {
            return -1;
        }
        Format[] formatArray = audioContainerInputStream.getFormat();
        AudioFormat audioFormat = (AudioFormat)formatArray[0];
        int n6 = audioFormat.getSampleRate();
        float f3 = (float)n6 / 1000.0f;
        JavaSoundParams javaSoundParams = (JavaSoundParams)J3DHaeStream.soundParams.elementAt(n);
        JavaSoundParams javaSoundParams2 = (JavaSoundParams)J3DHaeStream.soundParams.elementAt(n2);
        if (J3DHaeStream.soundParams.size() <= n) {
            return -1;
        }
        boolean bl2 = bl = false;
        int n7 = 0;
        int n8 = 0;
        n7 = 0;
        n8 = audioContainerInputStream.getTotalFrames();
        try {
            if (n3 > 0) {
                haeAudioStreamClip.setLoop(n7, n8, n3);
                haeAudioStreamClip2.setLoop(n7, n8, n3);
            } else {
                haeAudioStreamClip.setLoop(n7, n8, 0);
                haeAudioStreamClip2.setLoop(n7, n8, 0);
            }
            if (javaSoundParams.startTime == 0L) {
                if (n4 < 0 || n5 < 0) {
                    haeAudioStreamClip.clipData.seek(0);
                    haeAudioStreamClip2.clipData.seek(0);
                    haeAudioStreamClip.start(d2, J3DHaeStream.panLeft, bl);
                    haeAudioStreamClip2.start(d3, J3DHaeStream.panRight, bl2);
                } else if (n4 < n5) {
                    haeAudioStreamClip.clipData.seek(0);
                    haeAudioStreamClip2.clipData.seek(n5 - n4);
                    haeAudioStreamClip.start(d2, J3DHaeStream.panLeft, bl);
                    haeAudioStreamClip2.start(d3, J3DHaeStream.panRight, bl2);
                } else {
                    haeAudioStreamClip2.clipData.seek(0);
                    haeAudioStreamClip.clipData.seek(n4 - n5);
                    haeAudioStreamClip2.start(d3, J3DHaeStream.panRight, bl2);
                    haeAudioStreamClip.start(d2, J3DHaeStream.panLeft, bl);
                }
                javaSoundParams.startTime = System.currentTimeMillis();
            } else {
                long l = System.currentTimeMillis();
                int n9 = J3DHaeClip.calcFrameOffset(javaSoundParams, audioContainerInputStream, l, f3);
                if (n8 > 0) {
                    int n10 = J3DHaeClip.calcRemainingLoops(n3, javaSoundParams, audioContainerInputStream, l, f3);
                    haeAudioStreamClip.setLoop(n7, n8, n10);
                    haeAudioStreamClip2.setLoop(n7, n8, n10);
                }
                if (n4 < 0 || n5 < 0) {
                    haeAudioStreamClip.clipData.seek(n9);
                    haeAudioStreamClip2.clipData.seek(n9);
                    haeAudioStreamClip.start(d2, J3DHaeStream.panLeft, bl);
                    haeAudioStreamClip2.start(d3, J3DHaeStream.panRight, bl2);
                } else if (n4 < n5) {
                    haeAudioStreamClip.clipData.seek(n9);
                    haeAudioStreamClip2.clipData.seek(n5 - n4 + n9);
                    haeAudioStreamClip.start(d2, J3DHaeStream.panLeft, bl);
                    haeAudioStreamClip2.start(d3, J3DHaeStream.panRight, bl2);
                } else {
                    haeAudioStreamClip2.clipData.seek(n9);
                    haeAudioStreamClip.clipData.seek(n4 - n5 + n9);
                    haeAudioStreamClip2.start(d3, J3DHaeStream.panRight, bl2);
                    haeAudioStreamClip.start(d2, J3DHaeStream.panLeft, bl);
                }
            }
        }
        catch (Exception exception) {
            javaSoundParams.startTime = 0L;
            return -1;
        }
        return 0;
    }

    public static int startSample(int n, int n2, float f) {
        double d = 0.0039;
        double d2 = f;
        if (n < 0) {
            return -1;
        }
        if (J3DHaeStream.soundSamples.size() <= n) {
            return -1;
        }
        HaeAudioStreamClip haeAudioStreamClip = (HaeAudioStreamClip)J3DHaeStream.soundSamples.elementAt(n);
        if (haeAudioStreamClip == null) {
            return -1;
        }
        AudioContainerInputStream audioContainerInputStream = (AudioContainerInputStream)J3DHaeStream.soundContainers.elementAt(n);
        if (audioContainerInputStream == null) {
            return -1;
        }
        Format[] formatArray = audioContainerInputStream.getFormat();
        AudioFormat audioFormat = (AudioFormat)formatArray[0];
        int n3 = audioFormat.getSampleRate();
        float f2 = (float)n3 / 1000.0f;
        float f3 = 0.0f;
        JavaSoundParams javaSoundParams = (JavaSoundParams)J3DHaeStream.soundParams.elementAt(n);
        if (J3DHaeStream.soundParams.size() <= n) {
            return -1;
        }
        boolean bl = javaSoundParams.getReverbFlag();
        try {
            int n4 = 0;
            int n5 = 0;
            n4 = 0;
            n5 = audioContainerInputStream.getTotalFrames();
            if (n2 > 0) {
                haeAudioStreamClip.setLoop(n4, n5, n2);
            } else {
                haeAudioStreamClip.setLoop(n4, n5, 0);
            }
            if (javaSoundParams.startTime == 0L) {
                haeAudioStreamClip.clipData.seek(0);
                haeAudioStreamClip.start(d2, f3, bl);
                javaSoundParams.startTime = System.currentTimeMillis();
            } else {
                long l = System.currentTimeMillis();
                int n6 = J3DHaeClip.calcFrameOffset(javaSoundParams, audioContainerInputStream, l, f2);
                if (n5 > 0) {
                    int n7 = J3DHaeClip.calcRemainingLoops(n2, javaSoundParams, audioContainerInputStream, l, f2);
                    haeAudioStreamClip.setLoop(n4, n5, n7);
                }
                haeAudioStreamClip.clipData.seek(n6);
                haeAudioStreamClip.start(d2, f3, bl);
            }
        }
        catch (Exception exception) {
            javaSoundParams.startTime = 0L;
            return -1;
        }
        return 0;
    }

    public static int stopSample(int n) {
        HaeAudioStreamClip haeAudioStreamClip = null;
        if (n < 0) {
            return -1;
        }
        if (J3DHaeStream.soundSamples.size() <= n) {
            return -1;
        }
        haeAudioStreamClip = (HaeAudioStreamClip)J3DHaeStream.soundSamples.elementAt(n);
        if (haeAudioStreamClip == null) {
            return -1;
        }
        JavaSoundParams javaSoundParams = (JavaSoundParams)J3DHaeStream.soundParams.elementAt(n);
        try {
            AudioContainerInputStream audioContainerInputStream = (AudioContainerInputStream)J3DHaeStream.soundContainers.elementAt(n);
            haeAudioStreamClip.setLoop(0, audioContainerInputStream.getTotalFrames(), 0);
            haeAudioStreamClip.stop(false);
            haeAudioStreamClip.flush();
        }
        catch (Exception exception) {
            javaSoundParams.startTime = 0L;
            return -1;
        }
        javaSoundParams.startTime = 0L;
        return 0;
    }

    public static int stopSamples(int n, int n2) {
        HaeAudioStreamClip haeAudioStreamClip = null;
        HaeAudioStreamClip haeAudioStreamClip2 = null;
        if (n < 0 || n2 < 0) {
            return -1;
        }
        if (J3DHaeStream.soundSamples.size() <= n) {
            return -1;
        }
        if (J3DHaeStream.soundSamples.size() <= n2) {
            return -1;
        }
        haeAudioStreamClip = (HaeAudioStreamClip)J3DHaeStream.soundSamples.elementAt(n);
        if (haeAudioStreamClip == null) {
            return -1;
        }
        haeAudioStreamClip2 = (HaeAudioStreamClip)J3DHaeStream.soundSamples.elementAt(n2);
        if (haeAudioStreamClip2 == null) {
            return -1;
        }
        AudioContainerInputStream audioContainerInputStream = (AudioContainerInputStream)J3DHaeStream.soundContainers.elementAt(n);
        JavaSoundParams javaSoundParams = (JavaSoundParams)J3DHaeStream.soundParams.elementAt(n);
        JavaSoundParams javaSoundParams2 = (JavaSoundParams)J3DHaeStream.soundParams.elementAt(n2);
        try {
            if (haeAudioStreamClip.isPlaying()) {
                haeAudioStreamClip.setLoop(0, audioContainerInputStream.getTotalFrames(), 0);
                haeAudioStreamClip.stop(false);
                haeAudioStreamClip.flush();
            }
            if (haeAudioStreamClip2.isPlaying()) {
                haeAudioStreamClip2.setLoop(0, audioContainerInputStream.getTotalFrames(), 0);
                haeAudioStreamClip2.stop(false);
                haeAudioStreamClip2.flush();
            }
        }
        catch (Exception exception) {
            javaSoundParams.startTime = 0L;
            javaSoundParams2.startTime = 0L;
            return -1;
        }
        javaSoundParams.startTime = 0L;
        javaSoundParams2.startTime = 0L;
        return 0;
    }

    public static void setSampleGain(int n, float f) {
        HaeAudioStreamClip haeAudioStreamClip = null;
        if (n < 0) {
            return;
        }
        if (J3DHaeStream.soundSamples.size() <= n) {
            return;
        }
        haeAudioStreamClip = (HaeAudioStreamClip)J3DHaeStream.soundSamples.elementAt(n);
        if (haeAudioStreamClip == null) {
            return;
        }
        double d = f;
        haeAudioStreamClip.setVolume(d);
    }

    public static void setSampleDelay(int n, int n2) {
    }

    public static void setReverb(int n, int n2, boolean bl) {
        boolean bl2 = false;
        JavaSoundParams javaSoundParams = (JavaSoundParams)J3DHaeStream.soundParams.elementAt(n);
        HaeAudioStreamClip haeAudioStreamClip = (HaeAudioStreamClip)J3DHaeStream.soundSamples.elementAt(n);
        if (javaSoundParams.getReverbType() != n2) {
            try {
                J3DHaeStream.mixer.setReverbType(n2 + 1);
            }
            catch (Exception exception) {
                return;
            }
            javaSoundParams.setReverbType(n2);
            bl2 = true;
        }
        if (bl2 || javaSoundParams.getReverbFlag() != bl) {
            try {
                haeAudioStreamClip.setReverb(bl);
            }
            catch (Exception exception) {
                return;
            }
            javaSoundParams.setReverbFlag(bl);
        }
    }

    public static void scaleSampleRate(int n, float f) {
        HaeAudioStreamClip haeAudioStreamClip = (HaeAudioStreamClip)J3DHaeStream.soundSamples.elementAt(n);
        if (haeAudioStreamClip == null) {
            return;
        }
        AudioContainerInputStream audioContainerInputStream = (AudioContainerInputStream)J3DHaeStream.soundContainers.elementAt(n);
        if (audioContainerInputStream == null) {
            return;
        }
        Format[] formatArray = audioContainerInputStream.getFormat();
        AudioFormat audioFormat = (AudioFormat)formatArray[0];
        int n2 = audioFormat.getSampleRate();
        haeAudioStreamClip.setSampleRate((float)n2 * f);
    }

    public static int pauseSamples(int n, int n2) {
        HaeAudioStreamClip haeAudioStreamClip = (HaeAudioStreamClip)J3DHaeStream.soundSamples.elementAt(n);
        HaeAudioStreamClip haeAudioStreamClip2 = (HaeAudioStreamClip)J3DHaeStream.soundSamples.elementAt(n2);
        if (haeAudioStreamClip == null) {
            return -1;
        }
        if (haeAudioStreamClip2 == null) {
            return -1;
        }
        haeAudioStreamClip.pause();
        haeAudioStreamClip2.pause();
        return 0;
    }

    public static int pauseSample(int n) {
        HaeAudioStreamClip haeAudioStreamClip = (HaeAudioStreamClip)J3DHaeStream.soundSamples.elementAt(n);
        if (haeAudioStreamClip == null) {
            return -1;
        }
        haeAudioStreamClip.pause();
        return 0;
    }

    public static int unpauseSamples(int n, int n2) {
        HaeAudioStreamClip haeAudioStreamClip = (HaeAudioStreamClip)J3DHaeStream.soundSamples.elementAt(n);
        HaeAudioStreamClip haeAudioStreamClip2 = (HaeAudioStreamClip)J3DHaeStream.soundSamples.elementAt(n2);
        if (haeAudioStreamClip == null) {
            return -1;
        }
        if (haeAudioStreamClip2 == null) {
            return -1;
        }
        haeAudioStreamClip.resume();
        haeAudioStreamClip2.resume();
        return 0;
    }

    public static int unpauseSample(int n) {
        HaeAudioStreamClip haeAudioStreamClip = (HaeAudioStreamClip)J3DHaeStream.soundSamples.elementAt(n);
        if (haeAudioStreamClip == null) {
            return -1;
        }
        haeAudioStreamClip.resume();
        return 0;
    }
}

