/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audio;

import com.sun.j3d.audio.HaeException;
import com.sun.j3d.audio.HaeMixer;
import com.sun.j3d.audio.HaeNoise;
import com.sun.j3d.audio.HaePlayable;

abstract class HaeWaveNoise
extends HaeNoise
implements HaePlayable {
    protected double m_sampleRate = 0.0;
    protected boolean m_useReverb = false;
    protected int m_id = 0;
    private int m_bitsPerSample = 0;
    private int m_channelsPerFrame = 0;
    private int m_bytesPerFrame = 0;
    private boolean m_isPaused = false;

    public void play() throws HaeException {
        if (!this.isPlaying()) {
            this.start();
        }
        while (this.isPlaying()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void start() throws HaeException {
        this.start(1.0, 0.0, true);
    }

    public void start(double d, double d2, boolean bl) throws HaeException {
        this.m_isPaused = false;
        this.m_useReverb = bl;
        this.privateStart(d, d2, bl);
    }

    public void pause() {
        this.m_isPaused = true;
        this.privateSetSampleRate(0.0);
    }

    public void resume() {
        this.m_isPaused = false;
        this.privateSetSampleRate(this.m_sampleRate);
    }

    public void setSampleRate(double d) {
        this.m_sampleRate = d;
        this.privateSetSampleRate(this.m_isPaused ? 0.0 : this.m_sampleRate);
    }

    public abstract void setVolume(double var1);

    public abstract void setPan(double var1);

    public void setReverb(boolean bl) {
        this.m_useReverb = bl;
        this.privateSetReverb(bl);
    }

    public static void prepareMonoSd8Data(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            byArray[n3] = (byte)(byArray[n3] + 128);
        }
    }

    public static void prepareMonoSd16Data(byte[] byArray, int n) {
        n *= 2;
        int n2 = 0;
        while (n2 < n) {
            byte by = byArray[n2];
            byArray[n2] = byArray[n2 + 1];
            byArray[n2 + 1] = by;
            n2 += 2;
        }
    }

    public abstract boolean isPlaying();

    public boolean isPaused() {
        return this.m_isPaused;
    }

    public double getSampleRate() {
        return this.m_sampleRate;
    }

    public int getBitsPerSample() {
        return this.m_bitsPerSample;
    }

    public int getChannelsPerFrame() {
        return this.m_channelsPerFrame;
    }

    public int getBytesPerFrame() {
        return this.m_bytesPerFrame;
    }

    public abstract double getVolume();

    public abstract double getPan();

    public boolean getReverb() {
        return this.m_useReverb;
    }

    protected HaeWaveNoise(HaeMixer haeMixer) {
        super(haeMixer);
    }

    protected void setSampleInfo(double d, int n, int n2) {
        this.m_sampleRate = d;
        this.m_bitsPerSample = n;
        this.m_channelsPerFrame = n2;
        this.m_bytesPerFrame = (n + 7) / 8 * n2;
    }

    protected abstract void privateStart(double var1, double var3, boolean var5) throws HaeException;

    protected abstract void privateSetSampleRate(double var1);

    protected abstract void privateSetReverb(boolean var1);

    public abstract void stop(boolean var1);
}

