/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audio;

import com.sun.j3d.audio.AudioEnvironment;
import com.sun.j3d.audio.AudioFormat;
import com.sun.j3d.audio.AudioSecurity;
import com.sun.j3d.audio.AudioSecurityAction;
import com.sun.j3d.audio.AudioSecurityActionException;
import com.sun.j3d.audio.AudioSecurityExceptionAction;
import com.sun.j3d.audio.HaeException;
import java.io.File;
import java.util.StringTokenizer;

class HaeMixer {
    public static final int MAX_VOICES = 32;
    public static final int SAMPLE_RATE_11K = 11;
    public static final int SAMPLE_RATE_22K = 22;
    public static final int SAMPLE_RATE_44K = 44;
    public static final int INTERPOLATION_DROP_SAMPLE = 0;
    public static final int INTERPOLATION_2_POINT = 1;
    public static final int INTERPOLATION_LINEAR = 2;
    public static final int FLAGS_NONE = 0;
    public static final int FLAGS_USE_16 = 1;
    public static final int FLAGS_USE_STEREO = 2;
    public static final int FLAGS_ENABLE_REVERB = 4;
    public static final int FLAGS_STEREO_FILTER = 8;
    public static final int REVERB_NONE = 1;
    public static final int REVERB_TYPE_1 = 1;
    public static final int REVERB_TYPE_2 = 2;
    public static final int REVERB_TYPE_3 = 3;
    public static final int REVERB_TYPE_4 = 4;
    public static final int REVERB_TYPE_5 = 5;
    public static final int REVERB_TYPE_6 = 6;
    public static final int REVERB_TYPE_7 = 7;
    public static final int REVERB_TYPE_8 = 8;
    private int m_streamCount;
    private int m_quality;
    private int m_interpolation;
    private int m_reverbType;
    private int m_modifiers;
    private int m_midiVoiceCount;
    private int m_soundVoiceCount;
    private int m_volumeDivisor;
    private static boolean m_gmIsOpen;
    private static boolean m_bigEndian;
    private static String soundbankPath;
    private static String defaultSoundbank;

    public HaeMixer(String string) throws HaeException {
        this.construct();
        this.setHardwareEndianism();
        if (!this.smartSetSoundbank(string)) {
            throw new HaeException("Invalid sound bank: " + string);
        }
    }

    public HaeMixer() throws HaeException {
        this.construct();
        this.setHardwareEndianism();
        if (!this.smartSetSoundbank(null)) {
            System.out.println("Sound bank not set.");
        }
    }

    public void construct() throws HaeException {
        if (m_gmIsOpen) {
            throw new HaeException("only one HaeMixer{} allowed");
        }
        this.m_streamCount = 0;
        this.m_quality = 22;
        this.m_interpolation = 2;
        this.m_modifiers = 7;
        this.m_reverbType = 4;
        this.m_midiVoiceCount = 32;
        this.m_soundVoiceCount = 32;
        this.m_volumeDivisor = 6;
        this.open();
        m_gmIsOpen = true;
        if (AudioEnvironment.trace) {
            System.err.println("Mixer construted.");
        }
    }

    private void setHardwareEndianism() {
        String string = null;
        string = (String)AudioSecurity.doPrivileged(new AudioSecurityAction(){

            public Object run() {
                String string = System.getProperty("os.arch");
                return string;
            }
        }, "UniversalPropertyRead");
        if (string != null) {
            m_bigEndian = string.equals("x86") ? false : string.equals("sparc");
        }
        if (AudioEnvironment.trace) {
            System.err.println("Rendering to a " + (m_bigEndian ? "big endian" : "little endian") + " machine.");
        }
    }

    public void finalize() {
        if (this.m_streamCount != 0) {
            System.err.println("Mixer finalizing, non-zero stream_count: " + this.m_streamCount);
        }
        this.close();
        m_gmIsOpen = false;
    }

    private boolean smartSetSoundbank(String string) {
        boolean bl;
        block21: {
            bl = false;
            try {
                String string2;
                String string3 = null;
                string3 = string;
                if (string3 == null) {
                    string3 = (String)AudioSecurity.doPrivileged(new AudioSecurityAction(){

                        public Object run() {
                            String string = System.getProperty("java.soundpath");
                            return string;
                        }
                    }, "UniversalPropertyRead");
                }
                if (string3 == null) {
                    string3 = defaultSoundbank;
                }
                try {
                    this.setSoundbank(string3);
                    soundbankPath = string3;
                    bl = true;
                }
                catch (HaeException haeException) {
                    // empty catch block
                }
                String string4 = null;
                String string5 = null;
                if (!bl) {
                    string5 = (String)AudioSecurity.doPrivileged(new AudioSecurityAction(){

                        public Object run() {
                            String string = System.getProperty("java.home");
                            return string;
                        }
                    }, "UniversalPropertyRead");
                    string5 = string5 + File.separatorChar + "lib" + File.separatorChar + "audio";
                    string2 = string5 + File.separatorChar + string3;
                    try {
                        this.setSoundbank(string2);
                        soundbankPath = string2;
                        bl = true;
                    }
                    catch (HaeException haeException) {
                        // empty catch block
                    }
                }
                if (bl) break block21;
                string4 = (String)AudioSecurity.doPrivileged(new AudioSecurityAction(){

                    public Object run() {
                        String string = System.getProperty("java.class.path");
                        return string;
                    }
                }, "UniversalPropertyRead");
                StringTokenizer stringTokenizer = new StringTokenizer(string4, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens() && !bl) {
                    string5 = stringTokenizer.nextToken();
                    try {
                        string2 = string5 + File.separatorChar + string3;
                        this.setSoundbank(string2);
                        soundbankPath = string2;
                        bl = true;
                    }
                    catch (HaeException haeException) {
                        if (string5.endsWith("lib")) {
                            try {
                                string2 = string5 + File.separatorChar + "audio" + File.separatorChar + string3;
                                this.setSoundbank(string2);
                                soundbankPath = string2;
                                bl = true;
                            }
                            catch (HaeException haeException2) {
                                // empty catch block
                            }
                        }
                        if (bl || string5.lastIndexOf(File.separatorChar) == -1) continue;
                        try {
                            string5 = string5.substring(0, string5.lastIndexOf(File.separatorChar));
                            try {
                                string2 = string5 + File.separatorChar + string3;
                                this.setSoundbank(string2);
                                soundbankPath = string2;
                                bl = true;
                            }
                            catch (HaeException haeException3) {
                                if (!string5.endsWith("lib")) continue;
                                try {
                                    string2 = string5 + File.separatorChar + "audio" + File.separatorChar + string3;
                                    this.setSoundbank(string2);
                                    soundbankPath = string2;
                                    bl = true;
                                }
                                catch (HaeException haeException4) {}
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public AudioFormat getOutputFormat() {
        int n;
        switch (this.m_quality) {
            case 11: {
                n = 11025;
                break;
            }
            case 22: {
                n = 22050;
                break;
            }
            case 44: {
                n = 44100;
                break;
            }
            default: {
                n = 22050;
            }
        }
        String string = "JAUDIO_LINEAR";
        int n2 = (this.m_modifiers & 1) > 0 ? 16 : 8;
        int n3 = (this.m_modifiers & 2) > 0 ? 2 : 1;
        int n4 = n2 * n3;
        boolean bl = m_bigEndian;
        boolean bl2 = true;
        return new AudioFormat(n, string, n2, n4, n3, bl, bl2);
    }

    public void setOutputFormat(AudioFormat audioFormat) throws HaeException {
        int n;
        int n2 = this.getInterpolation();
        switch (audioFormat.getSampleRate()) {
            case 11025: {
                n = 11;
                break;
            }
            case 22050: {
                n = 22;
                break;
            }
            case 44100: {
                n = 44;
                break;
            }
            default: {
                n = 22;
            }
        }
        int n3 = 0;
        if (audioFormat.getSampleSize() == 16) {
            ++n3;
        }
        if (audioFormat.getChannels() == 2) {
            n3 += 2;
        }
        this.setAudioModes(n, n2, n3);
    }

    public void reengageAudio() throws HaeException {
        try {
            AudioSecurity.doPrivileged(new AudioSecurityExceptionAction(){

                public Object run() throws HaeException {
                    HaeMixer.this.reengageAudio0();
                    return null;
                }
            });
        }
        catch (AudioSecurityActionException audioSecurityActionException) {
            throw new HaeException(audioSecurityActionException.getException().getMessage());
        }
        if (AudioEnvironment.trace) {
            System.err.println("Engine Engaged.");
        }
    }

    public native void setSoundbank(String var1) throws HaeException;

    public native void setAudioModes(int var1, int var2, int var3) throws HaeException;

    public native void setReverbType(int var1) throws HaeException;

    public native void setVoiceCounts(int var1, int var2, int var3) throws HaeException;

    public native void setMasterVolume(double var1);

    public native void close();

    public synchronized native void disengageAudio();

    public synchronized native void reengageAudio0() throws HaeException;

    public int getQuality() {
        return this.m_quality;
    }

    public int getInterpolation() {
        return this.m_interpolation;
    }

    public int getModifiers() {
        return this.m_modifiers;
    }

    public int getReverbType() {
        return this.m_reverbType;
    }

    public int getMidiVoiceCount() {
        return this.m_midiVoiceCount;
    }

    public int getSoundVoiceCount() {
        return this.m_soundVoiceCount;
    }

    public int getVolumeDivisor() {
        return this.m_volumeDivisor;
    }

    public boolean isBigEndian() {
        return m_bigEndian;
    }

    public native double getMasterVolume();

    public native double getTick();

    public native long getSamplesPlayed();

    public native int getAudioLatency();

    private native void open() throws HaeException;

    static {
        if (AudioEnvironment.trace) {
            System.err.println("Java Sound Engine Version: internal_build");
            System.err.println("Using library: j3daudio");
        }
        AudioSecurity.doPrivileged(new AudioSecurityAction(){

            public Object run() {
                System.loadLibrary("j3daudio");
                return null;
            }
        }, "UniversalLinkAccess");
        m_gmIsOpen = false;
        m_bigEndian = false;
        soundbankPath = null;
        defaultSoundbank = "soundbank.gm";
    }
}

