/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audio;

import com.sun.j3d.audio.AudioContainerInputStream;
import com.sun.j3d.audio.AudioFormat;
import com.sun.j3d.audio.Format;
import com.sun.j3d.audio.HaeDevice;
import com.sun.j3d.audio.HaeException;
import com.sun.j3d.audio.HaeWaveStream;
import com.sun.j3d.audio.HaeWaveStreamBuffer;
import com.sun.j3d.audio.InvalidAudioFormatException;
import java.io.PrintStream;

class HaeAudioStream
extends HaeWaveStream {
    String streamName;
    AudioContainerInputStream inputStream;
    AudioFormat inputStreamFormat;
    AudioFormat outputStreamFormat;
    boolean processBytes = false;
    boolean swapBytes = false;
    boolean convertFromUlaw = false;
    boolean convertUnsigned = false;
    int transfer;
    boolean verbose = false;
    protected final PrintStream trace = System.err;

    public HaeAudioStream(AudioContainerInputStream audioContainerInputStream, String string) throws HaeException, InvalidAudioFormatException {
        super(HaeDevice.getSystemMixer());
        this.inputStream = audioContainerInputStream;
        this.streamName = string;
        this.outputStreamFormat = audioContainerInputStream.getOutputFormat();
        Format[] formatArray = audioContainerInputStream.getFormat();
        if (formatArray.length == 0) {
            throw new InvalidAudioFormatException("Can't find a format on the input stream");
        }
        this.inputStreamFormat = (AudioFormat)formatArray[0];
        if (this.inputStreamFormat == null) {
            throw new InvalidAudioFormatException("Can't find a format on the input stream");
        }
        if (this.verbose) {
            this.trace.println("Input stream is formatted: " + this.inputStreamFormat);
        }
        int n = this.inputStreamFormat.getSampleSize();
        String string2 = this.inputStreamFormat.getEncoding();
        int n2 = this.inputStreamFormat.getChannels();
        if (this.inputStreamFormat.isBigEndian() == this.getMixer().isBigEndian()) {
            this.swapBytes = false;
        } else {
            boolean bl = this.swapBytes = n != 1;
        }
        if (!this.inputStreamFormat.isSigned() && string2 == "JAUDIO_LINEAR") {
            this.convertUnsigned = true;
        }
        if (string2.equals("JAUDIO_G711_ULAW")) {
            if (n2 != 1) {
                throw new InvalidAudioFormatException("Stereo ulaw");
            }
            this.convertFromUlaw = true;
            n = 2;
        } else {
            this.convertFromUlaw = false;
        }
        if (this.swapBytes || this.convertUnsigned || this.convertFromUlaw) {
            this.processBytes = true;
        }
    }

    void open() throws HaeException {
        int n = this.inputStreamFormat.getSampleRate();
        int n2 = this.inputStreamFormat.getSampleSize();
        int n3 = this.inputStreamFormat.getChannels();
        String string = this.inputStreamFormat.getEncoding();
        int n4 = this.outputStreamFormat.getSampleRate();
        int n5 = this.outputStreamFormat.getSampleSize();
        int n6 = this.outputStreamFormat.getChannels();
        int n7 = n5 * n6;
        if (this.verbose) {
            this.trace.println("HaeAudioStream: Opening up a: " + n3 + " channel, " + n2 * 8 + " bit, " + n + " stream.  The output to the engine will be: " + n6 + " channel, " + n5 * 8 + " bit, " + n4 + " stream.");
        }
        this.open(this.getTransferSize(), n5 * 8, n6, n4);
    }

    public void start(double d, double d2, boolean bl) throws HaeException {
        this.close();
        this.m_samplesSubmitted = 0L;
        this.m_done = false;
        this.open();
        super.start(d, d2, bl);
    }

    protected boolean getWavedata(HaeWaveStreamBuffer haeWaveStreamBuffer, int n) {
        boolean bl = false;
        try {
            int n2 = n;
            int n3 = 0;
            if (this.inputStream.getTotalFrames() != 0) {
                int n4 = this.inputStream.getTotalFrames() - (int)this.m_samplesSubmitted;
                n2 = Math.min(n, n4);
            }
            byte[] byArray = haeWaveStreamBuffer.allocateByte(n2);
            n3 = this.inputStream.getConvertedData(byArray, n2);
            if (this.inputStream.streamIsFinished()) {
                this.processEndOfMedia();
                bl = true;
            }
            haeWaveStreamBuffer.reduceFrameCount(n3);
            this.m_samplesSubmitted += (long)n3;
            if (this.inputStream.getTotalFrames() > 0 && this.m_samplesSubmitted >= (long)this.inputStream.getTotalFrames()) {
                this.processEndOfMedia();
                bl = true;
            }
        }
        catch (Exception exception) {
            System.err.println(this.getClass().getName() + "(" + this.getStreamName() + ") Exception during getWavedata callback. " + exception);
        }
        catch (Error error) {
            System.err.println(this.getClass().getName() + "(" + this.getStreamName() + ") Error during getWavedata callback. " + error);
        }
        if (this.verbose) {
            this.trace.println("getWavedata returning: " + !bl);
        }
        return !bl;
    }

    protected void processEndOfMedia() {
        if (this.verbose) {
            this.trace.println("AudioStream (verbose)" + this.getStreamName() + " EOM");
        }
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public String getStreamName() {
        return this.streamName;
    }
}

