/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audio;

import com.sun.j3d.audio.AudioDevice;
import com.sun.j3d.audio.AudioSecurity;
import com.sun.j3d.audio.AudioSecurityAction;
import java.io.InputStream;

public class AudioPlayer
extends Thread {
    private AudioDevice devAudio = AudioDevice.device;
    public static final AudioPlayer player = AudioPlayer.getAudioPlayer();

    private static ThreadGroup getAudioThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null && threadGroup.getParent().getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    private static AudioPlayer getAudioPlayer() {
        return (AudioPlayer)AudioSecurity.doPrivileged(new AudioSecurityAction(){

            public Object run() {
                return new AudioPlayer();
            }
        }, "UniversalThreadGroupAccess");
    }

    private AudioPlayer() {
        super(AudioPlayer.getAudioThreadGroup(), "Audio Player");
        try {
            AudioSecurity.doPrivileged(new AudioSecurityAction(){

                public Object run() {
                    AudioPlayer.this.setPriority(10);
                    AudioPlayer.this.setDaemon(true);
                    return null;
                }
            }, "UniversalThreadAccess");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.devAudio.open();
        this.start();
    }

    public synchronized void start(InputStream inputStream) {
        this.devAudio.openChannel(inputStream);
        this.notify();
    }

    public synchronized void stop(InputStream inputStream) {
        this.devAudio.closeChannel(inputStream);
    }

    public void run() {
        this.devAudio.play();
        System.out.println("AudioPlayer exited; audio device may not be accessible.");
    }
}

