/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import ucar.multiarray.MultiArrayInfo;
import ucar.netcdf.Attribute;
import ucar.netcdf.AttributeDictionary;
import ucar.netcdf.AttributeIterator;
import ucar.netcdf.AttributeSet;
import ucar.netcdf.Dimension;
import ucar.netcdf.DimensionDictionary;
import ucar.netcdf.DimensionIterator;
import ucar.netcdf.Named;
import ucar.netcdf.UnlimitedDimension;
import ucar.netcdf.Variable;

public class ProtoVariable
implements Named,
MultiArrayInfo,
Serializable,
Cloneable {
    private String name;
    private Class componentType;
    private Dimension[] dimArray;
    private AttributeDictionary attributes;

    static final boolean checkComponentType(Class componentType) {
        return componentType.isPrimitive() && !componentType.equals(Long.TYPE) && !componentType.equals(Boolean.TYPE);
    }

    public ProtoVariable(String name, Class componentType, Dimension[] dimArray) {
        this.name = name;
        if (!ProtoVariable.checkComponentType(componentType)) {
            throw new IllegalArgumentException("Invalid Type");
        }
        this.componentType = componentType;
        if (dimArray == null) {
            this.dimArray = new Dimension[0];
        } else {
            Dimension[] dimensionArray = dimArray;
            synchronized (dimensionArray) {
                this.dimArray = new Dimension[dimArray.length];
                int ii = 0;
                while (ii < dimArray.length) {
                    Dimension dim = dimArray[ii];
                    if (dim instanceof UnlimitedDimension) {
                        if (ii > 0) {
                            throw new IllegalArgumentException("UnlimitedDimension not is leftmost position");
                        }
                    } else if (dim.getLength() == 0) {
                        throw new IllegalArgumentException("Zero length dimension");
                    }
                    this.dimArray[ii] = dim;
                    ++ii;
                }
            }
        }
        this.attributes = new AttributeDictionary();
    }

    public ProtoVariable(String name, Class componentType, Dimension dimension) {
        this.name = name;
        if (!ProtoVariable.checkComponentType(componentType)) {
            throw new IllegalArgumentException("Invalid Type");
        }
        this.componentType = componentType;
        this.dimArray = new Dimension[1];
        this.dimArray[0] = dimension;
        this.attributes = new AttributeDictionary();
    }

    public ProtoVariable(String name, Class componentType, Dimension[] dimArray, Attribute[] attrArray) {
        this.name = name;
        if (!ProtoVariable.checkComponentType(componentType)) {
            throw new IllegalArgumentException("Invalid Type");
        }
        this.componentType = componentType;
        if (dimArray == null) {
            this.dimArray = new Dimension[0];
        } else {
            Dimension[] dimensionArray = dimArray;
            synchronized (dimensionArray) {
                this.dimArray = new Dimension[dimArray.length];
                int ii = 0;
                while (ii < dimArray.length) {
                    Dimension dim = dimArray[ii];
                    if (dim instanceof UnlimitedDimension) {
                        if (ii > 0) {
                            throw new IllegalArgumentException("UnlimitedDimension not is leftmost position");
                        }
                    } else if (dim.getLength() == 0) {
                        throw new IllegalArgumentException("Zero length dimension");
                    }
                    this.dimArray[ii] = dim;
                    ++ii;
                }
            }
        }
        this.attributes = new AttributeDictionary(attrArray);
    }

    ProtoVariable(ProtoVariable pv) {
        this.name = pv.getName();
        this.componentType = pv.getComponentType();
        pv.copyVolatile(this);
    }

    public ProtoVariable(Variable var) {
        this.name = var.meta.getName();
        this.componentType = var.meta.getComponentType();
        var.meta.copyVolatile(this);
    }

    private synchronized void copyVolatile(ProtoVariable dest) {
        dest.dimArray = new Dimension[this.dimArray.length];
        int ii = 0;
        while (ii < this.dimArray.length) {
            dest.dimArray[ii] = (Dimension)this.dimArray[ii].clone();
            ++ii;
        }
        dest.attributes = new AttributeDictionary(this.attributes);
    }

    public Object clone() {
        try {
            ProtoVariable pv = (ProtoVariable)super.clone();
            this.copyVolatile(pv);
            return pv;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }

    public final String getName() {
        return this.name;
    }

    public final Class getComponentType() {
        return this.componentType;
    }

    public final int getRank() {
        return this.dimArray.length;
    }

    public final int[] getLengths() {
        int[] lengths = new int[this.dimArray.length];
        int ii = 0;
        while (ii < this.dimArray.length) {
            lengths[ii] = this.dimArray[ii].getLength();
            ++ii;
        }
        return lengths;
    }

    public final boolean isUnlimited() {
        return this.dimArray.length > 0 && this.dimArray[0] instanceof UnlimitedDimension;
    }

    public final boolean isScalar() {
        return this.dimArray.length == 0;
    }

    public DimensionIterator getDimensionIterator() {
        return new 1();
    }

    public Attribute getAttribute(String name) {
        return this.attributes.get(name);
    }

    public AttributeSet getAttributes() {
        return this.attributes;
    }

    public Attribute putAttribute(Attribute attr) {
        return this.attributes.put(attr);
    }

    public void toCdl(StringBuffer buf) {
        buf.append(this.getComponentType());
        buf.append(" ");
        buf.append(this.getName());
        buf.append("(");
        DimensionIterator iter = this.getDimensionIterator();
        while (iter.hasNext()) {
            buf.append(iter.next().getName());
            if (!iter.hasNext()) break;
            buf.append(", ");
        }
        buf.append(") ;\n");
        AttributeIterator iter2 = this.getAttributes().iterator();
        while (iter2.hasNext()) {
            buf.append("\t\t");
            buf.append(this.getName());
            iter2.next().toCdl(buf);
            buf.append("\n");
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.toCdl(buf);
        return buf.toString();
    }

    synchronized void connectDims(DimensionDictionary dimensions) {
        int ii = 0;
        while (ii < this.dimArray.length) {
            this.dimArray[ii] = dimensions.put(this.dimArray[ii]);
            ++ii;
        }
    }

    private int encodeComponentType() {
        if (this.componentType.isPrimitive()) {
            if (this.componentType.equals(Byte.TYPE)) {
                return 66;
            }
            if (this.componentType.equals(Character.TYPE)) {
                return 67;
            }
            if (this.componentType.equals(Double.TYPE)) {
                return 68;
            }
            if (this.componentType.equals(Float.TYPE)) {
                return 70;
            }
            if (this.componentType.equals(Integer.TYPE)) {
                return 73;
            }
            if (this.componentType.equals(Long.TYPE)) {
                return 74;
            }
            if (this.componentType.equals(Short.TYPE)) {
                return 83;
            }
            if (this.componentType.equals(Boolean.TYPE)) {
                return 90;
            }
        }
        throw new IllegalArgumentException(this.componentType.toString());
    }

    private static Class decodeComponentType(int typecode) throws InvalidClassException {
        switch (typecode) {
            case 66: {
                return Byte.TYPE;
            }
            case 67: {
                return Character.TYPE;
            }
            case 68: {
                return Double.TYPE;
            }
            case 70: {
                return Float.TYPE;
            }
            case 73: {
                return Integer.TYPE;
            }
            case 74: {
                return Long.TYPE;
            }
            case 83: {
                return Short.TYPE;
            }
            case 90: {
                return Boolean.TYPE;
            }
        }
        throw new InvalidClassException(Integer.toHexString(typecode));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.name);
        out.write(this.encodeComponentType());
        out.writeObject(this.dimArray);
        out.writeObject(this.attributes);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.name = (String)in.readObject();
        int typecode = in.read();
        this.componentType = ProtoVariable.decodeComponentType(typecode);
        this.dimArray = (Dimension[])in.readObject();
        this.attributes = (AttributeDictionary)in.readObject();
    }

    private final class 1
    implements DimensionIterator {
        int position;

        public boolean hasNext() {
            return this.position < ProtoVariable.this.dimArray.length;
        }

        public Dimension next() {
            return ProtoVariable.this.dimArray[this.position++];
        }

        /* synthetic */ 1() {
        }
    }
}

