/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import java.io.File;
import java.io.IOException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.ConnectException;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;
import ucar.netcdf.Entry;
import ucar.netcdf.NetcdfRemoteProxy;
import ucar.netcdf.NetcdfRemoteProxyImpl;
import ucar.netcdf.NetcdfService;

public class NetcdfServer
extends UnicastRemoteObject
implements NetcdfService {
    private Hashtable table = new Hashtable();
    private Registry registry;

    public NetcdfServer(String[] exports, Registry registry) throws RemoteException, AlreadyBoundException {
        int ii = 0;
        while (ii < exports.length) {
            this.export(exports[ii]);
            ++ii;
        }
        if (this.table.size() == 0) {
            throw new IllegalArgumentException("No exports");
        }
        if (registry != null) {
            this.registry = registry;
            registry.bind("NetcdfService", this);
            System.out.println("NetcdfService bound in registry");
        }
    }

    public int ping() throws RemoteException {
        return 0;
    }

    public NetcdfRemoteProxy lookup(String dataSetName) throws IOException, RemoteException {
        if (!this.table.containsKey(dataSetName)) {
            throw new AccessException(String.valueOf(dataSetName) + " not available");
        }
        return new NetcdfRemoteProxyImpl(this.get(dataSetName).getNetcdfFile());
    }

    public String[] list() throws IOException, RemoteException {
        String[] ret = new String[this.table.size()];
        Enumeration ee = this.table.keys();
        int ii = 0;
        while (ee.hasMoreElements()) {
            ret[ii] = (String)ee.nextElement();
            ++ii;
        }
        return ret;
    }

    public void export(File ff) {
        if (!ff.isFile()) {
            throw new IllegalArgumentException(String.valueOf(ff.getPath()) + " not a File");
        }
        Entry entry = new Entry(ff);
        String keyval = entry.keyValue();
        System.out.println("Exporting " + ff + " as " + keyval);
        this.put(keyval, entry);
    }

    public void export(String path) {
        this.export(new File(path));
    }

    protected void finalize() {
        System.out.print("finalize: ");
        if (this.registry != null) {
            try {
                System.out.print("unbind");
                this.registry.unbind("NetcdfService");
            }
            catch (Exception ee) {
                System.out.println(": " + ee.getMessage());
                ee.printStackTrace();
            }
        }
        System.out.println("");
        this.registry = null;
    }

    public static Registry startRegistry() throws RemoteException {
        System.out.println("No registry, starting one");
        return LocateRegistry.createRegistry(1099);
    }

    public static Registry checkRegistry(Registry regis, int tryagain) throws RemoteException {
        if (regis == null) {
            regis = NetcdfServer.startRegistry();
        }
        NetcdfService existing = null;
        try {
            existing = (NetcdfService)regis.lookup("NetcdfService");
        }
        catch (ConnectException ce) {
            if (--tryagain > 0) {
                return NetcdfServer.checkRegistry(NetcdfServer.startRegistry(), tryagain);
            }
            throw ce;
        }
        catch (NotBoundException notBoundException) {
            return regis;
        }
        try {
            existing.ping();
        }
        catch (ConnectException connectException) {
            try {
                System.out.println("unbinding dead registry entry");
                regis.unbind("NetcdfService");
            }
            catch (NotBoundException notBoundException) {}
        }
        return regis;
    }

    public static void main(String[] args) {
        System.setSecurityManager(new RMISecurityManager());
        Registry regis = null;
        try {
            regis = NetcdfServer.checkRegistry(LocateRegistry.getRegistry(), 2);
        }
        catch (Exception ee) {
            System.out.println("NetcdfServer: error getting registry: " + ee.getMessage());
            ee.printStackTrace();
            System.exit(1);
        }
        try {
            NetcdfServer svc = new NetcdfServer(args, regis);
        }
        catch (Throwable ee) {
            System.out.println("NetcdfServer err: " + ee.getMessage());
            ee.printStackTrace();
            System.exit(1);
        }
    }

    private Entry get(String dataSetName) {
        return (Entry)this.table.get(dataSetName);
    }

    private synchronized void put(String keyval, Entry entry) {
        this.table.put(keyval, entry);
    }
}

