/*
 * Decompiled with CFR 0.152.
 */
package ucar.multiarray;

import java.lang.reflect.Array;
import ucar.multiarray.IndexMap;

public class ConcreteIndexMap
implements IndexMap {
    protected ZZMap iMap_;
    protected ZZMap lengthsMap_;

    protected ConcreteIndexMap() {
    }

    protected final void init(ZZMap iMap, ZZMap lengthsMap) {
        this.iMap_ = iMap;
        this.lengthsMap_ = lengthsMap;
    }

    protected final void init(ZZMap iMap) {
        this.init(iMap, new ZZMap());
    }

    protected final void link(ConcreteIndexMap prev, ZZMap iMap, ZZMap lengthsMap) {
        this.iMap_ = prev.iMap_;
        this.lengthsMap_ = lengthsMap;
        this.iMap_.setPrev(iMap);
        this.lengthsMap_.setPrev(prev.lengthsMap_);
    }

    protected final void link(ConcreteIndexMap prev, ZZMap iMap) {
        this.link(prev, iMap, new ZZMap());
    }

    public final synchronized int getOutputLength() {
        return this.iMap_.size();
    }

    public final synchronized void setInput(int[] input) {
        this.iMap_.rebind(input);
    }

    public final synchronized int[] getTransformed(int[] output) {
        int sz = this.getOutputLength();
        int ii = 0;
        while (ii < sz) {
            output[ii] = this.iMap_.get(ii);
            ++ii;
        }
        return output;
    }

    public final synchronized int[] transform(int[] output, int[] input) {
        this.setInput(input);
        return this.getTransformed(output);
    }

    public final synchronized int getRank() {
        return this.lengthsMap_.size();
    }

    public final synchronized void setLengths(int[] lengths) {
        this.lengthsMap_.rebind(lengths);
        if (this.getRank() < 0) {
            throw new IllegalArgumentException("rank < 0");
        }
    }

    public final synchronized int[] getLengths(int[] output) {
        int sz = this.lengthsMap_.size();
        int ii = 0;
        while (ii < sz) {
            output[ii] = this.lengthsMap_.get(ii);
            ++ii;
        }
        return output;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(String.valueOf(super.toString()) + "\n\t");
        buf.append(String.valueOf(this.iMap_.toString()) + "\n\t");
        buf.append(this.lengthsMap_.toString());
        return buf.toString();
    }

    private static void testZZMap() {
        System.out.println("Testing Inner Class ZZMap");
        ConcreteIndexMap im = new ConcreteIndexMap();
        System.out.println("Unbound:");
        ZZMap zm = im.new ZZMap();
        System.out.println("\t" + zm);
        ConcreteIndexMap concreteIndexMap = im;
        concreteIndexMap.getClass();
        ZZMap next = concreteIndexMap.new ZZMap(zm);
        System.out.println("\t" + next);
        System.out.println("Bernoulli");
        int[] ia = new int[]{1, 1, 2, 3, 5, 8, 13};
        zm.rebind(ia);
        System.out.println("\t" + zm);
        System.out.println("\t" + next);
        System.out.println("Rebound");
        int[] ia2 = new int[]{1, 2, 4, 8};
        next.rebind(ia2);
        System.out.println("\t" + zm);
        System.out.println("\t" + next);
        System.out.println("End ZZMap Test");
    }

    private static void testInit() {
        System.out.println("Testing init() and link() ");
        ConcreteIndexMap im = new ConcreteIndexMap();
        im.init(im.new ZZMap(), im.new ZZMap());
        System.out.println("Unbound:        " + im);
        ConcreteIndexMap next = new ConcreteIndexMap();
        next.link(im, next.new ZZMap(), next.new ZZMap());
        System.out.println("Next Unbound:   " + next);
        int[] ia = new int[]{1, 1, 2, 3, 5, 8, 13};
        int[] ia2 = new int[]{1, 2, 4, 8};
        next.setInput(ia);
        next.setLengths(ia2);
        System.out.println("forward  :      " + im);
        System.out.println("Next forward  : " + next);
        next.setInput(ia2);
        next.setLengths(ia);
        System.out.println("reversed:       " + im);
        System.out.println("Next reversed:  " + next);
        System.out.println("End init(), link() test");
    }

    public static void main(String[] args) {
        ConcreteIndexMap.testZZMap();
        ConcreteIndexMap.testInit();
    }

    protected class ZZMap {
        private Object prev_;

        protected ZZMap() {
            ConcreteIndexMap.this = ConcreteIndexMap.this;
            this.rebind(null);
        }

        protected ZZMap(ZZMap prev) {
            ConcreteIndexMap.this = ConcreteIndexMap.this;
            this.setPrev(prev);
        }

        synchronized int get(int key) {
            if (this.prev_ instanceof ZZMap) {
                return ((ZZMap)this.prev_).get(key);
            }
            try {
                return Array.getInt(this.prev_, key);
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException("Improper Binding");
            }
        }

        final synchronized void rebind(int[] range) {
            if (this.prev_ instanceof ZZMap) {
                ((ZZMap)this.prev_).rebind(range);
                return;
            }
            this.prev_ = range;
        }

        synchronized int size() {
            if (this.prev_ instanceof ZZMap) {
                return ((ZZMap)this.prev_).size();
            }
            try {
                return Array.getLength(this.prev_);
            }
            catch (NullPointerException nullPointerException) {
                return 0;
            }
        }

        final synchronized void setPrev(ZZMap prev) {
            if (this.prev_ instanceof ZZMap) {
                ((ZZMap)this.prev_).setPrev(prev);
                return;
            }
            this.prev_ = prev;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            int sz = this.size();
            buf.append(" [");
            buf.append(sz);
            buf.append("]");
            buf.append(" {");
            int last = sz - 1;
            int ii = 0;
            while (ii < sz) {
                buf.append(this.get(ii));
                if (ii == last) break;
                buf.append(", ");
                ++ii;
            }
            buf.append("}");
            return buf.toString();
        }
    }
}

