/*
 * Decompiled with CFR 0.152.
 */
package ucar.multiarray;

import java.io.IOException;
import java.lang.reflect.Array;
import ucar.multiarray.AbstractAccessor;
import ucar.multiarray.IndexIterator;
import ucar.multiarray.MultiArray;
import ucar.multiarray.MultiArrayImpl;
import ucar.multiarray.OffsetIndexIterator;

public class ArrayMultiArray
implements MultiArray {
    public final Object jla;
    private final int rank;
    private final Class componentType;

    ArrayMultiArray(Object aro, int theRank, Class componentType) {
        this.jla = aro;
        this.rank = theRank;
        this.componentType = componentType;
    }

    public ArrayMultiArray(Object aro) {
        int rank_ = 0;
        Class<?> componentType_ = aro.getClass();
        while (componentType_.isArray()) {
            ++rank_;
            componentType_ = componentType_.getComponentType();
        }
        if (rank_ == 0) {
            throw new IllegalArgumentException();
        }
        this.jla = aro;
        this.rank = rank_;
        this.componentType = componentType_;
    }

    public ArrayMultiArray(Class componentType, int[] dimensions) {
        this.rank = dimensions.length;
        if (this.rank == 0) {
            throw new IllegalArgumentException();
        }
        this.componentType = componentType;
        this.jla = Array.newInstance(componentType, dimensions);
    }

    public ArrayMultiArray(MultiArray ma) throws IOException {
        this.rank = ma.getRank();
        if (this.rank == 0) {
            throw new IllegalArgumentException();
        }
        this.componentType = ma.getComponentType();
        int[] lengths = ma.getLengths();
        this.jla = Array.newInstance(this.componentType, lengths);
        IndexIterator odo = new IndexIterator(lengths);
        while (odo.notDone()) {
            int[] index = odo.value();
            this.set(index, ma.get(index));
            odo.incr();
        }
    }

    public Class getComponentType() {
        return this.componentType;
    }

    public int getRank() {
        return this.rank;
    }

    public int[] getLengths() {
        int[] lengths = new int[this.rank];
        Object oo = this.jla;
        int ii = 0;
        while (ii < this.rank) {
            lengths[ii] = Array.getLength(oo);
            oo = Array.get(oo, 0);
            ++ii;
        }
        return lengths;
    }

    public boolean isUnlimited() {
        return false;
    }

    public boolean isScalar() {
        return this.rank == 0;
    }

    public Object get(int[] index) {
        if (index.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int end = this.rank - 1;
        Object oo = this.jla;
        int ii = 0;
        while (ii < end) {
            oo = Array.get(oo, index[ii]);
            ++ii;
        }
        return Array.get(oo, index[end]);
    }

    public boolean getBoolean(int[] index) {
        if (index.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int end = this.rank - 1;
        Object oo = this.jla;
        int ii = 0;
        while (ii < end) {
            oo = Array.get(oo, index[ii]);
            ++ii;
        }
        return Array.getBoolean(oo, index[end]);
    }

    public char getChar(int[] index) {
        if (index.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int end = this.rank - 1;
        Object oo = this.jla;
        int ii = 0;
        while (ii < end) {
            oo = Array.get(oo, index[ii]);
            ++ii;
        }
        return Array.getChar(oo, index[end]);
    }

    public byte getByte(int[] index) {
        if (index.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int end = this.rank - 1;
        Object oo = this.jla;
        int ii = 0;
        while (ii < end) {
            oo = Array.get(oo, index[ii]);
            ++ii;
        }
        return Array.getByte(oo, index[end]);
    }

    public short getShort(int[] index) {
        if (index.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int end = this.rank - 1;
        Object oo = this.jla;
        int ii = 0;
        while (ii < end) {
            oo = Array.get(oo, index[ii]);
            ++ii;
        }
        return Array.getShort(oo, index[end]);
    }

    public int getInt(int[] index) {
        if (index.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int end = this.rank - 1;
        Object oo = this.jla;
        int ii = 0;
        while (ii < end) {
            oo = Array.get(oo, index[ii]);
            ++ii;
        }
        return Array.getInt(oo, index[end]);
    }

    public long getLong(int[] index) {
        if (index.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int end = this.rank - 1;
        Object oo = this.jla;
        int ii = 0;
        while (ii < end) {
            oo = Array.get(oo, index[ii]);
            ++ii;
        }
        return Array.getLong(oo, index[end]);
    }

    public float getFloat(int[] index) {
        if (index.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int end = this.rank - 1;
        Object oo = this.jla;
        int ii = 0;
        while (ii < end) {
            oo = Array.get(oo, index[ii]);
            ++ii;
        }
        return Array.getFloat(oo, index[end]);
    }

    public double getDouble(int[] index) {
        if (index.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int end = this.rank - 1;
        Object oo = this.jla;
        int ii = 0;
        while (ii < end) {
            oo = Array.get(oo, index[ii]);
            ++ii;
        }
        return Array.getDouble(oo, index[end]);
    }

    public void set(int[] index, Object value) {
        if (index.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int end = this.rank - 1;
        Object oo = this.jla;
        int ii = 0;
        while (ii < end) {
            oo = Array.get(oo, index[ii]);
            ++ii;
        }
        Array.set(oo, index[end], value);
    }

    public void setBoolean(int[] index, boolean value) {
        if (index.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int end = this.rank - 1;
        Object oo = this.jla;
        int ii = 0;
        while (ii < end) {
            oo = Array.get(oo, index[ii]);
            ++ii;
        }
        Array.setBoolean(oo, index[end], value);
    }

    public void setChar(int[] index, char value) {
        if (index.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int end = this.rank - 1;
        Object oo = this.jla;
        int ii = 0;
        while (ii < end) {
            oo = Array.get(oo, index[ii]);
            ++ii;
        }
        Array.setChar(oo, index[end], value);
    }

    public void setByte(int[] index, byte value) {
        if (index.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int end = this.rank - 1;
        Object oo = this.jla;
        int ii = 0;
        while (ii < end) {
            oo = Array.get(oo, index[ii]);
            ++ii;
        }
        Array.setByte(oo, index[end], value);
    }

    public void setShort(int[] index, short value) {
        if (index.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int end = this.rank - 1;
        Object oo = this.jla;
        int ii = 0;
        while (ii < end) {
            oo = Array.get(oo, index[ii]);
            ++ii;
        }
        Array.setShort(oo, index[end], value);
    }

    public void setInt(int[] index, int value) {
        if (index.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int end = this.rank - 1;
        Object oo = this.jla;
        int ii = 0;
        while (ii < end) {
            oo = Array.get(oo, index[ii]);
            ++ii;
        }
        Array.setInt(oo, index[end], value);
    }

    public void setLong(int[] index, long value) {
        if (index.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int end = this.rank - 1;
        Object oo = this.jla;
        int ii = 0;
        while (ii < end) {
            oo = Array.get(oo, index[ii]);
            ++ii;
        }
        Array.setLong(oo, index[end], value);
    }

    public void setFloat(int[] index, float value) {
        if (index.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int end = this.rank - 1;
        Object oo = this.jla;
        int ii = 0;
        while (ii < end) {
            oo = Array.get(oo, index[ii]);
            ++ii;
        }
        Array.setFloat(oo, index[end], value);
    }

    public void setDouble(int[] index, double value) {
        if (index.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int end = this.rank - 1;
        Object oo = this.jla;
        int ii = 0;
        while (ii < end) {
            oo = Array.get(oo, index[ii]);
            ++ii;
        }
        Array.setDouble(oo, index[end], value);
    }

    public MultiArray copyout(int[] origin, int[] shape) {
        if (origin.length != this.rank || shape.length != this.rank) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        int[] shp = (int[])shape.clone();
        int[] pducts = new int[shp.length];
        int product = MultiArrayImpl.numberOfElements(shp, pducts);
        Object dst = Array.newInstance(this.getComponentType(), product);
        int ji = this.rank - 1;
        int src_pos = origin[ji];
        if (ji == 0) {
            System.arraycopy(this.jla, src_pos, dst, 0, product);
        } else {
            int contig = pducts[--ji];
            OffsetIndexIterator odo = new OffsetIndexIterator(ArrayMultiArray.truncCopy(origin), this.getTruncLengths());
            int dst_pos = 0;
            while (dst_pos < product) {
                System.arraycopy(this.getLeaf(odo.value()), src_pos, dst, dst_pos, contig);
                odo.incr();
                dst_pos += contig;
            }
        }
        return new MultiArrayImpl(shp, pducts, dst);
    }

    public void copyin(int[] origin, MultiArray data) throws IOException {
        if (origin.length != this.rank || data.getRank() != this.rank) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        if (data.getComponentType() != this.componentType) {
            throw new ArrayStoreException();
        }
        AbstractAccessor.copy(data, data.getLengths(), this, origin);
    }

    public Object toArray() {
        return this.toArray(null, null, null);
    }

    public Object toArray(Object dst, int[] origin, int[] shape) {
        if (origin == null) {
            origin = new int[this.rank];
        } else if (origin.length != this.rank) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        int[] shp = null;
        if (shape == null) {
            shp = this.getLengths();
        } else if (shape.length == this.rank) {
            shp = (int[])shape.clone();
        } else {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        int[] pducts = new int[shp.length];
        int product = MultiArrayImpl.numberOfElements(shp, pducts);
        dst = MultiArrayImpl.fixDest(dst, product, this.componentType);
        int ji = this.rank - 1;
        int src_pos = origin[ji];
        if (ji == 0) {
            System.arraycopy(this.jla, src_pos, dst, 0, product);
        } else {
            int contig = pducts[--ji];
            OffsetIndexIterator odo = new OffsetIndexIterator(ArrayMultiArray.truncCopy(origin), this.getTruncLengths());
            int dst_pos = 0;
            while (dst_pos < product) {
                System.arraycopy(this.getLeaf(odo.value()), src_pos, dst, dst_pos, contig);
                odo.incr();
                dst_pos += contig;
            }
        }
        return dst;
    }

    static int[] truncCopy(int[] src) {
        int len = src.length - 1;
        int[] dst = new int[len];
        System.arraycopy(src, 0, dst, 0, len);
        return dst;
    }

    public Object get(int index) {
        if (this.rank == 1) {
            return Array.get(this.jla, index);
        }
        return new ArrayMultiArray(Array.get(this.jla, index), this.rank - 1, this.componentType);
    }

    public Object getLeaf(int[] index) {
        int end = this.rank - 2;
        if (index.length <= end) {
            throw new IllegalArgumentException();
        }
        Object oo = this.jla;
        int ii = 0;
        while (ii < end) {
            oo = Array.get(oo, index[ii]);
            ++ii;
        }
        return Array.get(oo, index[end]);
    }

    private int[] getTruncLengths() {
        int containRank = this.rank - 1;
        int[] lengths = new int[containRank];
        Object oo = this.jla;
        int ii = 0;
        while (ii < containRank) {
            lengths[ii] = Array.getLength(oo);
            oo = Array.get(oo, 0);
            ++ii;
        }
        return lengths;
    }

    public static void main(String[] args) {
        int[] lengths;
        System.out.println(">>  " + System.currentTimeMillis());
        int[] shape = new int[]{48, 64};
        MultiArrayImpl init = new MultiArrayImpl(Integer.TYPE, shape);
        int size = MultiArrayImpl.numberOfElements(shape);
        int ii = 0;
        while (ii < size) {
            Array.setInt(init.storage, ii, ii);
            ++ii;
        }
        ArrayMultiArray src = null;
        try {
            src = new ArrayMultiArray(init);
        }
        catch (IOException iOException) {}
        int[] clip = new int[]{32, 64};
        int[] nArray = new int[2];
        nArray[0] = 8;
        int[] origin = nArray;
        MultiArray ma = src.copyout(origin, clip);
        try {
            System.out.println("Rank  " + ma.getRank());
            lengths = ma.getLengths();
            System.out.println("Shape { " + lengths[0] + ", " + lengths[1] + " }");
            System.out.println(ma.getInt(new int[2]));
            int[] nArray2 = new int[2];
            nArray2[0] = 1;
            System.out.println(ma.getInt(nArray2));
            System.out.println(ma.getInt(new int[]{lengths[0] - 1, lengths[1] - 1}));
        }
        catch (IOException iOException) {}
        clip = new int[]{48, 48};
        int[] nArray3 = new int[2];
        nArray3[1] = 8;
        origin = nArray3;
        ma = src.copyout(origin, clip);
        try {
            System.out.println("Rank  " + ma.getRank());
            lengths = ma.getLengths();
            System.out.println("Shape { " + lengths[0] + ", " + lengths[1] + " }");
            System.out.println(ma.getInt(new int[2]));
            int[] nArray4 = new int[2];
            nArray4[0] = 1;
            System.out.println(ma.getInt(nArray4));
            System.out.println(ma.getInt(new int[]{lengths[0] - 1, lengths[1] - 1}));
        }
        catch (IOException iOException) {}
        ArrayMultiArray dest = new ArrayMultiArray(Integer.TYPE, shape);
        try {
            dest.copyin(origin, ma);
            System.out.println("***Rank  " + dest.getRank());
            int[] lengths2 = dest.getLengths();
            System.out.println("Shape { " + lengths2[0] + ", " + lengths2[1] + " }");
            System.out.println(dest.getInt(new int[2]));
            int[] nArray5 = new int[2];
            nArray5[1] = 7;
            System.out.println(dest.getInt(nArray5));
            int[] nArray6 = new int[2];
            nArray6[1] = 8;
            System.out.println(dest.getInt(nArray6));
            System.out.println(dest.getInt(new int[]{47, 55}));
            System.out.println(dest.getInt(new int[]{47, 56}));
            System.out.println(dest.getInt(new int[]{47, 63}));
        }
        catch (IOException iOException) {}
    }
}

