/*
 * Decompiled with CFR 0.152.
 */
package ucar.multiarray;

import java.io.IOException;
import ucar.multiarray.Accessor;
import ucar.multiarray.MultiArray;
import ucar.multiarray.OffsetDualIndexIterator;

public abstract class AbstractAccessor
implements Accessor {
    public static void copy(Accessor src, int[] src_limits, Accessor dst, int[] dst_pos) throws IOException {
        OffsetDualIndexIterator odo = new OffsetDualIndexIterator(dst_pos, src_limits);
        while (odo.notDone()) {
            dst.set(odo.offsetValue(), src.get(odo.value()));
            odo.incr();
        }
    }

    public static void copyO(Accessor src, int[] src_pos, Accessor dst, int[] dst_limits) throws IOException {
        OffsetDualIndexIterator odo = new OffsetDualIndexIterator(src_pos, dst_limits);
        while (odo.notDone()) {
            dst.set(odo.value(), src.get(odo.offsetValue()));
            odo.incr();
        }
    }

    public abstract Object get(int[] var1) throws IOException;

    public boolean getBoolean(int[] index) throws IOException {
        Boolean nn = (Boolean)this.get(index);
        return nn;
    }

    public char getChar(int[] index) throws IOException {
        Character nn = (Character)this.get(index);
        return nn.charValue();
    }

    public byte getByte(int[] index) throws IOException {
        Number nn = (Number)this.get(index);
        return nn.byteValue();
    }

    public short getShort(int[] index) throws IOException {
        Number nn = (Number)this.get(index);
        return nn.shortValue();
    }

    public int getInt(int[] index) throws IOException {
        Number nn = (Number)this.get(index);
        return nn.intValue();
    }

    public long getLong(int[] index) throws IOException {
        Number nn = (Number)this.get(index);
        return nn.longValue();
    }

    public float getFloat(int[] index) throws IOException {
        Number nn = (Number)this.get(index);
        return nn.floatValue();
    }

    public double getDouble(int[] index) throws IOException {
        Number nn = (Number)this.get(index);
        return nn.doubleValue();
    }

    public abstract void set(int[] var1, Object var2) throws IOException;

    public void setBoolean(int[] index, boolean value) throws IOException {
        this.set(index, new Boolean(value));
    }

    public void setChar(int[] index, char value) throws IOException {
        this.set(index, new Character(value));
    }

    public void setByte(int[] index, byte value) throws IOException {
        this.set(index, new Byte(value));
    }

    public void setShort(int[] index, short value) throws IOException {
        this.set(index, new Short(value));
    }

    public void setInt(int[] index, int value) throws IOException {
        this.set(index, new Integer(value));
    }

    public void setLong(int[] index, long value) throws IOException {
        this.set(index, new Long(value));
    }

    public void setFloat(int[] index, float value) throws IOException {
        this.set(index, new Float(value));
    }

    public void setDouble(int[] index, double value) throws IOException {
        this.set(index, new Float(value));
    }

    public abstract MultiArray copyout(int[] var1, int[] var2) throws IOException;

    public void copyin(int[] origin, MultiArray data) throws IOException {
        OffsetDualIndexIterator odo = new OffsetDualIndexIterator(origin, data.getLengths());
        while (odo.notDone()) {
            this.set(odo.offsetValue(), data.get(odo.value()));
            odo.incr();
        }
    }

    public abstract Object toArray() throws IOException;

    public abstract Object toArray(Object var1, int[] var2, int[] var3) throws IOException;
}

