/*
 * Decompiled with CFR 0.152.
 */
public class navGVAR {
    final double PI = Math.PI;
    final double DEG = 57.29577951308232;
    final double RAD = Math.PI / 180;
    final double NOMORB = 42164.365;
    final double AE = 6378.137;
    final double FER = 0.003352656112592056;
    final float AEBE2 = (float)(1.0 / Math.pow(0.9966473438874079, 2.0));
    final float AEBE3 = this.AEBE2 - 1.0f;
    final float AEBE4 = (float)Math.pow(0.9966473438874079, 4.0) - 1.0f;
    final int GVAR = 1196835154;
    final int LL = 123;
    final int XY = 234;
    private double[] xs = new double[3];
    private double[][] bt = new double[3][3];
    private double q3;
    private double pitch;
    private double roll;
    private double yaw;
    private float pma;
    private float rma;
    private int[] incmax = new int[]{6136, 2805};
    private float[] elvmax = new float[]{0.220896f, 0.22089376f};
    private float[] scnmax = new float[]{0.24544f, 0.2454375f};
    private float[] elvinc = new float[]{8.0E-6f, 1.75E-5f};
    private float[] scninc = new float[]{1.6E-5f, 3.5E-5f};
    private float[] elvln = new float[]{2.8E-5f, 2.8E-4f};
    private float[] scnpx = new float[]{1.6E-5f, 2.8E-4f};
    private float[] nsnom = new float[]{0.220896f, 0.22089376f};
    private float[] ewnom = new float[]{0.24544f, 0.2454375f};
    final int STTYPE = 0;
    final int IDNTFR = 1;
    final int IMCACT = 2;
    final int IYFLIP = 3;
    final int REFLON = 5;
    final int REFDIS = 6;
    final int REFLAT = 7;
    final int REFYAW = 8;
    final int RATROL = 9;
    final int RATPTC = 10;
    final int RATYAW = 11;
    final int ETIME = 12;
    final int EDTIME = 14;
    final int IMCROL = 15;
    final int IMCPTC = 16;
    final int IMCYAW = 17;
    final int LDR1 = 18;
    final int LDR2 = 19;
    final int LDR3 = 20;
    final int LDR4 = 21;
    final int LDR5 = 22;
    final int LDR6 = 23;
    final int LDR7 = 24;
    final int LDR8 = 25;
    final int LDR9 = 26;
    final int LDR10 = 27;
    final int LDR11 = 28;
    final int LDR12 = 29;
    final int LDR13 = 30;
    final int RDDR1 = 31;
    final int RDDR2 = 32;
    final int RDDR3 = 33;
    final int RDDR4 = 34;
    final int RDDR5 = 35;
    final int RDDR6 = 36;
    final int RDDR7 = 37;
    final int RDDR8 = 38;
    final int RDDR9 = 39;
    final int RDDR10 = 40;
    final int RDDR11 = 41;
    final int DGL1 = 42;
    final int DGL2 = 43;
    final int DGL3 = 44;
    final int DGL4 = 45;
    final int DGL5 = 46;
    final int DGL6 = 47;
    final int DGL7 = 48;
    final int DGL8 = 49;
    final int DGL9 = 50;
    final int DOY1 = 51;
    final int DOY2 = 52;
    final int DOY3 = 53;
    final int DOY4 = 54;
    final int DOY5 = 55;
    final int DOY6 = 56;
    final int DOY7 = 57;
    final int DOY8 = 58;
    final int DOY9 = 59;
    final int EXPTIM = 61;
    final int RAAWDS = 62;
    final int PAAWDS = 129;
    final int YAAWDS = 184;
    final int RMAWDS = 257;
    final int PMAWDS = 312;
    final int IMGDAY = 367;
    final int IMGTM = 368;
    final int IMGSND = 369;
    final int IOFNC = 379;
    final int IOFEC = 380;
    final int IOFNI = 381;
    final int IOFEI = 382;
    final int MXCDSZ = 640;
    final int OASIZE = 336;
    final int PCOEFS = 117;
    final int RMACFS = 227;
    final int CUTOF1 = 115;
    final int CUTOF2 = 225;
    final int IMCFLG = 7;
    final int FLPFLG = 15;
    private int iflip;
    private double aec;
    private double ts;
    private double dr;
    private double lam;
    private double dlat;
    private double dyaw;
    private double phi;
    private double aebe2c;
    private double aebe3c;
    private double aebe4c;
    private double ferc;
    private int instr;
    private int itype;
    private double sublat;
    private double sublon;
    private double rlat;
    private double rlon;
    private double gam;
    private double alf;
    private float resLine = 1.0f;
    private float resElement = 1.0f;
    private float magLine = 1.0f;
    private float magElement = 1.0f;
    private float startLine;
    private float startElement;
    private float startImageLine;
    private float startImageElement;
    final int[][] RELLST = new int[][]{{4, 10}, {13, 63}, {65, 94}, {98, 100}, {103, 105}, {108, 110}, {113, 115}, {116, 118}, {120, 149}, {153, 155}, {158, 160}, {163, 165}, {168, 170}, {171, 173}, {175, 204}, {208, 210}, {213, 215}, {218, 220}, {223, 225}, {226, 228}, {230, 259}, {263, 265}, {268, 270}, {273, 275}, {278, 283}, {285, 314}, {318, 320}, {323, 325}, {328, 330}, {333, 335}, {-1, -1}};

    public navGVAR(int n, int[] nArray) {
        double[][] dArray = new double[3][3];
        float[] fArray = new float[640];
        this.aec = 6378.137;
        this.ferc = 0.003352656112592056;
        this.aebe2c = this.AEBE2;
        this.aebe3c = this.AEBE3;
        this.aebe4c = this.AEBE4;
        if (n != 1) {
            if (nArray[0] == 123) {
                this.itype = 1;
            }
            if (nArray[0] == 234) {
                this.itype = 2;
            }
            return;
        }
        if (nArray[0] != 1196835154) {
            return;
        }
        this.itype = 1;
        int n2 = 0;
        while (n2 < 640) {
            fArray[n2] = Float.intBitsToFloat(nArray[n2]);
            ++n2;
        }
        int n3 = 0;
        fArray[368] = (float)nArray[368] / 1000.0f;
        while (this.RELLST[n3][0] != -1) {
            int n4 = 1;
            if (this.RELLST[n3][0] > 115) {
                n4 = 13;
            }
            if (this.RELLST[n3][0] > 225) {
                n4 = 31;
            }
            n2 = this.RELLST[n3][0];
            while (n2 <= this.RELLST[n3][1]) {
                fArray[n2 + n4] = n2 == 13 || n2 == 60 || (n2 - 7) % 55 == 0 && n2 != 7 ? (float)nArray[n2 + n4] / 100.0f : (float)nArray[n2 + n4] / 1.0E7f;
                ++n2;
            }
            ++n3;
        }
        this.instr = nArray[369];
        int n5 = nArray[379];
        int n6 = nArray[381];
        int n7 = nArray[380];
        int n8 = nArray[382];
        if (n5 != 0 && n6 != 0 && n7 != 0 && n8 != 0) {
            if (this.instr == 1) {
                this.elvmax[0] = (float)(n5 * this.incmax[0] + n6) * this.elvinc[0];
            } else {
                this.elvmax[1] = (float)((9 - n5) * this.incmax[1] - n6) * this.elvinc[1];
            }
            this.scnmax[this.instr - 1] = (float)(n7 * this.incmax[this.instr - 1] + n8) * this.scninc[this.instr - 1];
        }
        int n9 = 1900 + nArray[367] / 1000;
        int n10 = nArray[367] - nArray[367] / 1000 * 1000;
        int n11 = (int)fArray[368] / 10000;
        int n12 = (int)fArray[368] / 100 - n11 * 100;
        double d = fArray[368] - 100.0f * (float)n12 - 10000.0f * (float)n11;
        int n13 = n10 + 1461 * (n9 + 4799) / 4 - 3 * ((n9 + 4899) / 100) / 4 - 2465022;
        double d2 = (double)n13 * 1440.0 + (double)n11 * 60.0 + (double)n12 + d / 60.0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 1;
        int n17 = nArray[12];
        int n18 = nArray[13];
        int n19 = 0;
        while (n19 < 8) {
            n14 += (n17 & 0xF) * n16;
            n15 += (n18 & 0xF) * n16;
            n17 >>>= 4;
            n18 >>>= 4;
            n16 *= 10;
            ++n19;
        }
        n9 = n14 / 10000;
        n10 = (int)((double)(n14 - n9 * 10000) * 0.1);
        int n20 = n14 - n9 * 10000;
        int n21 = (n20 - n10 * 10) * 10;
        int n22 = n15 / 10000000;
        int n23 = n15 - n22 * 10000000;
        int n24 = n15 - n23;
        n11 = n21 + n22;
        n12 = (int)((double)n23 * 1.0E-5);
        double d3 = (double)(n15 - (n24 + n12 * 100000)) * 0.001;
        n13 = n10 + 1461 * (n9 + 4799) / 4 - 3 * ((n9 + 4899) / 100) / 4 - 2465022;
        double d4 = (double)n13 * 1440.0 + (double)n11 * 60.0 + (double)n12 + d3 / 60.0;
        boolean bl = true;
        if ((nArray[2] & 0x80) != 0) {
            bl = false;
        }
        this.iflip = 1;
        if ((nArray[3] & 0x8000) != 0) {
            this.iflip = -1;
        }
        this.lam = fArray[5];
        this.dr = fArray[6];
        this.phi = fArray[7];
        double d5 = fArray[8];
        this.roll = fArray[9];
        this.pitch = fArray[10];
        this.yaw = fArray[11];
        this.rma = 0.0f;
        this.pma = 0.0f;
        if (bl) {
            this.dr = 0.0;
            this.phi = 0.0;
            d5 = 0.0;
            this.ts = d2 - d4;
            double d6 = 0.0043746900000000005 * this.ts;
            double d7 = Math.sin(d6);
            double d8 = Math.cos(d6);
            double d9 = Math.sin(0.927 * d6);
            double d10 = Math.cos(0.927 * d6);
            double d11 = Math.sin(2.0 * d6);
            double d12 = Math.cos(2.0 * d6);
            double d13 = Math.sin(1.9268 * d6);
            double d14 = Math.cos(1.9268 * d6);
            this.lam = this.lam + (double)fArray[18] + ((double)fArray[19] + (double)fArray[20] * d6) * d6 + ((double)fArray[27] * d9 + (double)fArray[28] * d10 + (double)fArray[21] * d7 + (double)fArray[22] * d8 + (double)fArray[23] * d11 + (double)fArray[24] * d12 + (double)fArray[25] * d13 + (double)fArray[26] * d14 + d6 * ((double)fArray[29] * d7 + (double)fArray[30] * d8)) * 2.0;
            this.dr = this.dr + (double)fArray[31] + (double)fArray[32] * d8 + (double)fArray[33] * d7 + (double)fArray[34] * d12 + (double)fArray[35] * d11 + (double)fArray[36] * d14 + (double)fArray[37] * d13 + (double)fArray[38] * d10 + (double)fArray[39] * d9 + d6 * ((double)fArray[40] * d8 + (double)fArray[41] * d7);
            this.dlat = (double)fArray[42] + (double)fArray[43] * d8 + (double)fArray[44] * d7 + (double)fArray[45] * d12 + (double)fArray[46] * d11 + d6 * ((double)fArray[47] * d8 + (double)fArray[48] * d7) + (double)fArray[49] * d10 + (double)fArray[50] * d9;
            this.phi += this.dlat * (1.0 + this.dlat * this.dlat / 6.0);
            this.dyaw = (double)fArray[51] + (double)fArray[52] * d7 + (double)fArray[53] * d8 + (double)fArray[54] * d11 + (double)fArray[55] * d12 + d6 * ((double)fArray[56] * d7 + (double)fArray[57] * d8) + (double)fArray[58] * d9 + (double)fArray[59] * d10;
            d5 += this.dyaw * (1.0 + this.dyaw * this.dyaw / 6.0);
        }
        double d15 = Math.sin(this.phi);
        double d16 = Math.sin(d5);
        double d17 = d15 * d15 + d16 * d16;
        double d18 = Math.sqrt(1.0 - d17);
        d17 = Math.sqrt(d17);
        double d19 = d15 == 0.0 && d16 == 0.0 ? 0.0 : Math.atan2(d15, d16);
        double d20 = Math.sin(d19);
        double d21 = Math.cos(d19);
        double d22 = this.lam - d19;
        double d23 = Math.sin(d22);
        double d24 = Math.cos(d22);
        this.sublat = Math.atan(this.aebe2c * Math.tan(this.phi));
        this.sublon = d22 + Math.atan2(d18 * d20, d21);
        dArray[0][1] = -d23 * d17;
        dArray[1][1] = d24 * d17;
        dArray[2][1] = -d18;
        dArray[0][2] = -d24 * d21 + d23 * d20 * d18;
        dArray[1][2] = -d23 * d21 - d24 * d20 * d18;
        dArray[2][2] = -d15;
        dArray[0][0] = -d24 * d20 - d23 * d21 * d18;
        dArray[1][0] = -d23 * d20 + d24 * d21 * d18;
        dArray[2][0] = d21 * d17;
        double d25 = (42164.365 + this.dr) / this.aec;
        this.xs[0] = -dArray[0][2] * d25;
        this.xs[1] = -dArray[1][2] * d25;
        this.xs[2] = -dArray[2][2] * d25;
        this.q3 = this.xs[0] * this.xs[0] + this.xs[1] * this.xs[1] + this.aebe2c * this.xs[2] * this.xs[2] - 1.0;
        if (bl) {
            double d26 = (double)fArray[60] * this.ts;
            double d27 = this.ts - (double)fArray[61];
            this.roll += this.gatt(62, fArray, nArray, d26, d27);
            this.pitch += this.gatt(129, fArray, nArray, d26, d27);
            this.yaw += this.gatt(184, fArray, nArray, d26, d27);
            this.rma = (float)this.gatt(257, fArray, nArray, d26, d27);
            this.pma = (float)this.gatt(312, fArray, nArray, d26, d27);
            this.roll += (double)fArray[15];
            this.pitch += (double)fArray[16];
            this.yaw += (double)fArray[17];
        }
        this.inst2e(this.roll, this.pitch, this.yaw, dArray, this.bt);
    }

    private double gatt(int n, float[] fArray, int[] nArray, double d, double d2) {
        double d3 = fArray[n + 2];
        if (d2 >= 0.0) {
            d3 += (double)fArray[n] * Math.exp(-d2 / (double)fArray[n + 1]);
        }
        double d4 = nArray[n + 3];
        int n2 = (int)d4;
        int n3 = 1;
        while (n3 <= n2) {
            d3 += (double)fArray[n + 2 * n3 + 2] * Math.cos(d * (double)n3 + (double)fArray[n + 2 * n3 + 3]);
            ++n3;
        }
        d4 = nArray[n += 34];
        int n4 = nArray[n];
        int n5 = 1;
        while (n5 <= n4) {
            int n6 = n + 5 * n5;
            double d5 = nArray[n6 - 4];
            double d6 = nArray[n6 - 3];
            d3 += (double)fArray[n6 - 2] * Math.pow(d - (double)fArray[n6], d6) * Math.cos(d5 * d + (double)fArray[n6 - 1]);
            ++n5;
        }
        return d3;
    }

    private void inst2e(double d, double d2, double d3, double[][] dArray, double[][] dArray2) {
        double[][] dArray3 = new double[3][3];
        dArray3[0][0] = 1.0 - 0.5 * (d2 * d2 + d3 * d3);
        dArray3[0][1] = -d3;
        dArray3[0][2] = d2;
        dArray3[1][0] = d3 + d2 * d;
        dArray3[1][1] = 1.0 - 0.5 * (d3 * d3 + d * d);
        dArray3[1][2] = -d;
        dArray3[2][0] = -d2 + d * d3;
        dArray3[2][1] = d + d2 * d3;
        dArray3[2][2] = 1.0 - 0.5 * (d2 * d2 + d * d);
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            while (n2 < 3) {
                dArray2[n][n2] = dArray[n][0] * dArray3[0][n2] + dArray[n][1] * dArray3[1][n2] + dArray[n][2] * dArray3[2][n2];
                ++n2;
            }
            ++n;
        }
    }

    public float[][] toLatLon(float[][] fArray) {
        int n = fArray[0].length;
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        float[][] fArray2 = new float[2][n];
        int n2 = 0;
        while (n2 < n) {
            double d = fArray[0][n2];
            double d2 = fArray[1][n2];
            d = (double)this.startImageLine + (double)this.resLine * (d - (double)this.startLine) / (double)this.magLine;
            d2 = (double)this.startImageElement + (double)this.resElement * (d2 - (double)this.startElement) / (double)this.magElement;
            if (this.instr == 2) {
                d = (d + 9.0) / 10.0;
                d2 = (d2 + 9.0) / 10.0;
            }
            double d3 = this.instr == 1 ? (double)this.elvmax[0] - (d - 4.5) * (double)this.elvln[0] : (double)this.elvmax[1] - (d - 2.5) * (double)this.elvln[1];
            double d4 = (d2 - 1.0) * (double)this.scnpx[this.instr - 1] - (double)this.scnmax[this.instr - 1];
            double d5 = this.iflip;
            if (this.instr == 2) {
                d5 = -d5;
            }
            double d6 = this.scnmax[this.instr - 1] - this.ewnom[this.instr - 1];
            double d7 = d3 - d3 * d4 * d6;
            double d8 = d4 + 0.5 * d3 * d3 * d6;
            double d9 = Math.cos(d7);
            double d10 = Math.sin(d7);
            double d11 = Math.cos(d8);
            double d12 = d7 - (double)this.pma * d10 * (d5 / d11 + Math.tan(d8)) - (double)this.rma * (1.0 - d9 / d11);
            double d13 = d8 + d5 * (double)this.rma * d10;
            d11 = Math.cos(d13);
            dArray2[0] = Math.sin(d13);
            dArray2[1] = -d11 * Math.sin(d12);
            dArray2[2] = d11 * Math.cos(d12);
            dArray[0] = this.bt[0][0] * dArray2[0] + this.bt[0][1] * dArray2[1] + this.bt[0][2] * dArray2[2];
            dArray[1] = this.bt[1][0] * dArray2[0] + this.bt[1][1] * dArray2[1] + this.bt[1][2] * dArray2[2];
            dArray[2] = this.bt[2][0] * dArray2[0] + this.bt[2][1] * dArray2[1] + this.bt[2][2] * dArray2[2];
            double d14 = this.xs[0] * dArray[0] + this.xs[1] * dArray[1] + this.aebe2c * this.xs[2] * dArray[2];
            double d15 = dArray[0] * dArray[0] + dArray[1] * dArray[1] + this.aebe2c * dArray[2] * dArray[2];
            double d16 = d14 * d14 - d15 * this.q3;
            if (Math.abs(d16) < -8.0) {
                d16 = 0.0;
            }
            if (!(d16 >= 0.0)) {
                fArray2[0][n2] = Float.NaN;
                fArray2[1][n2] = Float.NaN;
            } else {
                d16 = Math.sqrt(d16);
                double d17 = -(d14 + d16) / d15;
                dArray3[0] = this.xs[0] + d17 * dArray[0];
                dArray3[1] = this.xs[1] + d17 * dArray[1];
                dArray3[2] = this.xs[2] + d17 * dArray[2];
                double d18 = dArray3[2] / Math.sqrt(dArray3[0] * dArray3[0] + dArray3[1] * dArray3[1] + dArray3[2] * dArray3[2]);
                this.rlat = Math.atan(this.aebe2c * d18 / Math.sqrt(1.0 - d18 * d18));
                this.rlon = Math.atan2(dArray3[1], dArray3[0]);
                this.rlat *= 57.29577951308232;
                this.rlon *= 57.29577951308232;
                this.rlon = -this.rlon;
                if (this.itype == 2) {
                    float f = (float)this.rlat;
                    float f2 = (float)this.rlon;
                } else {
                    fArray2[0][n2] = (float)this.rlat;
                    fArray2[1][n2] = (float)this.rlon;
                }
            }
            ++n2;
        }
        return fArray2;
    }

    public float[][] toLinEle(float[][] fArray) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        int n = fArray[0].length;
        float[][] fArray2 = new float[2][n];
        double d = this.iflip;
        if (this.instr == 2) {
            d = -d;
        }
        double d2 = this.scnmax[this.instr - 1] - this.ewnom[this.instr - 1];
        int n2 = 0;
        while (n2 < n) {
            if (this.itype == 2) {
                float f = fArray[0][n2];
                float f2 = fArray[1][n2];
            }
            if ((double)Math.abs(fArray[0][n2]) > 90.0) {
                fArray2[0][n2] = Float.NaN;
                fArray2[1][n2] = Float.NaN;
            } else {
                this.rlat = (double)fArray[0][n2] * (Math.PI / 180);
                this.rlon = -((double)fArray[1][n2]) * (Math.PI / 180);
                double d3 = Math.sin(this.rlat);
                double d4 = this.aebe4c * d3 * d3;
                double d5 = ((0.375 * d4 - 0.5) * d4 + 1.0) * d3 / this.aebe2c;
                double d6 = d5 * d5;
                d4 = this.aebe3c * d6;
                d4 = (0.375 * d4 - 0.5) * d4 + 1.0;
                dArray3[2] = d5 * d4;
                d6 = d4 * Math.sqrt(1.0 - d6);
                dArray3[0] = d6 * Math.cos(this.rlon);
                dArray3[1] = d6 * Math.sin(this.rlon);
                dArray[0] = dArray3[0] - this.xs[0];
                dArray[1] = dArray3[1] - this.xs[1];
                dArray[2] = dArray3[2] - this.xs[2];
                d6 = dArray3[0] * dArray[0] + dArray3[1] * dArray[1] + dArray3[2] * dArray[2] * this.aebe2c;
                if (!(d6 <= 0.0)) {
                    fArray2[0][n2] = Float.NaN;
                    fArray2[1][n2] = Float.NaN;
                } else {
                    dArray2[0] = this.bt[0][0] * dArray[0] + this.bt[1][0] * dArray[1] + this.bt[2][0] * dArray[2];
                    dArray2[1] = this.bt[0][1] * dArray[0] + this.bt[1][1] * dArray[1] + this.bt[2][1] * dArray[2];
                    dArray2[2] = this.bt[0][2] * dArray[0] + this.bt[1][2] * dArray[1] + this.bt[2][2] * dArray[2];
                    this.gam = Math.atan(dArray2[0] / Math.sqrt(dArray2[1] * dArray2[1] + dArray2[2] * dArray2[2]));
                    this.alf = -Math.atan(dArray2[1] / dArray2[2]);
                    d4 = Math.sin(this.alf);
                    d6 = Math.cos(this.gam);
                    double d7 = this.alf + (double)this.rma * (1.0 - Math.cos(this.alf) / d6) + (double)this.pma * d4 * (d2 / d6 + Math.tan(this.gam));
                    this.gam -= d * (double)this.rma * d4;
                    this.alf = d7 + d7 * this.gam * d2;
                    this.gam -= 0.5 * d7 * d7 * d2;
                    double d8 = ((double)this.elvmax[this.instr - 1] - this.alf) / (double)this.elvln[this.instr - 1];
                    d8 = this.instr == 1 ? (d8 += 4.5) : (d8 += 2.5);
                    double d9 = ((double)this.scnmax[this.instr - 1] + this.gam) / (double)this.scnpx[this.instr - 1] + 1.0;
                    fArray2[0][n2] = (float)d8;
                    fArray2[1][n2] = (float)d9;
                    if (this.instr == 2) {
                        fArray2[0][n2] = fArray2[0][n2] * 10.0f - 9.0f;
                        fArray2[1][n2] = fArray2[1][n2] * 10.0f - 9.0f;
                    }
                    fArray2[0][n2] = this.startLine + this.magLine * (fArray2[0][n2] - this.startImageLine) / this.resLine;
                    fArray2[1][n2] = this.startElement + this.magElement * (fArray2[1][n2] - this.startImageElement) / this.resElement;
                }
            }
            ++n2;
        }
        return fArray2;
    }

    public void setRes(int n, int n2) {
        this.resLine = n;
        this.resElement = n2;
    }

    public void setRes(float f, float f2) {
        this.resLine = f;
        this.resElement = f2;
    }

    public void setMag(int n, int n2) {
        this.magLine = n;
        this.magElement = n2;
    }

    public void setMag(float f, float f2) {
        this.magLine = f;
        this.magElement = f2;
    }

    public void setStart(int n, int n2) {
        this.startLine = n;
        this.startElement = n2;
    }

    public void setImageStart(int n, int n2) {
        this.startImageLine = n;
        this.startImageElement = n2;
    }
}

