/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;

class NavigatorGvar
implements Navigator {
    private static final int GVAR_NAV_SIZE = 640;
    private static int sid;
    private static int intGVAR;
    private int[] navBlock = new int[640];
    private navGVAR ng;

    public NavigatorGvar(DataInputStream dataInputStream, AncillaryData ancillaryData) throws IOException, NavigatorGvarException {
        int n = 0;
        if (ancillaryData.getNavOffset() > 0) {
            n = ancillaryData.getCalOffset() > 0 ? ancillaryData.getCalOffset() - ancillaryData.getNavOffset() : ancillaryData.getDataOffset() - ancillaryData.getNavOffset();
        }
        int n2 = 0;
        while (n2 < n / 4) {
            this.navBlock[n2] = dataInputStream.readInt();
            ++n2;
        }
        if (this.navBlock[0] != intGVAR) {
            throw new NavigatorGvarException("Unable to create GVAR nav object");
        }
        this.ng = new navGVAR(1, this.navBlock);
        sid = ancillaryData.getSensorId();
        if (sid % 2 == 0) {
            this.ng.setRes(ancillaryData.getLineRes(), ancillaryData.getElemRes());
        } else {
            this.ng.setRes(10 * ancillaryData.getLineRes(), 10 * ancillaryData.getElemRes());
        }
        this.ng.setImageStart(ancillaryData.getStartLine(), ancillaryData.getStartElem());
        this.ng.setStart(0, 0);
    }

    public float[][] toLinEle(float[][] fArray) {
        return this.ng.toLinEle(fArray);
    }

    public float[][] toLatLon(float[][] fArray) {
        return this.ng.toLatLon(fArray);
    }

    static {
        intGVAR = 1196835154;
    }
}

