/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import ucar.multiarray.ArrayMultiArray;
import ucar.netcdf.Attribute;
import ucar.netcdf.Dimension;
import ucar.netcdf.NetcdfFile;
import ucar.netcdf.ProtoVariable;
import ucar.netcdf.Schema;
import ucar.netcdf.Variable;

public class AreaToNetCDF {
    public static void main(String[] stringArray) {
        ScienceImage scienceImage = null;
        AncillaryData ancillaryData = null;
        String string = "AREA0001";
        String string2 = "AREA0001.nc";
        if (stringArray.length == 0) {
            string2 = new String("AREA0001.nc");
        } else {
            string = stringArray[0];
            if (stringArray.length > 1) {
                string2 = stringArray[1];
                if (string2.indexOf(".nc") < 0) {
                    string2 = String.valueOf(string2) + ".nc";
                }
            } else {
                string2 = String.valueOf(string) + ".nc";
            }
        }
        System.out.println("input filename: " + string);
        System.out.println("output filename: " + string2);
        try {
            scienceImage = new ScienceImage(string);
            ancillaryData = scienceImage.getAD();
        }
        catch (IOException iOException) {
            System.out.println("Error creating ScienceImage" + iOException);
            return;
        }
        try {
            String string3;
            Schema schema = new Schema();
            Dimension dimension = new Dimension("lines", ancillaryData.getNumLines());
            Dimension dimension2 = new Dimension("elements", ancillaryData.getNumElements());
            Dimension dimension3 = new Dimension("numbands", ancillaryData.getNumBands());
            Dimension dimension4 = new Dimension("stringlength", 128);
            ProtoVariable protoVariable = new ProtoVariable("version", (Class)Integer.TYPE, null);
            schema.put(protoVariable);
            protoVariable.putAttribute(new Attribute("long_name", "McIDAS area file version number"));
            ProtoVariable protoVariable2 = new ProtoVariable("sensor_ID", Character.TYPE, dimension4);
            schema.put(protoVariable2);
            protoVariable2.putAttribute(new Attribute("long_name", "sensor identification"));
            ProtoVariable protoVariable3 = new ProtoVariable("image_date", (Class)Integer.TYPE, null);
            schema.put(protoVariable3);
            protoVariable3.putAttribute(new Attribute("units", "ccyyddd"));
            protoVariable3.putAttribute(new Attribute("long_name", "image year and day of year"));
            ProtoVariable protoVariable4 = new ProtoVariable("image_time", (Class)Integer.TYPE, null);
            schema.put(protoVariable4);
            protoVariable4.putAttribute(new Attribute("units", "hhmmss UTC"));
            protoVariable4.putAttribute(new Attribute("long_name", "image time in UTC"));
            ProtoVariable protoVariable5 = new ProtoVariable("start_line", (Class)Integer.TYPE, null);
            schema.put(protoVariable5);
            protoVariable5.putAttribute(new Attribute("units", "satellite coordinates"));
            protoVariable5.putAttribute(new Attribute("long_name", "image starting line"));
            ProtoVariable protoVariable6 = new ProtoVariable("start_elem", (Class)Integer.TYPE, null);
            schema.put(protoVariable6);
            protoVariable6.putAttribute(new Attribute("units", "satellite coordinates"));
            protoVariable6.putAttribute(new Attribute("long_name", "image starting element"));
            ProtoVariable protoVariable7 = new ProtoVariable("num_lines", (Class)Integer.TYPE, null);
            schema.put(protoVariable7);
            protoVariable7.putAttribute(new Attribute("long_name", "number of lines"));
            ProtoVariable protoVariable8 = new ProtoVariable("num_elems", (Class)Integer.TYPE, null);
            schema.put(protoVariable8);
            protoVariable8.putAttribute(new Attribute("long_name", "number of elements"));
            ProtoVariable protoVariable9 = new ProtoVariable("data_width", (Class)Integer.TYPE, null);
            schema.put(protoVariable9);
            protoVariable9.putAttribute(new Attribute("units", "bytes/data point"));
            protoVariable9.putAttribute(new Attribute("long_name", "number of bytes per source data point"));
            ProtoVariable protoVariable10 = new ProtoVariable("line_resolution", (Class)Integer.TYPE, null);
            schema.put(protoVariable10);
            protoVariable10.putAttribute(new Attribute("units", "km"));
            protoVariable10.putAttribute(new Attribute("long_name", "resolution of each pixel in line direction"));
            ProtoVariable protoVariable11 = new ProtoVariable("elem_resolution", (Class)Integer.TYPE, null);
            schema.put(protoVariable11);
            protoVariable11.putAttribute(new Attribute("units", "km"));
            protoVariable11.putAttribute(new Attribute("long_name", "resolution of each pixel in elem direction"));
            ProtoVariable protoVariable12 = new ProtoVariable("prefix_size", (Class)Integer.TYPE, null);
            schema.put(protoVariable12);
            protoVariable12.putAttribute(new Attribute("units", "bytes"));
            protoVariable12.putAttribute(new Attribute("long_name", "line prefix size"));
            ProtoVariable protoVariable13 = new ProtoVariable("project_number", (Class)Integer.TYPE, null);
            schema.put(protoVariable13);
            ProtoVariable protoVariable14 = new ProtoVariable("creation_date", (Class)Integer.TYPE, null);
            schema.put(protoVariable14);
            protoVariable14.putAttribute(new Attribute("units", "ccyyddd"));
            protoVariable14.putAttribute(new Attribute("long_name", "image creation year and day of year"));
            ProtoVariable protoVariable15 = new ProtoVariable("creation_time", (Class)Integer.TYPE, null);
            schema.put(protoVariable15);
            protoVariable15.putAttribute(new Attribute("units", "hhmmss UTC"));
            protoVariable15.putAttribute(new Attribute("long_name", "image creation time in UTC"));
            Dimension[] dimensionArray = new Dimension[]{dimension3};
            ProtoVariable protoVariable16 = new ProtoVariable("bands", Integer.TYPE, dimensionArray);
            schema.put(protoVariable16);
            protoVariable16.putAttribute(new Attribute("long_name", "spectral bands present"));
            Dimension[] dimensionArray2 = new Dimension[]{dimension3, dimension, dimension2};
            Dimension[] dimensionArray3 = new Dimension[]{dimension, dimension2};
            ProtoVariable protoVariable17 = new ProtoVariable("data", Float.TYPE, dimensionArray2);
            schema.put(protoVariable17);
            protoVariable17.putAttribute(new Attribute("long_name", "pixel radiance values"));
            protoVariable17.putAttribute(new Attribute("units", "watts/cm2/steradian/micron"));
            ProtoVariable protoVariable18 = new ProtoVariable("lats", Float.TYPE, dimensionArray3);
            schema.put(protoVariable18);
            protoVariable18.putAttribute(new Attribute("units", "degrees East"));
            protoVariable18.putAttribute(new Attribute("long_name", "pixel latitude"));
            ProtoVariable protoVariable19 = new ProtoVariable("lons", Float.TYPE, dimensionArray3);
            schema.put(protoVariable19);
            protoVariable19.putAttribute(new Attribute("units", "degrees North"));
            protoVariable19.putAttribute(new Attribute("long_name", "pixel longitude"));
            NetcdfFile netcdfFile = new NetcdfFile(string2, true, true, schema);
            int[] nArray = new int[1];
            netcdfFile.get(protoVariable7.getName()).setInt(nArray, ancillaryData.getNumLines());
            netcdfFile.get(protoVariable8.getName()).setInt(nArray, ancillaryData.getNumElements());
            netcdfFile.get(protoVariable10.getName()).setInt(nArray, ancillaryData.getLineRes());
            netcdfFile.get(protoVariable11.getName()).setInt(nArray, ancillaryData.getElemRes());
            netcdfFile.get(protoVariable3.getName()).setInt(nArray, ancillaryData.getImageDate());
            netcdfFile.get(protoVariable4.getName()).setInt(nArray, ancillaryData.getImageTime());
            netcdfFile.get(protoVariable5.getName()).setInt(nArray, ancillaryData.getStartLine());
            netcdfFile.get(protoVariable6.getName()).setInt(nArray, ancillaryData.getStartElem());
            netcdfFile.get(protoVariable14.getName()).setInt(nArray, ancillaryData.getCreationDate());
            netcdfFile.get(protoVariable15.getName()).setInt(nArray, ancillaryData.getCreationTime());
            int n = ancillaryData.getSensorId();
            switch (n) {
                case 70: {
                    string3 = "GOES-8 Imager";
                    break;
                }
                case 71: {
                    string3 = "GOES-8 Sounder";
                    break;
                }
                case 72: {
                    string3 = "GOES-9 Imager";
                    break;
                }
                case 73: {
                    string3 = "GOES-9 Sounder";
                    break;
                }
                case 74: {
                    string3 = "GOES-10 Imager";
                    break;
                }
                case 75: {
                    string3 = "GOES-10 Sounder";
                    break;
                }
                default: {
                    string3 = "unknown";
                }
            }
            int n2 = 0;
            while (n2 < string3.length()) {
                nArray[0] = n2;
                netcdfFile.get(protoVariable2.getName()).setChar(nArray, string3.charAt(n2));
                ++n2;
            }
            nArray[0] = 0;
            netcdfFile.get(protoVariable.getName()).setInt(nArray, ancillaryData.getVersion());
            netcdfFile.get(protoVariable9.getName()).setInt(nArray, ancillaryData.getDataWidth());
            netcdfFile.get(protoVariable12.getName()).setInt(nArray, ancillaryData.getPrefixSize());
            netcdfFile.get(protoVariable13.getName()).setInt(nArray, ancillaryData.getProjectNum());
            int n3 = ancillaryData.getBandMap();
            int n4 = 0;
            int[] nArray2 = new int[ancillaryData.getNumBands()];
            int n5 = 0;
            while (n5 < 32) {
                if ((n3 >> n5 & 1) > 0) {
                    nArray2[n4] = n5 + 1;
                    System.out.println("new band: " + (n5 + 1));
                    ++n4;
                }
                ++n5;
            }
            ArrayMultiArray arrayMultiArray = new ArrayMultiArray(nArray2);
            netcdfFile.get(protoVariable16.getName()).copyin(nArray, arrayMultiArray);
            SensorData sensorData = scienceImage.getSD();
            Sensor sensor = scienceImage.getS();
            Calibrator calibrator = sensor.getC();
            Navigator navigator = sensor.getN();
            calibrator.setCalType(ancillaryData.getCalType());
            float[][][] fArray = new float[ancillaryData.getNumBands()][1][ancillaryData.getNumElements()];
            float[] fArray2 = new float[ancillaryData.getNumElements() * ancillaryData.getNumBands()];
            float[][] fArray3 = new float[1][ancillaryData.getNumElements()];
            float[][] fArray4 = new float[1][ancillaryData.getNumElements()];
            float[][] fArray5 = new float[2][ancillaryData.getNumElements()];
            float[][] fArray6 = new float[2][ancillaryData.getNumElements()];
            int n6 = 0;
            while (n6 < ancillaryData.getNumElements()) {
                fArray5[1][n6] = n6;
                ++n6;
            }
            int[] nArray3 = new int[]{0, 0, 0};
            int[] nArray4 = new int[]{0, 0};
            Variable variable = netcdfFile.get(protoVariable17.getName());
            Variable variable2 = netcdfFile.get(protoVariable18.getName());
            Variable variable3 = netcdfFile.get(protoVariable19.getName());
            int n7 = 0;
            while (n7 < ancillaryData.getNumLines()) {
                int n8;
                System.out.println("Fetching, calibrating, navigating, storing line " + n7 + "...");
                fArray2 = sensorData.nextLine(fArray2);
                int n9 = ancillaryData.getNumBands();
                n4 = 0;
                while (n4 < ancillaryData.getNumBands()) {
                    n8 = 0;
                    while (n8 < ancillaryData.getNumElements()) {
                        fArray[n4][0][n8] = calibrator.calibrate(fArray2[n4 + n8 * n9], nArray2[n4], 2);
                        ++n8;
                    }
                    ++n4;
                }
                nArray3[1] = n7;
                variable.copyin(nArray3, new ArrayMultiArray(fArray));
                n8 = 0;
                while (n8 < ancillaryData.getNumElements()) {
                    fArray5[0][n8] = n7;
                    ++n8;
                }
                if (navigator != null) {
                    fArray6 = navigator.toLatLon(fArray5);
                }
                int n10 = 0;
                while (n10 < ancillaryData.getNumElements()) {
                    fArray3[0][n10] = fArray6[0][n10];
                    fArray4[0][n10] = fArray6[1][n10];
                    ++n10;
                }
                nArray4[0] = n7++;
                variable2.copyin(nArray4, new ArrayMultiArray(fArray3));
                variable3.copyin(nArray4, new ArrayMultiArray(fArray4));
            }
            System.out.println("Closing file and signing off...");
            netcdfFile.close();
            return;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return;
        }
    }
}

