/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;

public class AncillaryData {
    private static final int DIR_SIZE = 64;
    private int numLines;
    private int numElems;
    private int firstImageLine;
    private int firstImageElem;
    private int lineResolution;
    private int elemResolution;
    private int imageDate;
    private int imageTime;
    private int creationDate;
    private int creationTime;
    private int bandCount;
    private int sensorId;
    private int status;
    private int version;
    private int dataWidth;
    private int numBands;
    private int prefixSize;
    private int projectNum;
    private int bandMap;
    private int calType;
    private int navOffset;
    private int calOffset;
    private int datOffset;
    private int[] bands;

    public AncillaryData(DataInputStream dataInputStream) throws IOException {
        int[] nArray = new int[64];
        int n = 0;
        while (n < 64) {
            nArray[n] = dataInputStream.readInt();
            ++n;
        }
        this.numLines = nArray[8];
        this.numElems = nArray[9];
        this.firstImageLine = nArray[5];
        this.firstImageElem = nArray[6];
        this.lineResolution = nArray[11];
        this.elemResolution = nArray[12];
        this.imageDate = nArray[3];
        this.imageTime = nArray[4];
        this.bandCount = nArray[13];
        this.sensorId = nArray[2];
        this.creationDate = nArray[16];
        this.creationTime = nArray[17];
        this.status = nArray[0];
        this.version = nArray[1];
        this.dataWidth = nArray[10];
        this.numBands = nArray[13];
        this.prefixSize = nArray[14];
        this.projectNum = nArray[15];
        this.bandMap = nArray[18];
        this.calType = nArray[52];
        this.navOffset = nArray[34];
        this.calOffset = nArray[62];
        this.datOffset = nArray[33];
    }

    public int getCalType() {
        char[] cArray = new char[]{(char)(this.calType >> 24 & 0xFF), (char)(this.calType >> 16 & 0xFF), (char)(this.calType >> 8 & 0xFF), (char)(this.calType & 0xFF)};
        if (String.valueOf(cArray).equals("RAW ")) {
            System.out.println("determined cal type is RAW");
            return 1;
        }
        if (String.valueOf(cArray).equals("BRIT")) {
            System.out.println("determined cal type is BRIT");
            return 5;
        }
        if (String.valueOf(cArray).equals("TEMP")) {
            System.out.println("determined cal type is TEMP");
            return 4;
        }
        if (String.valueOf(cArray).equals("RAD ")) {
            System.out.println("determined cal type is RAD");
            return 2;
        }
        if (String.valueOf(cArray).equals("ALB")) {
            System.out.println("determined cal type is ALB");
            return 3;
        }
        return -1;
    }

    public int getSensorId() {
        return this.sensorId;
    }

    public int getNumElements() {
        return this.numElems;
    }

    public int getNumLines() {
        return this.numLines;
    }

    public int getStartLine() {
        return this.firstImageLine;
    }

    public int getStartElem() {
        return this.firstImageElem;
    }

    public int getLineRes() {
        return this.lineResolution;
    }

    public int getElemRes() {
        return this.elemResolution;
    }

    public int getImageDate() {
        return this.imageDate;
    }

    public int getImageTime() {
        return this.imageTime;
    }

    public int getCreationDate() {
        return this.creationDate;
    }

    public int getCreationTime() {
        return this.creationTime;
    }

    public int getStatus() {
        return this.status;
    }

    public int getVersion() {
        return this.version;
    }

    public int getDataWidth() {
        return this.dataWidth;
    }

    public int getNumBands() {
        return this.numBands;
    }

    public int getPrefixSize() {
        return this.prefixSize;
    }

    public int getProjectNum() {
        return this.projectNum;
    }

    public int getBandMap() {
        return this.bandMap;
    }

    public int getNavOffset() {
        return this.navOffset;
    }

    public int getCalOffset() {
        return this.calOffset;
    }

    public int getDataOffset() {
        return this.datOffset;
    }
}

