/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.BaseColorControl;
import visad.Control;
import visad.DisplayException;
import visad.VisADException;
import visad.util.ArrowSlider;
import visad.util.BaseRGBMap;
import visad.util.ColorPreview;
import visad.util.SliderLabel;

public class SimpleColorMapWidget
extends JPanel {
    BaseRGBMap baseMap;
    ColorPreview preview;
    ArrowSlider slider;
    private SliderLabel label;

    public SimpleColorMapWidget(String name, float[][] in_table, float min, float max) throws RemoteException, VisADException {
        float[][] table = in_table != null && in_table[0] != null && in_table.length >= 3 && in_table.length <= 4 && in_table[0].length > 4 ? SimpleColorMapWidget.table_reorg(in_table) : in_table;
        if (table != null && (table[0] == null || table[0].length < 3 || table[0].length > 4)) {
            throw new VisADException("Bad initial table");
        }
        this.baseMap = table == null ? new BaseRGBMap(false) : new BaseRGBMap(table);
        this.finishInit(name, min, max);
    }

    public SimpleColorMapWidget(String name, Control ctl, float min, float max) throws RemoteException, VisADException {
        if (ctl == null) {
            throw new DisplayException(this.getClass().getName() + ": Null control");
        }
        if (!(ctl instanceof BaseColorControl)) {
            throw new DisplayException(this.getClass().getName() + ": Control must " + "be BaseColorControl, not " + ctl.getClass().getName());
        }
        this.baseMap = new BaseRGBMap((BaseColorControl)ctl);
        this.finishInit(name, min, max);
    }

    private void finishInit(String name, float min, float max) {
        this.preview = new ColorPreview(this.baseMap);
        this.slider = new ArrowSlider(min, max, (min + max) / 2.0f, name);
        this.label = new SliderLabel(this.slider);
        this.setLayout(new BoxLayout(this, 1));
        this.updateSlider(min, max);
        this.rebuildGUI();
    }

    void rebuildGUI() {
        this.removeAll();
        this.add(this.baseMap);
        this.add(this.preview);
        this.add(this.slider);
        this.add(this.label);
    }

    void updateSlider(float min, float max) {
        float val = this.slider.getValue();
        if (val != val || val <= min || val >= max) {
            val = (min + max) / 2.0f;
        }
        this.slider.setBounds(min, max, val);
    }

    public BaseRGBMap getBaseMap() {
        return this.baseMap;
    }

    public ColorPreview getPreview() {
        return this.preview;
    }

    public ArrowSlider getSlider() {
        return this.slider;
    }

    public void setTable(float[][] table) throws RemoteException, VisADException {
        float[][] newTable = SimpleColorMapWidget.copy_table(table);
        this.baseMap.setValues(newTable);
    }

    static float[][] copy_table(float[][] table) {
        if (table == null || table[0] == null) {
            return null;
        }
        int dim = table.length;
        int len = table[0].length;
        float[][] new_table = new float[dim][len];
        try {
            for (int i = 0; i < dim; ++i) {
                System.arraycopy(table[i], 0, new_table[i], 0, len);
            }
            return new_table;
        }
        catch (ArrayIndexOutOfBoundsException obe) {
            return null;
        }
    }

    static float[][] table_reorg(float[][] table) {
        if (table == null || table[0] == null) {
            return null;
        }
        int dim = table.length;
        int len = table[0].length;
        float[][] out = new float[len][dim];
        try {
            for (int i = 0; i < len; ++i) {
                out[i][0] = table[0][i];
                out[i][1] = table[1][i];
                out[i][2] = table[2][i];
                if (dim <= 3) continue;
                out[i][3] = table[3][i];
            }
        }
        catch (ArrayIndexOutOfBoundsException obe) {
            out = null;
        }
        return out;
    }

    public static void main(String[] args) throws RemoteException, VisADException {
        try {
            JFrame f = new JFrame("Empty SimpleColorMapWidget");
            f.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            SimpleColorMapWidget simple = new SimpleColorMapWidget("Foo", (float[][])null, 0.0f, 1.0f);
            f.getContentPane().add(simple);
            f.pack();
            f.setVisible(true);
            int num = 4;
            int len = 256;
            float[][] table = new float[4][256];
            float step = 0.003921569f;
            float total = 1.0f;
            for (int j = 0; j < 256; ++j) {
                float f2 = total;
                table[2][j] = f2;
                table[1][j] = f2;
                table[0][j] = f2;
                table[3][j] = 1.0f;
                total -= 0.003921569f;
            }
            f = new JFrame("Full SimpleColorMapWidget");
            f.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            simple = new SimpleColorMapWidget("Foo", table, 0.0f, 1.0f);
            f.getContentPane().add(simple);
            f.pack();
            f.setVisible(true);
        }
        catch (VisADException ve) {
            ve.printStackTrace();
        }
    }
}

