/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.ActivityHandler;
import visad.ConstantMap;
import visad.DataDisplayLink;
import visad.DataImpl;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.LocalDisplay;
import visad.ScalarMap;
import visad.VisADException;
import visad.data.DefaultFamily;
import visad.java3d.DisplayImplJ3D;
import visad.util.DualRes;

public class ResSwitcher
extends DualRes
implements ActivityHandler {
    private LocalDisplay display;
    private DataRenderer hi_rend;
    private DataRenderer lo_rend;

    public ResSwitcher(LocalDisplay d, DataReferenceImpl ref) throws VisADException, RemoteException {
        this(d, ref, null, null);
    }

    public ResSwitcher(LocalDisplay d, DataReferenceImpl ref, DataRenderer renderer, ConstantMap[] cmaps) throws VisADException, RemoteException {
        super(ref);
        this.display = d;
        if (renderer == null) {
            this.display.addReference(this.lo_ref, cmaps);
        } else {
            this.display.addReferences(renderer, this.lo_ref, cmaps);
        }
        Vector dataRenderers = this.display.getRendererVector();
        int len = dataRenderers == null ? 0 : dataRenderers.size();
        int flags = 0;
        for (int i = 0; i < len && flags != 3; ++i) {
            DataRenderer rend = (DataRenderer)dataRenderers.elementAt(i);
            DataDisplayLink[] links = rend.getLinks();
            for (int j = 0; j < links.length && flags != 3; ++j) {
                DataReference jref = links[j].getDataReference();
                if (jref == this.hi_ref) {
                    this.hi_rend = rend;
                    flags &= 1;
                    continue;
                }
                if (jref != this.lo_ref) continue;
                this.lo_rend = rend;
                flags &= 2;
            }
        }
        this.display.addActivityHandler(this);
    }

    public void unlink() throws VisADException {
        this.display.removeActivityHandler(this);
    }

    @Override
    public void busyDisplay(LocalDisplay d) {
        if (this.lo_rend != null && this.hi_rend != null) {
            this.lo_rend.toggle(true);
            this.hi_rend.toggle(false);
        }
    }

    @Override
    public void idleDisplay(LocalDisplay d) {
        if (this.lo_rend != null && this.hi_rend != null) {
            this.hi_rend.toggle(true);
            this.lo_rend.toggle(false);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("Please specify a datafile on the command line.");
            return;
        }
        DefaultFamily loader = new DefaultFamily("loader");
        DataImpl d = loader.open(args[0]);
        DisplayImplJ3D display = new DisplayImplJ3D("display");
        ScalarMap[] maps = d.getType().guessMaps(true);
        if (maps != null) {
            for (int i = 0; i < maps.length; ++i) {
                display.addMap(maps[i]);
            }
        }
        DataReferenceImpl ref = new DataReferenceImpl("ref");
        ref.setData(d);
        display.addReference(ref);
        ResSwitcher rs = new ResSwitcher(display, ref);
        if (args.length > 1) {
            try {
                rs.setResolutionScale(Double.parseDouble(args[1]));
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
        }
        JFrame frame = new JFrame("ResSwitcher test");
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setAlignmentY(0.0f);
        p.setAlignmentX(0.0f);
        frame.setContentPane(p);
        p.add(display.getComponent());
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.pack();
        frame.show();
    }
}

