/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.ErrorEstimate;
import visad.Field;
import visad.FieldException;
import visad.FieldImpl;
import visad.FlatField;
import visad.Function;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.GriddedSet;
import visad.Integer2DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.IrregularSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Set;
import visad.SetType;
import visad.Text;
import visad.Tuple;
import visad.TupleIface;
import visad.TupleType;
import visad.TypeException;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADException;
import visad.java2d.DisplayImplJ2D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.util.ImageHelper;

public class DataUtility {
    private static boolean init = false;
    private static FunctionType simpleImageType;
    private static RealType radiance;
    private static RealTupleType imageDomain;
    private static RealType line;
    private static RealType element;
    private int num_lines;
    private int num_elements;

    private static synchronized void makeTypes() throws VisADException {
        if (!init) {
            init = true;
            simpleImageType = (FunctionType)MathType.stringToType("((ImageElement, ImageLine) -> ImageRadiance)");
            imageDomain = simpleImageType.getDomain();
            line = (RealType)imageDomain.getComponent(1);
            element = (RealType)imageDomain.getComponent(0);
            MathType range = simpleImageType.getRange();
            radiance = range instanceof RealType ? (RealType)range : (RealType)((RealTupleType)range).getComponent(0);
        }
    }

    public static FlatField makeImage(float[][] values) throws VisADException, RemoteException {
        if (values == null) {
            return null;
        }
        int nlines = values.length;
        int nelements = 0;
        for (int l = 0; l < nlines; ++l) {
            if (values[l] == null || values[l].length <= nelements) continue;
            nelements = values[l].length;
        }
        if (!init) {
            DataUtility.makeTypes();
        }
        FlatField image = new FlatField(simpleImageType, new Integer2DSet((MathType)imageDomain, nelements, nlines));
        DataUtility.setPixels(image, values);
        return image;
    }

    public static void setPixels(FlatField image, float[][] values) throws VisADException, RemoteException {
        if (values == null) {
            return;
        }
        Integer2DSet set = (Integer2DSet)image.getDomainSet();
        int num_elements = set.getLength(0);
        int num_lines = set.getLength(1);
        float[][] vals = new float[1][num_lines * num_elements];
        for (int i = 0; i < num_lines * num_elements; ++i) {
            vals[0][i] = Float.NaN;
        }
        int nl = values.length;
        if (num_lines < nl) {
            nl = num_lines;
        }
        int base = 0;
        for (int l = 0; l < nl; ++l) {
            if (values[l] != null) {
                int ne = values[l].length;
                if (num_elements < ne) {
                    ne = num_elements;
                }
                for (int e = 0; e < ne; ++e) {
                    vals[0][base + e] = values[l][e];
                }
            }
            base += num_elements;
        }
        image.setSamples(vals, false);
    }

    public static float[][] getPixels(FlatField image) throws VisADException, RemoteException {
        Integer2DSet set = (Integer2DSet)image.getDomainSet();
        int num_elements = set.getLength(0);
        int num_lines = set.getLength(1);
        float[][] values = new float[num_lines][num_elements];
        double[][] vals = image.getValues();
        int base = 0;
        for (int l = 0; l < num_lines; ++l) {
            for (int e = 0; e < num_elements; ++e) {
                values[l][e] = (float)vals[0][base + e];
            }
            base += num_elements;
        }
        return values;
    }

    public static FlatField makeField(Image image) throws IOException, VisADException {
        return DataUtility.makeField(image, false);
    }

    public static FlatField makeField(Image image, boolean withAlpha) throws IOException, VisADException {
        RealType[] realTypeArray;
        if (image == null) {
            throw new VisADException("image cannot be null");
        }
        ImageHelper ih = new ImageHelper();
        int width = -1;
        int height = -1;
        while (true) {
            if (width < 0) {
                width = image.getWidth(ih);
            }
            if (height < 0) {
                height = image.getHeight(ih);
            }
            if (ih.badImage || width >= 0 && height >= 0) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        if (ih.badImage) {
            throw new IOException("Not an image");
        }
        int numPixels = width * height;
        int[] words = new int[numPixels];
        PixelGrabber grabber = new PixelGrabber(image.getSource(), 0, 0, width, height, words, 0, width);
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        ColorModel cm = grabber.getColorModel();
        boolean doAlpha = cm.hasAlpha() && withAlpha;
        float[] red_pix = new float[numPixels];
        float[] green_pix = new float[numPixels];
        float[] blue_pix = new float[numPixels];
        float[] alpha_pix = null;
        for (int i = 0; i < numPixels; ++i) {
            red_pix[i] = cm.getRed(words[i]);
            green_pix[i] = cm.getGreen(words[i]);
            blue_pix[i] = cm.getBlue(words[i]);
        }
        boolean opaque = true;
        if (doAlpha) {
            alpha_pix = new float[numPixels];
            for (int i = 0; i < numPixels; ++i) {
                alpha_pix[i] = cm.getAlpha(words[i]);
                if (alpha_pix[i] == 255.0f) continue;
                opaque = false;
            }
        }
        if (opaque && doAlpha) {
            doAlpha = false;
            alpha_pix = null;
        }
        RealType line = RealType.getRealType("ImageLine");
        RealType element = RealType.getRealType("ImageElement");
        RealType c_red = RealType.getRealType("Red");
        RealType c_green = RealType.getRealType("Green");
        RealType c_blue = RealType.getRealType("Blue");
        RealType c_alpha = RealType.getRealType("Alpha");
        if (doAlpha) {
            RealType[] realTypeArray2 = new RealType[4];
            realTypeArray2[0] = c_red;
            realTypeArray2[1] = c_green;
            realTypeArray2[2] = c_blue;
            realTypeArray = realTypeArray2;
            realTypeArray2[3] = c_alpha;
        } else {
            RealType[] realTypeArray3 = new RealType[3];
            realTypeArray3[0] = c_red;
            realTypeArray3[1] = c_green;
            realTypeArray = realTypeArray3;
            realTypeArray3[2] = c_blue;
        }
        RealType[] c_all = realTypeArray;
        RealTupleType radiance = new RealTupleType(c_all);
        RealType[] domain_components = new RealType[]{element, line};
        RealTupleType image_domain = new RealTupleType(domain_components);
        Linear2DSet domain_set = new Linear2DSet((MathType)image_domain, 0.0, (float)((double)width - 1.0), width, (float)((double)height - 1.0), 0.0, height);
        FunctionType image_type = new FunctionType(image_domain, radiance);
        FlatField field = new FlatField(image_type, domain_set);
        float[][] samples = new float[doAlpha ? 4 : 3][];
        samples[0] = red_pix;
        samples[1] = green_pix;
        samples[2] = blue_pix;
        if (doAlpha) {
            samples[3] = alpha_pix;
        }
        try {
            field.setSamples(samples, false);
        }
        catch (RemoteException e) {
            throw new VisADException("Couldn't finish image initialization");
        }
        return field;
    }

    public static Image extractImage(FlatField field, boolean reverse) {
        try {
            int len;
            GriddedSet set = (GriddedSet)field.getDomainSet();
            int[] wh = set.getLengths();
            int w = wh[0];
            int h = wh[1];
            double[][] samples = field.getValues();
            int[] pixels = new int[samples[0].length];
            if (samples.length == 3) {
                len = samples[0].length;
                for (int i = 0; i < len; ++i) {
                    int r = (int)samples[0][i] & 0xFF;
                    int g = (int)samples[1][i] & 0xFF;
                    int b = (int)samples[2][i] & 0xFF;
                    int index = reverse ? len - i - 1 : i;
                    pixels[index] = r << 16 | g << 8 | b;
                }
            } else {
                len = samples[0].length;
                for (int i = 0; i < len; ++i) {
                    int v = (int)samples[0][i] & 0xFF;
                    int index = reverse ? len - i - 1 : i;
                    pixels[index] = v << 16 | v << 8 | v;
                }
            }
            MemoryImageSource source = new MemoryImageSource(w, h, (ColorModel)new DirectColorModel(24, 0xFF0000, 65280, 255), pixels, 0, w);
            source.setFullBufferUpdates(true);
            return Toolkit.getDefaultToolkit().createImage(source);
        }
        catch (VisADException exc) {
            return null;
        }
    }

    public static FlatField[] getImageFields(Data data) {
        FlatField[] fields = null;
        String pcImageType = "((e, l) -> v)";
        String rgbImageType = "((e, l) -> (r, g, b))";
        String pcTimeType = "(t -> " + pcImageType + ")";
        String rgbTimeType = "(t -> " + rgbImageType + ")";
        try {
            MathType type = data.getType();
            if (type.equalsExceptName(MathType.stringToType(pcTimeType)) || type.equalsExceptName(MathType.stringToType(rgbTimeType))) {
                FieldImpl fi = (FieldImpl)data;
                int len = fi.getLength();
                fields = new FlatField[len];
                for (int i = 0; i < len; ++i) {
                    fields[i] = (FlatField)fi.getSample(i);
                }
            } else if (type.equalsExceptName(MathType.stringToType(pcImageType)) || type.equalsExceptName(MathType.stringToType(rgbImageType))) {
                fields = new FlatField[]{(FlatField)data};
            }
        }
        catch (VisADException exc) {
        }
        catch (RemoteException exc) {
            // empty catch block
        }
        return fields;
    }

    public static DisplayImpl makeSimpleDisplay(DataImpl data) throws VisADException, RemoteException {
        boolean three_d = true;
        DisplayImpl display = null;
        try {
            display = new DisplayImplJ3D("simple data display");
        }
        catch (UnsatisfiedLinkError e) {
            display = new DisplayImplJ2D("simple data display");
            three_d = false;
        }
        MathType type = data.getType();
        ScalarMap[] maps = type.guessMaps(three_d);
        if (maps == null) {
            display.stop();
            return null;
        }
        if (three_d) {
            boolean only_2d = true;
            for (int i = 0; i < maps.length; ++i) {
                DisplayRealType dtype = maps[i].getDisplayScalar();
                if (!Display.ZAxis.equals(maps[i]) && !Display.Latitude.equals(maps[i])) continue;
                only_2d = false;
                break;
            }
            if (only_2d) {
                display.destroy();
                display = new DisplayImplJ3D("simple data display", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
            }
        }
        for (int i = 0; i < maps.length; ++i) {
            display.addMap(maps[i]);
        }
        DataReferenceImpl ref = new DataReferenceImpl("simple data display");
        ref.setData(data);
        display.addReference(ref);
        return display;
    }

    public static void main(String[] argv) throws VisADException, RemoteException {
        float[][] pixels = new float[64][64];
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                pixels[i][j] = i * (i - 32) * (i - 64) * j * (j - 32) * (j - 64) + 100000;
            }
        }
        FlatField image = DataUtility.makeImage(pixels);
        DisplayImpl display = DataUtility.makeSimpleDisplay(image);
        JFrame jframe = new JFrame("SimplImage.main");
        jframe.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        jframe.setContentPane((JPanel)display.getComponent());
        jframe.pack();
        jframe.setVisible(true);
    }

    public static RealTupleType ensureRealTupleType(MathType type) throws TypeException, VisADException {
        RealTupleType result;
        if (type instanceof RealTupleType) {
            result = (RealTupleType)type;
        } else if (type instanceof RealType) {
            result = new RealTupleType((RealType)type);
        } else if (type instanceof SetType) {
            result = ((SetType)type).getDomain();
        } else {
            throw new TypeException(DataUtility.class.getName() + ".ensureRealTupleType(MathType): Can't convert MathType \"" + type + "\" into a RealTupleType");
        }
        return result;
    }

    public static TupleType ensureTupleType(MathType type) throws VisADException {
        return type instanceof TupleType ? (TupleType)type : (type instanceof SetType ? ((SetType)type).getDomain() : (type instanceof RealType ? new RealTupleType((RealType)type) : new TupleType(new MathType[]{type})));
    }

    public static TupleIface ensureTuple(Data datum) throws VisADException, RemoteException {
        return datum instanceof TupleIface ? (TupleIface)datum : (datum instanceof Real ? new RealTuple(new Real[]{(Real)datum}) : new Tuple(new Data[]{datum}));
    }

    public static RealTupleType getDomainType(Set set) {
        return ((SetType)set.getType()).getDomain();
    }

    public static RealTupleType getDomainType(Function function) throws VisADException, RemoteException {
        return ((FunctionType)function.getType()).getDomain();
    }

    public static MathType getRangeType(Function function) throws VisADException, RemoteException {
        return ((FunctionType)function.getType()).getRange();
    }

    public static TupleType getRangeTupleType(Function function) throws VisADException, RemoteException {
        return DataUtility.ensureTupleType(DataUtility.getRangeType(function));
    }

    public static RealTupleType getFlatRangeType(Function function) throws VisADException, RemoteException {
        return ((FunctionType)function.getType()).getFlatRange();
    }

    public static int getRangeDimension(Function function) throws VisADException, RemoteException {
        return DataUtility.getRangeTupleType(function).getDimension();
    }

    public static int getComponentIndex(TupleType tupleType, MathType componentType) throws VisADException, RemoteException {
        int i = tupleType.getDimension();
        while (--i >= 0) {
            if (!componentType.equals(tupleType.getComponent(i))) continue;
            return i;
        }
        i = tupleType.getDimension();
        while (--i >= 0) {
            if (!componentType.equalsExceptNameButUnits(tupleType.getComponent(i))) continue;
            return i;
        }
        return -1;
    }

    public static int getComponentIndex(Set set, MathType componentType) throws VisADException, RemoteException {
        return DataUtility.getComponentIndex(((SetType)set.getType()).getDomain(), componentType);
    }

    public static int getComponentIndex(Function function, MathType componentType) throws VisADException, RemoteException {
        return DataUtility.getComponentIndex(DataUtility.getRangeTupleType(function), componentType);
    }

    public static Field ensureRange(Field field, MathType newRangeType) throws UnimplementedException, TypeException, VisADException, RemoteException {
        Field result;
        if (newRangeType.equals(DataUtility.getRangeType(field))) {
            result = field;
        } else if (newRangeType instanceof RealType) {
            int componentIndex = DataUtility.getComponentIndex(field, newRangeType);
            result = componentIndex >= 0 ? field.extract(componentIndex) : new FlatField(new FunctionType(DataUtility.getDomainType(field), newRangeType), field.getDomainSet());
        } else if (newRangeType instanceof RealTupleType) {
            int realTupleIndex = DataUtility.getComponentIndex(field, newRangeType);
            if (realTupleIndex >= 0) {
                result = (FlatField)field.extract(realTupleIndex);
            } else {
                RealTupleType newRangeRealTupleType = (RealTupleType)newRangeType;
                int componentCount = newRangeRealTupleType.getDimension();
                ArrayList<Field> flatFields = new ArrayList<Field>(componentCount);
                for (int i = 0; i < componentCount; ++i) {
                    int componentIndex = DataUtility.getComponentIndex(field, newRangeRealTupleType.getComponent(i));
                    if (componentIndex < 0) continue;
                    flatFields.add(field.extract(componentIndex));
                }
                result = flatFields.size() != componentCount ? new FlatField(new FunctionType(DataUtility.getDomainType(field), newRangeType), field.getDomainSet()) : (FlatField)FieldImpl.combine(flatFields.toArray(new FlatField[componentCount]));
            }
        } else {
            if (newRangeType instanceof TupleType) {
                throw new UnimplementedException("Can't yet create Field with range " + newRangeType + " from existing Field");
            }
            throw new TypeException("Can't create Field with range " + newRangeType);
        }
        return result;
    }

    public static Field consolidate(Field[] fields) throws FieldException, TypeException, VisADException, RemoteException {
        ArrayList<Field> validFields = new ArrayList<Field>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (field.isMissing()) continue;
            validFields.add(field);
        }
        if (validFields.size() == 0) {
            throw new FieldException(DataUtility.class.getName() + "(Field[]): Zero fields to consolidate");
        }
        FunctionType funcType = (FunctionType)fields[0].getType();
        TreeSet<ReferencedDomainPoint> consolidatedDomainTuples = new TreeSet<ReferencedDomainPoint>();
        for (Field field : validFields) {
            if (!field.getType().equals(funcType)) {
                throw new TypeException("Field type mismatch");
            }
            Enumeration en = field.domainEnumeration();
            while (en.hasMoreElements()) {
                consolidatedDomainTuples.add(new ReferencedDomainPoint((RealTuple)en.nextElement(), field));
            }
        }
        Field field = fields[0];
        float[][] domainFloats = new float[field.getDomainDimension()][consolidatedDomainTuples.size()];
        Unit[] domainUnits = field.getDomainUnits();
        int sampleIndex = 0;
        Iterator iter = consolidatedDomainTuples.iterator();
        while (iter.hasNext()) {
            RealTuple domainTuple = ((ReferencedDomainPoint)iter.next()).sample;
            int i = domainFloats.length;
            while (--i >= 0) {
                domainFloats[i][sampleIndex] = (float)((Real)domainTuple.getComponent(i)).getValue(domainUnits[i]);
            }
            ++sampleIndex;
        }
        SampledSet consolidatedDomain = domainFloats.length == 1 ? new Gridded1DSet((MathType)DataUtility.getDomainType(field), domainFloats, domainFloats[0].length, (CoordinateSystem)null, field.getDomainUnits(), (ErrorEstimate[])null) : (domainFloats.length == 2 ? new Irregular2DSet(DataUtility.getDomainType(field), domainFloats, null, field.getDomainUnits(), null, null) : (domainFloats.length == 3 ? new Irregular3DSet(DataUtility.getDomainType(field), domainFloats, null, field.getDomainUnits(), null, null) : new IrregularSet((MathType)DataUtility.getDomainType(field), domainFloats, (CoordinateSystem)null, field.getDomainUnits(), (ErrorEstimate[])null)));
        FieldImpl consolidatedField = field instanceof FlatField ? new FlatField(funcType, consolidatedDomain) : new FieldImpl(funcType, consolidatedDomain);
        for (ReferencedDomainPoint point : consolidatedDomainTuples) {
            RealTuple domainTuple = point.sample;
            consolidatedField.setSample(domainTuple, point.field.evaluate(domainTuple));
        }
        return consolidatedField;
    }

    public static GriddedSet createGriddedSet(FlatField field, boolean copy) throws VisADException, RemoteException {
        int i;
        int domainRank = field.getDomainDimension();
        int flatRangeRank = field.getRangeDimension();
        RealType[] realTypes = new RealType[domainRank + flatRangeRank];
        RealTupleType tupleType = DataUtility.getDomainType(field);
        for (i = 0; i < domainRank; ++i) {
            realTypes[i] = (RealType)tupleType.getComponent(i);
        }
        tupleType = DataUtility.getFlatRangeType(field);
        for (i = 0; i < flatRangeRank; ++i) {
            realTypes[domainRank + i] = (RealType)tupleType.getComponent(i);
        }
        float[][] samples = new float[realTypes.length][field.getLength()];
        System.arraycopy(field.getDomainSet().getSamples(), 0, samples, 0, domainRank);
        System.arraycopy(field.getFloats(copy), 0, samples, domainRank, flatRangeRank);
        int[] lengths = new int[samples.length];
        int i2 = samples.length;
        while (--i2 >= 0) {
            lengths[i2] = samples[i2].length;
        }
        Unit[] units = new Unit[realTypes.length];
        System.arraycopy(field.getDomainUnits(), 0, units, 0, domainRank);
        System.arraycopy(field.getDefaultRangeUnits(), 0, units, domainRank, flatRangeRank);
        return GriddedSet.create(new RealTupleType(realTypes), samples, lengths, null, units, null);
    }

    public static MathType simplify(MathType type) throws VisADException {
        while (type instanceof TupleType && ((TupleType)type).getDimension() == 1) {
            type = ((TupleType)type).getComponent(0);
        }
        return type;
    }

    public static int getRealTypes(Data data, Vector v) throws VisADException, RemoteException {
        return DataUtility.getRealTypes(new Data[]{data}, v, true, false);
    }

    public static int getRealTypes(Data[] data, Vector v, boolean keepDupl, boolean doCoordSys) throws VisADException, RemoteException {
        int dupl = DataUtility.getScalarTypes(data, v, keepDupl, doCoordSys);
        int i = 0;
        while (i < v.size()) {
            ScalarType st = (ScalarType)v.elementAt(i);
            if (!(st instanceof RealType)) {
                v.remove(i);
                continue;
            }
            ++i;
        }
        return dupl;
    }

    public static int getScalarTypes(Data data, Vector v) throws VisADException, RemoteException {
        return DataUtility.getScalarTypes(new Data[]{data}, v, true, false);
    }

    public static int getScalarTypes(Data[] data, Vector v, boolean keepDupl, boolean doCoordSys) throws VisADException, RemoteException {
        int i;
        Vector coord = doCoordSys ? new Vector() : null;
        int[] dupl = new int[]{0};
        for (i = 0; i < data.length; ++i) {
            Data d = data[i];
            if (d == null) continue;
            MathType type = d.getType();
            DataUtility.parse(type, v, dupl, keepDupl, coord);
        }
        if (coord != null) {
            for (i = 0; i < coord.size(); ++i) {
                Object o = coord.elementAt(i);
                boolean c = v.contains(o);
                if (c) {
                    dupl[0] = dupl[0] + 1;
                }
                if (!keepDupl && c) continue;
                v.add(o);
            }
        }
        return dupl[0];
    }

    private static void parse(MathType mathType, Vector v, int[] i, boolean keepDupl, Vector coord) throws VisADException {
        if (mathType instanceof FunctionType) {
            DataUtility.parseFunction((FunctionType)mathType, v, i, keepDupl, coord);
        } else if (mathType instanceof SetType) {
            DataUtility.parseSet((SetType)mathType, v, i, keepDupl, coord);
        } else if (mathType instanceof TupleType) {
            DataUtility.parseTuple((TupleType)mathType, v, i, keepDupl, coord);
        } else {
            DataUtility.parseScalar((ScalarType)mathType, v, i, keepDupl);
        }
    }

    private static void parseFunction(FunctionType mathType, Vector v, int[] i, boolean keepDupl, Vector coord) throws VisADException {
        RealTupleType domain = mathType.getDomain();
        DataUtility.parseTuple(domain, v, i, keepDupl, coord);
        MathType range = mathType.getRange();
        DataUtility.parse(range, v, i, keepDupl, coord);
    }

    private static void parseSet(SetType mathType, Vector v, int[] i, boolean keepDupl, Vector coord) throws VisADException {
        RealTupleType domain = mathType.getDomain();
        DataUtility.parseTuple(domain, v, i, keepDupl, coord);
    }

    private static void parseTuple(TupleType mathType, Vector v, int[] i, boolean keepDupl, Vector coord) throws VisADException {
        RealTupleType realTupleType;
        CoordinateSystem coordSys;
        for (int j = 0; j < mathType.getDimension(); ++j) {
            MathType cType = mathType.getComponent(j);
            if (cType == null) continue;
            DataUtility.parse(cType, v, i, keepDupl, coord);
        }
        if (mathType instanceof RealTupleType && coord != null && (coordSys = (realTupleType = (RealTupleType)mathType).getCoordinateSystem()) != null) {
            RealType rType;
            int j;
            RealTupleType ref = coordSys.getReference();
            for (j = 0; j < realTupleType.getDimension(); ++j) {
                rType = (RealType)realTupleType.getComponent(j);
                DataUtility.parseScalar(rType, coord, new int[1], keepDupl);
            }
            for (j = 0; j < ref.getDimension(); ++j) {
                rType = (RealType)ref.getComponent(j);
                DataUtility.parseScalar(rType, coord, new int[1], keepDupl);
            }
        }
    }

    private static void parseScalar(ScalarType mathType, Vector v, int[] i, boolean keepDupl) {
        if (v.contains(mathType)) {
            if (keepDupl) {
                v.add(mathType);
            }
            i[0] = i[0] + 1;
        } else {
            v.add(mathType);
        }
    }

    public static ScalarMap[] guessMaps(MathType[] types, boolean allow3d) {
        int len = types.length;
        ScalarMap[] maps = null;
        for (int i = 0; i < len; ++i) {
            MathType t = types[i];
            if (t != null) {
                maps = t.guessMaps(allow3d);
            }
            if (maps != null) break;
        }
        return maps;
    }

    public static String convertMapsToString(Vector v) {
        int len = v.size();
        ScalarMap[] sm = new ScalarMap[len];
        for (int i = 0; i < len; ++i) {
            sm[i] = (ScalarMap)v.elementAt(i);
        }
        return DataUtility.convertMapsToString(sm);
    }

    public static String convertMapsToString(ScalarMap[] sm) {
        StringBuffer sb = new StringBuffer(128);
        for (int i = 0; i < sm.length; ++i) {
            ScalarMap m = sm[i];
            ScalarType domain = m.getScalar();
            DisplayRealType range = m.getDisplayScalar();
            int q = -1;
            for (int j = 0; j < Display.DisplayRealArray.length; ++j) {
                if (!range.equals(Display.DisplayRealArray[j])) continue;
                q = j;
            }
            sb.append(' ');
            sb.append(domain.getName());
            sb.append(' ');
            sb.append(q);
        }
        return sb.toString();
    }

    public static ScalarMap[] convertStringToMaps(String mapString, Data data, boolean showErrors) {
        return DataUtility.convertStringToMaps(mapString, new Data[]{data}, showErrors);
    }

    public static ScalarMap[] convertStringToMaps(String mapString, Data[] data, boolean showErrors) {
        Vector types = new Vector();
        for (int i = 0; i < data.length; ++i) {
            try {
                DataUtility.getScalarTypes(data[i], types);
                continue;
            }
            catch (VisADException exc) {
                if (!showErrors) continue;
                System.out.println("Warning: could not extract ScalarTypes from Data object.");
                continue;
            }
            catch (RemoteException exc) {
                if (!showErrors) continue;
                System.out.println("Warning: could not extract ScalarTypes from Data object.");
            }
        }
        return DataUtility.convertStringToMaps(mapString, types, showErrors);
    }

    public static ScalarMap[] convertStringToMaps(String mapString, Vector types, boolean showErrors) {
        int len;
        if (mapString == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(mapString);
        Vector<String> dnames = new Vector<String>();
        Vector<Integer> rnames = new Vector<Integer>();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (!st.hasMoreTokens()) {
                if (!showErrors) continue;
                System.err.println("Warning: trailing maps value " + s + " has no corresponding number and will be ignored");
                continue;
            }
            String si = st.nextToken();
            Integer i = null;
            try {
                i = new Integer(Integer.parseInt(si));
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
            if (i == null) {
                if (!showErrors) continue;
                System.err.println("Warning: maps value " + si + " is not a " + "valid integer and the maps pair (" + s + ", " + si + ") " + "will be ignored");
                continue;
            }
            dnames.add(s);
            rnames.add(i);
        }
        if (dnames != null && (len = dnames.size()) > 0) {
            int vLen = types.size();
            int dLen = Display.DisplayRealArray.length;
            ScalarMap[] maps = new ScalarMap[len];
            for (int j = 0; j < len; ++j) {
                ScalarType mapDomain = null;
                String name = (String)dnames.elementAt(j);
                for (int k = 0; k < vLen; ++k) {
                    ScalarType type = (ScalarType)types.elementAt(k);
                    if (!name.equals(type.getName())) continue;
                    mapDomain = type;
                    break;
                }
                if (mapDomain == null) {
                    mapDomain = ScalarType.getScalarTypeByName(name);
                }
                int q = (Integer)rnames.elementAt(j);
                DisplayRealType mapRange = null;
                if (q >= 0 && q < dLen) {
                    mapRange = Display.DisplayRealArray[q];
                }
                if (mapDomain == null || mapRange == null) {
                    if (showErrors) {
                        System.err.print("Warning: maps pair (" + name + ", " + q + ") has an invalid ");
                        if (mapDomain == null && mapRange == null) {
                            System.err.print("domain and range");
                        } else if (mapDomain == null) {
                            System.err.print("domain");
                        } else {
                            System.err.print("range");
                        }
                        System.err.println(" and will be ignored");
                    }
                    maps[j] = null;
                    continue;
                }
                try {
                    maps[j] = new ScalarMap(mapDomain, mapRange);
                    continue;
                }
                catch (VisADException exc) {
                    if (showErrors) {
                        System.err.println("Warning: maps pair (" + name + ", " + q + ") cannot be converted to a ScalarMap");
                    }
                    maps[j] = null;
                }
            }
            return maps;
        }
        return null;
    }

    public static Tuple stringsToTuple(String[] s) {
        return DataUtility.stringsToTuple(s, false);
    }

    public static Tuple stringsToTuple(String[] s, boolean printStackTraces) {
        block7: {
            try {
                if (s == null) {
                    return null;
                }
                int len = s.length;
                if (len == 0) {
                    return null;
                }
                Data[] text = new Text[len];
                for (int i = 0; i < len; ++i) {
                    text[i] = new Text(s[i]);
                }
                Tuple tuple = new Tuple(text);
                return tuple;
            }
            catch (VisADException exc) {
                if (printStackTraces) {
                    exc.printStackTrace();
                }
            }
            catch (RemoteException exc) {
                if (!printStackTraces) break block7;
                exc.printStackTrace();
            }
        }
        return null;
    }

    public static String[] tupleToStrings(Tuple t) {
        return DataUtility.tupleToStrings(t, false);
    }

    public static String[] tupleToStrings(Tuple t, boolean printStackTraces) {
        block6: {
            if (t == null) {
                return null;
            }
            int len = t.getDimension();
            try {
                String[] errors = new String[len];
                for (int i = 0; i < len; ++i) {
                    Text text = (Text)t.getComponent(i);
                    errors[i] = text.getValue();
                }
                return errors;
            }
            catch (VisADException exc) {
                if (printStackTraces) {
                    exc.printStackTrace();
                }
            }
            catch (RemoteException exc) {
                if (!printStackTraces) break block6;
                exc.printStackTrace();
            }
        }
        return null;
    }

    public static boolean isSerializable(Object obj) {
        return DataUtility.isSerializable(obj, false);
    }

    public static boolean isSerializable(Object obj, boolean printStackTraces) {
        ObjectInputStream inStream;
        ObjectOutputStream outStream;
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        try {
            outStream = new ObjectOutputStream(outBytes);
        }
        catch (IOException ioe) {
            if (printStackTraces) {
                ioe.printStackTrace();
            }
            return false;
        }
        try {
            outStream.writeObject(obj);
            outStream.flush();
        }
        catch (IOException ioe) {
            if (printStackTraces) {
                ioe.printStackTrace();
            }
            return false;
        }
        ByteArrayInputStream inBytes = new ByteArrayInputStream(outBytes.toByteArray());
        try {
            outStream.close();
            outBytes.close();
        }
        catch (IOException ioe) {
            if (printStackTraces) {
                ioe.printStackTrace();
            }
            return false;
        }
        try {
            inStream = new ObjectInputStream(inBytes);
        }
        catch (IOException ioe) {
            if (printStackTraces) {
                ioe.printStackTrace();
            }
            return false;
        }
        try {
            Object obj2 = inStream.readObject();
        }
        catch (IOException ioe) {
            if (printStackTraces) {
                ioe.printStackTrace();
            }
            return false;
        }
        catch (ClassNotFoundException cnfe) {
            if (printStackTraces) {
                cnfe.printStackTrace();
            }
            return false;
        }
        try {
            inStream.close();
            inBytes.close();
        }
        catch (IOException ioe) {
            if (printStackTraces) {
                ioe.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public static DataImpl makeLocal(Data data) {
        return DataUtility.makeLocal(data, false);
    }

    public static DataImpl makeLocal(Data data, boolean printStackTraces) {
        block5: {
            try {
                if (data != null) {
                    return data.local();
                }
            }
            catch (VisADException exc) {
                if (printStackTraces) {
                    exc.printStackTrace();
                }
            }
            catch (RemoteException exc) {
                if (!printStackTraces) break block5;
                exc.printStackTrace();
            }
        }
        return null;
    }

    public static RealTuple getSample(Set set, int index) throws VisADException, RemoteException {
        RealTuple sample;
        RealTupleType realTupleType = ((SetType)set.getType()).getDomain();
        double[][] values = Unit.convertTuple(set.indexToDouble(new int[]{index}), set.getSetUnits(), realTupleType.getDefaultUnits());
        if (index < 0 || index >= set.getLength()) {
            sample = new RealTuple(realTupleType);
        } else {
            double[] doubles = new double[values.length];
            int i = doubles.length;
            while (--i >= 0) {
                doubles[i] = values[i][0];
            }
            sample = new RealTuple(realTupleType, doubles);
        }
        return sample;
    }

    public static Unit[] getRangeUnits(FlatField field) {
        Unit[][] units = field.getRangeUnits();
        Unit[] result = new Unit[units.length];
        int i = result.length;
        while (--i >= 0) {
            result[i] = units[i][0];
        }
        return result;
    }

    public static RealType getUniqueRealType(String name, Unit unit) {
        return DataUtility.getUniqueRealType(name, unit, null, 0);
    }

    public static RealType getUniqueRealType(String name, Unit unit, Set set, int attrMask) {
        RealType type = RealType.getRealType(name, unit, set, attrMask);
        if (type == null) {
            String newname = DataUtility.cleanTypeName(name) + "[unit:" + (unit == null ? "null" : DataUtility.cleanTypeName(unit.toString())) + "]";
            type = RealType.getRealType(newname, unit, set, attrMask);
        }
        return type;
    }

    public static String cleanTypeName(String name) {
        name = name.replace('.', '_');
        name = name.replace(",", "_");
        name = name.replace("-", "_");
        name = name.replace("*", "_");
        name = name.replace(' ', '_');
        name = name.replace('(', '[');
        name = name.replace(')', ']');
        while (name.indexOf("__") >= 0) {
            name = name.replace("__", "_");
        }
        return name;
    }

    private static class ReferencedDomainPoint
    implements Comparable {
        protected final RealTuple sample;
        protected final Field field;

        public ReferencedDomainPoint(RealTuple sample, Field field) {
            this.sample = sample;
            this.field = field;
        }

        public int compareTo(Object obj) {
            return RealTupleComparator.INSTANCE.compare(this.sample, ((ReferencedDomainPoint)obj).sample);
        }
    }

    public static final class RealTupleComparator
    implements Comparator {
        public static final RealTupleComparator INSTANCE = new RealTupleComparator();

        private RealTupleComparator() {
        }

        public int compare(Object obj1, Object obj2) throws ClassCastException {
            RealTuple realTuple1 = (RealTuple)obj1;
            RealTuple realTuple2 = (RealTuple)obj2;
            try {
                int rank = realTuple1.getDimension();
                int comp = 0;
                int i = rank;
                while (--i >= 0 && comp == 0) {
                    comp = ((Real)realTuple1.getComponent(i)).compareTo((Real)realTuple2.getComponent(i));
                }
                return comp;
            }
            catch (Exception e) {
                String reason = e.getMessage();
                throw new ClassCastException("Can't compare RealTuple-s" + (reason == null ? "" : ": " + reason));
            }
        }
    }
}

