/*
 * Decompiled with CFR 0.152.
 */
package visad.python;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import visad.VisADException;
import visad.python.RunJPython;
import visad.util.CodeEditor;
import visad.util.ExtensionFileFilter;

public class JPythonEditor
extends CodeEditor {
    private static final String PREPENDED_TEXT = "from visad.python.JPythonMethods import *";
    private static final Font MONO_FONT = new Font("Monospaced", 0, 11);
    protected RunJPython python = new RunJPython();
    protected boolean warnBeforeSave = true;
    protected boolean runSeparate = true;
    private JMenuItem runItem;

    public static String[] runCommand(String cmd) throws IOException, VisADException {
        String str;
        ArrayList<String> list = new ArrayList<String>();
        Process proc = Runtime.getRuntime().exec(cmd);
        InputStream istr = proc.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(istr));
        while ((str = br.readLine()) != null) {
            list.add(str);
        }
        try {
            proc.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        br.close();
        if (proc.exitValue() != 0) {
            throw new VisADException("exit value was non-zero");
        }
        return list.toArray(new String[0]);
    }

    public JPythonEditor() throws VisADException {
        this((String)null);
    }

    public JPythonEditor(String filename) throws VisADException {
        super(filename);
    }

    @Override
    protected JFileChooser doMakeFileChooser() {
        JFileChooser tmpFileChooser = super.doMakeFileChooser();
        tmpFileChooser.addChoosableFileFilter(new ExtensionFileFilter("py", "JPython source code"));
        return tmpFileChooser;
    }

    private String handleError(String err, String filename) {
        Container c;
        String toLine;
        StringTokenizer st = new StringTokenizer(err, "\r\n");
        StringBuffer sbuf = new StringBuffer(err.length());
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            int tab = line.indexOf("\t");
            while (tab >= 0) {
                line = line.substring(0, tab) + "        " + line.substring(tab + 1);
                tab = line.indexOf("\t");
            }
            sbuf.append(line + "\n");
        }
        String nerr = sbuf.toString();
        int index = nerr.indexOf((toLine = filename + "\", ") + "line ");
        if (index >= 0) {
            int nline = nerr.indexOf("\n", index += toLine.length() + 5);
            int lineNum = -1;
            try {
                lineNum = Integer.parseInt(nerr.substring(index, nline));
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
            if (--lineNum >= 1) {
                this.highlightLine(lineNum);
                nerr = nerr.substring(0, index) + lineNum + nerr.substring(nline);
            }
        }
        final JDialog dialog = (c = this.getRootPane().getParent()) instanceof Dialog ? new JDialog((Dialog)c, "JPython script error", true) : (c instanceof Frame ? new JDialog((Frame)c, "JPython script error", true) : new JDialog((Frame)null, "JPython script error", true));
        JLabel label = new JLabel("An error in the script occurred:");
        label.setAlignmentX(0.5f);
        JTextArea area = new JTextArea(nerr, 16, 80);
        area.setEditable(false);
        area.setFont(MONO_FONT);
        area.setWrapStyleWord(true);
        JButton button = new JButton("OK");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.hide();
            }
        });
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(label);
        p.add(area);
        p.add(button);
        dialog.setContentPane(p);
        dialog.pack();
        dialog.show();
        return nerr;
    }

    @Override
    public void exec(String line) throws VisADException {
        this.python.exec(line);
    }

    public void execfile(String filename) throws VisADException {
        try {
            this.python.execfile(filename);
        }
        catch (VisADException exc) {
            String error = this.handleError(exc.getMessage(), filename);
            throw new VisADException(error);
        }
    }

    @Override
    public String getText() {
        return PREPENDED_TEXT + System.getProperty("line.separator") + super.getText();
    }

    @Override
    public void setText(String text) {
        if (text.startsWith(PREPENDED_TEXT)) {
            text = text.substring(PREPENDED_TEXT.length()).trim();
        }
        super.setText(text);
    }

    public void setWarnBeforeSave(boolean warn) {
        this.warnBeforeSave = warn;
    }

    public void setRunSeparateProcess(boolean separate) {
        this.runSeparate = separate;
    }

    public void setRunItem(JMenuItem run) {
        this.runItem = run;
    }

    @Override
    public void run() {
        if (this.hasChanged()) {
            int ans;
            if (this.warnBeforeSave && (ans = JOptionPane.showConfirmDialog(this, "A save is required before execution. Okay to save?", "VisAD JPython Editor", 0)) != 0) {
                return;
            }
            boolean success = this.saveFile();
            if (!success) {
                return;
            }
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                String name = JPythonEditor.this.getFilename();
                if (JPythonEditor.this.runSeparate) {
                    try {
                        String[] out = JPythonEditor.runCommand("java visad.python.RunJPython " + name);
                    }
                    catch (IOException exc) {
                    }
                    catch (VisADException exc) {
                        String error = JPythonEditor.this.handleError(exc.getMessage(), name);
                    }
                } else {
                    JPythonEditor.this.runItem.setEnabled(false);
                    JPythonEditor.this.runItem.setText("Running...");
                    try {
                        JPythonEditor.this.execfile(name);
                    }
                    catch (VisADException visADException) {
                        // empty catch block
                    }
                    JPythonEditor.this.runItem.setText("Run");
                    JPythonEditor.this.runItem.setEnabled(true);
                }
            }
        });
        t.start();
    }

    @Override
    public void compile() throws VisADException {
        throw new VisADException("Not yet implemented!");
    }
}

