/*
 * Decompiled with CFR 0.152.
 */
package visad.meteorology;

import java.rmi.RemoteException;
import visad.Data;
import visad.DateTime;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.Real;
import visad.RealTuple;
import visad.RealType;
import visad.SampledSet;
import visad.SingletonSet;
import visad.VisADException;
import visad.meteorology.ImageSequence;
import visad.meteorology.SingleBandedImage;
import visad.util.DataUtility;

public class ImageSequenceImpl
extends FieldImpl
implements ImageSequence {
    public ImageSequenceImpl(FunctionType type, SingleBandedImage[] images) throws VisADException, RemoteException {
        super(ImageSequenceImpl.ensureFunctionType(type), ImageSequenceImpl.makeDomainSet(images));
        FunctionType rangeType = (FunctionType)type.getRange();
        for (int i = 0; i < images.length; ++i) {
            RealTuple timeTuple = new RealTuple(new Real[]{images[i].getStartTime()});
            FunctionType imageRange = (FunctionType)images[i].getType();
            SingleBandedImage image = imageRange.equals(rangeType) ? images[i] : (SingleBandedImage)images[i].changeMathType(rangeType);
            this.setSample(timeTuple, (Data)image, false);
        }
    }

    public ImageSequenceImpl(SingleBandedImage[] images) throws VisADException, RemoteException {
        this(new FunctionType(RealType.Time, (FunctionType)images[0].getType()), images);
    }

    private static SampledSet makeDomainSet(SingleBandedImage[] images) throws VisADException, RemoteException {
        if (images == null) {
            throw new VisADException("images can't be null");
        }
        DateTime[] startTimes = new DateTime[images.length];
        for (int i = 0; i < images.length; ++i) {
            startTimes[i] = images[i].getStartTime();
        }
        return startTimes.length > 1 ? DateTime.makeTimeSet(startTimes) : new SingletonSet(new RealTuple(new Real[]{startTimes[0]}));
    }

    @Override
    public DateTime[] getImageTimes() throws VisADException {
        DateTime[] times = null;
        times = this.getDomainSet().getLength() > 1 ? DateTime.timeSetToArray((Gridded1DDoubleSet)this.getDomainSet()) : new DateTime[]{new DateTime(((SingletonSet)this.getDomainSet()).getDoubles()[0][0])};
        return times == null ? new DateTime[]{} : times;
    }

    @Override
    public int getImageCount() throws VisADException {
        return ((SampledSet)this.getDomainSet()).getLength();
    }

    @Override
    public SingleBandedImage getImage(DateTime dt) throws VisADException, RemoteException {
        return (SingleBandedImage)this.evaluate(dt);
    }

    @Override
    public SingleBandedImage getImage(int index) throws VisADException, RemoteException {
        return (SingleBandedImage)this.getSample(index);
    }

    private static FunctionType ensureFunctionType(FunctionType type) throws VisADException {
        if (type.getDomain().equals(DataUtility.ensureRealTupleType(RealType.Time)) && type.getRange() instanceof FunctionType && ((FunctionType)type.getRange()).getFlatRange().getDimension() == 1) {
            return type;
        }
        throw new VisADException("Not a valid ImageSequence type: " + type);
    }
}

