/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.util.ArrayList;
import java.util.Arrays;
import visad.CommonUnit;
import visad.FlowInfo;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.MathType;
import visad.RealTupleType;
import visad.Set;
import visad.ShadowType;
import visad.TrajectoryParams;
import visad.Unit;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.VisADTriangleArray;
import visad.java3d.Interpolation;

public class Trajectory {
    float[] startPts = new float[3];
    int[] startCell;
    float[] cellWeights;
    float[] uVecPath = new float[]{Float.NaN, Float.NaN, Float.NaN};
    int[] guess3D = new int[]{-1, -1, -1};
    int[] guess2D = new int[]{-1, -1};
    byte[] startColor;
    byte[] stopColor;
    float[] stopPts = new float[3];
    float[][] startPts2D = new float[2][1];
    float[][] startPts3D = new float[3][1];
    public int initialTimeIndex = 0;
    public int currentTimeIndex = 0;
    public double initialTime = 0.0;
    public double currentTime = 0.0;
    boolean offGrid = false;
    static int coordCnt = 0;
    static int colorCnt = 0;
    static int vertCnt = 0;
    private static float[] coordinates = null;
    private static byte[] colors = null;
    public static boolean[] markGrid;
    public static int[] markGridTime;
    public static int cnt;
    public static int[] o_j;
    public static int[] o_i;

    public Trajectory(float startX, float startY, float startZ, int[] startCell, float[] cellWeights, byte[] startColor) {
        this.startPts[0] = startX;
        this.startPts[1] = startY;
        this.startPts[2] = startZ;
        this.startCell = startCell;
        this.cellWeights = cellWeights;
        int clrDim = startColor.length;
        this.stopColor = new byte[clrDim];
        this.startColor = startColor;
    }

    public static void makeTrajectories(double time, ArrayList<Trajectory> trajectories, float[][] startPts, byte[][] color_values, GriddedSet spatial_set) throws VisADException {
        int num = startPts[0].length;
        int clrDim = color_values.length;
        int manifoldDimension = spatial_set.getManifoldDimension();
        int[][] indices = new int[num][];
        float[][] weights = new float[num][];
        if (manifoldDimension == 2) {
            spatial_set.valueToInterp(new float[][]{startPts[0], startPts[1]}, indices, weights);
        } else if (manifoldDimension == 3) {
            spatial_set.valueToInterp(new float[][]{startPts[0], startPts[1], startPts[2]}, indices, weights);
        }
        for (int k = 0; k < num; ++k) {
            float startX = startPts[0][k];
            float startY = startPts[1][k];
            float startZ = startPts[2][k];
            byte[] startColor = new byte[clrDim];
            startColor[0] = color_values[0][k];
            startColor[1] = color_values[1][k];
            startColor[2] = color_values[2][k];
            if (clrDim == 4) {
                startColor[3] = color_values[3][k];
            }
            Trajectory traj = new Trajectory(startX, startY, startZ, indices[k], weights[k], startColor);
            traj.initialTime = time;
            trajectories.add(traj);
        }
    }

    public static GriddedSet makeSpatialSetTraj(Gridded3DSet spatial_set) throws VisADException {
        int manifoldDim = spatial_set.getManifoldDimension();
        int[] lens = spatial_set.getLengths();
        float[][] setLocs = spatial_set.getSamples(false);
        GriddedSet spatialSetTraj = manifoldDim == 2 ? new Gridded2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, new float[][]{setLocs[0], setLocs[1]}, lens[0], lens[1]) : spatial_set;
        return spatialSetTraj;
    }

    public static void getStartPointsFromDomain(int skip, Gridded3DSet spatial_set, byte[][] color_values, float[][] startPts, byte[][] startClrs) throws VisADException {
        int manifoldDim = spatial_set.getManifoldDimension();
        int[] lens = spatial_set.getLengths();
        int lenX = lens[0];
        int lenY = lens[1];
        if (manifoldDim == 3) {
            int lenZ = lens[2];
            Trajectory.getStartPointsFromDomain3D(skip, spatial_set.getSamples(false), lenX, lenY, lenZ, color_values, startPts, startClrs);
        } else if (manifoldDim == 2) {
            Trajectory.getStartPointsFromDomain2D(skip, spatial_set.getSamples(false), lenX, lenY, color_values, startPts, startClrs);
        }
    }

    public static void getStartPointsFromDomain3D(int skip, float[][] locs, int lenX, int lenY, int lenZ, byte[][] color_values, float[][] startPts, byte[][] startClrs) throws VisADException {
        int len2D = lenX * lenY;
        float[][] locs2D = new float[3][len2D];
        float[][] pts = new float[3][];
        byte[][] clrs = new byte[startClrs.length][];
        int skipZ = lenZ / 3;
        int lenA = 0;
        for (int k = 0; k < lenZ; k += skipZ) {
            System.arraycopy(locs[0], k * len2D, locs2D[0], 0, len2D);
            System.arraycopy(locs[1], k * len2D, locs2D[1], 0, len2D);
            System.arraycopy(locs[2], k * len2D, locs2D[2], 0, len2D);
            Trajectory.getStartPointsFromDomain2D(skip, locs2D, lenX, lenY, color_values, pts, clrs);
            int lenB = pts[0].length;
            float[][] tmpPts = new float[3][lenA + lenB];
            byte[][] tmpClrs = new byte[clrs.length][lenA + lenB];
            if (lenA > 0) {
                System.arraycopy(startPts[0], 0, tmpPts[0], 0, lenA);
                System.arraycopy(startClrs[0], 0, tmpClrs[0], 0, lenA);
            }
            System.arraycopy(pts[0], 0, tmpPts[0], lenA, lenB);
            System.arraycopy(clrs[0], 0, tmpClrs[0], lenA, lenB);
            startPts[0] = tmpPts[0];
            startClrs[0] = tmpClrs[0];
            if (lenA > 0) {
                System.arraycopy(startPts[1], 0, tmpPts[1], 0, lenA);
                System.arraycopy(startClrs[1], 0, tmpClrs[1], 0, lenA);
            }
            System.arraycopy(pts[1], 0, tmpPts[1], lenA, lenB);
            System.arraycopy(clrs[1], 0, tmpClrs[1], lenA, lenB);
            startPts[1] = tmpPts[1];
            startClrs[1] = tmpClrs[1];
            if (lenA > 0) {
                System.arraycopy(startPts[2], 0, tmpPts[2], 0, lenA);
                System.arraycopy(startClrs[2], 0, tmpClrs[2], 0, lenA);
            }
            System.arraycopy(pts[2], 0, tmpPts[2], lenA, lenB);
            System.arraycopy(clrs[2], 0, tmpClrs[2], lenA, lenB);
            startPts[2] = tmpPts[2];
            startClrs[2] = tmpClrs[2];
            if (lenA > 0 && startClrs.length == 4) {
                System.arraycopy(startClrs[3], 0, tmpClrs[3], 0, lenA);
                System.arraycopy(clrs[3], 0, tmpClrs[3], lenA, lenB);
                startClrs[3] = tmpClrs[3];
            }
            lenA = startPts[0].length;
        }
    }

    public static void getStartPointsFromDomain2D(int skip, float[][] setLocs, int lenX, int lenY, byte[][] color_values, float[][] startPts, byte[][] startClrs) throws VisADException {
        int clrDim = color_values.length;
        int m = cnt % 4;
        ++cnt;
        int jA = 1 + o_j[m] * (skip / 2);
        int jB = lenY - skip;
        int iA = 1 + o_i[m] * (skip / 2);
        int iB = lenX - skip;
        int numJ = 1 + (jB - 1 - jA) / skip;
        int numI = 1 + (iB - 1 - iA) / skip;
        int num = numJ * numI;
        startPts[0] = new float[num];
        startPts[1] = new float[num];
        startPts[2] = new float[num];
        startClrs[0] = new byte[num];
        startClrs[1] = new byte[num];
        startClrs[2] = new byte[num];
        if (clrDim == 4) {
            startClrs[3] = new byte[num];
        }
        num = 0;
        for (int j = 1 + o_j[m] * (skip / 2); j < lenY - skip; j += skip) {
            for (int i = 1 + o_i[m] * (skip / 2); i < lenX - skip; i += skip) {
                int k = j * lenX + i;
                if (!markGrid[k]) {
                    startPts[0][num] = setLocs[0][k];
                    startPts[1][num] = setLocs[1][k];
                    startPts[2][num] = setLocs[2][k];
                    startClrs[0][num] = color_values[0][k];
                    startClrs[1][num] = color_values[1][k];
                    startClrs[2][num] = color_values[2][k];
                    if (clrDim == 4) {
                        startClrs[3][num] = color_values[3][k];
                    }
                }
                ++num;
            }
        }
    }

    public static void makeTrajectories(double time, ArrayList<Trajectory> trajectories, int skip, byte[][] color_values, float[][] startPts, int[] setLens) {
        int lenX = setLens[0];
        int lenY = setLens[1];
        int clrDim = color_values.length;
        int m = cnt % 4;
        ++cnt;
        for (int j = 1 + o_j[m] * (skip / 2); j < lenY - skip; j += skip) {
            for (int i = 1 + o_i[m] * (skip / 2); i < lenX - skip; i += skip) {
                int k = j * lenX + i;
                if (markGrid[k]) continue;
                float startX = startPts[0][k];
                float startY = startPts[1][k];
                float startZ = startPts[2][k];
                byte[] startColor = new byte[clrDim];
                startColor[0] = color_values[0][k];
                startColor[1] = color_values[1][k];
                startColor[2] = color_values[2][k];
                if (clrDim != 4) continue;
                startColor[3] = color_values[3][k];
            }
        }
    }

    public static void checkTime(int timeIdx) {
        for (int k = 0; k < markGridTime.length; ++k) {
            if (timeIdx - markGridTime[k] <= 4) continue;
            Trajectory.markGridTime[k] = timeIdx;
            Trajectory.markGrid[k] = false;
        }
    }

    public static ArrayList<Trajectory> clean(ArrayList<Trajectory> trajectories, double threshold) {
        ArrayList<Trajectory> newList = new ArrayList<Trajectory>();
        for (Trajectory traj : trajectories) {
            if (traj.offGrid || !(traj.currentTime - traj.initialTime < threshold)) continue;
            newList.add(traj);
        }
        return newList;
    }

    public static ArrayList<Trajectory> clean(ArrayList<Trajectory> trajectories) {
        return Trajectory.clean(trajectories, -1.0);
    }

    public static void reset(int maxNumVerts, int clrDim) {
        coordCnt = 0;
        colorCnt = 0;
        vertCnt = 0;
        coordinates = new float[3 * (maxNumVerts *= 2)];
        colors = new byte[clrDim * maxNumVerts];
        Arrays.fill(coordinates, Float.NaN);
    }

    public static void reset(ArrayList<Trajectory> trajectories, int numIntrpPts, int clrDim) {
        for (int k = 0; k < trajectories.size(); ++k) {
            Trajectory traj = trajectories.get(k);
        }
    }

    public static VisADLineArray makeGeometry() {
        VisADLineArray array = new VisADLineArray();
        float[] newCoords = new float[coordCnt];
        byte[] newColors = new byte[colorCnt];
        System.arraycopy(coordinates, 0, newCoords, 0, newCoords.length);
        System.arraycopy(colors, 0, newColors, 0, newColors.length);
        array.coordinates = newCoords;
        array.colors = newColors;
        array.vertexCount = vertCnt;
        return array;
    }

    public static VisADGeometryArray makeGeometry(ArrayList<Trajectory> trajectories) {
        return null;
    }

    public static VisADGeometryArray makeTracerGeometry(ArrayList<Trajectory> trajectories, ArrayList<VisADGeometryArray> arrays, ArrayList<float[]> anchors, int direction, float trcrSize, double[] scale, boolean fill) {
        int numTrajs = trajectories.size();
        VisADGeometryArray array = null;
        double barblen = 0.7 / scale[0] * (double)trcrSize * 0.034;
        float[] norm = new float[]{0.0f, 0.0f, 1.0f};
        float[] trj_u = new float[3];
        for (int k = 0; k < numTrajs; ++k) {
            byte[] colors;
            float[] coords;
            int numVerts;
            int numPts;
            if (!fill) {
                numPts = 8;
                numVerts = numPts * 1;
                coords = new float[3 * numVerts];
                colors = new byte[3 * numVerts];
                array = new VisADLineArray();
            } else {
                numPts = 12;
                numVerts = numPts * 1;
                coords = new float[3 * numVerts];
                colors = new byte[3 * numVerts];
                array = new VisADTriangleArray();
            }
            Trajectory traj = trajectories.get(k);
            trj_u[0] = traj.uVecPath[0];
            trj_u[1] = traj.uVecPath[1];
            trj_u[2] = traj.uVecPath[2];
            float[] endPt = new float[]{traj.startPts[0], traj.startPts[1], traj.startPts[2]};
            float[] norm_x_trj = new float[]{norm[1] * trj_u[2] - norm[2] * trj_u[1], -(norm[0] * trj_u[2] - norm[2] * trj_u[0]), norm[0] * trj_u[1] - norm[1] * trj_u[0]};
            float mag = (float)Math.sqrt(norm_x_trj[0] * norm_x_trj[0] + norm_x_trj[1] * norm_x_trj[1] + norm_x_trj[2] * norm_x_trj[2]);
            norm_x_trj[0] = norm_x_trj[0] / mag;
            norm_x_trj[1] = norm_x_trj[1] / mag;
            norm_x_trj[2] = norm_x_trj[2] / mag;
            float[] norm_x_trj_x_trj = new float[]{norm_x_trj[1] * trj_u[2] - norm_x_trj[2] * trj_u[1], -(norm_x_trj[0] * trj_u[2] - norm_x_trj[2] * trj_u[0]), norm_x_trj[0] * trj_u[1] - norm_x_trj[1] * trj_u[0]};
            mag = (float)Math.sqrt(norm_x_trj_x_trj[0] * norm_x_trj_x_trj[0] + norm_x_trj_x_trj[1] * norm_x_trj_x_trj[1] + norm_x_trj_x_trj[2] * norm_x_trj_x_trj[2]);
            norm_x_trj_x_trj[0] = norm_x_trj_x_trj[0] / mag;
            norm_x_trj_x_trj[1] = norm_x_trj_x_trj[1] / mag;
            norm_x_trj_x_trj[2] = norm_x_trj_x_trj[2] / mag;
            float[] ptOnPath = new float[3];
            float len = (float)(barblen * Math.cos(0.3839724354387525));
            ptOnPath[0] = -len * trj_u[0];
            ptOnPath[1] = -len * trj_u[1];
            ptOnPath[2] = -len * trj_u[2];
            ptOnPath[0] = ptOnPath[0] + endPt[0];
            ptOnPath[1] = ptOnPath[1] + endPt[1];
            ptOnPath[2] = ptOnPath[2] + endPt[2];
            float[] barbPtA = new float[3];
            float[] barbPtB = new float[3];
            float[] barbPtC = new float[3];
            float[] barbPtD = new float[3];
            len = (float)(barblen * Math.sin(0.3839724354387525));
            barbPtA[0] = len * norm_x_trj[0];
            barbPtA[1] = len * norm_x_trj[1];
            barbPtA[2] = len * norm_x_trj[2];
            barbPtB[0] = -len * norm_x_trj[0];
            barbPtB[1] = -len * norm_x_trj[1];
            barbPtB[2] = -len * norm_x_trj[2];
            barbPtA[0] = barbPtA[0] + ptOnPath[0];
            barbPtA[1] = barbPtA[1] + ptOnPath[1];
            barbPtA[2] = barbPtA[2] + ptOnPath[2];
            barbPtB[0] = barbPtB[0] + ptOnPath[0];
            barbPtB[1] = barbPtB[1] + ptOnPath[1];
            barbPtB[2] = barbPtB[2] + ptOnPath[2];
            len = (float)((double)len * (scale[0] / scale[2]));
            barbPtC[0] = len * norm_x_trj_x_trj[0];
            barbPtC[1] = len * norm_x_trj_x_trj[1];
            barbPtC[2] = len * norm_x_trj_x_trj[2];
            barbPtD[0] = -len * norm_x_trj_x_trj[0];
            barbPtD[1] = -len * norm_x_trj_x_trj[1];
            barbPtD[2] = -len * norm_x_trj_x_trj[2];
            barbPtC[0] = barbPtC[0] + ptOnPath[0];
            barbPtC[1] = barbPtC[1] + ptOnPath[1];
            barbPtC[2] = barbPtC[2] + ptOnPath[2];
            barbPtD[0] = barbPtD[0] + ptOnPath[0];
            barbPtD[1] = barbPtD[1] + ptOnPath[1];
            barbPtD[2] = barbPtD[2] + ptOnPath[2];
            int t = 0;
            int c = 0;
            coords[t] = traj.startPts[0];
            coords[++t] = traj.startPts[1];
            coords[++t] = traj.startPts[2];
            colors[c] = traj.startColor[0];
            colors[++c] = traj.startColor[1];
            colors[++c] = traj.startColor[2];
            coords[++t] = barbPtA[0];
            coords[++t] = barbPtA[1];
            coords[++t] = barbPtA[2];
            colors[++c] = traj.startColor[0];
            colors[++c] = traj.startColor[1];
            colors[++c] = traj.startColor[2];
            if (fill) {
                coords[++t] = ptOnPath[0];
                coords[++t] = ptOnPath[1];
                coords[++t] = ptOnPath[2];
                colors[++c] = traj.startColor[0];
                colors[++c] = traj.startColor[1];
                colors[++c] = traj.startColor[2];
            }
            coords[++t] = traj.startPts[0];
            coords[++t] = traj.startPts[1];
            coords[++t] = traj.startPts[2];
            colors[++c] = traj.startColor[0];
            colors[++c] = traj.startColor[1];
            colors[++c] = traj.startColor[2];
            coords[++t] = barbPtB[0];
            coords[++t] = barbPtB[1];
            coords[++t] = barbPtB[2];
            colors[++c] = traj.startColor[0];
            colors[++c] = traj.startColor[1];
            colors[++c] = traj.startColor[2];
            if (fill) {
                coords[++t] = ptOnPath[0];
                coords[++t] = ptOnPath[1];
                coords[++t] = ptOnPath[2];
                colors[++c] = traj.startColor[0];
                colors[++c] = traj.startColor[1];
                colors[++c] = traj.startColor[2];
            }
            coords[++t] = traj.startPts[0];
            coords[++t] = traj.startPts[1];
            coords[++t] = traj.startPts[2];
            colors[++c] = traj.startColor[0];
            colors[++c] = traj.startColor[1];
            colors[++c] = traj.startColor[2];
            coords[++t] = barbPtC[0];
            coords[++t] = barbPtC[1];
            coords[++t] = barbPtC[2];
            colors[++c] = traj.startColor[0];
            colors[++c] = traj.startColor[1];
            colors[++c] = traj.startColor[2];
            if (fill) {
                coords[++t] = ptOnPath[0];
                coords[++t] = ptOnPath[1];
                coords[++t] = ptOnPath[2];
                colors[++c] = traj.startColor[0];
                colors[++c] = traj.startColor[1];
                colors[++c] = traj.startColor[2];
            }
            coords[++t] = traj.startPts[0];
            coords[++t] = traj.startPts[1];
            coords[++t] = traj.startPts[2];
            colors[++c] = traj.startColor[0];
            colors[++c] = traj.startColor[1];
            colors[++c] = traj.startColor[2];
            coords[++t] = barbPtD[0];
            coords[++t] = barbPtD[1];
            coords[++t] = barbPtD[2];
            colors[++c] = traj.startColor[0];
            colors[++c] = traj.startColor[1];
            colors[++c] = traj.startColor[2];
            if (fill) {
                coords[++t] = ptOnPath[0];
                coords[++t] = ptOnPath[1];
                coords[++t] = ptOnPath[2];
                colors[++c] = traj.startColor[0];
                colors[++c] = traj.startColor[1];
                colors[++c] = traj.startColor[2];
            }
            array.vertexCount = numVerts;
            array.coordinates = coords;
            array.colors = colors;
            arrays.add(array);
            float[] anchrPts = new float[]{traj.startPts[0], traj.startPts[1], traj.startPts[2]};
            anchors.add(anchrPts);
        }
        return array;
    }

    public void forward(FlowInfo info, float[][] flow_values, byte[][] color_values, GriddedSet spatial_set, int direction, float timeStep) throws VisADException {
        if (this.offGrid) {
            return;
        }
        int[][] indices = new int[1][];
        float[][] weights = new float[1][];
        float[] intrpFlow = new float[3];
        int clrDim = color_values.length;
        float[] intrpClr = new float[clrDim];
        int manifoldDimension = spatial_set.getManifoldDimension();
        indices[0] = this.startCell;
        weights[0] = this.cellWeights;
        float[][] flowLoc = new float[3][1];
        float[][] flowVec = new float[3][1];
        if (indices[0] != null) {
            Arrays.fill(intrpFlow, 0.0f);
            Arrays.fill(intrpClr, 0.0f);
            for (int j = 0; j < indices[0].length; ++j) {
                int idx = indices[0][j];
                flowLoc[0][0] = info.spatial_values[0][idx];
                flowLoc[1][0] = info.spatial_values[1][idx];
                flowLoc[2][0] = info.spatial_values[2][idx];
                flowVec[0][0] = flow_values[0][idx];
                flowVec[1][0] = flow_values[1][idx];
                flowVec[2][0] = flow_values[2][idx];
                float[][] del = Trajectory.adjustFlow(info, flowLoc, flowVec, timeStep);
                intrpFlow[0] = intrpFlow[0] + weights[0][j] * (float)direction * del[0][0];
                intrpFlow[1] = intrpFlow[1] + weights[0][j] * (float)direction * del[1][0];
                intrpFlow[2] = intrpFlow[2] + weights[0][j] * (float)direction * del[2][0];
                intrpClr[0] = intrpClr[0] + weights[0][j] * (float)color_values[0][idx];
                intrpClr[1] = intrpClr[1] + weights[0][j] * (float)color_values[1][idx];
                intrpClr[2] = intrpClr[2] + weights[0][j] * (float)color_values[2][idx];
                if (clrDim == 4) {
                    intrpClr[3] = intrpClr[3] + weights[0][j] * (float)color_values[3][idx];
                }
                Trajectory.markGridTime[idx] = this.currentTimeIndex;
            }
            this.stopPts[0] = this.startPts[0] + intrpFlow[0];
            this.stopPts[1] = this.startPts[1] + intrpFlow[1];
            this.stopPts[2] = this.startPts[2] + intrpFlow[2];
            this.stopColor[0] = (byte)intrpClr[0];
            this.stopColor[1] = (byte)intrpClr[1];
            this.stopColor[2] = (byte)intrpClr[2];
            if (clrDim == 4) {
                this.stopColor[3] = (byte)intrpClr[3];
            }
            this.addPair(this.startPts, this.stopPts, this.startColor, this.startColor);
            this.uVecPath[0] = this.stopPts[0] - this.startPts[0];
            this.uVecPath[1] = this.stopPts[1] - this.startPts[1];
            this.uVecPath[2] = this.stopPts[2] - this.startPts[2];
            float mag = (float)Math.sqrt(this.uVecPath[0] * this.uVecPath[0] + this.uVecPath[1] * this.uVecPath[1] + this.uVecPath[2] * this.uVecPath[2]);
            this.uVecPath[0] = this.uVecPath[0] / mag;
            this.uVecPath[1] = this.uVecPath[1] / mag;
            this.uVecPath[2] = this.uVecPath[2] / mag;
            this.startPts[0] = this.stopPts[0];
            this.startPts[1] = this.stopPts[1];
            this.startPts[2] = this.stopPts[2];
            if (manifoldDimension == 2) {
                this.startPts2D[0][0] = this.startPts[0];
                this.startPts2D[1][0] = this.startPts[1];
                spatial_set.valueToInterp(this.startPts2D, indices, weights, this.guess2D);
            } else if (manifoldDimension == 3) {
                this.startPts3D[0][0] = this.startPts[0];
                this.startPts3D[1][0] = this.startPts[1];
                this.startPts3D[2][0] = this.startPts[2];
                spatial_set.valueToInterp(this.startPts3D, indices, weights, this.guess3D);
            }
            this.startCell = indices[0];
            this.cellWeights = weights[0];
            if (indices[0] == null) {
                this.offGrid = true;
            }
        }
    }

    private void addPair(float[] startPt, float[] stopPt, byte[] startColor, byte[] stopColor) {
        Trajectory.coordinates[Trajectory.coordCnt++] = startPt[0];
        Trajectory.coordinates[Trajectory.coordCnt++] = startPt[1];
        Trajectory.coordinates[Trajectory.coordCnt++] = startPt[2];
        ++vertCnt;
        Trajectory.coordinates[Trajectory.coordCnt++] = stopPt[0];
        Trajectory.coordinates[Trajectory.coordCnt++] = stopPt[1];
        Trajectory.coordinates[Trajectory.coordCnt++] = stopPt[2];
        ++vertCnt;
        int clrDim = startColor.length;
        Trajectory.colors[Trajectory.colorCnt++] = startColor[0];
        Trajectory.colors[Trajectory.colorCnt++] = startColor[1];
        Trajectory.colors[Trajectory.colorCnt++] = startColor[2];
        if (clrDim == 4) {
            Trajectory.colors[Trajectory.colorCnt++] = startColor[3];
        }
        Trajectory.colors[Trajectory.colorCnt++] = stopColor[0];
        Trajectory.colors[Trajectory.colorCnt++] = stopColor[1];
        Trajectory.colors[Trajectory.colorCnt++] = stopColor[2];
        if (clrDim == 4) {
            Trajectory.colors[Trajectory.colorCnt++] = stopColor[3];
        }
    }

    public static float[][] adjustFlow(FlowInfo info, float[][] spatial_values, float[][] flow_values, float timeStep) throws VisADException {
        return ShadowType.adjustFlowToEarth(info.which, flow_values, spatial_values, info.flowScale, info.renderer, false, true, timeStep);
    }

    public static float[][] smooth(float[][] values0, float[][] values1, float[][] values2, TrajectoryParams.SmoothParams smoothParams) {
        float w0 = smoothParams.w0;
        float w1 = smoothParams.w1;
        float w2 = smoothParams.w2;
        int numPts = values0[0].length;
        float[][] new_values = new float[3][numPts];
        for (int k = 0; k < numPts; ++k) {
            new_values[0][k] = w0 * values0[0][k] + w1 * values1[0][k] + w2 * values2[0][k];
            new_values[1][k] = w0 * values0[1][k] + w1 * values1[1][k] + w2 * values2[1][k];
            new_values[2][k] = w0 * values0[2][k] + w1 * values1[2][k] + w2 * values2[2][k];
        }
        return new_values;
    }

    public static double[] getTimeSteps(Gridded1DSet timeSet) throws VisADException {
        double[] timePts = timeSet instanceof Gridded1DDoubleSet ? timeSet.getDoubles()[0] : Set.floatToDouble(timeSet.getSamples())[0];
        double[] timeSteps = new double[timePts.length];
        Unit[] setUnits = timeSet.getSetUnits();
        timePts = CommonUnit.secondsSinceTheEpoch.toThis(timePts, setUnits[0]);
        for (int t = 0; t < timePts.length - 1; ++t) {
            timeSteps[t] = timePts[t + 1] - timePts[t];
        }
        timeSteps[timePts.length - 1] = timeSteps[timePts.length - 2];
        return timeSteps;
    }

    public static double[] getTimes(Gridded1DSet timeSet) throws VisADException {
        double[] timePts = timeSet instanceof Gridded1DDoubleSet ? timeSet.getDoubles()[0] : Set.floatToDouble(timeSet.getSamples())[0];
        Unit[] setUnits = timeSet.getSetUnits();
        timePts = CommonUnit.secondsSinceTheEpoch.toThis(timePts, setUnits[0]);
        return timePts;
    }

    public static int getNumIntrpPts(FlowInfo info, float maxSpd, double timeStep) throws VisADException {
        float[][] del = Trajectory.adjustFlow(info, new float[][]{{0.0f}, {0.0f}, {0.0f}}, new float[][]{{50.0f}, {0.0f}, {0.0f}}, (float)timeStep);
        double intrvl = (double)del[0][0] / 0.1;
        int numIntrpPts = intrvl < 2.0 ? 2 : (int)intrvl;
        return numIntrpPts;
    }

    public static float[][] convertFlowUnit(float[][] values, Unit[] units) throws VisADException {
        Unit meterPerSecond = CommonUnit.meterPerSecond;
        float[] valsX = values[0];
        if (Unit.canConvert(units[0], meterPerSecond)) {
            valsX = meterPerSecond.toThis(values[0], units[0]);
        }
        float[] valsY = values[1];
        if (Unit.canConvert(units[1], meterPerSecond)) {
            valsY = meterPerSecond.toThis(values[1], units[1]);
        }
        float[] valsZ = values[2];
        if (Unit.canConvert(units[2], meterPerSecond)) {
            valsZ = meterPerSecond.toThis(values[2], units[2]);
        }
        return new float[][]{valsX, valsY, valsZ};
    }

    public static void updateInterpolators(ArrayList<Trajectory> trajectories, int numSpatialPts, Interpolation uInterp, Interpolation vInterp, Interpolation wInterp) {
        boolean[] needed = new boolean[numSpatialPts];
        Arrays.fill(needed, false);
        for (int k = 0; k < trajectories.size(); ++k) {
            Trajectory traj = trajectories.get(k);
            if (traj.offGrid) continue;
            int[] cell = traj.startCell;
            for (int t = 0; t < cell.length; ++t) {
                needed[cell[t]] = true;
            }
        }
        uInterp.update(needed);
        vInterp.update(needed);
        wInterp.update(needed);
    }

    static {
        cnt = 0;
        o_j = new int[]{0, 0, 1, 1};
        o_i = new int[]{0, 1, 0, 1};
    }
}

