/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.AnimationControl;
import visad.CoordinateSystem;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetType;
import visad.VisADException;
import visad.java3d.AVControlJ3D;
import visad.java3d.AnimationControlJ3D;
import visad.java3d.DisplayImplJ3D;

public class DownRoundingAnimationControlJ3D
extends AnimationControlJ3D
implements Runnable,
AnimationControl {
    public DownRoundingAnimationControlJ3D(DisplayImplJ3D d, RealType r) {
        super(d, r);
    }

    DownRoundingAnimationControlJ3D() {
        this(null, null);
    }

    @Override
    public void setCurrent(int c) throws VisADException, RemoteException {
        Set set = this.getSet();
        if (set == null) {
            this.current = -1;
        } else {
            int n = set.getLength();
            if (c >= n) {
                c = n - 1;
            }
            this.current = c;
        }
        this.init();
        this.changeControl(false);
    }

    @Override
    public void setCurrent(double value) throws VisADException, RemoteException {
        Set set = this.getSet();
        this.current = this.getIndexLessThanValue(set, value);
        this.init();
        this.changeControl(false);
    }

    protected int getIndexLessThanValue(Set set, double value) throws VisADException {
        int index = -1;
        if (set != null) {
            double[][] values = set.getDoubles();
            int n = values[0].length;
            int i = 0;
            while (i < n && !(values[0][i] > value)) {
                index = i++;
            }
        }
        return index;
    }

    @Override
    public void init() throws VisADException {
        Set set = this.getSet();
        if (set != null) {
            double value = Double.NaN;
            if (this.current != -1) {
                value = set.indexToDouble(new int[]{this.current})[0][0];
            }
            RealType real = this.getRealType();
            this.animation_string(real, set, value, this.current);
            this.selectSwitches(value, set);
        }
    }

    @Override
    public void selectSwitches(double value, Set animation_set) throws VisADException {
        double[][] fvalues = new double[1][1];
        fvalues[0][0] = value;
        Enumeration pairs = ((Vector)this.getSwitches().clone()).elements();
        while (pairs.hasMoreElements()) {
            AVControlJ3D.SwitchSet ss = (AVControlJ3D.SwitchSet)pairs.nextElement();
            if (value != value) {
                ss.swit.setWhichChild(-1);
                continue;
            }
            Set set = ss.set;
            double[][] values = null;
            RealTupleType out = ((SetType)set.getType()).getDomain();
            if (animation_set != null) {
                RealTupleType in = ((SetType)animation_set.getType()).getDomain();
                values = CoordinateSystem.transformCoordinates(out, set.getCoordinateSystem(), set.getSetUnits(), null, in, animation_set.getCoordinateSystem(), animation_set.getSetUnits(), null, fvalues);
            } else {
                values = CoordinateSystem.transformCoordinates(out, set.getCoordinateSystem(), set.getSetUnits(), null, out, out.getCoordinateSystem(), out.getDefaultUnits(), null, fvalues);
            }
            int index = this.getIndexLessThanValue(set, values[0][0]);
            int numc = ss.swit.numChildren();
            if (index >= numc) {
                index = numc - 1;
            }
            if (index == -1) {
                ss.swit.setWhichChild(-1);
                continue;
            }
            ss.swit.setWhichChild(index);
        }
    }
}

