/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedTime;
import javax.vecmath.Point3d;
import visad.AnimationControl;
import visad.AnimationSetControl;
import visad.Control;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.DisplayException;
import visad.RealType;
import visad.Set;
import visad.ToggleControl;
import visad.VisADError;
import visad.VisADException;
import visad.browser.Convert;
import visad.java3d.AVControlJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;

public class AnimationControlJ3D
extends AVControlJ3D
implements AnimationControl {
    private static final long serialVersionUID = 7763197458917167330L;
    private static final long DEFAULT_DWELL = 500L;
    protected int current = 0;
    private boolean direction;
    private long step = 500L;
    private WakeupOnElapsedTime[] stepValues;
    private transient AnimationSetControl animationSet;
    private ToggleControl animate;
    private RealType real;
    private boolean computeSet = true;
    private transient Behavior steppingBehaviour;

    public AnimationControlJ3D(DisplayImplJ3D d, RealType r) {
        super(d);
        this.real = r;
        this.current = 0;
        this.direction = true;
        this.animationSet = new AnimationSetControl(d, this);
        this.stepValues = new WakeupOnElapsedTime[]{new WakeupOnElapsedTime(500L)};
        try {
            Set set = this.animationSet.getSet();
            if (set != null) {
                this.stepValues = new WakeupOnElapsedTime[set.getLength()];
            }
        }
        catch (VisADException v) {
            // empty catch block
        }
        for (int i = 0; i < this.stepValues.length; ++i) {
            this.stepValues[i] = new WakeupOnElapsedTime(500L);
        }
        d.addControl(this.animationSet);
        this.animate = new ToggleControl(d, this);
        d.addControl(this.animate);
        try {
            this.animate.setOn(false);
        }
        catch (VisADException v) {
        }
        catch (RemoteException v) {
            // empty catch block
        }
        this.steppingBehaviour = new TakeStepBehavior();
        BranchGroup bg = new BranchGroup();
        bg.addChild((Node)this.steppingBehaviour);
        DisplayRendererJ3D rend = (DisplayRendererJ3D)d.getDisplayRenderer();
        BranchGroup root = rend.getRoot();
        root.addChild((Node)bg);
    }

    AnimationControlJ3D() {
        this(null, null);
    }

    @Override
    public int getCurrent() {
        return this.current;
    }

    @Override
    public void setCurrent(int c) throws VisADException, RemoteException {
        if (this.animationSet != null) {
            this.current = this.animationSet.clipCurrent(c);
            this.init();
        } else {
            this.current = 0;
        }
        this.changeControl(false);
    }

    @Override
    public void setCurrent(double value) throws VisADException, RemoteException {
        if (this.animationSet != null) {
            this.current = this.animationSet.getIndex(value);
            this.init();
        } else {
            this.current = 0;
        }
        this.changeControl(false);
    }

    @Override
    public void setDirection(boolean dir) throws VisADException, RemoteException {
        this.direction = dir;
        this.changeControl(false);
    }

    @Override
    public boolean getDirection() {
        return this.direction;
    }

    @Override
    public long getStep() {
        if (this.stepValues == null || this.current < 0 || this.stepValues.length <= this.current) {
            return 500L;
        }
        return this.stepValues[this.current].getElapsedFrameTime();
    }

    @Override
    public long[] getSteps() {
        long[] steps = new long[this.stepValues.length];
        for (int i = 0; i < steps.length; ++i) {
            steps[i] = this.stepValues[i].getElapsedFrameTime();
        }
        return steps;
    }

    @Override
    public void setStep(int st) throws VisADException, RemoteException {
        if (st <= 0) {
            throw new DisplayException("AnimationControlJ3D.setStep: step must be > 0");
        }
        this.step = st;
        for (int i = 0; i < this.stepValues.length; ++i) {
            this.stepValues[i] = new WakeupOnElapsedTime((long)st);
        }
        this.changeControl(false);
    }

    @Override
    public void setSteps(int[] steps) throws VisADException, RemoteException {
        for (int i = 0; i < this.stepValues.length; ++i) {
            long step = i < steps.length ? (long)steps[i] : (long)steps[steps.length - 1];
            this.stepValues[i] = new WakeupOnElapsedTime(step);
            if (step > 0L) continue;
            throw new DisplayException("AnimationControlJ3D.setSteps: step " + i + " must be > 0");
        }
        this.changeControl(true);
    }

    @Override
    public void takeStep() throws VisADException, RemoteException {
        this.current = this.direction ? ++this.current : --this.current;
        if (this.animationSet != null) {
            this.current = this.animationSet.clipCurrent(this.current);
            this.init();
        }
        this.getDisplayRenderer().render_trigger();
        this.changeControl(false);
    }

    @Override
    public void init() throws VisADException {
        if (this.animationSet != null) {
            double value = this.animationSet.getValue(this.current);
            Set set = this.animationSet.getSet();
            this.animation_string(this.real, set, value, this.current);
            this.selectSwitches(value, set);
        }
    }

    @Override
    public Set getSet() {
        if (this.animationSet != null) {
            return this.animationSet.getSet();
        }
        return null;
    }

    @Override
    public void setSet(Set s) throws VisADException, RemoteException {
        if (s == null && this.animationSet != null && this.animationSet.getSet() == null) {
            return;
        }
        if (this.animationSet == null || s == null || s != null && !s.equals(this.animationSet.getSet())) {
            this.setSet(s, false);
            if (s == null) {
                this.stepValues = new WakeupOnElapsedTime[]{new WakeupOnElapsedTime(500L)};
                this.current = 0;
            } else if (s.getLength() != this.stepValues.length) {
                this.stepValues = new WakeupOnElapsedTime[s.getLength()];
                for (int i = 0; i < this.stepValues.length; ++i) {
                    this.stepValues[i] = new WakeupOnElapsedTime(this.step);
                }
            }
        }
    }

    @Override
    public void setSet(Set s, boolean noChange) throws VisADException, RemoteException {
        if (this.animationSet != null) {
            if (s == null) {
                this.stepValues = new WakeupOnElapsedTime[]{new WakeupOnElapsedTime(500L)};
                this.current = 0;
            } else if (s.getLength() != this.stepValues.length) {
                this.stepValues = new WakeupOnElapsedTime[s.getLength()];
                for (int i = 0; i < this.stepValues.length; ++i) {
                    this.stepValues[i] = new WakeupOnElapsedTime(this.step);
                }
            }
            this.animationSet.setSet(s, noChange);
        }
    }

    @Override
    public boolean getOn() {
        if (this.animate != null) {
            return this.animate.getOn();
        }
        return false;
    }

    @Override
    public void setOn(boolean o) throws VisADException, RemoteException {
        if (this.animate != null) {
            this.animate.setOn(o);
        }
    }

    @Override
    public void toggle() throws VisADException, RemoteException {
        if (this.animate != null) {
            this.animate.setOn(!this.animate.getOn());
        }
    }

    public RealType getRealType() {
        return this.real;
    }

    @Override
    public void subSetTicks() {
        if (this.animationSet != null) {
            this.animationSet.setTicks();
        }
        if (this.animate != null) {
            this.animate.setTicks();
        }
    }

    @Override
    public boolean subCheckTicks(DataRenderer r, DataDisplayLink link) {
        boolean flag = false;
        if (this.animationSet != null) {
            flag |= this.animationSet.checkTicks(r, link);
        }
        if (this.animate != null) {
            flag |= this.animate.checkTicks(r, link);
        }
        return flag;
    }

    @Override
    public boolean subPeekTicks(DataRenderer r, DataDisplayLink link) {
        boolean flag = false;
        if (this.animationSet != null) {
            flag |= this.animationSet.peekTicks(r, link);
        }
        if (this.animate != null) {
            flag |= this.animate.peekTicks(r, link);
        }
        return flag;
    }

    @Override
    public void subResetTicks() {
        if (this.animationSet != null) {
            this.animationSet.resetTicks();
        }
        if (this.animate != null) {
            this.animate.resetTicks();
        }
    }

    @Override
    public String getSaveString() {
        long[] steps;
        int numSteps;
        if (this.stepValues == null) {
            numSteps = 1;
            steps = new long[]{500L};
        } else {
            numSteps = this.stepValues.length;
            steps = new long[numSteps];
            for (int i = 0; i < numSteps; ++i) {
                steps[i] = this.stepValues[i].getElapsedFrameTime();
            }
        }
        StringBuffer sb = new StringBuffer(35 + 12 * numSteps);
        sb.append(this.animate != null && this.animate.getOn());
        sb.append(' ');
        sb.append(this.direction);
        sb.append(' ');
        sb.append(this.current);
        sb.append(' ');
        sb.append(numSteps);
        for (int i = 0; i < numSteps; ++i) {
            sb.append(' ');
            sb.append((int)steps[i]);
        }
        sb.append(' ');
        sb.append(this.computeSet);
        return sb.toString();
    }

    @Override
    public void setSaveString(String save) throws VisADException, RemoteException {
        if (save == null) {
            throw new VisADException("Invalid save string");
        }
        StringTokenizer st = new StringTokenizer(save);
        int numTokens = st.countTokens();
        if (numTokens < 4) {
            throw new VisADException("Invalid save string");
        }
        boolean on = Convert.getBoolean(st.nextToken());
        boolean dir = Convert.getBoolean(st.nextToken());
        int cur = Convert.getInt(st.nextToken());
        int numSteps = Convert.getInt(st.nextToken());
        if (numSteps <= 0) {
            throw new VisADException("Number of steps is not positive");
        }
        if (numTokens < 4 + numSteps) {
            throw new VisADException("Not enough step entries");
        }
        int[] steps = new int[numSteps];
        for (int i = 0; i < numSteps; ++i) {
            steps[i] = Convert.getInt(st.nextToken());
            if (steps[i] > 0) continue;
            throw new VisADException("Step #" + (i + 1) + "is not positive");
        }
        boolean cs = st.hasMoreTokens() ? Convert.getBoolean(st.nextToken()) : this.getComputeSet();
        this.setOn(on);
        this.setDirection(dir);
        this.setSteps(steps);
        this.setCurrent(cur);
        this.setComputeSet(cs);
    }

    @Override
    public void syncControl(Control rmt) throws VisADException {
        if (rmt == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(rmt instanceof AnimationControlJ3D)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + rmt.getClass().getName());
        }
        AnimationControlJ3D ac = (AnimationControlJ3D)rmt;
        boolean changed = false;
        if (this.direction != ac.direction) {
            changed = true;
            this.direction = ac.direction;
        }
        if (this.step != ac.step) {
            changed = true;
            this.step = ac.step;
        }
        if (this.animate != ac.animate) {
            changed = true;
            this.animate = ac.animate;
        }
        if (this.real != ac.real) {
            changed = true;
            this.real = ac.real;
        }
        if (this.computeSet != ac.computeSet) {
            changed = true;
            this.computeSet = ac.computeSet;
        }
        if (changed) {
            try {
                this.changeControl(false);
            }
            catch (RemoteException re) {
                throw new VisADException("Could not indicate that control changed: " + re.getMessage());
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        AnimationControlJ3D ac = (AnimationControlJ3D)o;
        if (this.direction != ac.direction) {
            return false;
        }
        if (this.step != ac.step) {
            return false;
        }
        if (this.animate != ac.animate) {
            return false;
        }
        if (this.real != ac.real) {
            return false;
        }
        return this.computeSet == ac.computeSet;
    }

    @Override
    public void setComputeSet(boolean compute) {
        this.computeSet = compute;
    }

    @Override
    public boolean getComputeSet() {
        return this.computeSet;
    }

    @Override
    public void stop() {
        this.steppingBehaviour.setEnable(false);
    }

    @Override
    public void run() {
        this.steppingBehaviour.setEnable(true);
    }

    private class TakeStepBehavior
    extends Behavior {
        public TakeStepBehavior() {
            this.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1.0E7));
        }

        public void initialize() {
            this.updateDwell();
        }

        public void processStimulus(Enumeration criteria) {
            try {
                if (AnimationControlJ3D.this.animate != null && AnimationControlJ3D.this.animate.getOn()) {
                    AnimationControlJ3D.this.takeStep();
                }
            }
            catch (VisADException v) {
                throw new VisADError("Unable to take animation step", v);
            }
            catch (RemoteException v) {
                throw new VisADError("Unable to take animation step", v);
            }
            this.updateDwell();
        }

        public void updateDwell() {
            if (0 <= AnimationControlJ3D.this.current && AnimationControlJ3D.this.current < AnimationControlJ3D.this.stepValues.length) {
                this.wakeupOn((WakeupCondition)AnimationControlJ3D.this.stepValues[AnimationControlJ3D.this.current]);
            } else {
                this.wakeupOn((WakeupCondition)new WakeupOnElapsedTime(500L));
            }
        }
    }
}

