/*
 * Decompiled with CFR 0.152.
 */
package visad.install;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class SplashScreen
extends JWindow {
    private static final int BORDER_WIDTH = 5;
    private static final int WIDTH_PAD = 2;
    private static final int HEIGHT_PAD = 2;
    private ImageIcon image;
    private String[] names;
    private String[] values;
    private Font textFont;
    private int nameLen;
    private int lineHeight;
    private int textX;
    private int textY;
    private int textWidth;
    private int textHeight;

    public SplashScreen(String imageName) {
        this(new ImageIcon(imageName), null, null);
    }

    public SplashScreen(ImageIcon image) {
        this(image, null, null);
    }

    public SplashScreen(String[] names, String[] values) {
        this((ImageIcon)null, names, values);
    }

    public SplashScreen(String imageName, String[] names, String[] values) {
        this(new ImageIcon(imageName), names, values);
    }

    public SplashScreen(ImageIcon image, String[] names, String[] values) {
        this.image = image;
        this.names = names;
        this.values = values;
        this.textFont = new Font("sansserif", 0, 12);
        this.setContentPane(this.createSplash());
        this.pack();
        this.center();
    }

    private void center() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension splashSize = this.getContentPane().getPreferredSize();
        int x = (screenSize.width - splashSize.width) / 2;
        int y = (screenSize.height - splashSize.height) / 2;
        this.setBounds(x, y, splashSize.width, splashSize.height);
    }

    private JPanel createSplash() {
        JPanel panel = new JPanel();
        Dimension d = this.image == null ? new Dimension(400, 200) : new Dimension(this.image.getIconWidth() + 10, this.image.getIconHeight() + 10);
        panel.setMinimumSize(d);
        panel.setPreferredSize(d);
        panel.setMaximumSize(d);
        return panel;
    }

    private void drawTextArea(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(this.textX, this.textY, this.textWidth, this.textHeight);
        g.setColor(Color.black);
        int yPos = this.textY + (this.lineHeight - 2);
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null) continue;
            g.drawString(this.names[i], this.textX + 2, yPos);
            g.drawString(this.values[i], this.textX + 2 + this.nameLen + 2, yPos);
            yPos += this.lineHeight;
        }
    }

    private void dumpFonts() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] allFonts = ge.getAllFonts();
        for (int i = 0; i < allFonts.length; ++i) {
            System.out.println("#" + i + ": " + allFonts[i]);
        }
    }

    private boolean initializeTextArea(Graphics g) {
        if (this.names == null || this.values == null) {
            return false;
        }
        FontMetrics fm = g.getFontMetrics();
        int valueLen = 0;
        this.nameLen = 0;
        int numLines = 0;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null) continue;
            int l = fm.stringWidth(this.names[i]);
            if (l > this.nameLen) {
                this.nameLen = l;
            }
            if ((l = fm.stringWidth(this.values[i])) > valueLen) {
                valueLen = l;
            }
            ++numLines;
        }
        if (valueLen == 0) {
            return false;
        }
        int lineWidth = this.nameLen + 2 + valueLen;
        this.lineHeight = fm.getHeight() + 2;
        this.textWidth = 2 + lineWidth + 2;
        this.textHeight = 2 + numLines * this.lineHeight;
        this.textX = 20;
        this.textY = this.getHeight() - (20 + this.textHeight);
        return true;
    }

    @Override
    public void paint(Graphics g) {
        g.setFont(this.textFont);
        boolean drawText = this.initializeTextArea(g);
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.image != null) {
            g.drawImage(this.image.getImage(), 5, 5, this.getBackground(), this);
        } else {
            g.setColor(Color.magenta);
            g.fillRect(0, 0, width, height);
        }
        g.setColor(Color.black);
        g.fillRect(0, 0, width, 5);
        g.fillRect(0, 0, 5, height);
        g.fillRect(width - 5, 5, 5, height - 5);
        g.fillRect(5, height - 5, width - 5, 5);
        if (drawText) {
            this.drawTextArea(g);
        }
    }

    public void setTextFont(Font f) {
        this.textFont = f;
    }

    public static final void main(String[] args) {
        Font f = null;
        if (args.length > 0) {
            int size = 12;
            if (args.length > 1) {
                try {
                    size = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Bad font size \"" + args[1] + "\"");
                    System.exit(1);
                }
            }
            f = new Font(args[0], 0, size);
        }
        ImageIcon img = new ImageIcon("visad-splash.jpg");
        String[] names = new String[]{"Name:", "Machine:"};
        String[] values = new String[]{"dglo", "hyde.ssec.wisc.edu"};
        SplashScreen ss = new SplashScreen(img);
        if (f != null) {
            ss.setTextFont(f);
        }
        ss.setVisible(true);
        try {
            Thread.sleep(7000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        ss.setVisible(false);
        ss = new SplashScreen(names, values);
        if (f != null) {
            ss.setTextFont(f);
        }
        ss.setVisible(true);
        try {
            Thread.sleep(7000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        ss.setVisible(false);
        ss = new SplashScreen(img, names, values);
        if (f != null) {
            ss.setTextFont(f);
        }
        ss.setVisible(true);
        try {
            Thread.sleep(7000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        ss.setVisible(false);
        System.exit(0);
    }
}

