/*
 * Decompiled with CFR 0.152.
 */
package visad.georef;

import java.awt.geom.Rectangle2D;
import visad.RealTupleType;
import visad.VisADException;
import visad.georef.MapProjection;

public class TrivialMapProjection
extends MapProjection {
    private static final long serialVersionUID = 1L;
    private float x;
    private float y;
    private float width;
    private float height;

    public TrivialMapProjection() throws VisADException {
        this(RealTupleType.SpatialEarth2DTuple, new Rectangle2D.Float(-180.0f, -90.0f, 360.0f, 180.0f));
    }

    public TrivialMapProjection(RealTupleType reference) throws VisADException {
        this(reference, new Rectangle2D.Float(-180.0f, -90.0f, 360.0f, 180.0f));
    }

    public TrivialMapProjection(RealTupleType type, Rectangle2D bounds) throws VisADException {
        super(type, type.getDefaultUnits());
        this.x = (float)bounds.getX();
        this.y = (float)bounds.getY();
        this.width = (float)bounds.getWidth();
        this.height = (float)bounds.getHeight();
    }

    @Override
    public double[][] toReference(double[][] tuple) throws VisADException {
        if (tuple == null || this.getDimension() != tuple.length) {
            throw new VisADException("Values are null or wrong dimension");
        }
        return tuple;
    }

    @Override
    public double[][] fromReference(double[][] refTuple) throws VisADException {
        if (refTuple == null || this.getDimension() != refTuple.length) {
            throw new VisADException("Values are null or wrong dimension");
        }
        return refTuple;
    }

    @Override
    public float[][] toReference(float[][] tuple) throws VisADException {
        if (tuple == null || this.getDimension() != tuple.length) {
            throw new VisADException("Values are null or wrong dimension");
        }
        return tuple;
    }

    @Override
    public float[][] fromReference(float[][] refTuple) throws VisADException {
        if (refTuple == null || this.getDimension() != refTuple.length) {
            throw new VisADException("Values are null or wrong dimension");
        }
        return refTuple;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof TrivialMapProjection)) {
            return false;
        }
        TrivialMapProjection that = (TrivialMapProjection)o;
        return this == that || that.getReference().equals(this.getReference()) && Double.doubleToLongBits(that.x) == Double.doubleToLongBits(this.x) && Double.doubleToLongBits(that.y) == Double.doubleToLongBits(this.y) && Double.doubleToLongBits(that.width) == Double.doubleToLongBits(this.width) && Double.doubleToLongBits(that.height) == Double.doubleToLongBits(this.height);
    }

    @Override
    public Rectangle2D getDefaultMapArea() {
        return new Rectangle2D.Float(this.x, this.y, this.width, this.height);
    }
}

