/*
 * Decompiled with CFR 0.152.
 */
package visad.formula;

import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.Stack;
import java.util.Vector;
import visad.ActionImpl;
import visad.CellImpl;
import visad.Data;
import visad.Real;
import visad.RealType;
import visad.RemoteCellImpl;
import visad.RemoteDataReference;
import visad.Text;
import visad.Thing;
import visad.ThingReference;
import visad.ThingReferenceImpl;
import visad.VisADException;
import visad.formula.FormulaException;
import visad.formula.FormulaManager;
import visad.formula.FormulaUtil;
import visad.formula.Postfix;

public class FormulaVar
extends ActionImpl {
    public static boolean DEBUG = false;
    public static RealType CONSTANT = RealType.getRealType("visad/formula/constant");
    private FormulaManager fm;
    String name;
    private String formula;
    private Postfix postfix;
    private ThingReference tref;
    private Vector errors = new Vector();
    private Object Lock = new Object();
    private boolean computing = false;
    private Vector depend = new Vector();
    private Vector required = new Vector();
    ThingReference textRef = null;
    CellImpl textCell = new CellImpl(){

        @Override
        public void doAction() {
            block8: {
                boolean textChanged = false;
                if (FormulaVar.this.textRef != null) {
                    try {
                        Thing thing = FormulaVar.this.textRef.getThing();
                        if (thing instanceof Text) {
                            Text t = (Text)thing;
                            String newForm = t.getValue();
                            if (newForm == null) {
                                newForm = "";
                            }
                            if (!newForm.equals(FormulaVar.this.formula)) {
                                textChanged = true;
                                FormulaVar.this.setFormula(newForm);
                            }
                        }
                    }
                    catch (VisADException exc) {
                        if (DEBUG) {
                            exc.printStackTrace();
                        }
                    }
                    catch (RemoteException exc) {
                        if (!DEBUG) break block8;
                        exc.printStackTrace();
                    }
                }
            }
        }
    };
    RemoteCellImpl rtCell = null;

    FormulaVar(String n, FormulaManager f) throws VisADException {
        this(n, f, null);
    }

    FormulaVar(String n, FormulaManager f, ThingReference t) throws VisADException {
        super(n);
        int i;
        this.fm = f;
        this.name = n;
        this.tref = t == null ? new ThingReferenceImpl(this.name) : t;
        for (i = 0; i < this.fm.bOps.length; ++i) {
            if (this.name.indexOf(this.fm.bOps[i]) < 0) continue;
            throw new FormulaException("variable names cannot contain operators");
        }
        for (i = 0; i < this.fm.uOps.length; ++i) {
            if (this.name.indexOf(this.fm.uOps[i]) < 0) continue;
            throw new FormulaException("variable names cannot contain operators");
        }
    }

    boolean othersDepend() {
        return !this.required.isEmpty();
    }

    boolean isDependentOn(FormulaVar v) {
        if (v == this || this.depend.contains(v)) {
            return true;
        }
        for (int i = 0; i < this.depend.size(); ++i) {
            FormulaVar vi = (FormulaVar)this.depend.elementAt(i);
            if (!vi.isDependentOn(v)) continue;
            return true;
        }
        return false;
    }

    private void setDependentOn(FormulaVar v) {
        block5: {
            if (!this.depend.contains(v)) {
                this.depend.add(v);
                try {
                    this.addReference(v.getReference());
                    v.required.add(this);
                }
                catch (VisADException exc) {
                    if (DEBUG) {
                        exc.printStackTrace();
                    }
                }
                catch (RemoteException exc) {
                    if (!DEBUG) break block5;
                    exc.printStackTrace();
                }
            }
        }
    }

    private void clearDependencies() {
        block5: {
            int len = this.depend.size();
            for (int i = 0; i < len; ++i) {
                FormulaVar v = (FormulaVar)this.depend.elementAt(i);
                v.required.remove(this);
            }
            this.depend.removeAllElements();
            try {
                this.removeAllReferences();
            }
            catch (VisADException exc) {
                if (DEBUG) {
                    exc.printStackTrace();
                }
            }
            catch (RemoteException exc) {
                if (!DEBUG) break block5;
                exc.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildDependencies() throws FormulaException {
        this.disableAction();
        Object object = this.Lock;
        synchronized (object) {
            this.clearDependencies();
            if (this.formula != null && this.postfix == null) {
                try {
                    Object[] o = new Object[]{this.formula, this.fm};
                    String pf = this.formula;
                    try {
                        pf = (String)FormulaUtil.invokeMethod(this.fm.ppMethod, o);
                    }
                    catch (IllegalAccessException exc) {
                        if (DEBUG) {
                            exc.printStackTrace();
                        }
                        this.evalError("Preparsing access exception", exc);
                    }
                    catch (IllegalArgumentException exc) {
                        if (DEBUG) {
                            exc.printStackTrace();
                        }
                        this.evalError("Preparsing argument exception", exc);
                    }
                    catch (InvocationTargetException exc) {
                        Throwable t = exc.getTargetException();
                        if (DEBUG) {
                            t.printStackTrace();
                        }
                        this.evalError("Preparsing exception", t);
                    }
                    this.postfix = new Postfix(pf, this.fm);
                    int len = this.postfix.tokens == null ? 0 : this.postfix.tokens.length;
                    for (int i = 0; i < len; ++i) {
                        String token = this.postfix.tokens[i];
                        if (this.postfix.codes[i] != 4) continue;
                        Double d = null;
                        try {
                            d = Double.valueOf(token);
                        }
                        catch (NumberFormatException exc) {
                            // empty catch block
                        }
                        if (d != null) continue;
                        FormulaVar v = null;
                        try {
                            v = this.fm.getVarByNameOrCreate(token);
                        }
                        catch (FormulaException exc) {
                            this.evalError("\"" + token + "\" is an illegal variable name");
                        }
                        catch (VisADException exc) {
                            this.evalError("Internal VisAD error", exc);
                        }
                        if (v == null) continue;
                        if (v.isDependentOn(this)) {
                            this.clearDependencies();
                            throw new FormulaException("This formula creates an infinite loop");
                        }
                        this.setDependentOn(v);
                    }
                }
                catch (FormulaException exc) {
                    this.evalError("Syntax error in formula", exc);
                    try {
                        this.tref.setThing(null);
                    }
                    catch (VisADException exc2) {
                        this.evalError("Internal VisAD error", exc2);
                    }
                    catch (RemoteException exc2) {
                        this.evalError("Internal remote error", exc2);
                    }
                }
            }
        }
        this.enableAction();
        if (this.depend.isEmpty()) {
            this.doAction();
        }
    }

    void setFormula(String f) throws FormulaException {
        block5: {
            this.formula = f;
            if (this.textRef != null) {
                Text text = new Text(this.formula);
                try {
                    this.textRef.setThing(text);
                }
                catch (VisADException exc) {
                    if (DEBUG) {
                        exc.printStackTrace();
                    }
                }
                catch (RemoteException exc) {
                    if (!DEBUG) break block5;
                    exc.printStackTrace();
                }
            }
        }
        this.postfix = null;
        this.computing = true;
        this.rebuildDependencies();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForFormula() {
        Object object = this.Lock;
        synchronized (object) {
            if (this.computing) {
                try {
                    this.Lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    void setTextRef(ThingReference tr) throws VisADException, RemoteException {
        if (this.textRef == tr) {
            return;
        }
        if (this.textRef != null) {
            if (this.textRef instanceof RemoteDataReference) {
                this.rtCell.removeReference(this.textRef);
                this.rtCell = null;
            } else {
                this.textCell.removeReference(this.textRef);
            }
        }
        this.textRef = tr;
        if (this.textRef != null) {
            if (this.textRef instanceof RemoteDataReference) {
                this.rtCell = new RemoteCellImpl(this.textCell);
                this.rtCell.addReference(this.textRef);
            } else {
                this.textCell.addReference(this.textRef);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setThing(Thing t) throws VisADException, RemoteException {
        Object object = this.Lock;
        synchronized (object) {
            this.formula = null;
            this.postfix = null;
            this.clearDependencies();
            if (t == null || t != this.tref.getThing()) {
                this.tref.setThing(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReference(ThingReference tr) {
        if (this.tref == tr) {
            return;
        }
        Object object = this.Lock;
        synchronized (object) {
            int len = this.required.size();
            for (int i = 0; i < len; ++i) {
                FormulaVar v = (FormulaVar)this.required.elementAt(i);
                try {
                    v.removeReference(this.tref);
                    v.addReference(tr);
                    continue;
                }
                catch (VisADException exc) {
                    if (!DEBUG) continue;
                    exc.printStackTrace();
                    continue;
                }
                catch (RemoteException exc) {
                    if (!DEBUG) continue;
                    exc.printStackTrace();
                }
            }
            this.tref = tr;
        }
    }

    Thing getThing() {
        try {
            return this.tref.getThing();
        }
        catch (VisADException exc) {
            return null;
        }
        catch (RemoteException exc) {
            return null;
        }
    }

    ThingReference getReference() {
        return this.tref;
    }

    String getFormula() {
        return this.formula;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getErrors() {
        Vector vector = this.errors;
        synchronized (vector) {
            int len = this.errors.size();
            if (len == 0) {
                return null;
            }
            String[] s = new String[len];
            for (int i = 0; i < len; ++i) {
                s[i] = (String)this.errors.elementAt(i);
            }
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearErrors() {
        Vector vector = this.errors;
        synchronized (vector) {
            this.errors.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evalError(String s) {
        Vector vector = this.errors;
        synchronized (vector) {
            this.errors.add(s);
        }
    }

    private void evalError(String s, Throwable t) {
        String msg = t == null ? null : t.getMessage();
        this.evalError(s + (msg == null ? "" : ": " + msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAction() {
        Object object = this.Lock;
        synchronized (object) {
            try {
                if (this.postfix != null) {
                    this.tref.setThing(this.compute(this.postfix));
                }
            }
            catch (VisADException exc) {
                this.evalError("Could not store final value in variable");
            }
            catch (RemoteException exc) {
                this.evalError("Could not store final value in variable (remote)");
            }
            this.computing = false;
            this.Lock.notifyAll();
        }
    }

    private Thing popStack(Stack s) {
        if (s.empty()) {
            this.evalError("Syntax error in formula (stack empty)");
            return null;
        }
        return (Thing)s.pop();
    }

    private Thing compute(Postfix formula) {
        if (formula.tokens == null) {
            return null;
        }
        int len = formula.tokens.length;
        Stack<Thing> stack = new Stack<Thing>();
        for (int i = 0; i < len; ++i) {
            Object[] o;
            String token = formula.tokens[i];
            String op = "\"" + token + "\"";
            int code = formula.codes[i];
            if (code == 0) {
                o = new Object[2];
                o[1] = this.popStack(stack);
                o[0] = this.popStack(stack);
                Thing ans = null;
                if (o[0] != null && o[1] != null) {
                    for (int j = 0; j < this.fm.bMethods.length; ++j) {
                        if (ans != null || !this.fm.bOps[j].equals(token)) continue;
                        try {
                            ans = (Thing)FormulaUtil.invokeMethod(this.fm.bMethods[j], o);
                            continue;
                        }
                        catch (IllegalAccessException exc) {
                            if (DEBUG) {
                                exc.printStackTrace();
                            }
                            this.evalError("Cannot access binary method for operator " + op, exc);
                            continue;
                        }
                        catch (IllegalArgumentException exc) {
                            if (DEBUG) {
                                exc.printStackTrace();
                            }
                            this.evalError("Invalid argument to binary method for operator " + op, exc);
                            continue;
                        }
                        catch (InvocationTargetException exc) {
                            Throwable t = exc.getTargetException();
                            if (DEBUG) {
                                t.printStackTrace();
                            }
                            this.evalError("Binary method for operator " + op + " threw an exception", t);
                        }
                    }
                }
                if (ans == null) {
                    this.evalError("Could not evaluate binary operator " + op);
                    stack.push(null);
                    continue;
                }
                stack.push(ans);
                continue;
            }
            if (code == 1) {
                o = new Object[]{this.popStack(stack)};
                Thing ans = null;
                if (o[0] != null) {
                    for (int j = 0; j < this.fm.uMethods.length; ++j) {
                        if (ans != null || !this.fm.uOps[j].equals(token)) continue;
                        try {
                            ans = (Thing)FormulaUtil.invokeMethod(this.fm.uMethods[j], o);
                            continue;
                        }
                        catch (IllegalAccessException exc) {
                            if (DEBUG) {
                                exc.printStackTrace();
                            }
                            this.evalError("Cannot access unary method for operator " + op, exc);
                            continue;
                        }
                        catch (IllegalArgumentException exc) {
                            if (DEBUG) {
                                exc.printStackTrace();
                            }
                            this.evalError("Invalid argument to unary method for operator " + op, exc);
                            continue;
                        }
                        catch (InvocationTargetException exc) {
                            Throwable t = exc.getTargetException();
                            if (DEBUG) {
                                t.printStackTrace();
                            }
                            this.evalError("Unary method for operator " + op + " threw an exception", t);
                        }
                    }
                }
                if (ans == null) {
                    this.evalError("Could not evaluate unary operator " + op);
                    stack.push(null);
                    continue;
                }
                stack.push(ans);
                continue;
            }
            if (code == 2) {
                Throwable t;
                int j;
                boolean eflag;
                Object o2;
                int num;
                Thing ans;
                block74: {
                    ans = null;
                    if (this.fm.isFunction(token)) {
                        block73: {
                            num = -1;
                            try {
                                Real r = (Real)this.popStack(stack);
                                num = (int)r.getValue();
                            }
                            catch (ClassCastException exc) {
                                if (!DEBUG) break block73;
                                exc.printStackTrace();
                            }
                        }
                        if (num < 0) {
                            this.evalError("Syntax error in formula (invalid function arg length)");
                            num = 1;
                        }
                        o2 = num > 0 ? new Object[num] : null;
                        eflag = false;
                        for (j = num - 1; j >= 0; --j) {
                            o2[j] = this.popStack(stack);
                            if (o2[j] != null) continue;
                            eflag = true;
                        }
                        if (!eflag) {
                            for (j = 0; j < this.fm.funcs.length; ++j) {
                                if (ans != null || !this.fm.funcs[j].equalsIgnoreCase(token)) continue;
                                try {
                                    ans = (Thing)FormulaUtil.invokeMethod(this.fm.fMethods[j], o2);
                                    continue;
                                }
                                catch (IllegalAccessException exc) {
                                    if (DEBUG) {
                                        exc.printStackTrace();
                                    }
                                    this.evalError("Cannot access method for function " + op, exc);
                                    continue;
                                }
                                catch (IllegalArgumentException exc) {
                                    if (DEBUG) {
                                        exc.printStackTrace();
                                    }
                                    this.evalError("Invalid argument to method for function " + op, exc);
                                    continue;
                                }
                                catch (InvocationTargetException exc) {
                                    t = exc.getTargetException();
                                    if (DEBUG) {
                                        t.printStackTrace();
                                    }
                                    this.evalError("Method for function " + op + " threw an exception", t);
                                }
                            }
                        }
                        if (ans == null) {
                            this.evalError("Could not evaluate function " + op);
                            stack.push(null);
                            continue;
                        }
                        stack.push(ans);
                        continue;
                    }
                    num = 0;
                    try {
                        num = Integer.parseInt(token) + 1;
                    }
                    catch (NumberFormatException exc) {
                        if (!DEBUG) break block74;
                        exc.printStackTrace();
                    }
                }
                if (num <= 0) {
                    this.evalError("Syntax error in formula (invalid implicit arg length)");
                    num = 1;
                }
                o2 = new Object[num];
                eflag = false;
                for (j = num - 1; j >= 0; --j) {
                    o2[j] = this.popStack(stack);
                    if (o2[j] != null) continue;
                    eflag = true;
                }
                if (!eflag) {
                    for (j = 0; j < this.fm.iMethods.length; ++j) {
                        if (ans != null) continue;
                        try {
                            ans = (Thing)FormulaUtil.invokeMethod(this.fm.iMethods[j], o2);
                            continue;
                        }
                        catch (IllegalAccessException exc) {
                            if (DEBUG) {
                                exc.printStackTrace();
                            }
                            this.evalError("Cannot access method for implicit function", exc);
                            continue;
                        }
                        catch (IllegalArgumentException exc) {
                            if (DEBUG) {
                                exc.printStackTrace();
                            }
                            this.evalError("Invalid argument to method for implicit function", exc);
                            continue;
                        }
                        catch (InvocationTargetException exc) {
                            t = exc.getTargetException();
                            if (DEBUG) {
                                t.printStackTrace();
                            }
                            this.evalError("Method for implicit function threw an exception", t);
                        }
                    }
                }
                if (ans == null) {
                    this.evalError("Could not evaluate implicit function");
                    stack.push(null);
                    continue;
                }
                stack.push(ans);
                continue;
            }
            Double d = null;
            try {
                d = Double.valueOf(token);
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
            if (d == null) {
                Thing t;
                block75: {
                    FormulaVar v = null;
                    try {
                        v = this.fm.getVarByNameOrCreate(token);
                    }
                    catch (FormulaException exc) {
                        this.evalError(op + " is an illegal variable name");
                        stack.push(null);
                    }
                    catch (VisADException exc) {
                        this.evalError("Internal error", exc);
                        stack.push(null);
                    }
                    if (v == null) continue;
                    ThingReference r = v.getReference();
                    t = null;
                    if (r != null) {
                        try {
                            t = r.getThing();
                        }
                        catch (VisADException exc) {
                            if (DEBUG) {
                                exc.printStackTrace();
                            }
                        }
                        catch (RemoteException exc) {
                            if (!DEBUG) break block75;
                            exc.printStackTrace();
                        }
                    }
                }
                if (t == null) {
                    this.evalError("Variable " + op + " has no value");
                    stack.push(null);
                    continue;
                }
                stack.push(t);
                continue;
            }
            if (code == 4) {
                stack.push(new Real(CONSTANT, (double)d));
                continue;
            }
            stack.push(new Real(d));
        }
        Thing answer = this.popStack(stack);
        if (!stack.empty()) {
            this.evalError("Syntax error in formula (leftover objects on stack)");
        }
        if (answer instanceof Data) {
            try {
                answer = ((Data)answer).local();
                if (answer instanceof Real && ((Real)answer).getType() == CONSTANT) {
                    answer = new Real(((Real)answer).getValue());
                }
            }
            catch (VisADException exc) {
                this.evalError("The answer could not be converted to local data");
                answer = null;
            }
            catch (RemoteException exc) {
                this.evalError("The answer could not be converted to local data (remote)");
                answer = null;
            }
        }
        return answer;
    }
}

