/*
 * Decompiled with CFR 0.152.
 */
package visad.data.vis5d;

import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded1DSet;
import visad.IdentityCoordinateSystem;
import visad.Linear1DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.Unit;
import visad.VisADException;
import visad.data.units.ParseException;
import visad.data.units.Parser;

public class Vis5DVerticalSystem {
    private static int counter = 0;
    Unit vert_unit = null;
    SampledSet vertSet;
    RealType vert_type;
    CoordinateSystem vert_cs;
    RealTupleType reference;

    public Vis5DVerticalSystem(int vert_sys, int n_levels, double[] vert_args) throws VisADException {
        switch (vert_sys) {
            case 0: {
                this.vert_unit = CommonUnit.promiscuous;
                this.vert_type = this.makeRealType("Height", this.vert_unit);
                this.reference = new RealTupleType(RealType.Generic);
                this.vert_cs = new IdentityCoordinateSystem(this.reference);
                break;
            }
            case 1: 
            case 2: {
                try {
                    this.vert_unit = Parser.parse("km");
                }
                catch (ParseException e) {
                    // empty catch block
                }
                this.vert_type = this.makeRealType("Height", this.vert_unit);
                this.reference = new RealTupleType(RealType.Altitude);
                this.vert_cs = new IdentityCoordinateSystem(this.reference);
                break;
            }
            case 3: {
                try {
                    this.vert_unit = Parser.parse("mbar");
                }
                catch (ParseException e) {
                    // empty catch block
                }
                this.vert_type = this.makeRealType("Pressure", this.vert_unit);
                this.reference = new RealTupleType(RealType.Altitude);
                this.vert_cs = new Vis5DVerticalCoordinateSystem();
                break;
            }
            default: {
                throw new VisADException("vert_sys unknown");
            }
        }
        switch (vert_sys) {
            case 0: 
            case 1: {
                double first = vert_args[0];
                double last = first + vert_args[1] * (double)(n_levels - 1);
                this.vertSet = new Linear1DSet((MathType)this.vert_type, first, last, n_levels, (CoordinateSystem)null, new Unit[]{this.vert_unit}, null);
                break;
            }
            case 2: {
                double[][] values = new double[1][n_levels];
                System.arraycopy(vert_args, 0, values[0], 0, n_levels);
                this.vertSet = new Gridded1DSet((MathType)this.vert_type, Set.doubleToFloat(values), n_levels, (CoordinateSystem)null, new Unit[]{this.vert_unit}, (ErrorEstimate[])null);
                break;
            }
            case 3: {
                double[][] pressures = new double[1][n_levels];
                System.arraycopy(vert_args, 0, pressures[0], 0, n_levels);
                int i = 0;
                while (i < n_levels) {
                    double[] dArray = pressures[0];
                    int n = i++;
                    dArray[n] = dArray[n] * 1000.0;
                }
                pressures = this.vert_cs.fromReference(pressures);
                this.vertSet = new Gridded1DSet((MathType)this.vert_type, Set.doubleToFloat(pressures), n_levels, (CoordinateSystem)null, new Unit[]{this.vert_unit}, (ErrorEstimate[])null);
                break;
            }
            default: {
                throw new VisADException("vert_sys unknown");
            }
        }
    }

    private RealType makeRealType(String name, Unit unit) throws VisADException {
        RealType rt = null;
        rt = RealType.getRealType(name, unit);
        if (rt == null && (rt = RealType.getRealType(name + "_" + counter++, unit)) == null) {
            throw new VisADException("Unable to create a unique RealType named " + name + " with unit " + unit);
        }
        return rt;
    }

    public static class Vis5DVerticalCoordinateSystem
    extends CoordinateSystem {
        private static final double DEFAULT_LOG_SCALE = 1012.5;
        private static final double DEFAULT_LOG_EXP = -7.2;
        private static Unit[] csUnits;

        public Vis5DVerticalCoordinateSystem() throws VisADException {
            super(new RealTupleType(RealType.Altitude), csUnits);
        }

        @Override
        public double[][] toReference(double[][] pressures) throws VisADException {
            int length = pressures[0].length;
            double[][] alts = new double[1][length];
            for (int kk = 0; kk < length; ++kk) {
                alts[0][kk] = Vis5DVerticalCoordinateSystem.pressureToAltitude(pressures[0][kk]);
            }
            return alts;
        }

        @Override
        public double[][] fromReference(double[][] alts) throws VisADException {
            int length = alts[0].length;
            double[][] pressures = new double[1][length];
            for (int kk = 0; kk < length; ++kk) {
                pressures[0][kk] = Vis5DVerticalCoordinateSystem.altitudeToPressure(alts[0][kk]);
            }
            return pressures;
        }

        @Override
        public float[][] toReference(float[][] pressures) throws VisADException {
            int length = pressures[0].length;
            float[][] alts = new float[1][length];
            for (int kk = 0; kk < length; ++kk) {
                alts[0][kk] = (float)Vis5DVerticalCoordinateSystem.pressureToAltitude(pressures[0][kk]);
            }
            return alts;
        }

        @Override
        public float[][] fromReference(float[][] alts) throws VisADException {
            int length = alts[0].length;
            float[][] pressures = new float[1][length];
            for (int kk = 0; kk < length; ++kk) {
                pressures[0][kk] = (float)Vis5DVerticalCoordinateSystem.altitudeToPressure(alts[0][kk]);
            }
            return pressures;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Vis5DVerticalCoordinateSystem;
        }

        public static double altitudeToPressure(double alt) {
            return 1012.5 * Math.exp(alt / 1000.0 / -7.2);
        }

        public static double pressureToAltitude(double pressure) {
            return -7.2 * Math.log(pressure / 1012.5) * 1000.0;
        }

        static {
            try {
                csUnits = new Unit[]{Parser.parse("mbar")};
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }
}

