/*
 * Decompiled with CFR 0.152.
 */
package visad.data.units;

import visad.BaseUnit;
import visad.OffsetUnit;
import visad.SI;
import visad.ScaledUnit;
import visad.Unit;
import visad.UnitException;
import visad.data.units.UnitPrefix;
import visad.data.units.UnitTable;
import visad.data.units.UnitsDB;

public final class DefaultUnitsDB
extends UnitTable {
    private static final DefaultUnitsDB db;
    protected final UnitPrefix[] prefixNames = new UnitPrefix[]{new UnitPrefix("centi", 0.01), new UnitPrefix("femto", 1.0E-15), new UnitPrefix("hecto", 100.0), new UnitPrefix("micro", 1.0E-6), new UnitPrefix("milli", 0.001), new UnitPrefix("yocto", 1.0E-24), new UnitPrefix("yotta", 1.0E24), new UnitPrefix("zepto", 1.0E-21), new UnitPrefix("zetta", 1.0E21), new UnitPrefix("atto", 1.0E-18), new UnitPrefix("deca", 10.0), new UnitPrefix("deci", 0.1), new UnitPrefix("deka", 10.0), new UnitPrefix("giga", 1.0E9), new UnitPrefix("kilo", 1000.0), new UnitPrefix("mega", 1000000.0), new UnitPrefix("nano", 1.0E-9), new UnitPrefix("peta", 1.0E15), new UnitPrefix("pico", 1.0E-12), new UnitPrefix("tera", 1.0E12), new UnitPrefix("exa", 1.0E18)};
    protected final UnitPrefix[] prefixSymbols = new UnitPrefix[]{new UnitPrefix("da", 10.0), new UnitPrefix("E", 1.0E18), new UnitPrefix("G", 1.0E9), new UnitPrefix("M", 1000000.0), new UnitPrefix("P", 1.0E15), new UnitPrefix("T", 1.0E12), new UnitPrefix("Y", 1.0E24), new UnitPrefix("Z", 1.0E21), new UnitPrefix("a", 1.0E-18), new UnitPrefix("c", 0.01), new UnitPrefix("d", 0.1), new UnitPrefix("f", 1.0E-15), new UnitPrefix("h", 100.0), new UnitPrefix("k", 1000.0), new UnitPrefix("m", 0.001), new UnitPrefix("n", 1.0E-9), new UnitPrefix("p", 1.0E-12), new UnitPrefix("u", 1.0E-6), new UnitPrefix("y", 1.0E-24), new UnitPrefix("z", 1.0E-21)};

    private DefaultUnitsDB() throws UnitException {
        super(677, 98);
        this.put(SI.ampere);
        this.put(SI.candela);
        this.put(SI.kelvin);
        this.put(SI.kilogram);
        this.put(SI.meter);
        this.put(SI.mole);
        this.put(SI.second);
        this.put(SI.radian);
        this.put(SI.steradian);
        this.ps("%", new ScaledUnit(0.01));
        this.pn("percent", "%");
        this.pn("PI", new ScaledUnit(Math.PI));
        this.pn("bakersdozen", new ScaledUnit(13.0));
        this.pn("pair", new ScaledUnit(2.0));
        this.pn("ten", new ScaledUnit(10.0));
        this.pn("dozen", new ScaledUnit(12.0));
        this.pn("score", new ScaledUnit(20.0));
        this.pn("hundred", new ScaledUnit(100.0));
        this.pn("thousand", new ScaledUnit(1000.0));
        this.pn("million", new ScaledUnit(1000000.0));
        this.pn("amp", "ampere");
        this.pn("abampere", this.get("A").scale(10.0));
        this.pn("gilbert", this.get("A").scale(0.7957747));
        this.pn("statampere", this.get("A").scale(3.33564E-10));
        this.pn("biot", "abampere");
        this.pn("candle", "candela");
        this.px("degree kelvin", "K");
        this.px("degrees kelvin", "K");
        this.ps("degK", "K");
        this.px("degreeK", "K");
        this.px("degreesK", "K");
        this.px("deg K", "K");
        this.px("degree K", "K");
        this.px("degrees K", "K");
        this.ps("Cel", new OffsetUnit(273.15, (BaseUnit)this.get("K")));
        this.pn("celsius", "Cel");
        this.px("degree celsius", "Cel");
        this.px("degrees celsius", "Cel");
        this.pn("centigrade", "Cel");
        this.px("degree centigrade", "Cel");
        this.px("degrees centigrade", "Cel");
        this.px("degC", "Cel");
        this.px("degreeC", "Cel");
        this.px("degreesC", "Cel");
        this.px("deg C", "Cel");
        this.px("degree C", "Cel");
        this.px("degrees C", "Cel");
        this.pn("rankine", this.get("K").scale(0.5555555555555556));
        this.px("degree rankine", "rankine");
        this.px("degrees rankine", "rankine");
        this.px("degR", "rankine");
        this.px("degreeR", "rankine");
        this.px("degreesR", "rankine");
        this.px("deg R", "rankine");
        this.px("degree R", "rankine");
        this.px("degrees R", "rankine");
        this.pn("fahrenheit", this.get("Rankine").shift(459.67));
        this.px("degree fahrenheit", "fahrenheit");
        this.px("degrees fahrenheit", "fahrenheit");
        this.px("degF", "fahrenheit");
        this.px("degreeF", "fahrenheit");
        this.px("degreesF", "fahrenheit");
        this.px("deg F", "fahrenheit");
        this.px("degree F", "fahrenheit");
        this.px("degrees F", "fahrenheit");
        this.pn("assay ton", this.get("kg").scale(0.02916667));
        this.pn("avoirdupois ounce", this.get("kg").scale(0.02834952));
        this.pn("avoirdupois pound", this.get("kg").scale(0.45359237));
        this.pn("carat", this.get("kg").scale(2.0E-4));
        this.ps("gr", this.get("kg").scale(6.479891E-5));
        this.ps("g", this.get("kg").scale(0.001));
        this.pn("long hundredweight", this.get("kg").scale(50.80235));
        this.ps("tne", this.get("kg").scale(1000.0));
        this.pn("pennyweight", this.get("kg").scale(0.001555174));
        this.pn("short hundredweight", this.get("kg").scale(45.35924));
        this.pn("slug", this.get("kg").scale(14.5939));
        this.pn("troy ounce", this.get("kg").scale(0.03110348));
        this.pn("troy pound", this.get("kg").scale(0.3732417));
        this.pn("amu", this.get("kg").scale(1.66054E-27));
        this.pn("scruple", this.get("gr").scale(20.0));
        this.pn("apdram", this.get("gr").scale(60.0));
        this.pn("apounce", this.get("gr").scale(480.0));
        this.pn("appound", this.get("gr").scale(5760.0));
        this.pn("gram", "g");
        this.pn("tonne", "tne");
        this.px("metric ton", "tne");
        this.pn("apothecary ounce", "troy ounce");
        this.pn("apothecary pound", "troy pound");
        this.pn("pound", "avoirdupois pound");
        this.pn("metricton", "tne");
        this.ps("grain", "gr");
        this.pn("atomicmassunit", "amu");
        this.pn("atomic mass unit", "amu");
        this.ps("t", "tne");
        this.ps("lb", "avoirdupois pound");
        this.pn("bag", this.get("pound").scale(94.0));
        this.pn("short ton", this.get("pound").scale(2000.0));
        this.pn("long ton", this.get("pound").scale(2240.0));
        this.pn("ton", "short ton");
        this.pn("shortton", "short ton");
        this.pn("longton", "long ton");
        this.pn("angstrom", this.get("m").scale(1.0E-10));
        this.pn("au", this.get("m").scale(1.495979E11));
        this.pn("fermi", this.get("m").scale(1.0E-15));
        this.pn("light year", this.get("m").scale(9.46073E15));
        this.pn("micron", this.get("m").scale(1.0E-6));
        this.pn("mil", this.get("m").scale(2.54E-5));
        this.pn("nautical mile", this.get("m").scale(1852.0));
        this.pn("parsec", this.get("m").scale(3.085678E16));
        this.pn("printers point", this.get("m").scale(3.514598E-4));
        this.pn("metre", "m");
        this.px("prs", "parsec");
        this.px("US survey foot", this.get("m").scale(0.3048006096012192));
        this.pn("US survey yard", this.get("US survey foot").scale(3.0));
        this.pn("US survey mile", this.get("US survey foot").scale(5280.0));
        this.pn("rod", this.get("US survey foot").scale(16.5));
        this.pn("furlong", this.get("US survey foot").scale(660.0));
        this.pn("fathom", this.get("US survey foot").scale(6.0));
        this.px("US survey feet", "US survey foot");
        this.pn("US statute mile", "US survey mile");
        this.pn("pole", "rod");
        this.px("perch", "rod");
        this.px("perches", "perch");
        this.px("international inch", this.get("m").scale(0.0254));
        this.px("international foot", this.get("international inch").scale(12.0));
        this.pn("international yard", this.get("international foot").scale(3.0));
        this.pn("international mile", this.get("international foot").scale(5280.0));
        this.px("international inches", "international inch");
        this.px("international feet", "international foot");
        this.px("inch", "international inch");
        this.px("foot", "international foot");
        this.pn("yard", "international yard");
        this.pn("mile", "international mile");
        this.px("inches", "inch");
        this.ps("in", "inches");
        this.px("feet", "foot");
        this.ps("ft", "feet");
        this.ps("yd", "yard");
        this.ps("mi", "mile");
        this.pn("chain", this.get("m").scale(20.11684));
        this.pn("pica", this.get("printers point").scale(12.0));
        this.pn("printers pica", "pica");
        this.pn("astronomicalunit", "au");
        this.ps("astronomical unit", "au");
        this.px("asu", "au");
        this.pn("nmile", "nautical mile");
        this.ps("nmi", "nautical mile");
        this.pn("big point", this.get("inch").scale(0.013888888888888888));
        this.pn("barleycorn", this.get("inch").scale(0.3333333333333333));
        this.pn("arpentlin", this.get("foot").scale(191.835));
        this.pn("Dobson", this.get("m").scale(1.0E-5));
        this.pn("DU", "Dobson");
        this.pn("year", this.get("s").scale(3.15569259747E7));
        this.ps("d", this.get("s").scale(86400.0));
        this.ps("h", this.get("s").scale(3600.0));
        this.ps("min", this.get("s").scale(60.0));
        this.pn("shake", this.get("s").scale(1.0E-8));
        this.pn("sidereal day", this.get("s").scale(86164.09));
        this.pn("sidereal hour", this.get("s").scale(3590.17));
        this.pn("sidereal minute", this.get("s").scale(59.83617));
        this.pn("sidereal second", this.get("s").scale(0.9972696));
        this.pn("sidereal year", this.get("s").scale(3.155815E7));
        this.pn("day", "d");
        this.pn("hour", "h");
        this.pn("minute", "min");
        this.pn("sec", "s");
        this.pn("lunar month", this.get("d").scale(29.530589));
        this.pn("common year", this.get("d").scale(365.0));
        this.pn("leap year", this.get("d").scale(366.0));
        this.pn("Julian year", this.get("d").scale(365.25));
        this.pn("Gregorian year", this.get("d").scale(365.2425));
        this.pn("tropical year", "year");
        this.pn("sidereal month", this.get("d").scale(27.321661));
        this.pn("tropical month", this.get("d").scale(27.321582));
        this.pn("fortnight", this.get("d").scale(14.0));
        this.pn("week", this.get("d").scale(7.0));
        this.pn("jiffy", this.get("s").scale(0.01));
        this.pn("eon", this.get("year").scale(1.0E9));
        this.pn("month", this.get("year").scale(0.08333333333333333));
        this.pn("tropical year", "year");
        this.pn("yr", "year");
        this.ps("a", "year");
        this.px("ann", "year");
        this.pn("hr", "h");
        this.pn("circle", this.get("radian").scale(Math.PI * 2));
        this.pn("deg", this.get("radian").scale(Math.PI / 180));
        this.pn("'", this.get("deg").scale(0.016666666666666666));
        this.pn("\"", this.get("deg").scale(2.777777777777778E-4));
        this.pn("grade", this.get("deg").scale(0.9));
        this.pn("cycle", this.get("circle"));
        this.pn("turn", "circle");
        this.pn("revolution", "cycle");
        this.px("gon", "grade");
        this.pn("angular degree", "deg");
        this.pn("angular minute", "'");
        this.pn("angular second", "\"");
        this.pn("arcdeg", "deg");
        this.pn("degree", "deg");
        this.pn("arcminute", "'");
        this.px("mnt", "'");
        this.pn("arcsecond", "\"");
        this.pn("arcmin", "'");
        this.pn("arcsec", "\"");
        this.px("degree true", this.get("deg"));
        this.px("degrees true", this.get("deg"));
        this.px("degrees north", this.get("deg"));
        this.px("degrees east", this.get("deg"));
        this.px("degrees south", this.get("degrees north").scale(-1.0));
        this.px("degrees west", this.get("degrees east").scale(-1.0));
        this.px("degree north", "degrees north");
        this.px("degreeN", "degrees north");
        this.px("degree N", "degrees north");
        this.px("degreesN", "degrees north");
        this.px("degrees N", "degrees north");
        this.px("degree east", "degrees east");
        this.px("degreeE", "degrees east");
        this.px("degree E", "degrees east");
        this.px("degreesE", "degrees east");
        this.px("degrees E", "degrees east");
        this.px("degree west", "degrees west");
        this.px("degreeW", "degrees west");
        this.px("degree W", "degrees west");
        this.px("degreesW", "degrees west");
        this.px("degrees W", "degrees west");
        this.px("degree true", "degrees true");
        this.px("degreeT", "degrees true");
        this.px("degree T", "degrees true");
        this.px("degreesT", "degrees true");
        this.px("degrees T", "degrees true");
        this.ps("Hz", this.get("second").pow(-1));
        this.ps("N", this.get("kg").multiply(this.get("m").divide(this.get("s").pow(2))));
        this.ps("C", this.get("A").multiply(this.get("s")));
        this.ps("lm", this.get("cd").multiply(this.get("sr")));
        this.ps("Bq", this.get("Hz"));
        this.px("standard free fall", this.get("m").divide(this.get("s").pow(2)).scale(9.80665));
        this.ps("Pa", this.get("N").divide(this.get("m").pow(2)));
        this.ps("J", this.get("N").multiply(this.get("m")));
        this.ps("lx", this.get("lm").divide(this.get("m").pow(2)));
        this.pn("sphere", this.get("steradian").scale(Math.PI * 4));
        this.ps("W", this.get("J").divide(this.get("s")));
        this.ps("Gy", this.get("J").divide(this.get("kg")));
        this.ps("Sv", this.get("J").divide(this.get("kg")));
        this.ps("V", this.get("W").divide(this.get("A")));
        this.ps("F", this.get("C").divide(this.get("V")));
        this.ps("Ohm", this.get("V").divide(this.get("A")));
        this.ps("S", this.get("A").divide(this.get("V")));
        this.ps("Wb", this.get("V").multiply(this.get("s")));
        this.ps("T", this.get("Wb").divide(this.get("m").pow(2)));
        this.ps("H", this.get("Wb").divide(this.get("A")));
        this.pn("newton", "N");
        this.pn("hertz", "Hz");
        this.pn("watt", "W");
        this.px("force", "standard free fall");
        this.px("gravity", "standard free fall");
        this.px("free fall", "standard free fall");
        this.px("conventional mercury", this.get("gravity").multiply(this.get("kg").divide(this.get("m").pow(3))).scale(13595.1));
        this.px("mercury 0C", this.get("gravity").multiply(this.get("kg").divide(this.get("m").pow(3))).scale(13595.1));
        this.px("mercury 60F", this.get("gravity").multiply(this.get("kg").divide(this.get("m").pow(3))).scale(13556.8));
        this.px("conventional water", this.get("gravity").multiply(this.get("kg").divide(this.get("m").pow(3))).scale(1000.0));
        this.px("water 4C", this.get("gravity").multiply(this.get("kg").divide(this.get("m").pow(3))).scale(999.972));
        this.px("water 60F", this.get("gravity").multiply(this.get("kg").divide(this.get("m").pow(3))).scale(999.001));
        this.px("mercury 32F", "mercury 0C");
        this.px("water 39F", "water 4C");
        this.px("mercury", "conventional mercury");
        this.px("water", "conventional water");
        this.pn("farad", "F");
        this.ps("Hg", "mercury");
        this.px("H2O", "water");
        this.ps("Gal", this.get("m").divide(this.get("s").pow(2)).scale(0.01));
        this.px("gals", "Gal");
        this.pn("are", this.get("m").pow(2).scale(100.0));
        this.pn("barn", this.get("m").pow(2).scale(1.0E-28));
        this.pn("circular mil", this.get("m").pow(2).scale(5.067075E-10));
        this.pn("darcy", this.get("m").pow(2).scale(9.869233E-13));
        this.pn("hectare", this.get("hectoare"));
        this.px("har", "hectare");
        this.pn("acre", this.get("rod").pow(2).scale(160.0));
        this.ps("b", this.get("barn"));
        this.pn("abfarad", this.get("F").scale(1.0E9));
        this.pn("abhenry", this.get("H").scale(1.0E-9));
        this.pn("abmho", this.get("S").scale(1.0E9));
        this.pn("abohm", this.get("Ohm").scale(1.0E-9));
        this.pn("megohm", this.get("Ohm").scale(1000000.0));
        this.pn("kilohm", this.get("Ohm").scale(1000.0));
        this.pn("abvolt", this.get("V").scale(1.0E-8));
        this.ps("e", this.get("C").scale(-17.39782267));
        this.pn("chemical faraday", this.get("C").scale(96495.7));
        this.pn("physical faraday", this.get("C").scale(96521.9));
        this.pn("C12 faraday", this.get("C").scale(96485.31));
        this.pn("gamma", this.get("nT"));
        this.pn("gauss", this.get("T").scale(1.0E-4));
        this.pn("maxwell", this.get("Wb").scale(1.0E-8));
        this.ps("Oe", this.get("A").divide(this.get("m")).scale(79.57747));
        this.pn("statcoulomb", this.get("C").scale(3.33564E-10));
        this.pn("statfarad", this.get("F").scale(1.11265E-12));
        this.pn("stathenry", this.get("H").scale(8.987554E11));
        this.pn("statmho", this.get("S").scale(1.11265E-12));
        this.pn("statohm", this.get("Ohm").scale(8.987554E11));
        this.pn("statvolt", this.get("V").scale(299.7925));
        this.pn("unit pole", this.get("Wb").scale(1.256637E-7));
        this.pn("henry", "H");
        this.pn("siemens", "S");
        this.pn("ohm", "Ohm");
        this.pn("tesla", "T");
        this.pn("volt", "V");
        this.pn("weber", "Wb");
        this.pn("mho", "siemens");
        this.pn("oersted", "Oe");
        this.pn("faraday", "C12 faraday");
        this.pn("coulomb", "C");
        this.ps("eV", this.get("J").scale(1.602177E-19));
        this.ps("bev", this.get("eV").scale(1.0E9));
        this.pn("erg", this.get("J").scale(1.0E-7));
        this.pn("IT Btu", this.get("J").scale(1055.05585262));
        this.pn("EC therm", this.get("J").scale(1.05506E8));
        this.pn("thermochemical calorie", this.get("J").scale(4.184));
        this.pn("IT calorie", this.get("J").scale(4.1868));
        this.px("ton TNT", this.get("J").scale(4.184E9));
        this.pn("US therm", this.get("J").scale(1.054804E8));
        this.ps("Wh", this.get("W").multiply(this.get("h")));
        this.pn("joule", "J");
        this.pn("therm", "US therm");
        this.pn("watthour", "Wh");
        this.ps("Btu", "IT Btu");
        this.pn("calorie", "IT calorie");
        this.pn("electronvolt", "eV");
        this.pn("electron volt", "eV");
        this.ps("thm", "therm");
        this.ps("cal", "calorie");
        this.pn("dyne", this.get("N").scale(1.0E-5));
        this.pn("pond", this.get("N").scale(0.00980665));
        this.px("force kilogram", this.get("N").scale(9.80665));
        this.px("force gram", this.get("N").scale(0.00980665));
        this.px("force ounce", this.get("N").scale(0.2780139));
        this.px("force pound", this.get("N").scale(4.4482216152605));
        this.pn("poundal", this.get("N").scale(0.138255));
        this.pn("force ton", this.get("force pound").scale(2000.0));
        this.ps("gf", "force gram");
        this.ps("lbf", "force pound");
        this.px("ounce force", "force ounce");
        this.px("kilogram force", "force kilogram");
        this.px("pound force", "force pound");
        this.ps("ozf", "force ounce");
        this.ps("kgf", "force kilogram");
        this.px("ton force", "force ton");
        this.px("gram force", "force gram");
        this.pn("kip", this.get("lbf").scale(1000.0));
        this.pn("clo", this.get("K").multiply(this.get("m").pow(2).divide(this.get("W"))).scale(0.155));
        this.pn("lumen", "lm");
        this.pn("lux", "lx");
        this.pn("footcandle", this.get("lux").scale(0.1076391));
        this.pn("footlambert", this.get("cd").divide(this.get("m").pow(2)).scale(3.426259));
        this.pn("lambert", this.get("cd").divide(this.get("m").pow(2)).scale(3183.098861837907));
        this.pn("stilb", this.get("cd").divide(this.get("m").pow(2)).scale(10000.0));
        this.pn("phot", this.get("lm").divide(this.get("m").pow(2)).scale(10000.0));
        this.pn("nit", this.get("cd").multiply(this.get("m").pow(2)));
        this.pn("langley", this.get("J").divide(this.get("m").pow(2)).scale(41840.0));
        this.pn("blondel", this.get("cd").divide(this.get("m").pow(2)).scale(0.3183098861837907));
        this.pn("apostilb", "blondel");
        this.ps("nt", "nit");
        this.ps("ph", "phot");
        this.ps("sb", "stilb");
        this.pn("denier", this.get("kg").divide(this.get("m")).scale(1.111111E-7));
        this.pn("tex", this.get("kg").divide(this.get("m")).scale(1.0E-6));
        this.px("perm 0C", this.get("kg").divide(this.get("Pa").multiply(this.get("s")).multiply(this.get("m").pow(2))).scale(5.72135E-11));
        this.px("perm 23C", this.get("kg").divide(this.get("Pa").multiply(this.get("s")).multiply(this.get("m").pow(2))).scale(5.74525E-11));
        this.ps("VA", this.get("V").multiply(this.get("A")));
        this.pn("voltampere", "VA");
        this.pn("boiler horsepower", this.get("W").scale(9809.5));
        this.pn("shaft horsepower", this.get("W").scale(745.6999));
        this.pn("metric horsepower", this.get("W").scale(7.35499));
        this.pn("electric horsepower", this.get("W").scale(746.0));
        this.pn("water horsepower", this.get("W").scale(746.043));
        this.pn("UK horsepower", this.get("W").scale(745.7));
        this.pn("refrigeration ton", this.get("Btu").divide(this.get("h")).scale(12000.0));
        this.pn("horsepower", "shaft horsepower");
        this.pn("ton of refrigeration", "refrigeration ton");
        this.ps("hp", "horsepower");
        this.pn("bar", this.get("Pa").scale(100000.0));
        this.pn("standard atmosphere", this.get("Pa").scale(101325.0));
        this.pn("technical atmosphere", this.get("kg").multiply(this.get("gravity").divide(this.get("m").scale(0.01).pow(2))));
        this.px("inch H2O 39F", this.get("inch").multiply(this.get("water 39F")));
        this.px("inch H2O 60F", this.get("inch").multiply(this.get("water 60F")));
        this.px("inch Hg 32F", this.get("inch").multiply(this.get("mercury 32F")));
        this.px("inch Hg 60F", this.get("inch").multiply(this.get("mercury 60F")));
        this.px("mm Hg 0C", this.get("m").scale(0.001).multiply(this.get("mercury 0C")));
        this.ps("cmHg", this.get("m").scale(0.01).multiply(this.get("Hg")));
        this.ps("cmH2O", this.get("m").scale(0.01).multiply(this.get("water")));
        this.px("inch Hg", this.get("inch").multiply(this.get("Hg")));
        this.px("torr", this.get("m").scale(0.001).multiply(this.get("Hg")));
        this.px("foot H2O", this.get("foot").multiply(this.get("water")));
        this.ps("psi", this.get("pound").multiply(this.get("gravity").divide(this.get("inch").pow(2))));
        this.ps("ksi", this.get("kip").divide(this.get("inch").pow(2)));
        this.pn("barie", this.get("N").divide(this.get("m").pow(2)).scale(0.1));
        this.px("footH2O", "foot H2O");
        this.ps("ftH2O", "foot H2O");
        this.pn("millimeter Hg", "torr");
        this.px("mm Hg", "torr");
        this.px("mm Hg", "torr");
        this.pn("pascal", "Pa");
        this.px("pal", "Pa");
        this.ps("inHg", "inch Hg");
        this.px("in Hg", "inch Hg");
        this.ps("at", "technical atmosphere");
        this.pn("atmosphere", "standard atmosphere");
        this.ps("atm", "standard atmosphere");
        this.pn("barye", "barie");
        this.ps("Ci", this.get("Bq").scale(3.7E10));
        this.pn("rem", this.get("Sv").scale(0.01));
        this.ps("rd", this.get("Gy").scale(0.01));
        this.ps("R", this.get("C").divide(this.get("kg")).scale(2.58E-4));
        this.ps("gray", "Gy");
        this.px("sie", "Sv");
        this.pn("becquerel", "Bq");
        this.px("rads", "rd");
        this.pn("roentgen", "R");
        this.pn("curie", "Ci");
        this.ps("c", this.get("m").divide(this.get("s")).scale(2.997925E8));
        this.pn("kt", this.get("nautical mile").divide(this.get("h")));
        this.px("knot international", "kt");
        this.px("international knot", "kt");
        this.pn("knot", "kt");
        this.ps("P", this.get("Pa").multiply(this.get("s")).scale(0.1));
        this.ps("St", this.get("m").pow(2).divide(this.get("s")).scale(1.0E-4));
        this.ps("rhe", this.get("Pa").multiply(this.get("s")).pow(-1).scale(10.0));
        this.pn("poise", "P");
        this.pn("stokes", "St");
        this.px("acre feet", this.get("m").pow(3).scale(1233.489));
        this.px("board feet", this.get("m").pow(3).scale(0.002359737));
        this.pn("bushel", this.get("m").pow(3).scale(0.03523907));
        this.pn("UK liquid gallon", this.get("m").pow(3).scale(0.00454609));
        this.pn("Canadian liquid gallon", this.get("m").pow(3).scale(0.00454609));
        this.pn("US dry gallon", this.get("m").pow(3).scale(0.004404884));
        this.pn("US liquid gallon", this.get("m").pow(3).scale(0.003785412));
        this.ps("cc", this.get("m").scale(0.01).pow(3));
        this.pn("liter", this.get("m").pow(3).scale(0.001));
        this.pn("stere", this.get("m").pow(3));
        this.ps("Bz", this.get("m").scale(1.0E-6).pow(3).log(10.0));
        this.pn("register ton", this.get("m").pow(3).scale(2.831685));
        this.pn("US dry quart", this.get("US dry gallon").scale(0.25));
        this.pn("US dry pint", this.get("US dry gallon").scale(0.125));
        this.pn("US liquid quart", this.get("US liquid gallon").scale(0.25));
        this.pn("US liquid pint", this.get("US liquid gallon").scale(0.125));
        this.pn("US liquid cup", this.get("US liquid gallon").scale(0.0625));
        this.pn("US liquid gill", this.get("US liquid gallon").scale(0.03125));
        this.pn("US liquid ounce", this.get("US liquid gallon").scale(0.0078125));
        this.pn("UK liquid quart", this.get("UK liquid gallon").scale(0.25));
        this.pn("UK liquid pint", this.get("UK liquid gallon").scale(0.125));
        this.pn("UK liquid cup", this.get("UK liquid gallon").scale(0.0625));
        this.pn("UK liquid gill", this.get("UK liquid gallon").scale(0.03125));
        this.pn("UK liquid ounce", this.get("UK liquid gallon").scale(0.00625));
        this.pn("US fluid ounce", "US liquid ounce");
        this.pn("UK fluid ounce", "UK liquid ounce");
        this.pn("liquid gallon", "US liquid gallon");
        this.pn("fluid ounce", "US fluid ounce");
        this.pn("dry quart", "US dry quart");
        this.pn("dry pint", "US dry pint");
        this.pn("liquid quart", this.get("liquid gallon").scale(0.25));
        this.pn("liquid pint", this.get("liquid gallon").scale(0.125));
        this.ps("bbl", this.get("US liquid gallon").scale(42.0));
        this.ps("pt", this.get("liquid pint"));
        this.pn("gallon", "liquid gallon");
        this.pn("quart", "liquid quart");
        this.pn("cup", this.get("liquid gallon").scale(0.0625));
        this.pn("gill", this.get("liquid gallon").scale(0.03125));
        this.pn("tablespoon", this.get("US fluid ounce").scale(0.5));
        this.pn("teaspoon", this.get("tablespoon").scale(0.3333333333333333));
        this.pn("peck", this.get("bushel").scale(0.25));
        this.px("acre foot", "acre feet");
        this.px("board foot", "board feet");
        this.pn("barrel", "bbl");
        this.ps("gal", this.get("gallon"));
        this.ps("oz", "fluid ounce");
        this.px("floz", "fluid ounce");
        this.pn("Tbl", "tablespoon");
        this.ps("Tbsp", "tablespoon");
        this.ps("tbsp", "tablespoon");
        this.ps("Tblsp", "tablespoon");
        this.ps("tblsp", "tablespoon");
        this.pn("litre", "liter");
        this.ps("L", "liter");
        this.ps("l", "liter");
        this.px("tsp", "teaspoon");
        this.ps("pk", "peck");
        this.ps("bu", "bushel");
        this.ps("fldr", this.get("floz").scale(0.125));
        this.ps("dr", this.get("floz").scale(0.0625));
        this.pn("firkin", this.get("bbl").scale(0.25));
        this.pn("pint", "pt");
        this.ps("dram", "dr");
        this.pn("sverdrup", this.get("m").pow(3).scale(1000000.0).divide(this.get("s")));
        this.pn("bit", new ScaledUnit(1.0));
        this.ps("Bd", this.get("Hz"));
        this.ps("bps", this.get("Hz"));
        this.ps("cps", this.get("cycle").divide(this.get("s")));
        this.pn("baud", "Bd");
        this.pn("kayser", this.get("m").pow(-1).scale(100.0));
        this.ps("rps", this.get("revolution").divide(this.get("s")));
        this.ps("rpm", this.get("revolution").divide(this.get("min")));
        this.px("geopotential", this.get("gravity"));
        this.pn("work year", this.get("hours").scale(2056.0));
        this.pn("work month", this.get("work year").scale(0.08333333333333333));
        this.pn("count", "");
        this.ps("gp", "geopotential");
        this.px("dynamic", "geopotential");
        this.ps("gpm", this.get("geopotential").multiply(this.get("meter")));
        this.ps("PVU", this.get("m").pow(2).divide(this.get("s")).multiply(this.get("K")).divide(this.get("kg")).scale(1.0E-6));
    }

    public static UnitsDB instance() throws UnitException {
        return db;
    }

    @Override
    public Unit get(String name) {
        Prefixer prefixer;
        Unit unit = super.get(name);
        if (unit == null && (prefixer = new Prefixer(name)).stripPrefix(this.prefixNames, this.prefixSymbols) && (unit = this.get(prefixer.getString())) != null) {
            try {
                unit = unit.scale(prefixer.getValue());
            }
            catch (UnitException e) {
                unit = null;
            }
        }
        return unit;
    }

    protected void ps(String symbol, String unitID) {
        this.putSymbol(symbol, super.get(unitID));
    }

    protected void ps(String symbol, Unit unit) throws UnitException {
        this.putSymbol(symbol, unit.clone(symbol));
    }

    protected void pn(String name, Unit unit) throws UnitException {
        unit = unit.clone(name);
        this.putName(name, unit);
        this.putName(this.makePlural(name), unit);
    }

    protected void pn(String name, String unitID) {
        Unit unit = super.get(unitID);
        this.putName(name, unit);
        this.putName(this.makePlural(name), unit);
    }

    protected void px(String name, Unit unit) throws UnitException {
        this.putName(name, unit.clone(name));
    }

    protected void px(String name, String unitID) {
        this.putName(name, super.get(unitID));
    }

    public static void main(String[] args) throws Exception {
        UnitsDB db = DefaultUnitsDB.instance();
        System.out.println("% = " + db.get("%"));
        System.out.println("abampere = " + db.get("abampere"));
        System.out.println("firkin = " + db.get("firkin"));
        System.out.println("MiCrOmEgAfirkin = " + db.get("MiCrOmEgAfirkin"));
        System.out.println("celsius = " + db.get("celsius"));
        System.out.println("fahrenheit = " + db.get("fahrenheit"));
        System.out.println("m = " + db.get("m"));
        System.out.println("mm = " + db.get("mm"));
        System.out.println("dam = " + db.get("dam"));
        System.out.println("million = " + db.get("million"));
        System.out.println("pascal = " + db.get("pascal"));
        System.out.println("Tperm_0C = " + db.get("Tperm_0C"));
        System.out.println("MILLIpoundal = " + db.get("MILLIpoundal"));
        System.out.println("");
        db.list();
    }

    static {
        try {
            db = new DefaultUnitsDB();
        }
        catch (UnitException e) {
            throw (ExceptionInInitializerError)new ExceptionInInitializerError().initCause(e);
        }
    }

    protected class Prefixer {
        protected final String string;
        protected int pos;
        protected double value;

        protected Prefixer(String string) {
            this.string = string;
            this.pos = 0;
            this.value = 1.0;
        }

        protected boolean stripPrefix(UnitPrefix[] names, UnitPrefix[] symbols) {
            UnitPrefix prefix;
            int icur;
            for (icur = 0; icur < names.length; ++icur) {
                prefix = names[icur];
                if (!this.string.regionMatches(true, this.pos, prefix.name, 0, prefix.name.length())) continue;
                this.value *= prefix.value;
                this.pos += prefix.name.length();
                return true;
            }
            for (icur = 0; icur < symbols.length; ++icur) {
                prefix = symbols[icur];
                if (!this.string.startsWith(prefix.name, this.pos)) continue;
                this.value *= prefix.value;
                this.pos += prefix.name.length();
                return true;
            }
            return false;
        }

        protected boolean isLessThan(UnitPrefix prefix) {
            int icomp = 1;
            int n = Math.min(prefix.name.length(), this.string.length() - this.pos);
            for (int i = 0; i < n && (icomp = Character.getNumericValue(this.string.charAt(this.pos + i)) - Character.getNumericValue(prefix.name.charAt(i))) == 0; ++i) {
            }
            return icomp < 0;
        }

        protected String getString() {
            return this.string.substring(this.pos);
        }

        protected double getValue() {
            return this.value;
        }
    }
}

