/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.out;

import java.io.IOException;
import ucar.netcdf.Attribute;
import ucar.netcdf.Dimension;
import visad.Gridded1DSet;
import visad.Unit;
import visad.data.BadFormException;
import visad.data.netcdf.out.ExportVar;

class CoordVar
extends ExportVar {
    private final Gridded1DSet set;
    private final Unit unit;

    CoordVar(String name, Dimension dim, Unit unit, Gridded1DSet set) throws BadFormException {
        super(name, Float.TYPE, new Dimension[]{dim}, CoordVar.myAttributes(unit));
        this.set = set;
        this.unit = unit;
    }

    protected static Attribute[] myAttributes(Unit unit) {
        Attribute[] attributeArray;
        if (unit == null) {
            attributeArray = null;
        } else {
            Attribute[] attributeArray2 = new Attribute[1];
            attributeArray = attributeArray2;
            attributeArray2[0] = new Attribute("units", unit.toString());
        }
        return attributeArray;
    }

    @Override
    public Object get(int[] indexes) throws IOException {
        int index = indexes[indexes.length - 1];
        try {
            return new Float(this.set.indexToValue(new int[]{index})[0][0]);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public boolean equals(CoordVar that) {
        return this.getName().equals(that.getName()) && this.getRank() == that.getRank() && this.getLengths()[0] == that.getLengths()[0] && (this.unit == that.unit || this.unit.equals(that.unit)) && this.set.equals(that.set);
    }
}

